//===----------------------------------------------------------------------===//
// Copyright © 2024 Apple Inc. and the Pkl project authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//===----------------------------------------------------------------------===//

/// Template for _docsite-info.pkl_, the descriptor for a Pkldoc website.
///
/// A website generated by Pkldoc can optionally have a descriptor that
/// * amends this template
/// * is named _docsite-info.pkl_
/// * is passed to the _pkldoc_ command together with the modules to generate documentation for.
///
/// A typical descriptor looks as follows:
/// ```
/// /// The optional overview documentation displayed on the main page of the website.
/// ///
/// /// Subsequent paragraphs are separated by an empty line and collapsed by default.
/// /// They can use *Markdown syntax* and Pkldoc links such as [String].
/// amends "pkl:DocsiteInfo"
///
/// title = "Title displayed in the header of each page"
/// ```
@ModuleInfo { minPklVersion = "0.27.0" }
module pkl.DocsiteInfo

import "pkl:reflect"

/// The title of this Pkldoc website.
///
/// This is displayed in the header of each page.
title: String?

@Unlisted
fixed overview: String? = moduleMirror.docComment

@Unlisted
fixed overviewImports: Map<String, Uri> = moduleMirror.imports

local moduleMirror = reflect.Module(this)
