/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.server;

import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.pkl.core.evaluatorSettings.PklEvaluatorSettings;
import org.pkl.core.messaging.BaseMessagePackEncoder;
import org.pkl.core.messaging.Message;
import org.pkl.core.messaging.Messages;
import org.pkl.core.packages.Checksums;
import org.pkl.server.CloseEvaluator;
import org.pkl.server.CreateEvaluatorRequest;
import org.pkl.server.CreateEvaluatorResponse;
import org.pkl.server.Dependency;
import org.pkl.server.EvaluateRequest;
import org.pkl.server.EvaluateResponse;
import org.pkl.server.Http;
import org.pkl.server.LogMessage;
import org.pkl.server.Project;
import org.pkl.server.RemoteDependency;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0014\u0010\f\u001a\u00020\t*\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\t*\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002J\u0014\u0010\u0014\u001a\u00020\t*\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0014\u0010\u0017\u001a\u00020\t*\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0014\u0010\u001a\u001a\u00020\t*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006\u001d"}, d2={"Lorg/pkl/server/ServerMessagePackEncoder;", "Lorg/pkl/core/messaging/BaseMessagePackEncoder;", "stream", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;)V", "packer", "Lorg/msgpack/core/MessagePacker;", "(Lorg/msgpack/core/MessagePacker;)V", "encodeMessage", "", "msg", "Lorg/pkl/core/messaging/Message;", "packChecksums", "checksums", "Lorg/pkl/core/packages/Checksums;", "packDependencies", "dependencies", "", "", "Lorg/pkl/server/Dependency;", "packExternalReader", "spec", "Lorg/pkl/core/evaluatorSettings/PklEvaluatorSettings$ExternalReader;", "packHttp", "http", "Lorg/pkl/server/Http;", "packProject", "project", "Lorg/pkl/server/Project;", "pkl-server"})
public final class ServerMessagePackEncoder
extends BaseMessagePackEncoder {
    public ServerMessagePackEncoder(@NotNull MessagePacker packer) {
        Intrinsics.checkNotNullParameter(packer, "packer");
        super(packer);
    }

    public ServerMessagePackEncoder(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        MessagePacker messagePacker = MessagePack.newDefaultPacker(stream);
        Intrinsics.checkNotNullExpressionValue(messagePacker, "newDefaultPacker(stream)");
        this(messagePacker);
    }

    private final void packProject(MessagePacker $this$packProject, Project project2) {
        $this$packProject.packMapHeader(2);
        this.packKeyValue("projectFileUri", project2.getProjectFileUri().toString());
        $this$packProject.packString("dependencies");
        this.packDependencies($this$packProject, project2.getDependencies());
    }

    private final void packHttp(MessagePacker $this$packHttp, Http http) {
        block1: {
            this.packMapHeader(0, http.getCaCertificates(), http.getProxy());
            byte[] byArray = http.getCaCertificates();
            if (byArray != null) {
                byte[] it = byArray;
                boolean bl = false;
                this.packKeyValue("caCertificates", it);
            }
            PklEvaluatorSettings.Proxy proxy = http.getProxy();
            if (proxy == null) break block1;
            PklEvaluatorSettings.Proxy proxy2 = proxy;
            boolean bl = false;
            $this$packHttp.packString("proxy");
            this.packMapHeader(0, proxy2.address(), proxy2.noProxy());
            URI uRI = proxy2.address();
            this.packKeyValue("address", uRI != null ? uRI.toString() : null);
            this.packKeyValue("noProxy", (Collection<String>)proxy2.noProxy());
        }
    }

    private final void packDependencies(MessagePacker $this$packDependencies, Map<String, ? extends Dependency> dependencies) {
        $this$packDependencies.packMapHeader(dependencies.size());
        for (Map.Entry<String, ? extends Dependency> entry : dependencies.entrySet()) {
            Checksums checksums;
            int n;
            String name = entry.getKey();
            Dependency dep = entry.getValue();
            $this$packDependencies.packString(name);
            if (dep instanceof Project) {
                $this$packDependencies.packMapHeader(4);
                this.packKeyValue("type", dep.getType().getValue());
                this.packKeyValue("packageUri", String.valueOf(dep.getPackageUri()));
                this.packKeyValue("projectFileUri", ((Project)dep).getProjectFileUri().toString());
                $this$packDependencies.packString("dependencies");
                this.packDependencies($this$packDependencies, ((Project)dep).getDependencies());
                continue;
            }
            Intrinsics.checkNotNull(dep, "null cannot be cast to non-null type org.pkl.server.RemoteDependency");
            RemoteDependency cfr_ignored_0 = (RemoteDependency)dep;
            MessagePacker messagePacker = $this$packDependencies;
            if (((RemoteDependency)dep).getChecksums() != null) {
                MessagePacker messagePacker2 = messagePacker;
                boolean bl = false;
                int n2 = 3;
                messagePacker = messagePacker2;
                n = n2;
            } else {
                n = 2;
            }
            messagePacker.packMapHeader(n);
            this.packKeyValue("type", dep.getType().getValue());
            this.packKeyValue("packageUri", ((RemoteDependency)dep).getPackageUri().toString());
            if (((RemoteDependency)dep).getChecksums() == null) continue;
            boolean bl = false;
            $this$packDependencies.packString("checksums");
            this.packChecksums($this$packDependencies, checksums);
        }
    }

    private final void packChecksums(MessagePacker $this$packChecksums, Checksums checksums) {
        $this$packChecksums.packMapHeader(1);
        this.packKeyValue("sha256", checksums.getSha256());
    }

    private final void packExternalReader(MessagePacker $this$packExternalReader, PklEvaluatorSettings.ExternalReader spec) {
        block0: {
            this.packMapHeader(1, spec.arguments());
            this.packKeyValue("executable", spec.executable());
            List<String> list = spec.arguments();
            if (list == null) break block0;
            List<String> it = list;
            boolean bl = false;
            this.packKeyValue("arguments", (Collection<String>)it);
        }
    }

    @Override
    protected void encodeMessage(@NotNull Message msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        switch (WhenMappings.$EnumSwitchMapping$0[msg.type().ordinal()]) {
            case 1: {
                PklEvaluatorSettings.ExternalReader spec;
                Collection<String> collection;
                List list;
                Pattern it;
                boolean bl;
                Collection<String> collection2;
                Iterable $this$mapTo$iv$iv;
                boolean $i$f$mapTo;
                Collection destination$iv$iv;
                boolean $i$f$map;
                ServerMessagePackEncoder serverMessagePackEncoder;
                String string;
                CreateEvaluatorRequest cfr_ignored_0 = (CreateEvaluatorRequest)msg;
                this.packMapHeader(1, ((CreateEvaluatorRequest)msg).getAllowedModules(), ((CreateEvaluatorRequest)msg).getAllowedResources(), ((CreateEvaluatorRequest)msg).getClientModuleReaders(), ((CreateEvaluatorRequest)msg).getClientResourceReaders(), ((CreateEvaluatorRequest)msg).getModulePaths(), ((CreateEvaluatorRequest)msg).getEnv(), ((CreateEvaluatorRequest)msg).getProperties(), ((CreateEvaluatorRequest)msg).getTimeout(), ((CreateEvaluatorRequest)msg).getRootDir(), ((CreateEvaluatorRequest)msg).getCacheDir(), ((CreateEvaluatorRequest)msg).getOutputFormat(), ((CreateEvaluatorRequest)msg).getProject(), ((CreateEvaluatorRequest)msg).getHttp(), ((CreateEvaluatorRequest)msg).getExternalModuleReaders(), ((CreateEvaluatorRequest)msg).getExternalResourceReaders());
                this.packKeyValue("requestId", ((CreateEvaluatorRequest)msg).requestId());
                ServerMessagePackEncoder serverMessagePackEncoder2 = this;
                String string2 = "allowedModules";
                List<Pattern> list2 = ((CreateEvaluatorRequest)msg).getAllowedModules();
                if (list2 != null) {
                    Iterable object = list2;
                    string = string2;
                    serverMessagePackEncoder = serverMessagePackEncoder2;
                    $i$f$map = false;
                    Iterable iterable = object;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(object, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Pattern pattern2 = (Pattern)item$iv$iv;
                        collection2 = destination$iv$iv;
                        bl = false;
                        collection2.add(it.toString());
                    }
                    collection2 = (List)destination$iv$iv;
                    serverMessagePackEncoder2 = serverMessagePackEncoder;
                    string2 = string;
                    list = collection2;
                } else {
                    list = null;
                }
                serverMessagePackEncoder2.packKeyValue(string2, list);
                ServerMessagePackEncoder serverMessagePackEncoder3 = this;
                String string3 = "allowedResources";
                List<Pattern> list3 = ((CreateEvaluatorRequest)msg).getAllowedResources();
                if (list3 != null) {
                    Iterable iterable = list3;
                    string = string3;
                    serverMessagePackEncoder = serverMessagePackEncoder3;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = iterable;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault(iterable, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Pattern)item$iv$iv;
                        collection2 = destination$iv$iv;
                        bl = false;
                        collection2.add(it.toString());
                    }
                    collection2 = (List)destination$iv$iv;
                    serverMessagePackEncoder3 = serverMessagePackEncoder;
                    string3 = string;
                    collection = collection2;
                } else {
                    collection = null;
                }
                serverMessagePackEncoder3.packKeyValue(string3, collection);
                if (((CreateEvaluatorRequest)msg).getClientModuleReaders() != null) {
                    this.packer.packString("clientModuleReaders");
                    this.packer.packArrayHeader(((CreateEvaluatorRequest)msg).getClientModuleReaders().size());
                    for (Messages.ModuleReaderSpec moduleReaderSpec : ((CreateEvaluatorRequest)msg).getClientModuleReaders()) {
                        this.packModuleReaderSpec(moduleReaderSpec);
                    }
                }
                if (((CreateEvaluatorRequest)msg).getClientResourceReaders() != null) {
                    this.packer.packString("clientResourceReaders");
                    this.packer.packArrayHeader(((CreateEvaluatorRequest)msg).getClientResourceReaders().size());
                    for (Messages.ResourceReaderSpec resourceReaderSpec : ((CreateEvaluatorRequest)msg).getClientResourceReaders()) {
                        this.packResourceReaderSpec(resourceReaderSpec);
                    }
                }
                this.packKeyValue("modulePaths", (Collection)((CreateEvaluatorRequest)msg).getModulePaths(), Object::toString);
                this.packKeyValue("env", ((CreateEvaluatorRequest)msg).getEnv());
                this.packKeyValue("properties", ((CreateEvaluatorRequest)msg).getProperties());
                Duration duration = ((CreateEvaluatorRequest)msg).getTimeout();
                this.packKeyValue("timeoutSeconds", duration != null ? Long.valueOf(duration.toSeconds()) : null);
                Path path2 = ((CreateEvaluatorRequest)msg).getRootDir();
                this.packKeyValue("rootDir", path2 != null ? ((Object)path2).toString() : null);
                Path path3 = ((CreateEvaluatorRequest)msg).getCacheDir();
                this.packKeyValue("cacheDir", path3 != null ? ((Object)path3).toString() : null);
                this.packKeyValue("outputFormat", ((CreateEvaluatorRequest)msg).getOutputFormat());
                if (((CreateEvaluatorRequest)msg).getProject() != null) {
                    this.packer.packString("project");
                    MessagePacker messagePacker = this.packer;
                    Intrinsics.checkNotNullExpressionValue(messagePacker, "packer");
                    this.packProject(messagePacker, ((CreateEvaluatorRequest)msg).getProject());
                }
                if (((CreateEvaluatorRequest)msg).getHttp() != null) {
                    this.packer.packString("http");
                    MessagePacker messagePacker = this.packer;
                    Intrinsics.checkNotNullExpressionValue(messagePacker, "packer");
                    this.packHttp(messagePacker, ((CreateEvaluatorRequest)msg).getHttp());
                }
                if (((CreateEvaluatorRequest)msg).getExternalModuleReaders() != null) {
                    this.packer.packString("externalModuleReaders");
                    this.packer.packMapHeader(((CreateEvaluatorRequest)msg).getExternalModuleReaders().size());
                    for (Map.Entry entry : ((CreateEvaluatorRequest)msg).getExternalModuleReaders().entrySet()) {
                        String scheme = (String)entry.getKey();
                        spec = (PklEvaluatorSettings.ExternalReader)entry.getValue();
                        this.packer.packString(scheme);
                        MessagePacker messagePacker = this.packer;
                        Intrinsics.checkNotNullExpressionValue(messagePacker, "packer");
                        this.packExternalReader(messagePacker, spec);
                    }
                }
                if (((CreateEvaluatorRequest)msg).getExternalResourceReaders() != null) {
                    this.packer.packString("externalResourceReaders");
                    this.packer.packMapHeader(((CreateEvaluatorRequest)msg).getExternalResourceReaders().size());
                    for (Map.Entry entry : ((CreateEvaluatorRequest)msg).getExternalResourceReaders().entrySet()) {
                        String scheme = (String)entry.getKey();
                        spec = (PklEvaluatorSettings.ExternalReader)entry.getValue();
                        this.packer.packString(scheme);
                        MessagePacker messagePacker = this.packer;
                        Intrinsics.checkNotNullExpressionValue(messagePacker, "packer");
                        this.packExternalReader(messagePacker, spec);
                    }
                }
                return;
            }
            case 2: {
                CreateEvaluatorResponse cfr_ignored_1 = (CreateEvaluatorResponse)msg;
                this.packMapHeader(1, ((CreateEvaluatorResponse)msg).getEvaluatorId(), ((CreateEvaluatorResponse)msg).getError());
                this.packKeyValue("requestId", ((CreateEvaluatorResponse)msg).requestId());
                this.packKeyValue("evaluatorId", ((CreateEvaluatorResponse)msg).getEvaluatorId());
                this.packKeyValue("error", ((CreateEvaluatorResponse)msg).getError());
                break;
            }
            case 3: {
                CloseEvaluator cfr_ignored_2 = (CloseEvaluator)msg;
                this.packer.packMapHeader(1);
                this.packKeyValue("evaluatorId", ((CloseEvaluator)msg).getEvaluatorId());
                break;
            }
            case 4: {
                EvaluateRequest cfr_ignored_3 = (EvaluateRequest)msg;
                this.packMapHeader(3, ((EvaluateRequest)msg).getModuleText(), ((EvaluateRequest)msg).getExpr());
                this.packKeyValue("requestId", ((EvaluateRequest)msg).requestId());
                this.packKeyValue("evaluatorId", ((EvaluateRequest)msg).getEvaluatorId());
                this.packKeyValue("moduleUri", ((EvaluateRequest)msg).getModuleUri().toString());
                this.packKeyValue("moduleText", ((EvaluateRequest)msg).getModuleText());
                this.packKeyValue("expr", ((EvaluateRequest)msg).getExpr());
                break;
            }
            case 5: {
                EvaluateResponse cfr_ignored_4 = (EvaluateResponse)msg;
                this.packMapHeader(2, ((EvaluateResponse)msg).getResult(), ((EvaluateResponse)msg).getError());
                this.packKeyValue("requestId", ((EvaluateResponse)msg).requestId());
                this.packKeyValue("evaluatorId", ((EvaluateResponse)msg).getEvaluatorId());
                byte[] byArray = ((EvaluateResponse)msg).getResult();
                if (byArray != null) {
                    byte[] it = byArray;
                    boolean bl = false;
                    this.packKeyValue("result", it);
                }
                this.packKeyValue("error", ((EvaluateResponse)msg).getError());
                break;
            }
            case 6: {
                LogMessage cfr_ignored_5 = (LogMessage)msg;
                this.packer.packMapHeader(4);
                this.packKeyValue("evaluatorId", ((LogMessage)msg).getEvaluatorId());
                this.packKeyValue("level", ((LogMessage)msg).getLevel());
                this.packKeyValue("message", ((LogMessage)msg).getMessage());
                this.packKeyValue("frameUri", ((LogMessage)msg).getFrameUri());
                break;
            }
            default: {
                super.encodeMessage(msg);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Message.Type.values().length];
            nArray[Message.Type.CREATE_EVALUATOR_REQUEST.ordinal()] = 1;
            nArray[Message.Type.CREATE_EVALUATOR_RESPONSE.ordinal()] = 2;
            nArray[Message.Type.CLOSE_EVALUATOR.ordinal()] = 3;
            nArray[Message.Type.EVALUATE_REQUEST.ordinal()] = 4;
            nArray[Message.Type.EVALUATE_RESPONSE.ordinal()] = 5;
            nArray[Message.Type.LOG_MESSAGE.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

