/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.server;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import org.pkl.core.evaluatorSettings.PklEvaluatorSettings;
import org.pkl.core.messaging.BaseMessagePackDecoder;
import org.pkl.core.messaging.Message;
import org.pkl.core.messaging.Messages;
import org.pkl.core.packages.Checksums;
import org.pkl.server.CloseEvaluator;
import org.pkl.server.CreateEvaluatorRequest;
import org.pkl.server.CreateEvaluatorResponse;
import org.pkl.server.Dependency;
import org.pkl.server.DependencyType;
import org.pkl.server.EvaluateRequest;
import org.pkl.server.EvaluateResponse;
import org.pkl.server.Http;
import org.pkl.server.LogMessage;
import org.pkl.server.Project;
import org.pkl.server.RemoteDependency;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u001c\u0010\u000f\u001a\u00020\u00102\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0002J,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\r*\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u0018*\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a8\u0006\u001b"}, d2={"Lorg/pkl/server/ServerMessagePackDecoder;", "Lorg/pkl/core/messaging/BaseMessagePackDecoder;", "stream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "unpacker", "Lorg/msgpack/core/MessageUnpacker;", "(Lorg/msgpack/core/MessageUnpacker;)V", "decodeMessage", "Lorg/pkl/core/messaging/Message;", "msgType", "Lorg/pkl/core/messaging/Message$Type;", "map", "", "Lorg/msgpack/value/Value;", "unpackExternalReader", "Lorg/pkl/core/evaluatorSettings/PklEvaluatorSettings$ExternalReader;", "unpackDependencies", "", "Lorg/pkl/server/Dependency;", "name", "unpackHttp", "Lorg/pkl/server/Http;", "unpackProject", "Lorg/pkl/server/Project;", "unpackProxy", "Lorg/pkl/core/evaluatorSettings/PklEvaluatorSettings$Proxy;", "pkl-server"})
public final class ServerMessagePackDecoder
extends BaseMessagePackDecoder {
    public ServerMessagePackDecoder(@NotNull MessageUnpacker unpacker) {
        Intrinsics.checkNotNullParameter(unpacker, "unpacker");
        super(unpacker);
    }

    public ServerMessagePackDecoder(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter(stream, "stream");
        MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(stream);
        Intrinsics.checkNotNullExpressionValue(messageUnpacker, "newDefaultUnpacker(stream)");
        this(messageUnpacker);
    }

    @Nullable
    protected Message decodeMessage(@NotNull Message.Type msgType, @NotNull Map<Value, ? extends Value> map2) {
        Intrinsics.checkNotNullParameter((Object)msgType, "msgType");
        Intrinsics.checkNotNullParameter(map2, "map");
        return switch (WhenMappings.$EnumSwitchMapping$0[msgType.ordinal()]) {
            case 1 -> new CreateEvaluatorRequest(BaseMessagePackDecoder.get(map2, "requestId").asIntegerValue().asLong(), BaseMessagePackDecoder.unpackStringListOrNull(map2, "allowedModules", Pattern::compile), BaseMessagePackDecoder.unpackStringListOrNull(map2, "allowedResources", Pattern::compile), BaseMessagePackDecoder.unpackListOrNull(map2, "clientModuleReaders", ServerMessagePackDecoder::decodeMessage$lambda-0), BaseMessagePackDecoder.unpackListOrNull(map2, "clientResourceReaders", ServerMessagePackDecoder::decodeMessage$lambda-1), BaseMessagePackDecoder.unpackStringListOrNull(map2, "modulePaths", p0 -> Path.of(p0, new String[0])), BaseMessagePackDecoder.unpackStringMapOrNull(map2, "env"), BaseMessagePackDecoder.unpackStringMapOrNull(map2, "properties"), BaseMessagePackDecoder.unpackLongOrNull(map2, "timeoutSeconds", Duration::ofSeconds), BaseMessagePackDecoder.unpackStringOrNull(map2, "rootDir", p0 -> Path.of(p0, new String[0])), BaseMessagePackDecoder.unpackStringOrNull(map2, "cacheDir", p0 -> Path.of(p0, new String[0])), BaseMessagePackDecoder.unpackStringOrNull(map2, "outputFormat"), this.unpackProject(map2), this.unpackHttp(map2), BaseMessagePackDecoder.unpackStringMapOrNull(map2, "externalModuleReaders", this::unpackExternalReader), BaseMessagePackDecoder.unpackStringMapOrNull(map2, "externalResourceReaders", this::unpackExternalReader));
            case 2 -> new CreateEvaluatorResponse(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLongOrNull(map2, "evaluatorId"), BaseMessagePackDecoder.unpackStringOrNull(map2, "error"));
            case 3 -> new CloseEvaluator(BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"));
            case 4 -> new EvaluateRequest(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"), new URI(BaseMessagePackDecoder.unpackString(map2, "moduleUri")), BaseMessagePackDecoder.unpackStringOrNull(map2, "moduleText"), BaseMessagePackDecoder.unpackStringOrNull(map2, "expr"));
            case 5 -> new EvaluateResponse(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"), BaseMessagePackDecoder.unpackByteArray(map2, "result"), BaseMessagePackDecoder.unpackStringOrNull(map2, "error"));
            case 6 -> {
                long v1 = BaseMessagePackDecoder.unpackLong(map2, "evaluatorId");
                int v2 = BaseMessagePackDecoder.unpackInt(map2, "level");
                String v3 = BaseMessagePackDecoder.unpackString(map2, "message");
                Intrinsics.checkNotNullExpressionValue(v3, "unpackString(map, \"message\")");
                String v4 = BaseMessagePackDecoder.unpackString(map2, "frameUri");
                Intrinsics.checkNotNullExpressionValue(v4, "unpackString(map, \"frameUri\")");
                yield new LogMessage(v1, v2, v3, v4);
            }
            default -> super.decodeMessage(msgType, map2);
        };
    }

    private final Project unpackProject(Map<Value, ? extends Value> $this$unpackProject) {
        Value value2 = BaseMessagePackDecoder.getNullable($this$unpackProject, "project");
        Map<Value, Value> map2 = value2 != null && (value2 = value2.asMapValue()) != null ? value2.map() : null;
        if (map2 == null) {
            return null;
        }
        Map<Value, Value> projMap = map2;
        URI projectFileUri = new URI(BaseMessagePackDecoder.unpackString(projMap, "projectFileUri"));
        Map<String, Dependency> dependencies = this.unpackDependencies(projMap, "dependencies");
        return new Project(projectFileUri, null, dependencies);
    }

    private final Http unpackHttp(Map<Value, ? extends Value> $this$unpackHttp) {
        Value value2 = BaseMessagePackDecoder.getNullable($this$unpackHttp, "http");
        Map<Value, Value> map2 = value2 != null && (value2 = value2.asMapValue()) != null ? value2.map() : null;
        if (map2 == null) {
            return null;
        }
        Map<Value, Value> httpMap = map2;
        PklEvaluatorSettings.Proxy proxy = this.unpackProxy(httpMap);
        Value value3 = BaseMessagePackDecoder.getNullable(httpMap, "caCertificates");
        byte[] caCertificates = value3 != null && (value3 = value3.asBinaryValue()) != null ? value3.asByteArray() : null;
        return new Http(caCertificates, proxy);
    }

    private final PklEvaluatorSettings.Proxy unpackProxy(Map<Value, ? extends Value> $this$unpackProxy) {
        Value value2 = BaseMessagePackDecoder.getNullable($this$unpackProxy, "proxy");
        Map<Value, Value> map2 = value2 != null && (value2 = value2.asMapValue()) != null ? value2.map() : null;
        if (map2 == null) {
            return null;
        }
        Map<Value, Value> proxyMap = map2;
        String string = BaseMessagePackDecoder.unpackString(proxyMap, "address");
        Intrinsics.checkNotNullExpressionValue(string, "unpackString(proxyMap, \"address\")");
        String address = string;
        List<String> noProxy2 = BaseMessagePackDecoder.unpackStringListOrNull(proxyMap, "noProxy");
        return PklEvaluatorSettings.Proxy.create(address, noProxy2);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Dependency> unpackDependencies(Map<Value, ? extends Value> $this$unpackDependencies, String name) {
        void $this$associateTo$iv$iv;
        Map<Value, Value> mapValue = BaseMessagePackDecoder.get($this$unpackDependencies, name).asMapValue().map();
        Iterable $this$associate$iv = mapValue.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Pair<String, Dependency> pair2;
            String type;
            Map map2 = destination$iv$iv;
            Object object = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Value key2 = (Value)object.getKey();
            Value value2 = (Value)object.getValue();
            String dependencyName = key2.asStringValue().asString();
            Map<Value, Value> dependencyObj = value2.asMapValue().map();
            Intrinsics.checkNotNullExpressionValue(BaseMessagePackDecoder.unpackString(dependencyObj, "type"), "unpackString(dependencyObj, \"type\")");
            URI packageUri = new URI(BaseMessagePackDecoder.unpackString(dependencyObj, "packageUri"));
            if (Intrinsics.areEqual(type, DependencyType.REMOTE.getValue())) {
                Checksums checksums;
                Map<Value, Value> map3;
                Object object2 = BaseMessagePackDecoder.getNullable(dependencyObj, "checksums");
                if (object2 != null && (object2 = object2.asMapValue()) != null && (object2 = (map3 = object2.map())) != null) {
                    String sha2562;
                    Intrinsics.checkNotNullExpressionValue(object2, "map()");
                    Map<Value, Value> obj = map3;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(BaseMessagePackDecoder.unpackString(obj, "sha256"), "unpackString(obj, \"sha256\")");
                    checksums = new Checksums(sha2562);
                } else {
                    checksums = null;
                }
                Checksums checksums2 = checksums;
                pair2 = TuplesKt.to(dependencyName, new RemoteDependency(packageUri, checksums2));
            } else {
                String projectFileUri;
                Intrinsics.checkNotNullExpressionValue(dependencyObj, "dependencyObj");
                Map<String, Dependency> dependencies = this.unpackDependencies(dependencyObj, "dependencies");
                Intrinsics.checkNotNullExpressionValue(BaseMessagePackDecoder.unpackString(dependencyObj, "projectFileUri"), "unpackString(dependencyObj, \"projectFileUri\")");
                pair2 = TuplesKt.to(dependencyName, new Project(new URI(projectFileUri), packageUri, dependencies));
            }
            object = pair2;
            map2.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
        }
        return destination$iv$iv;
    }

    private final PklEvaluatorSettings.ExternalReader unpackExternalReader(Map<Value, ? extends Value> map2) {
        String string = BaseMessagePackDecoder.unpackString(map2, "executable");
        List<String> list = BaseMessagePackDecoder.unpackStringListOrNull(map2, "arguments");
        Intrinsics.checkNotNull(list);
        return new PklEvaluatorSettings.ExternalReader(string, list);
    }

    private static final Messages.ModuleReaderSpec decodeMessage$lambda-0(Value it) {
        Messages.ModuleReaderSpec moduleReaderSpec = BaseMessagePackDecoder.unpackModuleReaderSpec(it);
        Intrinsics.checkNotNull(moduleReaderSpec);
        return moduleReaderSpec;
    }

    private static final Messages.ResourceReaderSpec decodeMessage$lambda-1(Value it) {
        Messages.ResourceReaderSpec resourceReaderSpec = BaseMessagePackDecoder.unpackResourceReaderSpec(it);
        Intrinsics.checkNotNull(resourceReaderSpec);
        return resourceReaderSpec;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Message.Type.values().length];
            nArray[Message.Type.CREATE_EVALUATOR_REQUEST.ordinal()] = 1;
            nArray[Message.Type.CREATE_EVALUATOR_RESPONSE.ordinal()] = 2;
            nArray[Message.Type.CLOSE_EVALUATOR.ordinal()] = 3;
            nArray[Message.Type.EVALUATE_REQUEST.ordinal()] = 4;
            nArray[Message.Type.EVALUATE_RESPONSE.ordinal()] = 5;
            nArray[Message.Type.LOG_MESSAGE.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

