/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.yaml.snake;

import java.util.Optional;
import org.pkl.core.util.yaml.snake.Yaml11Resolver;
import org.pkl.core.util.yaml.snake.Yaml12Resolver;
import org.pkl.core.util.yaml.snake.YamlCompatEmitterResolver;
import org.pkl.core.util.yaml.snake.YamlCompatParserResolver;
import org.snakeyaml.engine.v2.common.ScalarStyle;
import org.snakeyaml.engine.v2.events.ImplicitTuple;
import org.snakeyaml.engine.v2.events.ScalarEvent;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.resolver.ScalarResolver;

public final class YamlUtils {
    private static final ScalarResolver YAML_COMPAT_EMITTER_RESOLVER = new YamlCompatEmitterResolver();
    private static final ScalarResolver YAML_COMPAT_PARSER_RESOLVER = new YamlCompatParserResolver();
    private static final ScalarResolver YAML_11_RESOLVER = new Yaml11Resolver();
    private static final ScalarResolver YAML_12_RESOLVER = new Yaml12Resolver();
    private static final Optional<String> STRING_TAG = Optional.of(Tag.STR.toString());
    private static final ImplicitTuple TUPLE = new ImplicitTuple(true, true);

    private YamlUtils() {
    }

    public static ScalarResolver getEmitterResolver(String mode) {
        return YamlUtils.getScalarResolver(mode, YAML_COMPAT_EMITTER_RESOLVER);
    }

    public static ScalarResolver getParserResolver(String mode) {
        return YamlUtils.getScalarResolver(mode, YAML_COMPAT_PARSER_RESOLVER);
    }

    public static ScalarEvent stringScalar(String value2, ScalarResolver resolver) {
        ScalarStyle scalarStyle = value2.contains("\n") ? ScalarStyle.LITERAL : ScalarStyle.PLAIN;
        Tag inferredTag = resolver.resolve(value2, true);
        ImplicitTuple tuple = new ImplicitTuple(Tag.STR.equals(inferredTag), true);
        return new ScalarEvent(Optional.empty(), STRING_TAG, tuple, value2, scalarStyle);
    }

    public static ScalarEvent plainScalar(String value2, Tag tag) {
        return new ScalarEvent(Optional.empty(), Optional.of(tag.toString()), TUPLE, value2, ScalarStyle.PLAIN);
    }

    private static ScalarResolver getScalarResolver(String mode, ScalarResolver yamlCompatEmitterResolver) {
        return switch (mode) {
            case "compat" -> yamlCompatEmitterResolver;
            case "1.1" -> YAML_11_RESOLVER;
            case "1.2" -> YAML_12_RESOLVER;
            default -> throw new IllegalArgumentException(mode);
        };
    }
}

