/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.io.PrintWriter;
import java.util.EnumSet;
import java.util.Set;
import org.pkl.core.util.StringBuilderWriter;

public final class AnsiStringBuilder {
    private final StringBuilder builder = new StringBuilder();
    private final boolean usingColor;
    private Set<AnsiCode> currentCodes = EnumSet.noneOf(AnsiCode.class);
    private Set<AnsiCode> declaredCodes = EnumSet.noneOf(AnsiCode.class);

    public AnsiStringBuilder(boolean usingColor) {
        this.usingColor = usingColor;
    }

    public AnsiStringBuilder append(Set<AnsiCode> codes, String value2) {
        if (!this.usingColor) {
            this.builder.append(value2);
            return this;
        }
        Set<AnsiCode> prevDeclaredCodes = this.declaredCodes;
        this.declaredCodes = EnumSet.copyOf(codes);
        this.declaredCodes.addAll(prevDeclaredCodes);
        this.append(value2);
        this.declaredCodes = prevDeclaredCodes;
        return this;
    }

    public AnsiStringBuilder append(AnsiCode code, int value2) {
        if (!this.usingColor) {
            this.builder.append(value2);
            return this;
        }
        Set<AnsiCode> prevDeclaredCodes = this.declaredCodes;
        this.declaredCodes = EnumSet.of(code);
        this.declaredCodes.addAll(prevDeclaredCodes);
        this.append(value2);
        this.declaredCodes = prevDeclaredCodes;
        return this;
    }

    public AnsiStringBuilder append(AnsiCode code, String value2) {
        if (!this.usingColor) {
            this.builder.append(value2);
            return this;
        }
        Set<AnsiCode> prevDeclaredCodes = this.declaredCodes;
        this.declaredCodes = EnumSet.of(code);
        this.declaredCodes.addAll(prevDeclaredCodes);
        this.append(value2);
        this.declaredCodes = prevDeclaredCodes;
        return this;
    }

    public AnsiStringBuilder append(AnsiCode code, Runnable runnable) {
        if (!this.usingColor) {
            runnable.run();
            return this;
        }
        Set<AnsiCode> prevDeclaredCodes = this.declaredCodes;
        this.declaredCodes = EnumSet.of(code);
        this.declaredCodes.addAll(prevDeclaredCodes);
        runnable.run();
        this.declaredCodes = prevDeclaredCodes;
        return this;
    }

    public AnsiStringBuilder appendUntrusted(String value2) {
        this.appendCodes();
        this.builder.append(value2);
        if (this.usingColor) {
            this.doReset();
            this.doAppendCodes(this.currentCodes);
        }
        return this;
    }

    public AnsiStringBuilder append(String value2) {
        this.appendCodes();
        this.builder.append(value2);
        return this;
    }

    public AnsiStringBuilder append(char value2) {
        this.appendCodes();
        this.builder.append(value2);
        return this;
    }

    public AnsiStringBuilder append(int value2) {
        this.appendCodes();
        this.builder.append(value2);
        return this;
    }

    public AnsiStringBuilder append(Object value2) {
        this.appendCodes();
        this.builder.append(value2);
        return this;
    }

    public AnsiStringBuilder newInstance() {
        return new AnsiStringBuilder(this.usingColor);
    }

    public PrintWriter toPrintWriter() {
        return new PrintWriter(new StringBuilderWriter(this.builder));
    }

    public String toString() {
        this.reset();
        return this.builder.toString();
    }

    private void doAppendCodes(Set<AnsiCode> codes) {
        if (codes.isEmpty()) {
            return;
        }
        this.builder.append("\u001b[");
        boolean isFirst = true;
        for (AnsiCode code : codes) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.builder.append(';');
            }
            this.builder.append(code.value);
        }
        this.builder.append('m');
    }

    private void appendCodes() {
        if (!this.usingColor || this.currentCodes.equals(this.declaredCodes)) {
            return;
        }
        if (this.declaredCodes.containsAll(this.currentCodes)) {
            EnumSet<AnsiCode> newCodes = EnumSet.copyOf(this.declaredCodes);
            newCodes.removeAll(this.currentCodes);
            this.doAppendCodes(newCodes);
        } else {
            this.reset();
            this.doAppendCodes(this.declaredCodes);
        }
        this.currentCodes = this.declaredCodes;
    }

    private void reset() {
        if (!this.usingColor || this.currentCodes.isEmpty()) {
            return;
        }
        this.doReset();
        this.currentCodes = EnumSet.noneOf(AnsiCode.class);
    }

    private void doReset() {
        this.builder.append("\u001b[0m");
    }

    public static enum AnsiCode {
        RESET(0),
        BOLD(1),
        FAINT(2),
        BLACK(30),
        RED(31),
        GREEN(32),
        YELLOW(33),
        BLUE(34),
        MAGENTA(35),
        CYAN(36),
        WHITE(37),
        BG_BLACK(40),
        BG_RED(41),
        BG_GREEN(42),
        BG_YELLOW(43),
        BG_BLUE(44),
        BG_MAGENTA(45),
        BG_CYAN(46),
        BG_WHITE(47),
        BRIGHT_BLACK(90),
        BRIGHT_RED(91),
        BRIGHT_GREEN(92),
        BRIGHT_YELLOW(93),
        BRIGHT_BLUE(94),
        BRIGHT_MAGENTA(95),
        BRIGHT_CYAN(96),
        BRIGHT_WHITE(97),
        BG_BRIGHT_BLACK(100),
        BG_BRIGHT_RED(101),
        BG_BRIGHT_GREEN(102),
        BG_BRIGHT_YELLOW(103),
        BG_BRIGHT_BLUE(104),
        BG_BRIGHT_MAGENTA(105),
        BG_BRIGHT_CYAN(106),
        BG_BRIGHT_WHITE(107);

        private final int value;

        private AnsiCode(int value2) {
            this.value = value2;
        }
    }
}

