/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.pkl.core.ast.lambda.ApplyVmFunction1Node;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSafeMath;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalMethod3Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.stdlib.base.RegexMatchFactory;
import org.pkl.core.util.ByteArrayUtils;
import org.pkl.core.util.Pair;
import org.pkl.core.util.StringUtils;

public final class StringNodes {
    private StringNodes() {
    }

    @CompilerDirectives.TruffleBoundary
    private static String substringFrom(String string, int start2) {
        return string.substring(start2);
    }

    @CompilerDirectives.TruffleBoundary
    private static String substringUntil(String string, int end2) {
        return string.substring(0, end2);
    }

    private static Pattern patternOf(String regex) {
        return Pattern.compile(regex, 80);
    }

    private static boolean findLast(Matcher m) {
        MatchResult r;
        if (!m.find()) {
            return false;
        }
        do {
            r = m.toMatchResult();
        } while (m.find());
        return m.region(r.start(), r.end()).lookingAt();
    }

    private static String applyMapper(Matcher matcher, VmFunction mapper) {
        VmTyped regexMatch = RegexMatchFactory.create(Pair.of(matcher.toMatchResult(), -1));
        String replacement = mapper.applyString(regexMatch);
        return Matcher.quoteReplacement(replacement);
    }

    private static String removeUnderlinesFromNumber(String number) {
        StringBuilder builder = new StringBuilder();
        boolean numberStart = true;
        for (int i = 0; i < number.length(); ++i) {
            char c = number.charAt(i);
            if (c != '_') {
                builder.append(c);
            } else if (numberStart) {
                return number;
            }
            numberStart = c == '.' || c == 'e' || c == 'E';
        }
        return builder.toString();
    }

    public static abstract class base64Decoded
    extends ExternalPropertyNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            try {
                return new String(Base64.getDecoder().decode(self), StandardCharsets.UTF_8);
            }
            catch (IllegalArgumentException e2) {
                throw this.exceptionBuilder().adhocEvalError(e2.getMessage(), new Object[0]).withProgramValue("String", self).withCause(e2).build();
            }
        }
    }

    public static abstract class base64
    extends ExternalPropertyNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            return Base64.getEncoder().encodeToString(self.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static abstract class sha256Int
    extends ExternalPropertyNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected long eval(String self) {
            return ByteArrayUtils.sha256Int(self.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static abstract class sha256
    extends ExternalPropertyNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            return ByteArrayUtils.sha256(self.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static abstract class sha1
    extends ExternalPropertyNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            return ByteArrayUtils.sha1(self.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static abstract class md5
    extends ExternalPropertyNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            return ByteArrayUtils.md5(self.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static abstract class toBooleanOrNull
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object eval(String self) {
            if (self.equalsIgnoreCase("true")) {
                return true;
            }
            if (self.equalsIgnoreCase("false")) {
                return false;
            }
            return VmNull.withoutDefault();
        }
    }

    public static abstract class toBoolean
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected boolean eval(String self) {
            if (self.equalsIgnoreCase("true")) {
                return true;
            }
            if (self.equalsIgnoreCase("false")) {
                return false;
            }
            throw this.exceptionBuilder().evalError("cannotParseStringAs", "Boolean").withProgramValue("String", self).build();
        }
    }

    public static abstract class toFloatOrNull
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object eval(String self) {
            try {
                return Double.parseDouble(StringNodes.removeUnderlinesFromNumber(self));
            }
            catch (NumberFormatException e2) {
                return VmNull.withoutDefault();
            }
        }
    }

    public static abstract class toFloat
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected double eval(String self) {
            try {
                return Double.parseDouble(StringNodes.removeUnderlinesFromNumber(self));
            }
            catch (NumberFormatException e2) {
                throw this.exceptionBuilder().evalError("cannotParseStringAs", "Float").withProgramValue("String", self).build();
            }
        }
    }

    public static abstract class toIntOrNull
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object eval(String self) {
            try {
                return Long.parseLong(StringNodes.removeUnderlinesFromNumber(self));
            }
            catch (NumberFormatException e2) {
                return VmNull.withoutDefault();
            }
        }
    }

    public static abstract class toInt
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected long eval(String self) {
            try {
                return Long.parseLong(StringNodes.removeUnderlinesFromNumber(self));
            }
            catch (NumberFormatException e2) {
                throw this.exceptionBuilder().evalError("cannotParseStringAs", "Int").withProgramValue("String", self).build();
            }
        }
    }

    public static abstract class decapitalize
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            if (self.isEmpty()) {
                return "";
            }
            int firstChar = self.codePointAt(0);
            return Character.toString(firstChar).toLowerCase(Locale.ROOT) + self.substring(Character.isBmpCodePoint(firstChar) ? 1 : 2);
        }
    }

    public static abstract class capitalize
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            if (self.isEmpty()) {
                return "";
            }
            int firstChar = self.codePointAt(0);
            return Character.toString(Character.toTitleCase(firstChar)) + self.substring(Character.isBmpCodePoint(firstChar) ? 1 : 2);
        }
    }

    public static abstract class splitLimit
    extends ExternalMethod2Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected VmList eval(String self, String separator, long limit) {
            Object[] parts = self.split(Pattern.quote(separator), (int)limit);
            return VmList.create(parts);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected VmList eval(String self, VmRegex separator, long limit) {
            Object[] parts = separator.getPattern().split(self, (int)limit);
            return VmList.create(parts);
        }
    }

    public static abstract class split
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected VmList eval(String self, String separator) {
            Object[] parts = self.split(Pattern.quote(separator));
            return VmList.create(parts);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected VmList eval(String self, VmRegex separator) {
            return VmList.create(separator.getPattern().split(self));
        }
    }

    public static abstract class padEnd
    extends ExternalMethod2Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, long width, String ch) {
            int length2 = self.length();
            if ((long)length2 >= width) {
                return self;
            }
            StringBuilder result = new StringBuilder(VmSafeMath.toInt32(width));
            result.append(self);
            char c = ch.charAt(0);
            int i = 0;
            while ((long)i < width - (long)length2) {
                result.append(c);
                ++i;
            }
            return result.toString();
        }
    }

    public static abstract class padStart
    extends ExternalMethod2Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, long width, String ch) {
            int length2 = self.length();
            if ((long)length2 >= width) {
                return self;
            }
            StringBuilder result = new StringBuilder(VmSafeMath.toInt32(width));
            char c = ch.charAt(0);
            int i = 0;
            while ((long)i < width - (long)length2) {
                result.append(c);
                ++i;
            }
            result.append(self);
            return result.toString();
        }
    }

    public static abstract class trimEnd
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            return StringUtils.trimEnd(self);
        }
    }

    public static abstract class trimStart
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            return StringUtils.trimStart(self);
        }
    }

    public static abstract class trim
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            return self.strip();
        }
    }

    public static abstract class reverse
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            return new StringBuilder(self).reverse().toString();
        }
    }

    public static abstract class toUpperCase
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            return self.toUpperCase(Locale.ROOT);
        }
    }

    public static abstract class toLowerCase
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self) {
            return self.toLowerCase(Locale.ROOT);
        }
    }

    public static abstract class replaceAllMapped
    extends ExternalMethod2Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(String self, String pattern2, VmFunction mapper) {
            return this.doEval(self, StringNodes.patternOf(pattern2).matcher(self), mapper);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(String self, VmRegex regex, VmFunction mapper) {
            return this.doEval(self, regex.matcher(self), mapper);
        }

        private String doEval(String self, Matcher matcher, VmFunction mapper) {
            if (!matcher.find()) {
                return self;
            }
            StringBuilder buffer = new StringBuilder();
            do {
                matcher.appendReplacement(buffer, StringNodes.applyMapper(matcher, mapper));
            } while (matcher.find());
            matcher.appendTail(buffer);
            return buffer.toString();
        }
    }

    public static abstract class replaceLastMapped
    extends ExternalMethod2Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(String self, String pattern2, VmFunction mapper) {
            return this.doEval(self, StringNodes.patternOf(pattern2).matcher(self), mapper);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(String self, VmRegex regex, VmFunction mapper) {
            return this.doEval(self, regex.matcher(self), mapper);
        }

        private String doEval(String self, Matcher matcher, VmFunction mapper) {
            return !StringNodes.findLast(matcher) ? self : self.substring(0, matcher.start()) + StringNodes.applyMapper(matcher, mapper) + self.substring(matcher.end());
        }
    }

    public static abstract class replaceFirstMapped
    extends ExternalMethod2Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(String self, String pattern2, VmFunction mapper) {
            return this.doEval(self, StringNodes.patternOf(pattern2).matcher(self), mapper);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(String self, VmRegex regex, VmFunction mapper) {
            return this.doEval(self, regex.matcher(self), mapper);
        }

        private String doEval(String self, Matcher matcher, VmFunction mapper) {
            if (!matcher.find()) {
                return self;
            }
            return self.substring(0, matcher.start()) + StringNodes.applyMapper(matcher, mapper) + self.substring(matcher.end());
        }
    }

    public static abstract class replaceRange
    extends ExternalMethod3Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, long start2, long exclusiveEnd, String replacement) {
            int charStart = VmUtils.codePointOffsetToCharOffset(self, start2);
            if (charStart == -1) {
                throw this.exceptionBuilder().evalError("charIndexOutOfRange", start2, 0, self.codePointCount(0, self.length())).withProgramValue("String", self).build();
            }
            int charExclusiveEnd = VmUtils.codePointOffsetToCharOffset(self, exclusiveEnd - start2, charStart);
            if (charExclusiveEnd < charStart) {
                throw this.exceptionBuilder().evalError("charIndexOutOfRange", exclusiveEnd, start2, self.codePointCount(0, self.length())).withProgramValue("String", self).build();
            }
            return self.substring(0, charStart) + replacement + self.substring(charExclusiveEnd);
        }
    }

    public static abstract class replaceLast
    extends ExternalMethod2Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, String pattern2, String replacement) {
            int idx = self.lastIndexOf(pattern2);
            if (idx == -1) {
                return self;
            }
            return self.substring(0, idx) + replacement + self.substring(idx + pattern2.length());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, VmRegex regex, String replacement) {
            try {
                Matcher matcher = regex.matcher(self);
                if (!StringNodes.findLast(matcher)) {
                    return self;
                }
                StringBuilder result = new StringBuilder();
                matcher.appendReplacement(result, replacement);
                matcher.appendTail(result);
                return result.toString();
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e2) {
                throw this.exceptionBuilder().evalError("errorInRegexReplacement", regex.getPattern(), replacement, e2.getMessage()).build();
            }
        }
    }

    public static abstract class replaceFirst
    extends ExternalMethod2Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, String pattern2, String replacement) {
            int idx = self.indexOf(pattern2);
            if (idx == -1) {
                return self;
            }
            return self.substring(0, idx) + replacement + self.substring(idx + pattern2.length());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, VmRegex regex, String replacement) {
            try {
                return regex.matcher(self).replaceFirst(replacement);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e2) {
                throw this.exceptionBuilder().evalError("errorInRegexReplacement", regex.getPattern(), replacement, e2.getMessage()).build();
            }
        }
    }

    public static abstract class replaceAll
    extends ExternalMethod2Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, String pattern2, String replacement) {
            return self.replace(pattern2, replacement);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, VmRegex regex, String replacement) {
            try {
                return regex.matcher(self).replaceAll(replacement);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e2) {
                throw this.exceptionBuilder().evalError("errorInRegexReplacement", regex.getPattern().toString(), replacement, e2.getMessage()).build();
            }
        }
    }

    public static abstract class dropLastWhile
    extends TakeDropLastWhile {
        @Specialization
        protected String eval(String self, VmFunction function) {
            int idx = this.findOffset(self, function);
            return StringNodes.substringUntil(self, idx);
        }
    }

    public static abstract class dropLast
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(String self, long n) {
            VmUtils.checkPositive(n);
            int charIndex = VmUtils.codePointOffsetFromEndToCharOffset(self, n);
            return charIndex == -1 ? "" : self.substring(0, charIndex);
        }
    }

    public static abstract class dropWhile
    extends TakeDropWhile {
        @Specialization
        protected String eval(String self, VmFunction function) {
            int idx = this.findOffset(self, function);
            return StringNodes.substringFrom(self, idx);
        }
    }

    public static abstract class drop
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(String self, long n) {
            VmUtils.checkPositive(n);
            int charIndex = VmUtils.codePointOffsetToCharOffset(self, n);
            return charIndex == -1 ? "" : self.substring(charIndex);
        }
    }

    public static abstract class takeLastWhile
    extends TakeDropLastWhile {
        @Specialization
        protected String eval(String self, VmFunction function) {
            return StringNodes.substringFrom(self, this.findOffset(self, function));
        }
    }

    public static abstract class takeLast
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(String self, long n) {
            VmUtils.checkPositive(n);
            int charIndex = VmUtils.codePointOffsetFromEndToCharOffset(self, n);
            return charIndex == -1 ? self : self.substring(charIndex);
        }
    }

    public static abstract class takeWhile
    extends TakeDropWhile {
        @Specialization
        protected String eval(String self, VmFunction function) {
            return StringNodes.substringUntil(self, this.findOffset(self, function));
        }
    }

    public static abstract class take
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(String self, long n) {
            VmUtils.checkPositive(n);
            int charIndex = VmUtils.codePointOffsetToCharOffset(self, n);
            return charIndex == -1 ? self : self.substring(0, charIndex);
        }
    }

    public static abstract class lastIndexOfOrNull
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object eval(String self, String pattern2) {
            int charIndex = self.lastIndexOf(pattern2);
            if (charIndex == -1) {
                return VmNull.withoutDefault();
            }
            return (long)self.codePointCount(0, charIndex);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object eval(String self, VmRegex regex) {
            Matcher m = regex.matcher(self);
            return StringNodes.findLast(m) ? Long.valueOf(self.codePointCount(0, m.start())) : VmNull.withoutDefault();
        }
    }

    public static abstract class lastIndexOf
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected long eval(String self, String pattern2) {
            int charIndex = self.lastIndexOf(pattern2);
            if (charIndex == -1) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("doesNotContainLiteralMatch", new Object[0]).withProgramValue("String", self).withProgramValue("Pattern", pattern2).build();
            }
            return self.codePointCount(0, charIndex);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected long eval(String self, VmRegex regex) {
            Matcher matcher = regex.matcher(self);
            if (!StringNodes.findLast(matcher)) {
                throw this.exceptionBuilder().evalError("doesNotContainRegexMatch", new Object[0]).withProgramValue("String", self).withProgramValue("Pattern", regex).build();
            }
            return self.codePointCount(0, matcher.start());
        }
    }

    public static abstract class indexOfOrNull
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object eval(String self, String pattern2) {
            int charIndex = self.indexOf(pattern2);
            if (charIndex == -1) {
                return VmNull.withoutDefault();
            }
            return (long)self.codePointCount(0, charIndex);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object eval(String self, VmRegex regex) {
            Matcher matcher = regex.matcher(self);
            if (!matcher.find()) {
                return VmNull.withoutDefault();
            }
            return (long)self.codePointCount(0, matcher.start());
        }
    }

    public static abstract class indexOf
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected long eval(String self, String pattern2) {
            int charIndex = self.indexOf(pattern2);
            if (charIndex == -1) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("doesNotContainLiteralMatch", new Object[0]).withProgramValue("String", self).withProgramValue("Pattern", pattern2).build();
            }
            return self.codePointCount(0, charIndex);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected long eval(String self, VmRegex regex) {
            Matcher matcher = regex.matcher(self);
            if (!matcher.find()) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("doesNotContainRegexMatch", new Object[0]).withProgramValue("String", self).withProgramValue("Pattern", regex).build();
            }
            return self.codePointCount(0, matcher.start());
        }
    }

    public static abstract class endsWith
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected boolean eval(String self, String pattern2) {
            return self.endsWith(pattern2);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected boolean eval(String self, VmRegex regex) {
            Matcher matcher = regex.matcher(self);
            int end2 = -1;
            while (matcher.find()) {
                end2 = matcher.end();
            }
            return end2 == self.length();
        }
    }

    public static abstract class startsWith
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected boolean eval(String self, String pattern2) {
            return self.startsWith(pattern2);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected boolean eval(String self, VmRegex regex) {
            return regex.matcher(self).lookingAt();
        }
    }

    public static abstract class matches
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected boolean eval(String self, VmRegex regex) {
            return regex.matcher(self).matches();
        }
    }

    public static abstract class contains
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected boolean eval(String self, String other) {
            return self.contains(other);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected boolean eval(String self, VmRegex regex) {
            return regex.matcher(self).find();
        }
    }

    public static abstract class repeat
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, long count2) {
            VmSafeMath.toInt32(VmSafeMath.multiply(self.length(), count2));
            return self.repeat((int)count2);
        }
    }

    public static abstract class substringOrNull
    extends ExternalMethod2Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object eval(String self, long start2, long exclusiveEnd) {
            int charStart = VmUtils.codePointOffsetToCharOffset(self, start2);
            if (charStart == -1) {
                return VmNull.withoutDefault();
            }
            int charExclusiveEnd = VmUtils.codePointOffsetToCharOffset(self, exclusiveEnd - start2, charStart);
            if (charExclusiveEnd < charStart) {
                return VmNull.withoutDefault();
            }
            return self.substring(charStart, charExclusiveEnd);
        }
    }

    public static abstract class substring
    extends ExternalMethod2Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected String eval(String self, long start2, long exclusiveEnd) {
            int charStart = VmUtils.codePointOffsetToCharOffset(self, start2);
            if (charStart == -1) {
                throw this.exceptionBuilder().evalError("charIndexOutOfRange", start2, 0, self.codePointCount(0, self.length())).withProgramValue("String", self).build();
            }
            int charExclusiveEnd = VmUtils.codePointOffsetToCharOffset(self, exclusiveEnd - start2, charStart);
            if (charExclusiveEnd < charStart) {
                throw this.exceptionBuilder().evalError("charIndexOutOfRange", exclusiveEnd, start2, self.codePointCount(0, self.length())).withProgramValue("String", self).build();
            }
            return self.substring(charStart, charExclusiveEnd);
        }
    }

    public static abstract class getOrNull
    extends ExternalMethod1Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object eval(String self, long index) {
            int charIndex = VmUtils.codePointOffsetToCharOffset(self, index);
            if (charIndex == -1 || charIndex == self.length()) {
                return VmNull.withoutDefault();
            }
            if (Character.isHighSurrogate(self.charAt(charIndex))) {
                return self.substring(charIndex, charIndex + 2);
            }
            return self.substring(charIndex, charIndex + 1);
        }
    }

    public static abstract class codePoints
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmList eval(String self) {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            self.codePoints().forEach(cp -> builder.add(cp));
            return builder.build();
        }
    }

    public static abstract class chars
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmList eval(String self) {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            self.codePoints().forEach(cp -> builder.add(Character.toString(cp)));
            return builder.build();
        }
    }

    public static abstract class isRegex
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected boolean eval(String self) {
            try {
                Pattern.compile(self, 64);
                return true;
            }
            catch (PatternSyntaxException e2) {
                return false;
            }
        }
    }

    public static abstract class isBlank
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(String self) {
            return StringUtils.isBlank(self);
        }
    }

    public static abstract class isEmpty
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(String self) {
            return self.isEmpty();
        }
    }

    public static abstract class lastIndex
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected long eval(String self) {
            return self.codePointCount(0, self.length()) - 1;
        }
    }

    public static abstract class length
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected long eval(String self) {
            return self.codePointCount(0, self.length());
        }
    }

    public static abstract class TakeDropLastWhile
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        protected int findOffset(String string, VmFunction function) {
            int length2;
            int offset;
            String codePoint;
            for (offset = length2 = string.length(); offset > 0 && this.applyLambdaNode.executeBoolean(function, codePoint = TakeDropLastWhile.codePointBefore(string, offset)); offset -= codePoint.length()) {
            }
            LoopNode.reportLoopCount(this, length2 - offset);
            return offset;
        }

        @CompilerDirectives.TruffleBoundary
        private static String codePointBefore(String string, int offset) {
            char ch1;
            char ch2 = string.charAt(offset - 1);
            if (Character.isLowSurrogate(ch2) && offset - 2 >= 0 && Character.isHighSurrogate(ch1 = string.charAt(offset - 2))) {
                return String.valueOf(new char[]{ch1, ch2});
            }
            return String.valueOf(ch2);
        }
    }

    public static abstract class TakeDropWhile
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        protected int findOffset(String string, VmFunction function) {
            int offset;
            String codePoint;
            int length2 = string.length();
            for (offset = 0; offset < length2 && this.applyLambdaNode.executeBoolean(function, codePoint = TakeDropWhile.codePointAt(string, offset)); offset += codePoint.length()) {
            }
            LoopNode.reportLoopCount(this, offset);
            return offset;
        }

        @CompilerDirectives.TruffleBoundary
        private static String codePointAt(String string, int offset) {
            char ch2;
            char ch1 = string.charAt(offset);
            if (Character.isHighSurrogate(ch1) && offset + 1 < string.length() && Character.isLowSurrogate(ch2 = string.charAt(offset + 1))) {
                return String.valueOf(new char[]{ch1, ch2});
            }
            return String.valueOf(ch1);
        }
    }
}

