/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import java.util.HashSet;
import org.pkl.core.ast.PklNode;
import org.pkl.core.ast.lambda.ApplyVmFunction1Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2NodeGen;
import org.pkl.core.ast.lambda.ApplyVmFunction3Node;
import org.pkl.core.ast.lambda.ApplyVmFunction3NodeGen;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectBuilder;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.MutableBoolean;
import org.pkl.core.util.MutableLong;
import org.pkl.core.util.MutableReference;

public final class ListingNodes {
    private ListingNodes() {
    }

    private static void checkNonEmpty(VmListing self, PklNode node) {
        if (self.isEmpty()) {
            CompilerDirectives.transferToInterpreter();
            throw new VmExceptionBuilder().evalError("expectedNonEmptyListing", new Object[0]).withLocation(node).build();
        }
    }

    private static void checkSingleton(VmListing self, PklNode node) {
        if (self.getLength() != 1) {
            CompilerDirectives.transferToInterpreter();
            throw new VmExceptionBuilder().evalError("expectedSingleElementListing", new Object[0]).withLocation(node).build();
        }
    }

    public static abstract class toSet
    extends ExternalMethod0Node {
        @Specialization
        protected VmSet eval(VmListing self) {
            VmCollection.Builder<VmSet> builder = VmSet.EMPTY.builder();
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                builder.add(value2);
                return true;
            });
            return builder.build();
        }
    }

    public static abstract class toList
    extends ExternalMethod0Node {
        @Specialization
        protected VmList eval(VmListing self) {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                builder.add(value2);
                return true;
            });
            return builder.build();
        }
    }

    public static abstract class join
    extends ExternalMethod1Node {
        @Specialization
        protected Object eval(VmListing self, String separator) {
            if (self.isEmpty()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                if (!key2.equals(0L)) {
                    builder.append(separator);
                }
                builder.append(value2);
                return true;
            });
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.toString();
        }
    }

    public static abstract class foldIndexed
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction3Node applyLambdaNode = ApplyVmFunction3NodeGen.create();

        @Specialization
        protected Object eval(VmListing self, Object initial, VmFunction function) {
            MutableLong index = new MutableLong(0L);
            MutableReference<Object> result = new MutableReference<Object>(initial);
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                result.set(this.applyLambdaNode.execute(function, index.getAndIncrement(), result.get(), value2));
                return true;
            });
            LoopNode.reportLoopCount(this, self.getLength());
            return result.get();
        }
    }

    public static abstract class fold
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmListing self, Object initial, VmFunction function) {
            MutableReference<Object> result = new MutableReference<Object>(initial);
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                result.set(this.applyLambdaNode.execute(function, result.get(), value2));
                return true;
            });
            LoopNode.reportLoopCount(this, self.getLength());
            return result.get();
        }
    }

    public static abstract class contains
    extends ExternalMethod1Node {
        @Specialization
        protected boolean eval(VmListing self, Object element) {
            MutableBoolean result = new MutableBoolean(false);
            self.iterateMemberValues((key2, member, value2) -> {
                if (value2 == null) {
                    value2 = VmUtils.readMember(self, key2);
                }
                result.set(element.equals(value2));
                return !result.get();
            });
            LoopNode.reportLoopCount(this, self.getLength());
            return result.get();
        }
    }

    public static abstract class any
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyNode = ApplyVmFunction1Node.create();

        @Specialization
        protected boolean eval(VmListing self, VmFunction predicate) {
            MutableBoolean result = new MutableBoolean(false);
            self.iterateMemberValues((key2, member, value2) -> {
                if (value2 == null) {
                    value2 = VmUtils.readMember(self, key2);
                }
                result.set(this.applyNode.executeBoolean(predicate, value2));
                return !result.get();
            });
            return result.get();
        }
    }

    public static abstract class every
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyNode = ApplyVmFunction1Node.create();

        @Specialization
        protected boolean eval(VmListing self, VmFunction predicate) {
            MutableBoolean result = new MutableBoolean(true);
            self.iterateMemberValues((key2, member, value2) -> {
                if (value2 == null) {
                    value2 = VmUtils.readMember(self, key2);
                }
                result.set(this.applyNode.executeBoolean(predicate, value2));
                return result.get();
            });
            return result.get();
        }
    }

    public static abstract class distinctBy
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmListing eval(VmListing self, VmFunction selector) {
            HashSet visitedValues = CollectionUtils.newHashSet();
            VmObjectBuilder builder = new VmObjectBuilder();
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                if (visitedValues.add(this.applyNode.execute(selector, value2))) {
                    builder.addElement(value2);
                }
                return true;
            });
            return builder.toListing();
        }
    }

    public static abstract class singleOrNull
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmListing self) {
            if (self.getLength() != 1) {
                return VmNull.withoutDefault();
            }
            return VmUtils.readMember(self, 0L);
        }
    }

    public static abstract class single
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmListing self) {
            ListingNodes.checkSingleton(self, this);
            return VmUtils.readMember(self, 0L);
        }
    }

    public static abstract class lastOrNull
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmListing self) {
            int length2 = self.getLength();
            return length2 == 0 ? VmNull.withoutDefault() : VmUtils.readMember(self, (long)length2 - 1L);
        }
    }

    public static abstract class last
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmListing self) {
            ListingNodes.checkNonEmpty(self, this);
            return VmUtils.readMember(self, (long)self.getLength() - 1L);
        }
    }

    public static abstract class firstOrNull
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmListing self) {
            if (self.isEmpty()) {
                return VmNull.withoutDefault();
            }
            return VmUtils.readMember(self, 0L);
        }
    }

    public static abstract class first
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmListing self) {
            ListingNodes.checkNonEmpty(self, this);
            return VmUtils.readMember(self, 0L);
        }
    }

    public static abstract class distinct
    extends ExternalPropertyNode {
        @Specialization
        protected VmListing eval(VmListing self) {
            HashSet visitedValues = CollectionUtils.newHashSet();
            VmObjectBuilder builder = new VmObjectBuilder();
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                if (visitedValues.add(value2)) {
                    builder.addElement(value2);
                }
                return true;
            });
            return builder.toListing();
        }
    }

    public static abstract class isDistinctBy
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyNode = ApplyVmFunction1Node.create();

        @Specialization
        protected boolean eval(VmListing self, VmFunction selector) {
            HashSet visitedValues = CollectionUtils.newHashSet();
            return self.forceAndIterateMemberValues((key2, member, value2) -> visitedValues.add(this.applyNode.execute(selector, value2)));
        }
    }

    public static abstract class isDistinct
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected boolean eval(VmListing self) {
            HashSet visitedValues = CollectionUtils.newHashSet();
            return self.forceAndIterateMemberValues((key2, member, value2) -> visitedValues.add(value2));
        }
    }

    public static abstract class getOrNull
    extends ExternalMethod1Node {
        @Specialization
        protected Object eval(VmListing self, long index) {
            if (index < 0L || index >= (long)self.getLength()) {
                return VmNull.withoutDefault();
            }
            return VmUtils.readMember(self, index);
        }
    }

    public static abstract class lastIndex
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmListing self) {
            return self.getLength() - 1;
        }
    }

    public static abstract class isEmpty
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(VmListing self) {
            return self.isEmpty();
        }
    }

    public static abstract class length
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmListing self) {
            return self.getLength();
        }
    }
}

