/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import org.pkl.core.DataSizeUnit;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.util.MathUtils;

public final class DataSizeNodes {
    private DataSizeNodes() {
    }

    public static abstract class toDecimalUnit
    extends ExternalMethod0Node {
        @Specialization
        protected VmDataSize eval(VmDataSize self) {
            return switch (self.getUnit()) {
                case DataSizeUnit.KIBIBYTES -> self.convertTo(DataSizeUnit.KILOBYTES);
                case DataSizeUnit.MEBIBYTES -> self.convertTo(DataSizeUnit.MEGABYTES);
                case DataSizeUnit.GIBIBYTES -> self.convertTo(DataSizeUnit.GIGABYTES);
                case DataSizeUnit.TEBIBYTES -> self.convertTo(DataSizeUnit.TERABYTES);
                case DataSizeUnit.PEBIBYTES -> self.convertTo(DataSizeUnit.PETABYTES);
                default -> self;
            };
        }
    }

    public static abstract class toBinaryUnit
    extends ExternalMethod0Node {
        @Specialization
        protected VmDataSize eval(VmDataSize self) {
            return switch (self.getUnit()) {
                case DataSizeUnit.KILOBYTES -> self.convertTo(DataSizeUnit.KIBIBYTES);
                case DataSizeUnit.MEGABYTES -> self.convertTo(DataSizeUnit.MEBIBYTES);
                case DataSizeUnit.GIGABYTES -> self.convertTo(DataSizeUnit.GIBIBYTES);
                case DataSizeUnit.TERABYTES -> self.convertTo(DataSizeUnit.TEBIBYTES);
                case DataSizeUnit.PETABYTES -> self.convertTo(DataSizeUnit.PEBIBYTES);
                default -> self;
            };
        }
    }

    public static abstract class isDecimalUnit
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(VmDataSize self) {
            int ordinal = self.getUnit().ordinal();
            return ordinal == 0 || ordinal % 2 == 1;
        }
    }

    public static abstract class isBinaryUnit
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(VmDataSize self) {
            int ordinal = self.getUnit().ordinal();
            return ordinal % 2 == 0;
        }
    }

    public static abstract class toUnit
    extends ExternalMethod1Node {
        @Specialization
        protected VmDataSize eval(VmDataSize self, String str) {
            DataSizeUnit unit2 = DataSizeUnit.parse(str);
            assert (unit2 != null);
            return self.convertTo(unit2);
        }
    }

    public static abstract class isBetween
    extends ExternalMethod2Node {
        @Specialization
        protected boolean eval(VmDataSize self, VmDataSize start2, VmDataSize inclusiveEnd) {
            return self.compareTo(start2) >= 0 && self.compareTo(inclusiveEnd) <= 0;
        }
    }

    public static abstract class isPositive
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(VmDataSize self) {
            return self.getValue() >= 0.0;
        }
    }

    public static abstract class unit
    extends ExternalPropertyNode {
        @Specialization
        protected String eval(VmDataSize self) {
            return self.getUnit().getSymbol();
        }
    }

    @ImportStatic(value={MathUtils.class})
    public static abstract class value
    extends ExternalPropertyNode {
        @Specialization(guards={"isMathematicalInteger(self.getValue())"})
        protected long evalInt(VmDataSize self) {
            return (long)self.getValue();
        }

        @Specialization(guards={"!isMathematicalInteger(self.getValue())"})
        protected double evalFloat(VmDataSize self) {
            return self.getValue();
        }
    }
}

