/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.util.function.Supplier;
import org.graalvm.collections.EconomicMap;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.RegularMemberNode;
import org.pkl.core.ast.member.TypeCheckedPropertyNodeGen;
import org.pkl.core.ast.member.UntypedObjectMemberNode;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public final class VmObjectFactory<E> {
    private final Supplier<VmClass> classSupplier;
    private final EconomicMap<Object, ObjectMember> members = EconomicMaps.create();
    private final boolean isPropertyTypeChecked = IoUtils.isTestMode();

    public VmObjectFactory(Supplier<VmClass> classSupplier) {
        this.classSupplier = classSupplier;
    }

    public VmObjectFactory<E> addIntProperty(String name, IntProperty<E> impl) {
        return this.doAddProperty(name, new IntPropertyNode<E>(impl));
    }

    public VmObjectFactory<E> addBooleanProperty(String name, BooleanProperty<E> impl) {
        return this.doAddProperty(name, new BooleanPropertyNode<E>(impl));
    }

    public VmObjectFactory<E> addStringProperty(String name, Property<E, String> impl) {
        return this.doAddProperty(name, new PropertyNode<E, String>(impl));
    }

    public VmObjectFactory<E> addValueProperty(String name, Property<E, VmValue> impl) {
        return this.doAddProperty(name, new PropertyNode<E, VmValue>(impl));
    }

    public VmObjectFactory<E> addDurationProperty(String name, Property<E, VmDuration> impl) {
        return this.doAddProperty(name, new PropertyNode<E, VmDuration>(impl));
    }

    public VmObjectFactory<E> addTypedProperty(String name, Property<E, VmTyped> impl) {
        return this.doAddProperty(name, new PropertyNode<E, VmTyped>(impl));
    }

    public VmObjectFactory<E> addListProperty(String name, Property<E, VmList> impl) {
        return this.doAddProperty(name, new PropertyNode<E, VmList>(impl));
    }

    public VmObjectFactory<E> addSetProperty(String name, Property<E, VmSet> impl) {
        return this.doAddProperty(name, new PropertyNode<E, VmSet>(impl));
    }

    public VmObjectFactory<E> addMapProperty(String name, Property<E, VmMap> impl) {
        return this.doAddProperty(name, new PropertyNode<E, VmMap>(impl));
    }

    public VmObjectFactory<E> addClassProperty(String name, Property<E, VmClass> impl) {
        return this.doAddProperty(name, new PropertyNode<E, VmClass>(impl));
    }

    public <T> VmObjectFactory<E> addProperty(String name, Property<E, T> impl) {
        return this.doAddProperty(name, new PropertyNode<E, T>(impl));
    }

    @CompilerDirectives.TruffleBoundary
    private VmObjectFactory<E> doAddProperty(String name, ExpressionNode bodyNode) {
        SourceSection section = VmUtils.unavailableSourceSection();
        Identifier identifier = Identifier.get(name);
        ObjectMember member = new ObjectMember(section, section, 0, identifier, name);
        RegularMemberNode node = this.isPropertyTypeChecked ? TypeCheckedPropertyNodeGen.create(null, new FrameDescriptor(), member, bodyNode) : new UntypedObjectMemberNode(null, new FrameDescriptor(), member, bodyNode);
        member.initMemberNode(node);
        if (this.members.put(identifier, member) != null) {
            throw new VmExceptionBuilder().bug("Duplicate definition of property `" + name + "` for object of type `" + this.classSupplier.get().getDisplayName() + "`.", new Object[0]).build();
        }
        return this;
    }

    @CompilerDirectives.TruffleBoundary
    public VmTyped create(@Nullable E extraStorage) {
        VmClass clazz = this.classSupplier.get();
        assert (clazz != null);
        VmTyped result = new VmTyped(VmUtils.createEmptyMaterializedFrame(), clazz.getPrototype(), clazz, this.members);
        result.setExtraStorage(extraStorage);
        return result;
    }

    private static final class IntPropertyNode<E>
    extends ExpressionNode {
        private final IntProperty<E> impl;

        public IntPropertyNode(IntProperty<E> impl) {
            this.impl = impl;
        }

        @Override
        public long executeInt(VirtualFrame frame) {
            return this.doExecute(VmUtils.getOwner(frame));
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.doExecute(VmUtils.getOwner(frame));
        }

        @CompilerDirectives.TruffleBoundary
        private long doExecute(VmObjectLike owner) {
            return this.impl.evaluate(owner.getExtraStorage());
        }
    }

    @FunctionalInterface
    public static interface IntProperty<E> {
        public long evaluate(E var1);
    }

    private static final class BooleanPropertyNode<E>
    extends ExpressionNode {
        private final BooleanProperty<E> impl;

        public BooleanPropertyNode(BooleanProperty<E> impl) {
            this.impl = impl;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frame) {
            return this.doExecute(VmUtils.getOwner(frame));
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.doExecute(VmUtils.getOwner(frame));
        }

        @CompilerDirectives.TruffleBoundary
        private boolean doExecute(VmObjectLike owner) {
            return this.impl.evaluate(owner.getExtraStorage());
        }
    }

    @FunctionalInterface
    public static interface BooleanProperty<E> {
        public boolean evaluate(E var1);
    }

    private static final class PropertyNode<E, T>
    extends ExpressionNode {
        private final Property<E, T> impl;

        public PropertyNode(Property<E, T> impl) {
            this.impl = impl;
        }

        @Override
        public Object executeGeneric(VirtualFrame frame) {
            return this.doExecute(VmUtils.getOwner(frame));
        }

        @CompilerDirectives.TruffleBoundary
        private T doExecute(VmObjectLike owner) {
            return this.impl.evaluate(owner.getExtraStorage());
        }
    }

    @FunctionalInterface
    public static interface Property<E, T> {
        public T evaluate(E var1);

        public static <T> Property<T, T> identity() {
            return t -> t;
        }
    }
}

