/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.service;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pkl.core.Closeables;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.ModuleSource;
import org.pkl.core.PklException;
import org.pkl.core.Release;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagers;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.StackFrameTransformers;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.ModuleKeyFactories;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.project.Project;
import org.pkl.core.resource.ResourceReaders;
import org.pkl.executor.spi.v1.ExecutorSpi;
import org.pkl.executor.spi.v1.ExecutorSpiException;
import org.pkl.executor.spi.v1.ExecutorSpiOptions;
import org.pkl.executor.spi.v1.ExecutorSpiOptions2;

public final class ExecutorSpiImpl
implements ExecutorSpi {
    private static final int MAX_HTTP_CLIENTS = 3;
    private final Map<HttpClientKey, HttpClient> httpClients;
    private final String pklVersion = Release.current().version().toString();

    public ExecutorSpiImpl() {
        LinkedHashMap<HttpClientKey, HttpClient> map2 = new LinkedHashMap<HttpClientKey, HttpClient>(8, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<HttpClientKey, HttpClient> eldest) {
                return this.size() > 3;
            }
        };
        this.httpClients = Collections.synchronizedMap(map2);
    }

    public String getPklVersion() {
        return this.pklVersion;
    }

    public String evaluatePath(Path modulePath2, ExecutorSpiOptions options) {
        List<Pattern> allowedModules2 = options.getAllowedModules().stream().map(Pattern::compile).collect(Collectors.toList());
        List<Pattern> allowedResources2 = options.getAllowedResources().stream().map(Pattern::compile).collect(Collectors.toList());
        SecurityManager securityManager2 = SecurityManagers.standard(allowedModules2, allowedResources2, SecurityManagers.defaultTrustLevels, options.getRootDir());
        StackFrameTransformer transformer = StackFrameTransformers.defaultTransformer;
        if (options.getRootDir() != null) {
            transformer = transformer.andThen(StackFrameTransformers.relativizeModuleUri(options.getRootDir().toUri()));
        }
        ModulePathResolver resolver = new ModulePathResolver(options.getModulePath());
        EvaluatorBuilder builder = EvaluatorBuilder.unconfigured().setStackFrameTransformer(transformer).setSecurityManager(securityManager2).setHttpClient(this.getOrCreateHttpClient(options)).addResourceReader(ResourceReaders.environmentVariable()).addResourceReader(ResourceReaders.externalProperty()).addResourceReader(ResourceReaders.modulePath(resolver)).addResourceReader(ResourceReaders.pkg()).addResourceReader(ResourceReaders.projectpackage()).addResourceReader(ResourceReaders.file()).addResourceReader(ResourceReaders.http()).addResourceReader(ResourceReaders.https()).addModuleKeyFactory(ModuleKeyFactories.standardLibrary).addModuleKeyFactories(ModuleKeyFactories.fromServiceProviders()).addModuleKeyFactory(ModuleKeyFactories.modulePath(resolver)).addModuleKeyFactory(ModuleKeyFactories.pkg).addModuleKeyFactory(ModuleKeyFactories.projectpackage).addModuleKeyFactory(ModuleKeyFactories.file).addModuleKeyFactory(ModuleKeyFactories.http).addModuleKeyFactory(ModuleKeyFactories.genericUrl).setEnvironmentVariables(options.getEnvironmentVariables()).setExternalProperties(options.getExternalProperties()).setTimeout(options.getTimeout()).setOutputFormat(options.getOutputFormat()).setModuleCacheDir(options.getModuleCacheDir());
        try {
            if (options.getProjectDir() != null) {
                Project project2 = Project.loadFromPath(options.getProjectDir().resolve("PklProject"), securityManager2, null, transformer, options.getEnvironmentVariables());
                builder.setProjectDependencies(project2.getDependencies());
            }
            Evaluator evaluator = builder.build();
            try {
                String string = evaluator.evaluateOutputText(ModuleSource.path(modulePath2));
                if (evaluator != null) {
                    evaluator.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                try {
                    if (evaluator != null) {
                        try {
                            evaluator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PklException e2) {
                    throw new ExecutorSpiException(e2.getMessage(), e2.getCause());
                }
            }
        }
        finally {
            Closeables.closeQuietly(builder.getModuleKeyFactories());
            Closeables.closeQuietly(builder.getResourceReaders());
        }
    }

    private HttpClient getOrCreateHttpClient(ExecutorSpiOptions options) {
        int testPort;
        List certificateBytes;
        List certificateFiles;
        try {
            if (options instanceof ExecutorSpiOptions2) {
                ExecutorSpiOptions2 options2 = (ExecutorSpiOptions2)options;
                certificateFiles = options2.getCertificateFiles();
                certificateBytes = options2.getCertificateBytes();
                testPort = options2.getTestPort();
            } else {
                certificateFiles = List.of();
                certificateBytes = List.of();
                testPort = -1;
            }
        }
        catch (NoClassDefFoundError e2) {
            certificateFiles = List.of();
            certificateBytes = List.of();
            testPort = -1;
        }
        HttpClientKey clientKey = new HttpClientKey(certificateFiles, certificateBytes, testPort);
        return this.httpClients.computeIfAbsent(clientKey, key2 -> {
            HttpClient.Builder builder = HttpClient.builder();
            for (Path path2 : key2.certificateFiles) {
                builder.addCertificates(path2);
            }
            for (byte[] bytes : key2.certificateBytes) {
                builder.addCertificates(bytes);
            }
            builder.setTestPort(key2.testPort);
            return builder.buildLazily();
        });
    }

    private static final class HttpClientKey {
        final Set<Path> certificateFiles;
        final Set<byte[]> certificateBytes;
        final int testPort;

        HttpClientKey(List<Path> certificateFiles, List<byte[]> certificateBytes, int testPort) {
            this.certificateFiles = Set.copyOf(certificateFiles);
            this.certificateBytes = Set.copyOf(certificateBytes);
            this.testPort = testPort;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            HttpClientKey that = (HttpClientKey)obj;
            return this.certificateFiles.equals(that.certificateFiles) && this.certificateBytes.equals(that.certificateBytes) && this.testPort == that.testPort;
        }

        public int hashCode() {
            return Objects.hash(this.certificateFiles, this.certificateBytes, this.testPort);
        }
    }
}

