/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.pkl.core.ImportGraph;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.ast.builder.ImportsAndReadsParser;
import org.pkl.core.externalreader.ExternalReaderProcessException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.GlobResolver;
import org.pkl.core.util.IoUtils;

public class VmImportAnalyzer {
    @CompilerDirectives.TruffleBoundary
    public static ImportGraph analyze(URI[] moduleUris, VmContext context2) throws IOException, URISyntaxException, SecurityManagerException, ExternalReaderProcessException {
        TreeMap<URI, Set<ImportGraph.Import>> imports = new TreeMap<URI, Set<ImportGraph.Import>>();
        TreeMap<URI, URI> resolvedImports = new TreeMap<URI, URI>();
        for (URI moduleUri : moduleUris) {
            VmImportAnalyzer.analyzeSingle(moduleUri, context2, imports, resolvedImports);
        }
        return new ImportGraph(imports, resolvedImports);
    }

    @CompilerDirectives.TruffleBoundary
    private static void analyzeSingle(URI moduleUri, VmContext context2, Map<URI, Set<ImportGraph.Import>> imports, Map<URI, URI> resolvedImports) throws IOException, URISyntaxException, SecurityManagerException, ExternalReaderProcessException {
        ModuleResolver moduleResolver = context2.getModuleResolver();
        SecurityManager securityManager2 = context2.getSecurityManager();
        Set<ImportGraph.Import> importsInModule = VmImportAnalyzer.collectImports(moduleUri, moduleResolver, securityManager2);
        imports.put(moduleUri, importsInModule);
        resolvedImports.put(moduleUri, moduleResolver.resolve(moduleUri).resolve(securityManager2).getUri());
        for (ImportGraph.Import imprt : importsInModule) {
            if (imports.containsKey(imprt.uri())) continue;
            VmImportAnalyzer.analyzeSingle(imprt.uri(), context2, imports, resolvedImports);
        }
    }

    private static Set<ImportGraph.Import> collectImports(URI moduleUri, ModuleResolver moduleResolver, SecurityManager securityManager2) throws IOException, URISyntaxException, SecurityManagerException, ExternalReaderProcessException {
        List<ImportsAndReadsParser.Entry> importsAndReads;
        ModuleKey moduleKey = moduleResolver.resolve(moduleUri);
        ResolvedModuleKey resolvedModuleKey = moduleKey.resolve(securityManager2);
        try {
            importsAndReads = ImportsAndReadsParser.parse(moduleKey, resolvedModuleKey);
        }
        catch (VmException err) {
            throw new VmExceptionBuilder().evalError("cannotAnalyzeBecauseSyntaxError", moduleKey.getUri()).wrapping(err).build();
        }
        if (importsAndReads == null) {
            return Set.of();
        }
        TreeSet<ImportGraph.Import> result = new TreeSet<ImportGraph.Import>();
        for (ImportsAndReadsParser.Entry entry : importsAndReads) {
            if (!entry.isModule()) continue;
            if (entry.isGlob()) {
                ModuleKey theModuleKey = moduleResolver.resolve(moduleKey.resolveUri(IoUtils.toUri(entry.stringValue())));
                try {
                    Map<String, GlobResolver.ResolvedGlobElement> elements = GlobResolver.resolveGlob(securityManager2, theModuleKey, moduleKey, moduleKey.getUri(), entry.stringValue());
                    List<ImportGraph.Import> globImports = elements.values().stream().map(GlobResolver.ResolvedGlobElement::getUri).map(ImportGraph.Import::new).toList();
                    result.addAll(globImports);
                    continue;
                }
                catch (GlobResolver.InvalidGlobPatternException e2) {
                    throw new VmExceptionBuilder().evalError("invalidGlobPattern", entry.stringValue()).withSourceSection(entry.sourceSection()).build();
                }
            }
            URI resolvedUri = IoUtils.resolve(securityManager2, moduleKey, IoUtils.toUri(entry.stringValue()));
            result.add(new ImportGraph.Import(resolvedUri));
        }
        return result;
    }
}

