/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.pkl.core.Release;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.http.HttpClientInitException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeys;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.runtime.AnalyzeModule;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.BenchmarkModule;
import org.pkl.core.runtime.JsonnetModule;
import org.pkl.core.runtime.MathModule;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.PlatformModule;
import org.pkl.core.runtime.ProjectModule;
import org.pkl.core.runtime.ReflectModule;
import org.pkl.core.runtime.ReleaseModule;
import org.pkl.core.runtime.SemVerModule;
import org.pkl.core.runtime.SettingsModule;
import org.pkl.core.runtime.TestModule;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.XmlModule;
import org.pkl.core.util.Nullable;

public final class ModuleCache {
    private static final Set<URI> STDLIB_MODULE_URIS = Release.current().standardLibrary().modules().stream().map(URI::create).collect(Collectors.toSet());
    private final Map<URI, Object> modulesByOriginalUri = new HashMap<URI, Object>();
    private final Map<URI, Object> modulesByResolvedUri = new HashMap<URI, Object>();

    @CompilerDirectives.TruffleBoundary
    public synchronized VmTyped getOrLoad(ModuleKey moduleKey, SecurityManager securityManager2, ModuleResolver moduleResolver, Supplier<VmTyped> moduleInstantiator, ModuleInitializer moduleInitializer, @Nullable Node importNode) {
        if (ModuleKeys.isStdLibModule(moduleKey)) {
            String moduleName;
            switch (moduleName = moduleKey.getUri().getSchemeSpecificPart()) {
                case "analyze": {
                    return AnalyzeModule.getModule();
                }
                case "base": {
                    return BaseModule.getModule();
                }
                case "Benchmark": {
                    return BenchmarkModule.getModule();
                }
                case "jsonnet": {
                    return JsonnetModule.getModule();
                }
                case "math": {
                    return MathModule.getModule();
                }
                case "platform": {
                    return PlatformModule.getModule();
                }
                case "project": {
                    return ProjectModule.getModule();
                }
                case "reflect": {
                    return ReflectModule.getModule();
                }
                case "release": {
                    return ReleaseModule.getModule();
                }
                case "semver": {
                    return SemVerModule.getModule();
                }
                case "settings": {
                    return SettingsModule.getModule();
                }
                case "test": {
                    return TestModule.getModule();
                }
                case "xml": {
                    return XmlModule.getModule();
                }
            }
            if (!STDLIB_MODULE_URIS.contains(moduleKey.getUri())) {
                String stdlibModules = String.join((CharSequence)"\n", Release.current().standardLibrary().modules());
                throw new VmExceptionBuilder().withOptionalLocation(importNode).evalError("cannotFindStdLibModule", moduleName, stdlibModules).build();
            }
        }
        if (!moduleKey.isCached()) {
            ResolvedModuleKey resolvedKey = this.resolve(moduleKey, securityManager2, importNode);
            return this.doLoad(moduleKey, resolvedKey, moduleResolver, moduleInstantiator, moduleInitializer, importNode);
        }
        Object module1 = this.modulesByOriginalUri.get(moduleKey.getUri());
        if (module1 != null) {
            if (module1 instanceof VmTyped) {
                VmTyped typed = (VmTyped)module1;
                return typed;
            }
            assert (module1 instanceof RuntimeException);
            throw (RuntimeException)module1;
        }
        ResolvedModuleKey resolvedKey = this.resolve(moduleKey, securityManager2, importNode);
        Object module2 = this.modulesByResolvedUri.get(resolvedKey.getUri());
        if (module2 != null) {
            if (module2 instanceof VmTyped) {
                VmTyped typed = (VmTyped)module2;
                return typed;
            }
            assert (module2 instanceof RuntimeException);
            throw (RuntimeException)module2;
        }
        return this.doLoad(moduleKey, resolvedKey, moduleResolver, moduleInstantiator, moduleInitializer, importNode);
    }

    private VmTyped doLoad(ModuleKey moduleKey, ResolvedModuleKey resolvedKey, ModuleResolver moduleResolver, Supplier<VmTyped> moduleInstantiator, ModuleInitializer moduleInitializer, @Nullable Node importNode) {
        VmTyped module = moduleInstantiator.get();
        try {
            Source result = VmUtils.loadSource(resolvedKey);
            this.modulesByOriginalUri.put(moduleKey.getUri(), module);
            this.modulesByResolvedUri.put(resolvedKey.getUri(), module);
            moduleInitializer.initialize(moduleKey, resolvedKey, moduleResolver, result, module, importNode);
        }
        catch (Exception e2) {
            this.modulesByOriginalUri.put(moduleKey.getUri(), e2);
            this.modulesByResolvedUri.put(resolvedKey.getUri(), e2);
            throw e2;
        }
        return module;
    }

    private ResolvedModuleKey resolve(ModuleKey module, SecurityManager securityManager2, @Nullable Node importNode) {
        try {
            return module.resolve(securityManager2);
        }
        catch (SecurityManagerException | HttpClientInitException | PackageLoadError e2) {
            throw new VmExceptionBuilder().withOptionalLocation(importNode).withCause(e2).build();
        }
        catch (FileNotFoundException | NoSuchFileException e3) {
            VmExceptionBuilder exceptionBuilder = new VmExceptionBuilder().withOptionalLocation(importNode).evalError("cannotFindModule", module.getUri());
            String path2 = module.getUri().getPath();
            if (path2 != null && path2.contains("\\")) {
                exceptionBuilder.withHint("To resolve modules in nested directories, use `/` as the directory separator.");
            }
            throw exceptionBuilder.build();
        }
        catch (IOException e4) {
            throw new VmExceptionBuilder().withOptionalLocation(importNode).evalError("ioErrorLoadingModule", module.getUri()).withCause(e4).build();
        }
    }

    public static interface ModuleInitializer {
        public void initialize(ModuleKey var1, ResolvedModuleKey var2, ModuleResolver var3, Source var4, VmTyped var5, @Nullable Node var6);
    }
}

