/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;

public final class Iterators {
    private static final Iterator EMPTY_TRUFFLE_ITERATOR = new Iterator(){

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasNext() {
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void remove() {
            throw new IllegalStateException();
        }

        @CompilerDirectives.TruffleBoundary
        public void forEachRemaining(Consumer action) {
            throw new UnsupportedOperationException("forEachRemaining");
        }
    };

    private Iterators() {
    }

    public static <T> Iterator<T> emptyTruffleIterator() {
        return EMPTY_TRUFFLE_ITERATOR;
    }

    public static final class ReverseArrayIterator
    implements Iterator<Object> {
        private final Object[] array;
        private int nextIndex;

        public ReverseArrayIterator(Object[] array) {
            this.array = array;
            this.nextIndex = array.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        @Override
        public Object next() {
            return this.array[this.nextIndex--];
        }
    }

    public static final class ReverseTruffleIterator<T>
    implements Iterator<T> {
        private final ListIterator<? extends T> delegate;

        @CompilerDirectives.TruffleBoundary
        public ReverseTruffleIterator(List<? extends T> list) {
            this.delegate = list.listIterator(list.size());
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasNext() {
            return this.delegate.hasPrevious();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public T next() {
            return this.delegate.previous();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void forEachRemaining(Consumer<? super T> action) {
            throw new UnsupportedOperationException("forEachRemaining");
        }
    }

    public static final class TruffleIterator<T>
    implements Iterator<T> {
        private final Iterator<? extends T> delegate;

        @CompilerDirectives.TruffleBoundary
        public TruffleIterator(Iterable<? extends T> iterable) {
            this.delegate = iterable.iterator();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public T next() {
            return this.delegate.next();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void forEachRemaining(Consumer<? super T> action) {
            throw new UnsupportedOperationException("forEachRemaining");
        }
    }
}

