/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.externalreader.ExternalReaderProcess;
import org.pkl.core.externalreader.ExternalReaderProcessException;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.FileResolver;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.module.PathElement;
import org.pkl.core.module.ProjectDependenciesManager;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.PackageAssetUri;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.resource.ExternalResourceResolver;
import org.pkl.core.resource.Resource;
import org.pkl.core.resource.ResourceReader;
import org.pkl.core.runtime.ResourceManager;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.HttpUtils;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public final class ResourceReaders {
    private ResourceReaders() {
    }

    public static ResourceReader environmentVariable() {
        return EnvironmentVariable.INSTANCE;
    }

    public static ResourceReader externalProperty() {
        return ExternalProperty.INSTANCE;
    }

    public static ResourceReader file() {
        return FileResource.INSTANCE;
    }

    public static ResourceReader http() {
        return HttpResource.INSTANCE;
    }

    public static ResourceReader https() {
        return HttpsResource.INSTANCE;
    }

    public static ResourceReader classPath(ClassLoader classLoader) {
        return new ClassPathResource(classLoader);
    }

    public static ResourceReader modulePath(ModulePathResolver resolver) {
        return new ModulePathResource(resolver);
    }

    public static ResourceReader pkg() {
        return PackageResource.INSTANCE;
    }

    public static ResourceReader projectpackage() {
        return ProjectPackageResource.INSTANCE;
    }

    public static List<ResourceReader> fromServiceProviders() {
        return FromServiceProviders.INSTANCE;
    }

    public static ResourceReader externalProcess(String scheme, ExternalReaderProcess process) {
        return new ExternalProcess(scheme, process, 0L);
    }

    public static ResourceReader externalProcess(String scheme, ExternalReaderProcess process, long evaluatorId) {
        return new ExternalProcess(scheme, process, evaluatorId);
    }

    public static ResourceReader externalResolver(ExternalResourceResolver.Spec spec, ExternalResourceResolver resolver) {
        return new ExternalResolver(spec, resolver);
    }

    private static final class EnvironmentVariable
    implements ResourceReader {
        static final ResourceReader INSTANCE = new EnvironmentVariable();

        private EnvironmentVariable() {
        }

        @Override
        public String getUriScheme() {
            return "env";
        }

        @Override
        public Optional<Object> read(URI uri) {
            assert (uri.getScheme().equals("env"));
            VmContext context2 = VmContext.get(null);
            String value2 = context2.getEnvironmentVariables().get(uri.getSchemeSpecificPart());
            return Optional.ofNullable(value2);
        }

        @Override
        public boolean hasHierarchicalUris() {
            return false;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager2, URI baseUri) throws SecurityManagerException {
            securityManager2.checkResolveResource(baseUri);
            VmContext context2 = VmContext.get(null);
            ArrayList<PathElement> ret = new ArrayList<PathElement>();
            for (String envVarName : context2.getEnvironmentVariables().keySet()) {
                ret.add(PathElement.opaque(envVarName));
            }
            return ret;
        }
    }

    private static final class ExternalProperty
    implements ResourceReader {
        static final ResourceReader INSTANCE = new ExternalProperty();

        private ExternalProperty() {
        }

        @Override
        public String getUriScheme() {
            return "prop";
        }

        @Override
        public Optional<Object> read(URI uri) {
            assert (uri.getScheme().equals("prop"));
            VmContext context2 = VmContext.get(null);
            String value2 = context2.getExternalProperties().get(uri.getSchemeSpecificPart());
            return Optional.ofNullable(value2);
        }

        @Override
        public boolean hasHierarchicalUris() {
            return false;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager2, URI baseUri) throws SecurityManagerException {
            securityManager2.checkResolveResource(baseUri);
            VmContext context2 = VmContext.get(null);
            ArrayList<PathElement> ret = new ArrayList<PathElement>();
            for (String propName : context2.getExternalProperties().keySet()) {
                ret.add(PathElement.opaque(propName));
            }
            return ret;
        }
    }

    private static final class FileResource
    extends UrlResource {
        static final ResourceReader INSTANCE = new FileResource();

        private FileResource() {
        }

        @Override
        public String getUriScheme() {
            return "file";
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public boolean hasElement(SecurityManager securityManager2, URI elementUri) throws SecurityManagerException {
            securityManager2.checkResolveResource(elementUri);
            return FileResolver.hasElement(elementUri);
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager2, URI baseUri) throws IOException, SecurityManagerException {
            securityManager2.checkResolveResource(baseUri);
            return FileResolver.listElements(baseUri);
        }
    }

    private static final class HttpResource
    extends UrlResource {
        static final ResourceReader INSTANCE = new HttpResource();

        private HttpResource() {
        }

        @Override
        public String getUriScheme() {
            return "http";
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }
    }

    private static final class HttpsResource
    extends UrlResource {
        static final ResourceReader INSTANCE = new HttpsResource();

        private HttpsResource() {
        }

        @Override
        public String getUriScheme() {
            return "https";
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }
    }

    private static final class ClassPathResource
    implements ResourceReader {
        private final ClassLoader classLoader;

        public ClassPathResource(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        @Override
        public String getUriScheme() {
            return "modulepath";
        }

        @Override
        public Optional<Object> read(URI uri) throws URISyntaxException {
            Optional<Object> optional2;
            block10: {
                assert (uri.getScheme().equals("modulepath"));
                if (uri.getPath() == null) {
                    throw new URISyntaxException(uri.toString(), ErrorMessages.create("invalidModuleUriMissingSlash", uri, "modulepath"));
                }
                String path2 = ClassPathResource.getResourcePath(uri);
                InputStream stream = this.classLoader.getResourceAsStream(path2);
                try {
                    Optional<Object> optional3 = optional2 = stream == null ? Optional.empty() : Optional.of(new Resource(uri, stream.readAllBytes()));
                    if (stream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e2) {
                        return Optional.empty();
                    }
                }
                stream.close();
            }
            return optional2;
        }

        private static String getResourcePath(URI uri) {
            String path2 = uri.getPath();
            assert (path2.charAt(0) == '/');
            return path2.substring(1);
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }

        @Override
        public boolean hasElement(SecurityManager manager, URI uri) throws SecurityManagerException {
            manager.checkResolveResource(uri);
            String uriPath = uri.getPath();
            assert (uriPath.charAt(0) == '/');
            return this.classLoader.getResource(uriPath.substring(1)) != null;
        }
    }

    private static final class ModulePathResource
    implements ResourceReader {
        private final ModulePathResolver resolver;

        public ModulePathResource(ModulePathResolver resolver) {
            this.resolver = resolver;
        }

        @Override
        public String getUriScheme() {
            return "modulepath";
        }

        @Override
        public Optional<Object> read(URI uri) throws IOException, URISyntaxException {
            assert (uri.getScheme().equals("modulepath"));
            if (uri.getPath() == null) {
                throw new URISyntaxException(uri.toString(), ErrorMessages.create("invalidModuleUriMissingSlash", uri, "modulepath"));
            }
            try {
                Path path2 = this.resolver.resolve(uri);
                byte[] content = Files.readAllBytes(path2);
                return Optional.of(new Resource(uri, content));
            }
            catch (FileNotFoundException e2) {
                return Optional.empty();
            }
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return false;
        }

        @Override
        public boolean hasElement(SecurityManager securityManager2, URI elementUri) throws SecurityManagerException {
            securityManager2.checkResolveResource(elementUri);
            return this.resolver.hasElement(elementUri);
        }
    }

    private static final class PackageResource
    implements ResourceReader {
        static final PackageResource INSTANCE = new PackageResource();

        private PackageResource() {
        }

        @Override
        public String getUriScheme() {
            return "package";
        }

        @Override
        public Optional<Object> read(URI uri) throws IOException, URISyntaxException, SecurityManagerException {
            PackageAssetUri assetUri = new PackageAssetUri(uri);
            byte[] bytes = this.getPackageResolver().getBytes(assetUri, true, null);
            return Optional.of(new Resource(uri, bytes));
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public boolean hasFragmentPaths() {
            return true;
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager2, URI baseUri) throws IOException, SecurityManagerException {
            securityManager2.checkResolveResource(baseUri);
            PackageAssetUri packageAssetUri = PackageAssetUri.create(baseUri);
            return this.getPackageResolver().listElements(packageAssetUri, packageAssetUri.getPackageUri().getChecksums());
        }

        @Override
        public boolean hasElement(SecurityManager securityManager2, URI elementUri) throws IOException, SecurityManagerException {
            securityManager2.checkResolveResource(elementUri);
            PackageAssetUri packageAssetUri = PackageAssetUri.create(elementUri);
            return this.getPackageResolver().hasElement(packageAssetUri, packageAssetUri.getPackageUri().getChecksums());
        }

        private PackageResolver getPackageResolver() {
            PackageResolver packageResolver = VmContext.get(null).getPackageResolver();
            assert (packageResolver != null);
            return packageResolver;
        }
    }

    private static final class ProjectPackageResource
    implements ResourceReader {
        static final ProjectPackageResource INSTANCE = new ProjectPackageResource();

        private ProjectPackageResource() {
        }

        @Override
        public String getUriScheme() {
            return "projectpackage";
        }

        @Override
        public Optional<Object> read(URI uri) throws IOException, URISyntaxException, SecurityManagerException {
            PackageAssetUri assetUri = new PackageAssetUri(uri);
            Dependency dependency = this.getProjectDepsResolver().getResolvedDependency(assetUri.getPackageUri());
            URI local = this.getLocalUri(dependency, assetUri);
            if (local != null) {
                ResourceManager resourceManager = VmContext.get(null).getResourceManager();
                SecurityManager securityManager2 = VmContext.get(null).getSecurityManager();
                securityManager2.checkReadResource(local);
                ResourceReader reader = resourceManager.getResourceReader(local);
                if (reader == null) {
                    throw new VmExceptionBuilder().evalError("noResourceReaderRegistered", uri.getScheme()).build();
                }
                return resourceManager.doRead(reader, local, null);
            }
            Dependency.RemoteDependency remoteDep = (Dependency.RemoteDependency)dependency;
            byte[] bytes = this.getPackageResolver().getBytes(assetUri, true, remoteDep.getChecksums());
            return Optional.of(new Resource(uri, bytes));
        }

        @Override
        public boolean hasHierarchicalUris() {
            return true;
        }

        @Override
        public boolean isGlobbable() {
            return true;
        }

        @Override
        public boolean hasFragmentPaths() {
            return true;
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager2, URI baseUri) throws IOException, SecurityManagerException, ExternalReaderProcessException {
            securityManager2.checkResolveResource(baseUri);
            PackageAssetUri packageAssetUri = PackageAssetUri.create(baseUri);
            Dependency dependency = this.getProjectDepsResolver().getResolvedDependency(packageAssetUri.getPackageUri());
            URI local = this.getLocalUri(dependency, packageAssetUri);
            if (local != null) {
                ResourceReader reader = VmContext.get(null).getResourceManager().getResourceReader(local);
                if (reader == null) {
                    throw new VmExceptionBuilder().evalError("noResourceReaderRegistered", local.getScheme()).build();
                }
                return reader.listElements(securityManager2, local);
            }
            Dependency.RemoteDependency remoteDep = (Dependency.RemoteDependency)dependency;
            return this.getPackageResolver().listElements(PackageAssetUri.create(baseUri), remoteDep.getChecksums());
        }

        @Override
        public boolean hasElement(SecurityManager securityManager2, URI elementUri) throws IOException, SecurityManagerException, ExternalReaderProcessException {
            securityManager2.checkResolveResource(elementUri);
            PackageAssetUri packageAssetUri = PackageAssetUri.create(elementUri);
            Dependency dependency = this.getProjectDepsResolver().getResolvedDependency(packageAssetUri.getPackageUri());
            URI local = this.getLocalUri(dependency, packageAssetUri);
            if (local != null) {
                ResourceReader reader = VmContext.get(null).getResourceManager().getResourceReader(local);
                if (reader == null) {
                    throw new VmExceptionBuilder().evalError("noResourceReaderRegistered", local.getScheme()).build();
                }
                return reader.hasElement(securityManager2, local);
            }
            Dependency.RemoteDependency remoteDep = (Dependency.RemoteDependency)dependency;
            return this.getPackageResolver().hasElement(PackageAssetUri.create(elementUri), remoteDep.getChecksums());
        }

        private PackageResolver getPackageResolver() {
            PackageResolver packageResolver = VmContext.get(null).getPackageResolver();
            assert (packageResolver != null);
            return packageResolver;
        }

        private ProjectDependenciesManager getProjectDepsResolver() {
            ProjectDependenciesManager projectDepsManager = VmContext.get(null).getProjectDependenciesManager();
            assert (projectDepsManager != null);
            return projectDepsManager;
        }

        @Nullable
        private URI getLocalUri(Dependency dependency, PackageAssetUri packageAssetUri) {
            if (!(dependency instanceof Dependency.LocalDependency)) {
                return null;
            }
            Dependency.LocalDependency localDependency = (Dependency.LocalDependency)dependency;
            return localDependency.resolveAssetUri(this.getProjectDepsResolver().getProjectBaseUri(), packageAssetUri);
        }
    }

    private static class FromServiceProviders {
        private static final List<ResourceReader> INSTANCE;

        private FromServiceProviders() {
        }

        static {
            ServiceLoader<ResourceReader> loader = IoUtils.createServiceLoader(ResourceReader.class);
            ArrayList readers = new ArrayList();
            loader.forEach(readers::add);
            INSTANCE = Collections.unmodifiableList(readers);
        }
    }

    private static final class ExternalProcess
    implements ResourceReader {
        private final String scheme;
        private final ExternalReaderProcess process;
        private final long evaluatorId;
        private ExternalResolver underlying;

        public ExternalProcess(String scheme, ExternalReaderProcess process, long evaluatorId) {
            this.scheme = scheme;
            this.process = process;
            this.evaluatorId = evaluatorId;
        }

        private ExternalResolver getUnderlyingReader() throws ExternalReaderProcessException, IOException {
            if (this.underlying != null) {
                return this.underlying;
            }
            ExternalResourceResolver.Spec spec = this.process.getResourceReaderSpec(this.scheme);
            if (spec == null) {
                throw new ExternalReaderProcessException(ErrorMessages.create("externalReaderDoesNotSupportScheme", "resource", this.scheme));
            }
            this.underlying = new ExternalResolver(spec, this.process.getResourceResolver(this.evaluatorId));
            return this.underlying;
        }

        @Override
        public String getUriScheme() {
            return this.scheme;
        }

        @Override
        public boolean hasHierarchicalUris() throws ExternalReaderProcessException, IOException {
            return this.getUnderlyingReader().hasHierarchicalUris();
        }

        @Override
        public boolean isGlobbable() throws ExternalReaderProcessException, IOException {
            return this.getUnderlyingReader().isGlobbable();
        }

        @Override
        public Optional<Object> read(URI uri) throws IOException, ExternalReaderProcessException {
            return this.getUnderlyingReader().read(uri);
        }

        @Override
        public boolean hasElement(SecurityManager securityManager2, URI elementUri) throws IOException, SecurityManagerException, ExternalReaderProcessException {
            return this.getUnderlyingReader().hasElement(securityManager2, elementUri);
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager2, URI baseUri) throws IOException, SecurityManagerException, ExternalReaderProcessException {
            return this.getUnderlyingReader().listElements(securityManager2, baseUri);
        }

        @Override
        public void close() {
            this.process.close();
        }
    }

    private static final class ExternalResolver
    implements ResourceReader {
        private final ExternalResourceResolver.Spec readerSpec;
        private final ExternalResourceResolver resolver;

        public ExternalResolver(ExternalResourceResolver.Spec readerSpec, ExternalResourceResolver resolver) {
            this.readerSpec = readerSpec;
            this.resolver = resolver;
        }

        @Override
        public boolean hasHierarchicalUris() {
            return this.readerSpec.hasHierarchicalUris();
        }

        @Override
        public boolean isGlobbable() {
            return this.readerSpec.isGlobbable();
        }

        @Override
        public String getUriScheme() {
            return this.readerSpec.scheme();
        }

        @Override
        public Optional<Object> read(URI uri) throws IOException {
            return this.resolver.read(uri);
        }

        @Override
        public boolean hasElement(SecurityManager securityManager2, URI elementUri) throws SecurityManagerException {
            return this.resolver.hasElement(securityManager2, elementUri);
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager2, URI baseUri) throws IOException, SecurityManagerException {
            return this.resolver.listElements(securityManager2, baseUri);
        }
    }

    private static abstract class UrlResource
    implements ResourceReader {
        private UrlResource() {
        }

        @Override
        public Optional<Object> read(URI uri) throws IOException {
            if (HttpUtils.isHttpUrl(uri)) {
                HttpRequest request;
                HttpClient httpClient2 = VmContext.get(null).getHttpClient();
                HttpResponse<byte[]> response = httpClient2.send(request = HttpRequest.newBuilder(uri).build(), HttpResponse.BodyHandlers.ofByteArray());
                if (response.statusCode() == 404) {
                    return Optional.empty();
                }
                HttpUtils.checkHasStatusCode200(response);
                return Optional.of(new Resource(uri, response.body()));
            }
            try {
                byte[] content = IoUtils.readBytes(uri);
                return Optional.of(new Resource(uri, content));
            }
            catch (FileNotFoundException e2) {
                return Optional.empty();
            }
        }
    }
}

