/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.project;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Path;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.pkl.core.PklException;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.DependencyMetadata;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.project.CanonicalPackageUri;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.project.Project;
import org.pkl.core.project.ProjectDeps;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.EconomicSets;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;

public final class ProjectDependenciesResolver {
    private final Project project;
    private final PackageResolver packageResolver;
    private final Writer logWriter;
    private final EconomicMap<CanonicalPackageUri, Dependency> resolvedDependencies = EconomicMaps.create();
    private final EconomicSet<PackageUri> alreadyHandledDependencies = EconomicSets.create();

    public ProjectDependenciesResolver(Project project2, PackageResolver packageResolver, Writer logWriter) {
        this.project = project2;
        this.packageResolver = packageResolver;
        this.logWriter = logWriter;
    }

    public ProjectDeps resolve() {
        this.buildResolvedDependencies(this.project.getDependencies());
        for (DeclaredDependencies localProject : this.project.getDependencies().getLocalDependencies().values()) {
            PackageUri packageUri = localProject.getMyPackageUri();
            assert (packageUri != null);
            CanonicalPackageUri canonicalUri = CanonicalPackageUri.fromPackageUri(packageUri);
            Dependency resolvedDependency = (Dependency)this.resolvedDependencies.get(canonicalUri);
            if (this.resolvedDependencies.get(canonicalUri) instanceof Dependency.LocalDependency) continue;
            this.log(String.format("WARN: local dependency `%s` was overridden to remote dependency `%s`.", packageUri.getDisplayName(), resolvedDependency.getPackageUri().getDisplayName()));
        }
        return new ProjectDeps(this.resolvedDependencies);
    }

    private void log(String message) {
        try {
            this.logWriter.write(message + IoUtils.getLineSeparator());
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private void buildResolvedDependencies(DeclaredDependencies declaredDependencies) {
        for (Dependency.RemoteDependency dependency : declaredDependencies.getRemoteDependencies().values()) {
            this.resolveDependenciesOfPackageUri(dependency.getPackageUri().toProjectPackageUri(), dependency.getChecksums());
        }
        for (DeclaredDependencies localDeclaredDependencies : declaredDependencies.getLocalDependencies().values()) {
            this.resolveDependencies(localDeclaredDependencies);
        }
    }

    private void resolveDependenciesOfPackageUri(PackageUri packageUri, @Nullable Checksums expectedChecksums) {
        try {
            if (this.alreadyHandledDependencies.contains(packageUri)) {
                return;
            }
            Pair<DependencyMetadata, Checksums> pair2 = this.packageResolver.getDependencyMetadataAndComputeChecksum(packageUri);
            DependencyMetadata metadata = (DependencyMetadata)pair2.first;
            Checksums computedChecksums = (Checksums)pair2.second;
            if (expectedChecksums != null && !expectedChecksums.getSha256().equals(computedChecksums.getSha256())) {
                throw new PklException(ErrorMessages.create("invalidDeclaredChecksum", packageUri.getDisplayName(), computedChecksums.getSha256(), expectedChecksums.getSha256()));
            }
            Dependency.RemoteDependency dependencyWithChecksum = new Dependency.RemoteDependency(packageUri, computedChecksums);
            this.updateDependency(dependencyWithChecksum);
            EconomicSets.add(this.alreadyHandledDependencies, packageUri);
            for (Dependency.RemoteDependency transitiveDependency : metadata.getDependencies().values()) {
                this.resolveDependenciesOfPackageUri(transitiveDependency.getPackageUri().toProjectPackageUri(), transitiveDependency.getChecksums());
            }
        }
        catch (IOException | SecurityManagerException | PackageLoadError e2) {
            throw new PklException(e2.getMessage(), e2);
        }
    }

    private void resolveDependencies(DeclaredDependencies declaredDependencies) {
        PackageUri packageUri = declaredDependencies.getMyPackageUri();
        assert (packageUri != null);
        Path projectDir = Path.of(declaredDependencies.getProjectFileUri()).getParent();
        Path relativePath = IoUtils.relativize(projectDir, this.project.getProjectDir());
        Dependency.LocalDependency localDependency = new Dependency.LocalDependency(packageUri.toProjectPackageUri(), relativePath);
        this.updateDependency(localDependency);
        this.buildResolvedDependencies(declaredDependencies);
    }

    private void updateDependency(Dependency dependency) {
        CanonicalPackageUri canonicalPackageUri = CanonicalPackageUri.fromPackageUri(dependency.getPackageUri());
        Dependency currentDependency = (Dependency)this.resolvedDependencies.get(canonicalPackageUri);
        if (currentDependency == null || currentDependency.getVersion().compareTo(dependency.getVersion()) < 0) {
            EconomicMaps.put(this.resolvedDependencies, canonicalPackageUri, dependency);
        }
    }
}

