/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.packages;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.naming.OperationNotSupportedException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.http.HttpClient;
import org.pkl.core.module.PathElement;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.DependencyMetadata;
import org.pkl.core.packages.PackageAssetUri;
import org.pkl.core.packages.PackageResolvers;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;

public interface PackageResolver
extends Closeable {
    public static PackageResolver getInstance(SecurityManager securityManager2, HttpClient httpClient2, @Nullable Path cachedDir) {
        return cachedDir == null ? new PackageResolvers.InMemoryPackageResolver(securityManager2, httpClient2) : new PackageResolvers.DiskCachedPackageResolver(securityManager2, httpClient2, cachedDir);
    }

    public DependencyMetadata getDependencyMetadata(PackageUri var1, @Nullable Checksums var2) throws IOException, SecurityManagerException;

    public Pair<DependencyMetadata, Checksums> getDependencyMetadataAndComputeChecksum(PackageUri var1) throws IOException, SecurityManagerException;

    public void downloadPackage(PackageUri var1, @Nullable Checksums var2, boolean var3) throws OperationNotSupportedException, IOException, SecurityManagerException;

    public byte[] getBytes(PackageAssetUri var1, boolean var2, @Nullable Checksums var3) throws IOException, SecurityManagerException;

    public List<PathElement> listElements(PackageAssetUri var1, @Nullable Checksums var2) throws IOException, SecurityManagerException;

    public boolean hasElement(PackageAssetUri var1, @Nullable Checksums var2) throws IOException, SecurityManagerException;
}

