/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.packages;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.DataSize;
import org.pkl.core.DataSizeUnit;
import org.pkl.core.Duration;
import org.pkl.core.DurationUnit;
import org.pkl.core.PClassInfo;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.Pair;
import org.pkl.core.PklException;
import org.pkl.core.Version;
import org.pkl.core.packages.Checksums;
import org.pkl.core.packages.Dependency;
import org.pkl.core.packages.PackageUri;
import org.pkl.core.packages.PackageUtils;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.json.Json;
import org.pkl.core.util.json.JsonWriter;

public final class DependencyMetadata {
    private final String name;
    private final PackageUri packageUri;
    private final Version version;
    private final URI packageZipUrl;
    private final Checksums packageZipChecksums;
    private final Map<String, Dependency.RemoteDependency> dependencies;
    @Nullable
    private final String sourceCodeUrlScheme;
    @Nullable
    private final URI sourceCode;
    @Nullable
    private final URI documentation;
    @Nullable
    private final String license;
    @Nullable
    private final String licenseText;
    @Nullable
    private final List<String> authors;
    @Nullable
    private final URI issueTracker;
    @Nullable
    private final String description;
    private final List<PObject> annotations;

    public static DependencyMetadata parse(String input) throws Json.JsonParseException {
        Json.JsObject parsed = Json.parseObject(input);
        String name = parsed.getString("name");
        PackageUri packageUri = parsed.get("packageUri", it -> new PackageUri((String)it));
        Version version = parsed.getVersion("version");
        URI packageZipUrl = parsed.getURI("packageZipUrl");
        Checksums packageZipChecksums = parsed.get("packageZipChecksums", DependencyMetadata::parseChecksums);
        Map dependencies = parsed.get("dependencies", DependencyMetadata::parseDependencies);
        String sourceCodeUrlScheme = parsed.getStringOrNull("sourceCodeUrlScheme");
        URI sourceCode = parsed.getURIOrNull("sourceCode");
        URI documentation = parsed.getURIOrNull("documentation");
        String license = parsed.getStringOrNull("license");
        String licenseText = parsed.getStringOrNull("licenseText");
        List authors = parsed.getNullable("authors", DependencyMetadata::parseAuthors);
        URI issueTracker = parsed.getURIOrNull("issueTracker");
        String description = parsed.getStringOrNull("description");
        List<PObject> annotations = parsed.getNullable("annotations", DependencyMetadata::parseAnnotations);
        if (annotations == null) {
            annotations = List.of();
        }
        return new DependencyMetadata(name, packageUri, version, packageZipUrl, packageZipChecksums, dependencies, sourceCodeUrlScheme, sourceCode, documentation, license, licenseText, authors, issueTracker, description, annotations);
    }

    private static Map<String, Dependency.RemoteDependency> parseDependencies(Object deps) throws Json.JsonParseException {
        if (!(deps instanceof Json.JsObject)) {
            throw new Json.FormatException("object", deps.getClass());
        }
        Json.JsObject dependencies = (Json.JsObject)deps;
        HashMap<String, Dependency.RemoteDependency> ret = new HashMap<String, Dependency.RemoteDependency>(dependencies.size());
        for (String key2 : dependencies.keySet()) {
            Dependency.RemoteDependency remoteDependency = dependencies.get(key2, dep -> {
                if (!(dep instanceof Json.JsObject)) {
                    throw new Json.FormatException("object", dep.getClass());
                }
                Json.JsObject obj = (Json.JsObject)dep;
                Checksums checksums = obj.get("checksums", DependencyMetadata::parseChecksums);
                PackageUri packageUri = obj.get("uri", PackageUtils::parsePackageUriWithoutChecksums);
                return new Dependency.RemoteDependency(packageUri, checksums);
            });
            ret.put(key2, remoteDependency);
        }
        return ret;
    }

    private static List<PObject> parseAnnotations(Object ann) throws Json.JsonParseException, URISyntaxException {
        if (!(ann instanceof Json.JsArray)) {
            throw new Json.FormatException("array", ann.getClass());
        }
        Json.JsArray arr = (Json.JsArray)ann;
        ArrayList<PObject> annotations = new ArrayList<PObject>(arr.size());
        for (Object annotation : arr) {
            Object obj = DependencyMetadata.parsePObject(annotation);
            if (!(obj instanceof PObject)) {
                throw new PklException("Could not read annotation. Invalid object: " + obj);
            }
            PObject pObject = (PObject)obj;
            annotations.add(pObject);
        }
        return annotations;
    }

    private static Object parsePObject(@Nullable Object obj) throws Json.JsonParseException, URISyntaxException {
        if (obj == null) {
            return PNull.getInstance();
        }
        if (obj instanceof String) {
            String string = (String)obj;
            return string;
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return bool;
        }
        if (obj instanceof Integer) {
            Integer integer = (Integer)obj;
            return integer.longValue();
        }
        if (obj instanceof Long) {
            Long aLong = (Long)obj;
            return aLong;
        }
        if (obj instanceof Float) {
            Float aFloat = (Float)obj;
            return aFloat.doubleValue();
        }
        if (obj instanceof Double) {
            Double aDouble = (Double)obj;
            return aDouble;
        }
        if (obj instanceof Json.JsArray) {
            Json.JsArray array = (Json.JsArray)obj;
            ArrayList<Object> list = new ArrayList<Object>(array.size());
            for (Object element : array) {
                list.add(DependencyMetadata.parsePObject(element));
            }
            return list;
        }
        if (obj instanceof Json.JsObject) {
            String type;
            Json.JsObject jsObj = (Json.JsObject)obj;
            switch (type = jsObj.getString("type")) {
                case "Set": {
                    Json.JsArray value2 = jsObj.getArray("value");
                    HashSet<Object> set = new HashSet<Object>(value2.size());
                    for (Object element : value2) {
                        set.add(DependencyMetadata.parsePObject(element));
                    }
                    return set;
                }
                case "Map": {
                    Json.JsArray value3 = jsObj.getArray("value");
                    HashMap<Object, Object> map2 = new HashMap<Object, Object>();
                    for (Object kv : value3) {
                        Json.JsObject kvObj = (Json.JsObject)kv;
                        map2.put(DependencyMetadata.parsePObject(kvObj.get("key")), DependencyMetadata.parsePObject(kvObj.get("value")));
                    }
                    return map2;
                }
                case "PObject": {
                    Json.JsObject classInfoObj = jsObj.getObject("classInfo");
                    String moduleName = classInfoObj.getString("moduleName");
                    String className = classInfoObj.getString("class");
                    String moduleUri = classInfoObj.getString("moduleUri");
                    Json.JsObject props = jsObj.getObject("properties");
                    PClassInfo<?> classInfo = PClassInfo.get(moduleName, className, new URI(moduleUri));
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> kv : props.entrySet()) {
                        properties.put(kv.getKey(), DependencyMetadata.parsePObject(kv.getValue()));
                    }
                    return new PObject(classInfo, properties);
                }
                case "Pattern": {
                    String value4 = jsObj.getString("value");
                    return Pattern.compile(value4);
                }
                case "DataSize": {
                    String symbol = jsObj.getString("unit");
                    Object value5 = jsObj.get("value");
                    if (value5 == null) {
                        throw new Json.MissingFieldException(jsObj, "value");
                    }
                    DataSizeUnit unit2 = DataSizeUnit.parse(symbol);
                    if (unit2 == null) {
                        throw new PklException("Invalid DataSize unit symbol: " + symbol);
                    }
                    if (!(value5 instanceof Double)) {
                        throw new Json.FormatException("double", value5.getClass());
                    }
                    Double num = (Double)value5;
                    return new DataSize(num, unit2);
                }
                case "Duration": {
                    String symbol = jsObj.getString("unit");
                    Object value6 = jsObj.get("value");
                    if (value6 == null) {
                        throw new Json.MissingFieldException(jsObj, "value");
                    }
                    DurationUnit unit3 = DurationUnit.parse(symbol);
                    if (unit3 == null) {
                        throw new PklException("Invalid Duration unit symbol: " + symbol);
                    }
                    if (!(value6 instanceof Double)) {
                        throw new Json.FormatException("double", value6.getClass());
                    }
                    Double num = (Double)value6;
                    return new Duration(num, unit3);
                }
                case "Pair": {
                    Object first2 = DependencyMetadata.parsePObject(jsObj.get("first"));
                    Object second2 = DependencyMetadata.parsePObject(jsObj.get("second"));
                    return new Pair<Object, Object>(first2, second2);
                }
            }
        }
        throw new PklException("Could not read annotation. Invalid object type: " + obj.getClass());
    }

    public static Checksums parseChecksums(Object obj) throws Json.JsonParseException {
        if (!(obj instanceof Json.JsObject)) {
            throw new Json.FormatException("object", obj.getClass());
        }
        Json.JsObject jsObj = (Json.JsObject)obj;
        String sha2562 = jsObj.getString("sha256");
        return new Checksums(sha2562);
    }

    public static List<String> parseAuthors(Object obj) throws Json.JsonParseException {
        if (!(obj instanceof Json.JsArray)) {
            throw new Json.FormatException("array", obj.getClass());
        }
        Json.JsArray arr = (Json.JsArray)obj;
        ArrayList<String> ret = new ArrayList<String>(arr.size());
        for (Object elem : arr) {
            if (!(elem instanceof String)) {
                throw new Json.FormatException("string", elem.getClass());
            }
            String string = (String)elem;
            ret.add(string);
        }
        return ret;
    }

    public DependencyMetadata(String name, PackageUri packageUri, Version version, URI packageZipUrl, Checksums packageZipChecksums, Map<String, Dependency.RemoteDependency> dependencies, @Nullable String sourceCodeUrlScheme, @Nullable URI sourceCode, @Nullable URI documentation, @Nullable String license, @Nullable String licenseText, @Nullable List<String> authors, @Nullable URI issueTracker, @Nullable String description, List<PObject> annotations) {
        this.name = name;
        this.packageUri = packageUri;
        this.version = version;
        this.packageZipUrl = packageZipUrl;
        this.packageZipChecksums = packageZipChecksums;
        this.dependencies = dependencies;
        this.sourceCodeUrlScheme = sourceCodeUrlScheme;
        this.sourceCode = sourceCode;
        this.documentation = documentation;
        this.license = license;
        this.licenseText = licenseText;
        this.authors = authors;
        this.issueTracker = issueTracker;
        this.description = description;
        this.annotations = annotations;
    }

    public String getName() {
        return this.name;
    }

    public Version getVersion() {
        return this.version;
    }

    public URI getPackageZipUrl() {
        return this.packageZipUrl;
    }

    public Checksums getPackageZipChecksums() {
        return this.packageZipChecksums;
    }

    public Map<String, Dependency.RemoteDependency> getDependencies() {
        return this.dependencies;
    }

    @Nullable
    public String getSourceCodeUrlScheme() {
        return this.sourceCodeUrlScheme;
    }

    @Nullable
    public URI getSourceCode() {
        return this.sourceCode;
    }

    @Nullable
    public URI getDocumentation() {
        return this.documentation;
    }

    @Nullable
    public String getLicense() {
        return this.license;
    }

    @Nullable
    public String getLicenseText() {
        return this.licenseText;
    }

    @Nullable
    public List<String> getAuthors() {
        return this.authors;
    }

    @Nullable
    public URI getIssueTracker() {
        return this.issueTracker;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public List<PObject> getAnnotations() {
        return this.annotations;
    }

    public void writeTo(OutputStream out2) throws IOException {
        new DependencyMetadataWriter(out2, this).write();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DependencyMetadata that = (DependencyMetadata)o;
        return this.name.equals(that.name) && this.packageUri.equals(that.packageUri) && this.version.equals(that.version) && this.packageZipUrl.equals(that.packageZipUrl) && this.packageZipChecksums.equals(that.packageZipChecksums) && this.dependencies.equals(that.dependencies) && Objects.equals(this.sourceCodeUrlScheme, that.sourceCodeUrlScheme) && Objects.equals(this.sourceCode, that.sourceCode) && Objects.equals(this.documentation, that.documentation) && Objects.equals(this.license, that.license) && Objects.equals(this.licenseText, that.licenseText) && Objects.equals(this.authors, that.authors) && Objects.equals(this.issueTracker, that.issueTracker) && Objects.equals(this.description, that.description) && Objects.equals(this.annotations, that.annotations);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.packageUri, this.version, this.packageZipUrl, this.packageZipChecksums, this.dependencies, this.sourceCodeUrlScheme, this.sourceCode, this.documentation, this.license, this.licenseText, this.authors, this.issueTracker, this.description, this.annotations);
    }

    public String toString() {
        return "DependencyMetadata{name='" + this.name + "'packageUri='" + this.packageUri + "', version=" + this.version + ", packageZipUrl=" + this.packageZipUrl + ", packageZipChecksums=" + this.packageZipChecksums + ", dependencies=" + this.dependencies + ", sourceCodeUrlScheme='" + this.sourceCodeUrlScheme + "', sourceCode='" + this.sourceCode + "', documentation='" + this.documentation + "', license='" + this.license + "', licenseText='" + this.licenseText + "', authors=" + this.authors + "', issueTracker=" + this.issueTracker + "', description=" + this.description + ", annotations=" + this.annotations + "}";
    }

    private static final class DependencyMetadataWriter {
        private final JsonWriter jsonWriter;
        private final DependencyMetadata dependencyMetadata;

        private DependencyMetadataWriter(OutputStream outputStream2, DependencyMetadata dependencyMetadata) {
            this.jsonWriter = new JsonWriter(new OutputStreamWriter(outputStream2, StandardCharsets.UTF_8));
            this.jsonWriter.setIndent("  ");
            this.dependencyMetadata = dependencyMetadata;
        }

        private void writeChecksums() throws IOException {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("sha256").value(this.dependencyMetadata.packageZipChecksums.getSha256());
            this.jsonWriter.endObject();
        }

        private void writeDependencies() throws IOException {
            this.jsonWriter.beginObject();
            for (Map.Entry<String, Dependency.RemoteDependency> entry : this.dependencyMetadata.getDependencies().entrySet()) {
                this.jsonWriter.name(entry.getKey());
                this.jsonWriter.beginObject();
                this.jsonWriter.name("uri").value(entry.getValue().getPackageUri().toString());
                Checksums checksums = entry.getValue().getChecksums();
                if (checksums != null) {
                    this.jsonWriter.name("checksums");
                    this.jsonWriter.beginObject();
                    this.jsonWriter.name("sha256").value(entry.getValue().getChecksums().getSha256());
                    this.jsonWriter.endObject();
                }
                this.jsonWriter.endObject();
            }
            this.jsonWriter.endObject();
        }

        private void writeAuthors() throws IOException {
            List<String> authors = this.dependencyMetadata.authors;
            assert (authors != null);
            this.jsonWriter.beginArray();
            for (String author : authors) {
                this.jsonWriter.value(author);
            }
            this.jsonWriter.endArray();
        }

        private void write() throws IOException {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("name").value(this.dependencyMetadata.name);
            this.jsonWriter.name("packageUri").value(this.dependencyMetadata.packageUri.toString());
            this.jsonWriter.name("version").value(this.dependencyMetadata.version.toString());
            this.jsonWriter.name("packageZipUrl").value(this.dependencyMetadata.packageZipUrl.toString());
            this.jsonWriter.name("packageZipChecksums");
            this.writeChecksums();
            this.jsonWriter.name("dependencies");
            this.writeDependencies();
            if (this.dependencyMetadata.sourceCodeUrlScheme != null) {
                this.jsonWriter.name("sourceCodeUrlScheme").value(this.dependencyMetadata.sourceCodeUrlScheme);
            }
            if (this.dependencyMetadata.sourceCode != null) {
                this.jsonWriter.name("sourceCode").value(this.dependencyMetadata.sourceCode.toString());
            }
            if (this.dependencyMetadata.documentation != null) {
                this.jsonWriter.name("documentation").value(this.dependencyMetadata.documentation.toString());
            }
            if (this.dependencyMetadata.license != null) {
                this.jsonWriter.name("license").value(this.dependencyMetadata.license);
            }
            if (this.dependencyMetadata.licenseText != null) {
                this.jsonWriter.name("licenseText").value(this.dependencyMetadata.licenseText);
            }
            if (this.dependencyMetadata.authors != null) {
                this.jsonWriter.name("authors");
                this.writeAuthors();
            }
            if (this.dependencyMetadata.issueTracker != null) {
                this.jsonWriter.name("issueTracker").value(this.dependencyMetadata.issueTracker.toString());
            }
            if (this.dependencyMetadata.description != null) {
                this.jsonWriter.name("description").value(this.dependencyMetadata.description);
            }
            if (!this.dependencyMetadata.annotations.isEmpty()) {
                this.jsonWriter.name("annotations");
                this.writeAnnotations();
            }
            this.jsonWriter.endObject();
            this.jsonWriter.close();
        }

        private void writeAnnotations() throws IOException {
            this.jsonWriter.beginArray();
            for (PObject annotation : this.dependencyMetadata.annotations) {
                this.writePObject(annotation);
            }
            this.jsonWriter.endArray();
        }

        private void writePClassInfo(PClassInfo<?> pClassInfo) throws IOException {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("moduleName").value(pClassInfo.getModuleName());
            this.jsonWriter.name("class").value(pClassInfo.getSimpleName());
            this.jsonWriter.name("moduleUri").value(pClassInfo.getModuleUri().toString());
            this.jsonWriter.endObject();
        }

        private void writePObject(PObject object) throws IOException {
            this.jsonWriter.beginObject();
            this.jsonWriter.name("type").value("PObject");
            this.jsonWriter.name("classInfo");
            this.writePClassInfo(object.getClassInfo());
            this.jsonWriter.name("properties");
            this.jsonWriter.beginObject();
            for (Map.Entry<String, Object> kv : object.getProperties().entrySet()) {
                this.jsonWriter.name(kv.getKey());
                this.writeGenericObject(kv.getValue());
            }
            this.jsonWriter.endObject();
            this.jsonWriter.endObject();
        }

        private void writeGenericObject(Object value2) throws IOException {
            if (value2 instanceof PNull) {
                this.jsonWriter.nullValue();
            } else if (value2 instanceof PObject) {
                PObject pObject = (PObject)value2;
                this.writePObject(pObject);
            } else if (value2 instanceof String) {
                String string = (String)value2;
                this.jsonWriter.value(string);
            } else if (value2 instanceof Boolean) {
                Boolean bool = (Boolean)value2;
                this.jsonWriter.value(bool);
            } else if (value2 instanceof Integer) {
                Integer num = (Integer)value2;
                this.jsonWriter.value(num);
            } else if (value2 instanceof Long) {
                Long num = (Long)value2;
                this.jsonWriter.value(num);
            } else if (value2 instanceof Float) {
                Float num = (Float)value2;
                this.jsonWriter.value(num);
            } else if (value2 instanceof Double) {
                Double num = (Double)value2;
                this.jsonWriter.value(num);
            } else if (value2 instanceof List) {
                List list = (List)value2;
                this.jsonWriter.beginArray();
                for (Object v : list) {
                    this.writeGenericObject(v);
                }
                this.jsonWriter.endArray();
            } else if (value2 instanceof Set) {
                Set set = (Set)value2;
                this.jsonWriter.beginObject();
                this.jsonWriter.name("type").value("Set");
                this.jsonWriter.name("value");
                this.jsonWriter.beginArray();
                for (Object v : set) {
                    this.writeGenericObject(v);
                }
                this.jsonWriter.endArray();
                this.jsonWriter.endObject();
            } else if (value2 instanceof Map) {
                Map map2 = (Map)value2;
                this.jsonWriter.beginObject();
                this.jsonWriter.name("type").value("Map");
                this.jsonWriter.name("value");
                this.jsonWriter.beginArray();
                for (Map.Entry kv : map2.entrySet()) {
                    this.jsonWriter.beginObject();
                    this.jsonWriter.name("key");
                    this.writeGenericObject(kv.getKey());
                    this.jsonWriter.name("value");
                    this.writeGenericObject(kv.getValue());
                    this.jsonWriter.endObject();
                }
                this.jsonWriter.endArray();
                this.jsonWriter.endObject();
            } else if (value2 instanceof Pattern) {
                Pattern pattern2 = (Pattern)value2;
                this.jsonWriter.beginObject();
                this.jsonWriter.name("type").value("Pattern");
                this.jsonWriter.name("value").value(pattern2.pattern());
                this.jsonWriter.endObject();
            } else if (value2 instanceof DataSize) {
                DataSize dataSize = (DataSize)value2;
                this.jsonWriter.beginObject();
                this.jsonWriter.name("type").value("DataSize");
                this.jsonWriter.name("unit").value(dataSize.getUnit().getSymbol());
                this.jsonWriter.name("value").value(dataSize.getValue());
                this.jsonWriter.endObject();
            } else if (value2 instanceof Duration) {
                Duration duration = (Duration)value2;
                this.jsonWriter.beginObject();
                this.jsonWriter.name("type").value("Duration");
                this.jsonWriter.name("unit").value(duration.getUnit().getSymbol());
                this.jsonWriter.name("value").value(duration.getValue());
                this.jsonWriter.endObject();
            } else if (value2 instanceof Pair) {
                Pair pair2 = (Pair)value2;
                this.jsonWriter.beginObject();
                this.jsonWriter.name("type").value("Pair");
                this.jsonWriter.name("first");
                this.writeGenericObject(pair2.getFirst());
                this.jsonWriter.name("second");
                this.writeGenericObject(pair2.getSecond());
                this.jsonWriter.endObject();
            } else {
                throw new PklException("Error serializing annotation for PklProject:\n:  cannot render value with unexpected type: " + value2.getClass());
            }
        }
    }
}

