/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.messaging;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.messaging.MessageTransport;
import org.pkl.core.messaging.MessageTransports;
import org.pkl.core.messaging.Messages;
import org.pkl.core.messaging.ProtocolException;
import org.pkl.core.module.PathElement;
import org.pkl.core.resource.ExternalResourceResolver;
import org.pkl.core.resource.Resource;

public class MessageTransportResourceResolver
implements ExternalResourceResolver {
    private final MessageTransport transport;
    private final long evaluatorId;
    private final Map<URI, Future<byte[]>> readResponses = new ConcurrentHashMap<URI, Future<byte[]>>();
    private final Map<URI, Future<List<PathElement>>> listResponses = new ConcurrentHashMap<URI, Future<List<PathElement>>>();
    private final Random requestIdGenerator = new Random();

    public MessageTransportResourceResolver(MessageTransport transport, long evaluatorId) {
        this.transport = transport;
        this.evaluatorId = evaluatorId;
    }

    @Override
    public Optional<Object> read(URI uri) throws IOException {
        byte[] result = this.doRead(uri);
        return Optional.of(new Resource(uri, result));
    }

    @Override
    public boolean hasElement(SecurityManager securityManager2, URI elementUri) throws SecurityManagerException {
        securityManager2.checkResolveResource(elementUri);
        try {
            this.doRead(elementUri);
            return true;
        }
        catch (IOException e2) {
            return false;
        }
    }

    @Override
    public List<PathElement> listElements(SecurityManager securityManager2, URI baseUri) throws IOException, SecurityManagerException {
        securityManager2.checkResolveResource(baseUri);
        return this.doListElements(baseUri);
    }

    public List<PathElement> doListElements(URI baseUri) throws IOException {
        return (List)MessageTransports.resolveFuture(this.listResponses.computeIfAbsent(baseUri, uri -> {
            CompletableFuture future = new CompletableFuture();
            Messages.ListResourcesRequest request = new Messages.ListResourcesRequest(this.requestIdGenerator.nextLong(), this.evaluatorId, (URI)uri);
            try {
                this.transport.send(request, response -> {
                    if (response instanceof Messages.ListResourcesResponse) {
                        Messages.ListResourcesResponse resp = (Messages.ListResourcesResponse)response;
                        if (resp.error() != null) {
                            future.completeExceptionally(new IOException(resp.error()));
                        } else {
                            future.complete(Objects.requireNonNullElseGet(resp.pathElements(), List::of));
                        }
                    } else {
                        future.completeExceptionally(new ProtocolException("unexpected response"));
                    }
                });
            }
            catch (IOException | ProtocolException e2) {
                future.completeExceptionally(e2);
            }
            return future;
        }));
    }

    public byte[] doRead(URI baseUri) throws IOException {
        return (byte[])MessageTransports.resolveFuture(this.readResponses.computeIfAbsent(baseUri, uri -> {
            CompletableFuture future = new CompletableFuture();
            Messages.ReadResourceRequest request = new Messages.ReadResourceRequest(this.requestIdGenerator.nextLong(), this.evaluatorId, (URI)uri);
            try {
                this.transport.send(request, response -> {
                    if (response instanceof Messages.ReadResourceResponse) {
                        Messages.ReadResourceResponse resp = (Messages.ReadResourceResponse)response;
                        if (resp.error() != null) {
                            future.completeExceptionally(new IOException(resp.error()));
                        } else if (resp.contents() != null) {
                            future.complete(resp.contents());
                        } else {
                            future.complete(new byte[0]);
                        }
                    } else {
                        future.completeExceptionally(new ProtocolException("unexpected response"));
                    }
                });
            }
            catch (IOException | ProtocolException e2) {
                future.completeExceptionally(e2);
            }
            return future;
        }));
    }
}

