/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.messaging;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.messaging.MessageTransport;
import org.pkl.core.messaging.MessageTransports;
import org.pkl.core.messaging.Messages;
import org.pkl.core.messaging.ProtocolException;
import org.pkl.core.module.ExternalModuleResolver;
import org.pkl.core.module.PathElement;

public class MessageTransportModuleResolver
implements ExternalModuleResolver {
    private final MessageTransport transport;
    private final long evaluatorId;
    private final Map<URI, Future<String>> readResponses = new ConcurrentHashMap<URI, Future<String>>();
    private final Map<URI, Future<List<PathElement>>> listResponses = new ConcurrentHashMap<URI, Future<List<PathElement>>>();
    private final Random requestIdGenerator = new Random();

    public MessageTransportModuleResolver(MessageTransport transport, long evaluatorId) {
        this.transport = transport;
        this.evaluatorId = evaluatorId;
    }

    @Override
    public List<PathElement> listElements(SecurityManager securityManager2, URI uri) throws IOException, SecurityManagerException {
        securityManager2.checkResolveModule(uri);
        return this.doListElements(uri);
    }

    @Override
    public boolean hasElement(SecurityManager securityManager2, URI uri) throws SecurityManagerException {
        securityManager2.checkResolveModule(uri);
        try {
            this.doReadModule(uri);
            return true;
        }
        catch (IOException e2) {
            return false;
        }
    }

    @Override
    public String resolveModule(SecurityManager securityManager2, URI uri) throws IOException, SecurityManagerException {
        securityManager2.checkResolveModule(uri);
        return this.doReadModule(uri);
    }

    private String doReadModule(URI moduleUri) throws IOException {
        return (String)MessageTransports.resolveFuture(this.readResponses.computeIfAbsent(moduleUri, uri -> {
            CompletableFuture future = new CompletableFuture();
            Messages.ReadModuleRequest request = new Messages.ReadModuleRequest(this.requestIdGenerator.nextLong(), this.evaluatorId, (URI)uri);
            try {
                this.transport.send(request, response -> {
                    if (response instanceof Messages.ReadModuleResponse) {
                        Messages.ReadModuleResponse resp = (Messages.ReadModuleResponse)response;
                        if (resp.error() != null) {
                            future.completeExceptionally(new IOException(resp.error()));
                        } else if (resp.contents() != null) {
                            future.complete(resp.contents());
                        } else {
                            future.complete("");
                        }
                    } else {
                        future.completeExceptionally(new ProtocolException("unexpected response"));
                    }
                });
            }
            catch (IOException | ProtocolException e2) {
                future.completeExceptionally(e2);
            }
            return future;
        }));
    }

    private List<PathElement> doListElements(URI baseUri) throws IOException {
        return (List)MessageTransports.resolveFuture(this.listResponses.computeIfAbsent(baseUri, uri -> {
            CompletableFuture future = new CompletableFuture();
            Messages.ListModulesRequest request = new Messages.ListModulesRequest(this.requestIdGenerator.nextLong(), this.evaluatorId, (URI)uri);
            try {
                this.transport.send(request, response -> {
                    if (response instanceof Messages.ListModulesResponse) {
                        Messages.ListModulesResponse resp = (Messages.ListModulesResponse)response;
                        if (resp.error() != null) {
                            future.completeExceptionally(new IOException(resp.error()));
                        } else {
                            future.complete(Objects.requireNonNullElseGet(resp.pathElements(), List::of));
                        }
                    } else {
                        future.completeExceptionally(new ProtocolException("unexpected response"));
                    }
                });
            }
            catch (IOException | ProtocolException e2) {
                future.completeExceptionally(e2);
            }
            return future;
        }));
    }
}

