/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.messaging;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;
import org.pkl.core.messaging.AbstractMessagePackDecoder;
import org.pkl.core.messaging.DecodeException;
import org.pkl.core.messaging.Message;
import org.pkl.core.messaging.Messages;
import org.pkl.core.module.PathElement;
import org.pkl.core.util.Nullable;

public class BaseMessagePackDecoder
extends AbstractMessagePackDecoder {
    public BaseMessagePackDecoder(MessageUnpacker unpacker) {
        super(unpacker);
    }

    public BaseMessagePackDecoder(InputStream stream) {
        super(stream);
    }

    @Override
    @Nullable
    protected Message decodeMessage(Message.Type msgType, Map<Value, Value> map2) throws DecodeException, URISyntaxException {
        return switch (msgType) {
            case Message.Type.READ_RESOURCE_REQUEST -> new Messages.ReadResourceRequest(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"), new URI(BaseMessagePackDecoder.unpackString(map2, "uri")));
            case Message.Type.READ_RESOURCE_RESPONSE -> new Messages.ReadResourceResponse(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"), BaseMessagePackDecoder.unpackByteArray(map2, "contents"), BaseMessagePackDecoder.unpackStringOrNull(map2, "error"));
            case Message.Type.READ_MODULE_REQUEST -> new Messages.ReadModuleRequest(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"), new URI(BaseMessagePackDecoder.unpackString(map2, "uri")));
            case Message.Type.READ_MODULE_RESPONSE -> new Messages.ReadModuleResponse(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"), BaseMessagePackDecoder.unpackStringOrNull(map2, "contents"), BaseMessagePackDecoder.unpackStringOrNull(map2, "error"));
            case Message.Type.LIST_RESOURCES_REQUEST -> new Messages.ListResourcesRequest(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"), new URI(BaseMessagePackDecoder.unpackString(map2, "uri")));
            case Message.Type.LIST_RESOURCES_RESPONSE -> new Messages.ListResourcesResponse(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"), BaseMessagePackDecoder.unpackPathElements(map2, "pathElements"), BaseMessagePackDecoder.unpackStringOrNull(map2, "error"));
            case Message.Type.LIST_MODULES_REQUEST -> new Messages.ListModulesRequest(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"), new URI(BaseMessagePackDecoder.unpackString(map2, "uri")));
            case Message.Type.LIST_MODULES_RESPONSE -> new Messages.ListModulesResponse(BaseMessagePackDecoder.unpackLong(map2, "requestId"), BaseMessagePackDecoder.unpackLong(map2, "evaluatorId"), BaseMessagePackDecoder.unpackPathElements(map2, "pathElements"), BaseMessagePackDecoder.unpackStringOrNull(map2, "error"));
            default -> null;
        };
    }

    @Nullable
    protected static Messages.ModuleReaderSpec unpackModuleReaderSpec(@Nullable Value value2) throws DecodeException {
        if (value2 == null) {
            return null;
        }
        Map<Value, Value> map2 = value2.asMapValue().map();
        return new Messages.ModuleReaderSpec(BaseMessagePackDecoder.unpackString(map2, "scheme"), BaseMessagePackDecoder.unpackBoolean(map2, "hasHierarchicalUris"), BaseMessagePackDecoder.unpackBoolean(map2, "isLocal"), BaseMessagePackDecoder.unpackBoolean(map2, "isGlobbable"));
    }

    @Nullable
    protected static Messages.ResourceReaderSpec unpackResourceReaderSpec(@Nullable Value value2) throws DecodeException {
        if (value2 == null) {
            return null;
        }
        Map<Value, Value> map2 = value2.asMapValue().map();
        return new Messages.ResourceReaderSpec(BaseMessagePackDecoder.unpackString(map2, "scheme"), BaseMessagePackDecoder.unpackBoolean(map2, "hasHierarchicalUris"), BaseMessagePackDecoder.unpackBoolean(map2, "isGlobbable"));
    }

    @Nullable
    protected static List<PathElement> unpackPathElements(Map<Value, Value> map2, String key2) throws DecodeException {
        Value value2 = BaseMessagePackDecoder.getNullable(map2, key2);
        if (value2 == null) {
            return null;
        }
        ArrayList<PathElement> result = new ArrayList<PathElement>(value2.asArrayValue().size());
        for (Value pathElement : value2.asArrayValue()) {
            Map<Value, Value> pathElementMap = pathElement.asMapValue().map();
            result.add(new PathElement(BaseMessagePackDecoder.unpackString(pathElementMap, "name"), BaseMessagePackDecoder.unpackBoolean(pathElementMap, "isDirectory")));
        }
        return result;
    }
}

