/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.messaging;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.pkl.core.messaging.Message;
import org.pkl.core.messaging.MessageEncoder;
import org.pkl.core.messaging.ProtocolException;
import org.pkl.core.util.Nullable;

public abstract class AbstractMessagePackEncoder
implements MessageEncoder {
    protected final MessagePacker packer;

    public AbstractMessagePackEncoder(MessagePacker packer) {
        this.packer = packer;
    }

    public AbstractMessagePackEncoder(OutputStream stream) {
        this(MessagePack.newDefaultPacker(stream));
    }

    @Nullable
    protected abstract void encodeMessage(Message var1) throws ProtocolException, IOException;

    @Override
    public final void encode(Message msg) throws IOException, ProtocolException {
        this.packer.packArrayHeader(2);
        this.packer.packInt(msg.type().getCode());
        this.encodeMessage(msg);
        this.packer.flush();
    }

    protected void packMapHeader(int size, @Nullable Object value1) throws IOException {
        this.packer.packMapHeader(size + (value1 != null ? 1 : 0));
    }

    protected void packMapHeader(int size, @Nullable Object value1, @Nullable Object value2) throws IOException {
        this.packer.packMapHeader(size + (value1 != null ? 1 : 0) + (value2 != null ? 1 : 0));
    }

    protected void packMapHeader(int size, @Nullable Object value1, @Nullable Object value2, @Nullable Object value3, @Nullable Object value4, @Nullable Object value5, @Nullable Object value6, @Nullable Object value7, @Nullable Object value8, @Nullable Object value9, @Nullable Object valueA, @Nullable Object valueB, @Nullable Object valueC, @Nullable Object valueD, @Nullable Object valueE, @Nullable Object valueF) throws IOException {
        this.packer.packMapHeader(size + (value1 != null ? 1 : 0) + (value2 != null ? 1 : 0) + (value3 != null ? 1 : 0) + (value4 != null ? 1 : 0) + (value5 != null ? 1 : 0) + (value6 != null ? 1 : 0) + (value7 != null ? 1 : 0) + (value8 != null ? 1 : 0) + (value9 != null ? 1 : 0) + (valueA != null ? 1 : 0) + (valueB != null ? 1 : 0) + (valueC != null ? 1 : 0) + (valueD != null ? 1 : 0) + (valueE != null ? 1 : 0) + (valueF != null ? 1 : 0));
    }

    protected void packKeyValue(String name, @Nullable Integer value2) throws IOException {
        if (value2 == null) {
            return;
        }
        this.packer.packString(name);
        this.packer.packInt(value2);
    }

    protected void packKeyValue(String name, @Nullable Long value2) throws IOException {
        if (value2 == null) {
            return;
        }
        this.packer.packString(name);
        this.packer.packLong(value2);
    }

    protected <T> void packKeyValueLong(String name, @Nullable T value2, Function<T, Long> mapper) throws IOException {
        if (value2 == null) {
            return;
        }
        this.packKeyValue(name, mapper.apply(value2));
    }

    protected void packKeyValue(String name, @Nullable String value2) throws IOException {
        if (value2 == null) {
            return;
        }
        this.packer.packString(name);
        this.packer.packString(value2);
    }

    protected <T> void packKeyValueString(String name, @Nullable T value2, Function<T, String> mapper) throws IOException {
        if (value2 == null) {
            return;
        }
        this.packKeyValue(name, mapper.apply(value2));
    }

    protected void packKeyValue(String name, @Nullable Collection<String> value2) throws IOException {
        if (value2 == null) {
            return;
        }
        this.packer.packString(name);
        this.packer.packArrayHeader(value2.size());
        for (String elem : value2) {
            this.packer.packString(elem);
        }
    }

    protected <T> void packKeyValue(String name, @Nullable Collection<T> value2, Function<T, String> mapper) throws IOException {
        if (value2 == null) {
            return;
        }
        this.packer.packString(name);
        this.packer.packArrayHeader(value2.size());
        for (T elem : value2) {
            this.packer.packString(mapper.apply(elem));
        }
    }

    protected void packKeyValue(String name, @Nullable Map<String, String> value2) throws IOException {
        if (value2 == null) {
            return;
        }
        this.packer.packString(name);
        this.packer.packMapHeader(value2.size());
        for (Map.Entry<String, String> e2 : value2.entrySet()) {
            this.packer.packString(e2.getKey());
            this.packer.packString(e2.getValue());
        }
    }

    protected void packKeyValue(String name, byte @Nullable [] value2) throws IOException {
        if (value2 == null) {
            return;
        }
        this.packer.packString(name);
        this.packer.packBinaryHeader(value2.length);
        this.packer.writePayload(value2);
    }

    protected void packKeyValue(String name, boolean value2) throws IOException {
        this.packer.packString(name);
        this.packer.packBoolean(value2);
    }
}

