/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.http;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pkl.core.util.Nullable;

final class NoProxyRule {
    private static final String portString = "(?::(?<port>\\d{1,5}))?";
    private static final String cidrString = "(?:/(?<cidr>\\d{1,3}))?";
    private static final String ipv4AddressString = "(?<host>[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})";
    private static final Pattern ipv4Address = Pattern.compile("^(?<host>[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})$");
    private static final Pattern ipv4AddressOrCidr = Pattern.compile("^(?<host>[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})(?:/(?<cidr>\\d{1,3}))?(?::(?<port>\\d{1,5}))?$");
    private static final String ipv6AddressString = "(?<host>(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,7}:|(?:[0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,5}(?::[0-9a-fA-F]{1,4}){1,2}|(?:[0-9a-fA-F]{1,4}:){1,4}(?::[0-9a-fA-F]{1,4}){1,3}|(?:[0-9a-fA-F]{1,4}:){1,3}(?::[0-9a-fA-F]{1,4}){1,4}|(?:[0-9a-fA-F]{1,4}:){1,2}(?::[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:(?::[0-9a-fA-F]{1,4}){1,6}|:(?:(?::[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(?::[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]+|::(?:ffff(:0{1,4})?:)?(?:(?:25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])|(?:[0-9a-fA-F]{1,4}:){1,4}:(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\\.){3}(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9]))";
    private static final Pattern ipv6AddressOrCidr = Pattern.compile("^(?<open>\\[)?(?<host>(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,7}:|(?:[0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,5}(?::[0-9a-fA-F]{1,4}){1,2}|(?:[0-9a-fA-F]{1,4}:){1,4}(?::[0-9a-fA-F]{1,4}){1,3}|(?:[0-9a-fA-F]{1,4}:){1,3}(?::[0-9a-fA-F]{1,4}){1,4}|(?:[0-9a-fA-F]{1,4}:){1,2}(?::[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:(?::[0-9a-fA-F]{1,4}){1,6}|:(?:(?::[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(?::[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]+|::(?:ffff(:0{1,4})?:)?(?:(?:25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])|(?:[0-9a-fA-F]{1,4}:){1,4}:(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\\.){3}(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9]))(?:/(?<cidr>\\d{1,3}))?(?<close>])?(?::(?<port>\\d{1,5}))?$");
    private static final Pattern hostnamePattern = Pattern.compile("^\\.?(?<host>[^:]+)(?::(?<port>\\d{1,5}))?$");
    @Nullable
    private Integer ipv4 = null;
    @Nullable
    private Integer ipv4Mask = null;
    @Nullable
    private BigInteger ipv6 = null;
    @Nullable
    private BigInteger ipv6Mask = null;
    @Nullable
    private String hostname = null;
    private int port = 0;
    private boolean allNoProxy = false;

    public NoProxyRule(String repr) {
        if (repr.equals("*")) {
            this.allNoProxy = true;
            return;
        }
        Matcher ipv4Matcher = ipv4AddressOrCidr.matcher(repr);
        if (ipv4Matcher.matches()) {
            String ipAddress = ipv4Matcher.group("host");
            this.ipv4 = this.parseIpv4(ipAddress);
            if (ipv4Matcher.group("cidr") != null) {
                int prefixLength = Integer.parseInt(ipv4Matcher.group("cidr"));
                if (prefixLength > 32) {
                    this.hostname = repr;
                }
                this.ipv4Mask = -1 << 32 - prefixLength;
            }
            if (ipv4Matcher.group("port") != null) {
                this.port = Integer.parseInt(ipv4Matcher.group("port"));
            }
            return;
        }
        Matcher ipv6Matcher = ipv6AddressOrCidr.matcher(repr);
        if (ipv6Matcher.matches()) {
            String ipAddress = ipv6Matcher.group("host");
            this.ipv6 = this.parseIpv6(ipAddress);
            if (ipv6Matcher.group("cidr") != null) {
                ByteBuffer maskBuffer = ByteBuffer.allocate(16).putLong(-1L).putLong(-1L);
                int prefixLength = Integer.parseInt(ipv6Matcher.group("cidr"));
                if (prefixLength > 128) {
                    this.hostname = repr;
                    return;
                }
                this.ipv6Mask = new BigInteger(1, maskBuffer.array()).not().shiftRight(prefixLength);
            }
            if (ipv6Matcher.group("port") != null) {
                this.port = Integer.parseInt(ipv6Matcher.group("port"));
            }
            return;
        }
        Matcher hostnameMatcher = hostnamePattern.matcher(repr);
        if (hostnameMatcher.matches()) {
            this.hostname = hostnameMatcher.group("host");
            if (hostnameMatcher.group("port") != null) {
                this.port = Integer.parseInt(hostnameMatcher.group("port"));
            }
            return;
        }
        throw new RuntimeException("Failed to parse hostname in no-proxy rule: " + repr);
    }

    public boolean matches(URI uri) {
        if (this.allNoProxy) {
            return true;
        }
        if (!this.hostMatches(uri)) {
            return false;
        }
        if (this.port == 0) {
            return true;
        }
        int thatPort = uri.getPort();
        if (thatPort == -1) {
            thatPort = switch (uri.getScheme()) {
                case "http" -> 80;
                case "https" -> 443;
                default -> -1;
            };
        }
        return this.port == thatPort;
    }

    public boolean hostMatches(URI uri) {
        if (this.allNoProxy) {
            return true;
        }
        String host = uri.getHost();
        if (host == null) {
            return false;
        }
        if (host.equalsIgnoreCase(this.hostname)) {
            return true;
        }
        if (this.hostname != null && this.endsWithIgnoreCase(host, "." + this.hostname)) {
            return true;
        }
        return this.ipV6Matches(uri.getHost()) || this.ipV4Matches(uri.getHost());
    }

    private boolean endsWithIgnoreCase(String str, String suffix) {
        int len = suffix.length();
        return str.regionMatches(true, str.length() - len, suffix, 0, len);
    }

    private boolean ipV4Matches(String hostname) {
        if (this.ipv4 == null) {
            return false;
        }
        if (!ipv4Address.matcher(hostname).matches()) {
            return false;
        }
        int address = this.parseIpv4(hostname);
        if (this.ipv4.equals(address)) {
            return true;
        }
        if (this.ipv4Mask != null) {
            return (this.ipv4 & this.ipv4Mask) == (address & this.ipv4Mask);
        }
        return false;
    }

    private boolean ipV6Matches(String hostname) {
        if (this.ipv6 == null) {
            return false;
        }
        if (!hostname.startsWith("[") && !hostname.endsWith("]")) {
            return false;
        }
        String ipv6Repr = hostname.substring(1, hostname.length() - 1);
        BigInteger address = this.parseIpv6(ipv6Repr);
        if (this.ipv6.equals(address)) {
            return true;
        }
        if (this.ipv6Mask != null) {
            return this.ipv6.and(this.ipv6Mask).equals(address.and(this.ipv6Mask));
        }
        return false;
    }

    private BigInteger parseIpv6(String repr) {
        try {
            InetAddress inet = Inet6Address.getByName(repr);
            byte[] byteArr = inet.getAddress();
            return new BigInteger(1, byteArr);
        }
        catch (UnknownHostException e2) {
            throw new RuntimeException("Received unexpected UnknownHostException during parsing IPV6 literal", e2);
        }
    }

    private int parseIpv4(String repr) {
        try {
            InetAddress inet = Inet4Address.getByName(repr);
            return ByteBuffer.wrap(inet.getAddress()).getInt();
        }
        catch (UnknownHostException e2) {
            throw new RuntimeException("Received unexpected UnknownHostException during parsing IPV4 literal", e2);
        }
    }
}

