/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.externalreader;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.pkl.core.evaluatorSettings.PklEvaluatorSettings;
import org.pkl.core.externalreader.ExternalReaderMessagePackDecoder;
import org.pkl.core.externalreader.ExternalReaderMessagePackEncoder;
import org.pkl.core.externalreader.ExternalReaderMessages;
import org.pkl.core.externalreader.ExternalReaderProcess;
import org.pkl.core.externalreader.ExternalReaderProcessException;
import org.pkl.core.messaging.MessageTransport;
import org.pkl.core.messaging.MessageTransportModuleResolver;
import org.pkl.core.messaging.MessageTransportResourceResolver;
import org.pkl.core.messaging.MessageTransports;
import org.pkl.core.messaging.ProtocolException;
import org.pkl.core.module.ExternalModuleResolver;
import org.pkl.core.resource.ExternalResourceResolver;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;

final class ExternalReaderProcessImpl
implements ExternalReaderProcess {
    private static final Duration CLOSE_TIMEOUT = Duration.ofSeconds(3L);
    private final PklEvaluatorSettings.ExternalReader spec;
    @Nullable
    private final String logPrefix;
    private final Map<String, Future<@Nullable ExternalModuleResolver.Spec>> initializeModuleReaderResponses = new ConcurrentHashMap<String, Future<ExternalModuleResolver.Spec>>();
    private final Map<String, Future<@Nullable ExternalResourceResolver.Spec>> initializeResourceReaderResponses = new ConcurrentHashMap<String, Future<ExternalResourceResolver.Spec>>();
    private final Random requestIdGenerator = new Random();
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private boolean closed = false;
    @LateInit
    @GuardedBy(value="lock")
    private Process process;
    @LateInit
    @GuardedBy(value="lock")
    private MessageTransport transport;

    private void log(String msg) {
        if (this.logPrefix != null) {
            System.err.println(this.logPrefix + msg);
        }
    }

    ExternalReaderProcessImpl(PklEvaluatorSettings.ExternalReader spec) {
        this.spec = spec;
        this.logPrefix = Objects.equals(System.getenv("PKL_DEBUG"), "1") ? "[pkl-core][external-process][" + spec.executable() + "] " : null;
    }

    @Override
    public ExternalModuleResolver getModuleResolver(long evaluatorId) throws ExternalReaderProcessException {
        return new MessageTransportModuleResolver(this.getTransport(), evaluatorId);
    }

    @Override
    public ExternalResourceResolver getResourceResolver(long evaluatorId) throws ExternalReaderProcessException {
        return new MessageTransportResourceResolver(this.getTransport(), evaluatorId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageTransport getTransport() throws ExternalReaderProcessException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("External reader process has already been closed.");
            }
            if (this.process != null) {
                if (!this.process.isAlive()) {
                    throw new ExternalReaderProcessException(ErrorMessages.create("externalReaderAlreadyTerminated", new Object[0]));
                }
                return this.transport;
            }
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.spec.executable());
        command.addAll(this.spec.arguments());
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        try {
            this.process = builder.start();
        }
        catch (IOException e2) {
            throw new ExternalReaderProcessException(e2);
        }
        this.transport = MessageTransports.stream(new ExternalReaderMessagePackDecoder(this.process.getInputStream()), new ExternalReaderMessagePackEncoder(this.process.getOutputStream()), this::log);
        Thread rxThread = new Thread(this::runTransport, "ExternalReaderProcessImpl rxThread for " + this.spec);
        rxThread.setDaemon(true);
        rxThread.start();
        return this.transport;
    }

    private void runTransport() {
        try {
            this.transport.start(msg -> {
                throw new ProtocolException("Unexpected incoming one-way message: " + msg);
            }, msg -> {
                throw new ProtocolException("Unexpected incoming request message: " + msg);
            });
        }
        catch (IOException | ProtocolException e2) {
            throw new RuntimeException(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                if (this.transport != null && this.process != null && this.process.isAlive()) {
                    this.transport.send(new ExternalReaderMessages.CloseExternalProcess());
                    this.process.waitFor(CLOSE_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (this.process != null) {
                    this.process.destroyForcibly();
                }
                if (this.transport != null) {
                    this.transport.close();
                }
            }
        }
    }

    @Override
    public @Nullable ExternalModuleResolver.Spec getModuleReaderSpec(String uriScheme) throws IOException {
        return (ExternalModuleResolver.Spec)MessageTransports.resolveFuture(this.initializeModuleReaderResponses.computeIfAbsent(uriScheme, scheme -> {
            CompletableFuture future = new CompletableFuture();
            ExternalReaderMessages.InitializeModuleReaderRequest request = new ExternalReaderMessages.InitializeModuleReaderRequest(this.requestIdGenerator.nextLong(), (String)scheme);
            try {
                this.getTransport().send(request, response -> {
                    if (response instanceof ExternalReaderMessages.InitializeModuleReaderResponse) {
                        ExternalReaderMessages.InitializeModuleReaderResponse resp = (ExternalReaderMessages.InitializeModuleReaderResponse)response;
                        future.complete(resp.spec());
                    } else {
                        future.completeExceptionally(new ProtocolException("unexpected response"));
                    }
                });
            }
            catch (IOException | ExternalReaderProcessException | ProtocolException e2) {
                future.completeExceptionally(e2);
            }
            return future;
        }));
    }

    @Override
    public @Nullable ExternalResourceResolver.Spec getResourceReaderSpec(String uriScheme) throws IOException {
        return (ExternalResourceResolver.Spec)MessageTransports.resolveFuture(this.initializeResourceReaderResponses.computeIfAbsent(uriScheme, scheme -> {
            CompletableFuture future = new CompletableFuture();
            ExternalReaderMessages.InitializeResourceReaderRequest request = new ExternalReaderMessages.InitializeResourceReaderRequest(this.requestIdGenerator.nextLong(), (String)scheme);
            try {
                this.getTransport().send(request, response -> {
                    this.log(response.toString());
                    if (response instanceof ExternalReaderMessages.InitializeResourceReaderResponse) {
                        ExternalReaderMessages.InitializeResourceReaderResponse resp = (ExternalReaderMessages.InitializeResourceReaderResponse)response;
                        future.complete(resp.spec());
                    } else {
                        future.completeExceptionally(new ProtocolException("unexpected response"));
                    }
                });
            }
            catch (IOException | ExternalReaderProcessException | ProtocolException e2) {
                future.completeExceptionally(e2);
            }
            return future;
        }));
    }
}

