/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.pkl.core.PType;
import org.pkl.core.PklBugException;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ConstantValueNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.PklNode;
import org.pkl.core.ast.SimpleRootNode;
import org.pkl.core.ast.builder.SymbolTable;
import org.pkl.core.ast.expression.primary.GetModuleNode;
import org.pkl.core.ast.frame.WriteFrameSlotNode;
import org.pkl.core.ast.frame.WriteFrameSlotNodeGen;
import org.pkl.core.ast.member.DefaultPropertyBodyNode;
import org.pkl.core.ast.member.ListingOrMappingTypeCastNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.UntypedObjectMemberNode;
import org.pkl.core.ast.type.IdentityMixinNode;
import org.pkl.core.ast.type.TypeConstraintNode;
import org.pkl.core.ast.type.TypeNodeFactory;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.MirrorFactories;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.EconomicSets;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.MutableBoolean;
import org.pkl.core.util.Nonnull;
import org.pkl.core.util.Nullable;

public abstract class TypeNode
extends PklNode {
    protected TypeNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    public boolean isNoopTypeCheck() {
        return false;
    }

    public abstract FrameSlotKind getFrameSlotKind();

    public abstract TypeNode initWriteSlotNode(int var1);

    public abstract Object execute(VirtualFrame var1, Object var2);

    public abstract Object executeAndSet(VirtualFrame var1, Object var2);

    public Object executeEagerly(VirtualFrame frame, Object value2) {
        return this.execute(frame, value2);
    }

    public abstract Object executeEagerlyAndSet(VirtualFrame var1, Object var2);

    @Nullable
    public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
        return null;
    }

    protected abstract boolean acceptTypeNode(TypeNodeConsumer var1);

    public static TypeNode forClass(SourceSection sourceSection, VmClass clazz) {
        return clazz.isClosed() ? new FinalClassTypeNode(sourceSection, clazz) : TypeNodeFactory.NonFinalClassTypeNodeGen.create(sourceSection, clazz);
    }

    public static PType export(@Nullable TypeNode node) {
        return node != null ? node.doExport() : PType.UNKNOWN;
    }

    public static VmTyped getMirror(@Nullable TypeNode node) {
        return node != null ? node.getMirror() : MirrorFactories.unknownTypeFactory.create(null);
    }

    public static VmList getMirrors(TypeNode[] nodes) {
        VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
        for (TypeNode node : nodes) {
            builder.add(node.getMirror());
        }
        return builder.build();
    }

    protected PType doExport() {
        VmTypeAlias alias = this.getVmTypeAlias();
        if (alias != null) {
            return new PType.Alias(alias.export());
        }
        VmClass clazz = this.getVmClass();
        if (clazz != null) {
            return new PType.Class(clazz.export());
        }
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().bug("`%s` must override method `doExport()`.", this.getClass().getTypeName()).build();
    }

    protected boolean isParametric() {
        return false;
    }

    public boolean isEquivalentTo(TypeNode other) {
        return this == other || this.doIsEquivalentTo(other);
    }

    protected abstract boolean doIsEquivalentTo(TypeNode var1);

    @Nullable
    public VmClass getVmClass() {
        return null;
    }

    @Nullable
    public VmTypeAlias getVmTypeAlias() {
        return null;
    }

    public VmTyped getMirror() {
        return MirrorFactories.classTypeFactory.create(this);
    }

    public VmList getTypeArgumentMirrors() {
        return VmList.EMPTY;
    }

    protected final VmTypeMismatchException typeMismatch(Object actualValue, Object expectedType) {
        return new VmTypeMismatchException.Simple(this.sourceSection, actualValue, expectedType);
    }

    @Nullable
    private static Object createDefaultValue(VmClass clazz) {
        if (clazz.isInstantiable()) {
            if (clazz.isListingClass()) {
                return VmListing.empty();
            }
            if (clazz.isMappingClass()) {
                return VmMapping.empty();
            }
            return clazz.getPrototype();
        }
        if (clazz.isListClass()) {
            return VmList.EMPTY;
        }
        if (clazz.isSetClass()) {
            return VmSet.EMPTY;
        }
        if (clazz.isMapClass()) {
            return VmMap.EMPTY;
        }
        if (clazz.isCollectionClass()) {
            return VmList.EMPTY;
        }
        if (clazz.isNullClass()) {
            return VmNull.withoutDefault();
        }
        return null;
    }

    private static VmList createUnknownTypeArgumentMirrors(VmClass clazz) {
        int typeParameterCount = clazz.getTypeParameterCount();
        if (typeParameterCount == 0) {
            return VmList.EMPTY;
        }
        VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
        for (int i = 0; i < typeParameterCount; ++i) {
            builder.add(MirrorFactories.unknownTypeFactory.create(null));
        }
        return builder.build();
    }

    public static final class FinalClassTypeNode
    extends ObjectSlotTypeNode {
        private final VmClass clazz;

        public FinalClassTypeNode(SourceSection sourceSection, VmClass clazz) {
            super(sourceSection);
            this.clazz = clazz;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            VmValue vmValue;
            if (value2 instanceof VmValue && this.clazz == (vmValue = (VmValue)value2).getVmClass()) {
                return value2;
            }
            throw this.typeMismatch(value2, this.clazz);
        }

        @Override
        public VmClass getVmClass() {
            return this.clazz;
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return TypeNode.createUnknownTypeArgumentMirrors(this.clazz);
        }

        @Override
        @Nullable
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return TypeNode.createDefaultValue(this.clazz);
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof FinalClassTypeNode)) {
                return false;
            }
            FinalClassTypeNode finalClassTypeNode = (FinalClassTypeNode)other;
            return this.clazz.equals(finalClassTypeNode.clazz);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static abstract class NonFinalClassTypeNode
    extends ObjectSlotTypeNode {
        protected final VmClass clazz;

        public NonFinalClassTypeNode(SourceSection sourceSection, VmClass clazz) {
            super(sourceSection);
            this.clazz = clazz;
        }

        @Override
        public final VmClass getVmClass() {
            return this.clazz;
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return TypeNode.createUnknownTypeArgumentMirrors(this.clazz);
        }

        @ExplodeLoop
        @Specialization(guards={"value.getVmClass() == cachedClass"})
        protected Object eval(VmValue value2, @Cached(value="value.getVmClass()") VmClass cachedClass, @Cached(value="clazz.isSuperclassOf(cachedClass)") boolean isSuperclass) {
            if (isSuperclass) {
                return value2;
            }
            throw this.typeMismatch(value2, this.clazz);
        }

        @Specialization
        protected Object eval(VmValue value2) {
            if (this.clazz.isSuperclassOf(value2.getVmClass())) {
                return value2;
            }
            throw this.typeMismatch(value2, this.clazz);
        }

        @Fallback
        protected Object eval(Object value2) {
            throw this.typeMismatch(value2, this.clazz);
        }

        @Override
        @Nullable
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return TypeNode.createDefaultValue(this.clazz);
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof NonFinalClassTypeNode)) {
                return false;
            }
            NonFinalClassTypeNode nonFinalClassTypeNode = (NonFinalClassTypeNode)other;
            return this.clazz.equals(nonFinalClassTypeNode.clazz);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    @FunctionalInterface
    protected static interface TypeNodeConsumer {
        public boolean accept(TypeNode var1);
    }

    public static final class BooleanTypeNode
    extends FrameSlotTypeNode {
        public BooleanTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Boolean;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Boolean) {
                return value2;
            }
            throw this.typeMismatch(value2, BaseModule.getBooleanClass());
        }

        @Override
        public Object executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
            frame.setBoolean(this.slot, (Boolean)value2);
            return value2;
        }

        @Override
        public Object executeEagerlyAndSet(VirtualFrame frame, Object value2) {
            return this.executeAndSet(frame, value2);
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getBooleanClass();
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof BooleanTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class FloatTypeNode
    extends FrameSlotTypeNode {
        public FloatTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Double;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Double) {
                return value2;
            }
            throw this.typeMismatch(value2, BaseModule.getFloatClass());
        }

        @Override
        public Object executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
            frame.setDouble(this.slot, (Double)value2);
            return value2;
        }

        @Override
        public Object executeEagerlyAndSet(VirtualFrame frame, Object value2) {
            return this.executeAndSet(frame, value2);
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getFloatClass();
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof FloatTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class IntTypeNode
    extends IntSlotTypeNode {
        public IntTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long) {
                return value2;
            }
            throw this.typeMismatch(value2, BaseModule.getIntClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getIntClass();
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof IntTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class NumberTypeNode
    extends FrameSlotTypeNode {
        public NumberTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Illegal;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long || value2 instanceof Double) {
                return value2;
            }
            throw this.typeMismatch(value2, BaseModule.getNumberClass());
        }

        @Override
        public Object executeAndSet(VirtualFrame frame, Object value2) {
            FrameSlotKind kind = frame.getFrameDescriptor().getSlotKind(this.slot);
            if (value2 instanceof Long) {
                Long l = (Long)value2;
                if (kind == FrameSlotKind.Double || kind == FrameSlotKind.Object) {
                    frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Object);
                    frame.setObject(this.slot, l);
                } else {
                    frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Long);
                    frame.setLong(this.slot, l);
                }
                return value2;
            }
            if (value2 instanceof Double) {
                Double d2 = (Double)value2;
                if (kind == FrameSlotKind.Long || kind == FrameSlotKind.Object) {
                    frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Object);
                    frame.setObject(this.slot, d2);
                } else {
                    frame.getFrameDescriptor().setSlotKind(this.slot, FrameSlotKind.Double);
                    frame.setDouble(this.slot, d2);
                }
                return value2;
            }
            throw this.typeMismatch(value2, BaseModule.getNumberClass());
        }

        @Override
        public Object executeEagerlyAndSet(VirtualFrame frame, Object value2) {
            return this.executeAndSet(frame, value2);
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getNumberClass();
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof NumberTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class StringTypeNode
    extends ObjectSlotTypeNode {
        public StringTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof String) {
                return value2;
            }
            throw this.typeMismatch(value2, BaseModule.getStringClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getStringClass();
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof StringTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class AnyTypeNode
    extends WriteFrameSlotTypeNode {
        public AnyTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public boolean isNoopTypeCheck() {
            return true;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            return value2;
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getAnyClass();
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof AnyTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class ConstrainedTypeNode
    extends TypeNode {
        @Node.Child
        private TypeNode childNode;
        @Node.Children
        private final TypeConstraintNode[] constraintNodes;
        @CompilerDirectives.CompilationFinal
        private int customThisSlot = -1;

        public ConstrainedTypeNode(SourceSection sourceSection, TypeNode childNode, TypeConstraintNode[] constraintNodes) {
            super(sourceSection);
            this.childNode = childNode;
            this.constraintNodes = constraintNodes;
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return this.childNode.getFrameSlotKind();
        }

        @Override
        public TypeNode initWriteSlotNode(int slot) {
            this.childNode.initWriteSlotNode(slot);
            return this;
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame, Object value2) {
            if (this.customThisSlot == -1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.customThisSlot = frame.getFrameDescriptor().findOrAddAuxiliarySlot(SymbolTable.CustomThisScope.FRAME_SLOT_ID);
            }
            Object ret = this.childNode.execute(frame, value2);
            frame.setAuxiliarySlot(this.customThisSlot, value2);
            for (TypeConstraintNode node : this.constraintNodes) {
                node.execute(frame);
            }
            return ret;
        }

        @Override
        public Object executeAndSet(VirtualFrame frame, Object value2) {
            Object ret = this.execute(frame, value2);
            this.childNode.executeAndSet(frame, ret);
            return ret;
        }

        @Override
        public Object executeEagerlyAndSet(VirtualFrame frame, Object value2) {
            Object ret = this.executeEagerly(frame, value2);
            this.childNode.executeEagerlyAndSet(frame, ret);
            return ret;
        }

        @Override
        @Nullable
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return this.childNode.createDefaultValue(language, headerSection, qualifiedName);
        }

        public SourceSection getBaseTypeSection() {
            return this.childNode.getSourceSection();
        }

        public SourceSection getFirstConstraintSection() {
            return this.constraintNodes[0].getSourceSection();
        }

        @Override
        protected PType doExport() {
            return new PType.Constrained(this.childNode.doExport(), Arrays.stream(this.constraintNodes).map(TypeConstraintNode::export).collect(Collectors.toList()));
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return false;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            if (!consumer.accept(this)) {
                return false;
            }
            return this.childNode.acceptTypeNode(consumer);
        }

        @Override
        public VmTyped getMirror() {
            return this.childNode.getMirror();
        }
    }

    public static final class TypeAliasTypeNode
    extends TypeNode {
        private final VmTypeAlias typeAlias;
        private final TypeNode[] typeArgumentNodes;
        @Node.Child
        private TypeNode aliasedTypeNode;

        public TypeAliasTypeNode(SourceSection sourceSection, VmTypeAlias typeAlias, TypeNode[] typeArgumentNodes) {
            super(sourceSection);
            if (!typeAlias.isInitialized()) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("cyclicTypeAlias", new Object[0]).build();
            }
            if (typeArgumentNodes.length > 0 && typeArgumentNodes.length != typeAlias.getTypeParameterCount()) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("wrongTypeArgumentCount", typeAlias.getTypeParameterCount(), typeArgumentNodes.length).build();
            }
            this.typeAlias = typeAlias;
            this.typeArgumentNodes = typeArgumentNodes;
            this.aliasedTypeNode = typeAlias.instantiate(typeArgumentNodes);
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return this.aliasedTypeNode.getFrameSlotKind();
        }

        @Override
        public TypeNode initWriteSlotNode(int slot) {
            this.aliasedTypeNode.initWriteSlotNode(slot);
            return this;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return TypeAliasTypeNode.getMirrors(this.typeArgumentNodes);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            VmObjectLike prevOwner = VmUtils.getOwner(frame);
            Object prevReceiver = VmUtils.getReceiver(frame);
            TypeAliasTypeNode.setOwner(frame, VmUtils.getOwner(this.typeAlias.getEnclosingFrame()));
            TypeAliasTypeNode.setReceiver(frame, VmUtils.getReceiver(this.typeAlias.getEnclosingFrame()));
            try {
                Object object = this.aliasedTypeNode.execute(frame, value2);
                return object;
            }
            finally {
                TypeAliasTypeNode.setOwner(frame, prevOwner);
                TypeAliasTypeNode.setReceiver(frame, prevReceiver);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object executeAndSet(VirtualFrame frame, Object value2) {
            VmObjectLike prevOwner = VmUtils.getOwner(frame);
            Object prevReceiver = VmUtils.getReceiver(frame);
            TypeAliasTypeNode.setOwner(frame, VmUtils.getOwner(this.typeAlias.getEnclosingFrame()));
            TypeAliasTypeNode.setReceiver(frame, VmUtils.getReceiver(this.typeAlias.getEnclosingFrame()));
            try {
                Object object = this.aliasedTypeNode.executeAndSet(frame, value2);
                return object;
            }
            finally {
                TypeAliasTypeNode.setOwner(frame, prevOwner);
                TypeAliasTypeNode.setReceiver(frame, prevReceiver);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object executeEagerlyAndSet(VirtualFrame frame, Object value2) {
            VmObjectLike prevOwner = VmUtils.getOwner(frame);
            Object prevReceiver = VmUtils.getReceiver(frame);
            TypeAliasTypeNode.setOwner(frame, VmUtils.getOwner(this.typeAlias.getEnclosingFrame()));
            TypeAliasTypeNode.setReceiver(frame, VmUtils.getReceiver(this.typeAlias.getEnclosingFrame()));
            try {
                Object object = this.aliasedTypeNode.executeEagerlyAndSet(frame, value2);
                return object;
            }
            finally {
                TypeAliasTypeNode.setOwner(frame, prevOwner);
                TypeAliasTypeNode.setReceiver(frame, prevReceiver);
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        @Nullable
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            if (this.typeAlias == BaseModule.getMixinTypeAlias()) {
                return new VmFunction(VmUtils.createEmptyMaterializedFrame(), null, 1, new IdentityMixinNode(language, new FrameDescriptor(), this.getSourceSection(), qualifiedName, this.typeArgumentNodes.length == 1 ? this.typeArgumentNodes[0] : null), null);
            }
            return this.aliasedTypeNode.createDefaultValue(language, headerSection, qualifiedName);
        }

        @Override
        @Nullable
        public VmClass getVmClass() {
            return this.aliasedTypeNode.getVmClass();
        }

        @Override
        public @Nonnull VmTypeAlias getVmTypeAlias() {
            return this.typeAlias;
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (other instanceof TypeAliasTypeNode) {
                TypeAliasTypeNode typeAliasTypeNode = (TypeAliasTypeNode)other;
                return this.aliasedTypeNode.isEquivalentTo(typeAliasTypeNode.aliasedTypeNode);
            }
            return this.aliasedTypeNode.isEquivalentTo(other);
        }

        @Override
        protected PType doExport() {
            return new PType.Alias(this.typeAlias.export(), Arrays.stream(this.typeArgumentNodes).map(TypeNode::export).collect(Collectors.toList()), this.aliasedTypeNode.doExport());
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            if (!consumer.accept(this)) {
                return false;
            }
            return this.aliasedTypeNode.acceptTypeNode(consumer);
        }

        @Override
        protected boolean isParametric() {
            return this.typeArgumentNodes.length > 0;
        }

        private static void setReceiver(Frame frame, Object receiver) {
            frame.getArguments()[0] = receiver;
        }

        private static void setOwner(Frame frame, VmObjectLike owner) {
            frame.getArguments()[1] = owner;
        }
    }

    public static final class Int32TypeAliasTypeNode
    extends IntSlotTypeNode {
        public Int32TypeAliasTypeNode() {
            super(VmUtils.unavailableSourceSection());
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long) {
                Long l = (Long)value2;
                if (l == (long)l.intValue()) {
                    return value2;
                }
                throw new VmTypeMismatchException.Constraint(BaseModule.getInt32TypeAlias().getConstraintSection(), value2);
            }
            throw new VmTypeMismatchException.Simple(BaseModule.getInt32TypeAlias().getBaseTypeSection(), value2, BaseModule.getIntClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getIntClass();
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return BaseModule.getInt32TypeAlias();
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof Int32TypeAliasTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class Int16TypeAliasTypeNode
    extends IntSlotTypeNode {
        public Int16TypeAliasTypeNode() {
            super(VmUtils.unavailableSourceSection());
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long) {
                Long l = (Long)value2;
                if (l == (long)l.shortValue()) {
                    return value2;
                }
                throw new VmTypeMismatchException.Constraint(BaseModule.getInt16TypeAlias().getConstraintSection(), value2);
            }
            throw new VmTypeMismatchException.Simple(BaseModule.getInt16TypeAlias().getBaseTypeSection(), value2, BaseModule.getIntClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getIntClass();
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return BaseModule.getInt16TypeAlias();
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof Int16TypeAliasTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class Int8TypeAliasTypeNode
    extends IntSlotTypeNode {
        public Int8TypeAliasTypeNode() {
            super(VmUtils.unavailableSourceSection());
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long) {
                Long l = (Long)value2;
                if (l == (long)l.byteValue()) {
                    return value2;
                }
                throw new VmTypeMismatchException.Constraint(BaseModule.getInt8TypeAlias().getConstraintSection(), value2);
            }
            throw new VmTypeMismatchException.Simple(BaseModule.getInt8TypeAlias().getBaseTypeSection(), value2, BaseModule.getIntClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getIntClass();
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return BaseModule.getInt8TypeAlias();
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof Int8TypeAliasTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class UIntTypeAliasTypeNode
    extends IntSlotTypeNode {
        private final VmTypeAlias typeAlias;
        private final long mask;

        public UIntTypeAliasTypeNode(VmTypeAlias typeAlias, long mask) {
            super(VmUtils.unavailableSourceSection());
            this.typeAlias = typeAlias;
            this.mask = mask;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof Long) {
                Long l = (Long)value2;
                if ((l & this.mask) == l) {
                    return value2;
                }
                throw new VmTypeMismatchException.Constraint(this.typeAlias.getConstraintSection(), value2);
            }
            throw new VmTypeMismatchException.Simple(this.typeAlias.getBaseTypeSection(), value2, BaseModule.getIntClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getIntClass();
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return this.typeAlias;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof UIntTypeAliasTypeNode)) return false;
            UIntTypeAliasTypeNode aliasTypeNode = (UIntTypeAliasTypeNode)other;
            if (this.mask != aliasTypeNode.mask) return false;
            return true;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class NonNullTypeAliasTypeNode
    extends WriteFrameSlotTypeNode {
        public NonNullTypeAliasTypeNode() {
            super(VmUtils.unavailableSourceSection());
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmNull) {
                throw new VmTypeMismatchException.Constraint(BaseModule.getNonNullTypeAlias().getConstraintSection(), value2);
            }
            return value2;
        }

        @Override
        public VmTypeAlias getVmTypeAlias() {
            return BaseModule.getNonNullTypeAlias();
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeAliasTypeFactory.create(this);
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof NonNullTypeAliasTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class TypeVariableNode
    extends WriteFrameSlotTypeNode {
        private final TypeParameter typeParameter;

        public TypeVariableNode(SourceSection sourceSection, TypeParameter typeParameter) {
            super(sourceSection);
            this.typeParameter = typeParameter;
        }

        public int getTypeParameterIndex() {
            return this.typeParameter.getIndex();
        }

        @Override
        public boolean isNoopTypeCheck() {
            return true;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.typeVariableFactory.create(this);
        }

        public VmTyped getTypeParameterMirror() {
            return MirrorFactories.typeParameterFactory.create(this.typeParameter);
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            return value2;
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof TypeVariableNode;
        }

        @Override
        protected PType doExport() {
            return new PType.TypeVariable(this.typeParameter);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static class VarArgsTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode elementTypeNode;

        public VarArgsTypeNode(SourceSection sourceSection, TypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
        }

        @Override
        @Nullable
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("internalStdLibClass", "VarArgs").withSourceSection(headerSection).build();
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getVarArgsClass().export(), this.elementTypeNode.doExport());
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("internalStdLibClass", "VarArgs").build();
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof VarArgsTypeNode)) {
                return false;
            }
            VarArgsTypeNode varArgsTypeNode = (VarArgsTypeNode)other;
            return this.elementTypeNode.isEquivalentTo(varArgsTypeNode.elementTypeNode);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }

        @Override
        protected boolean isParametric() {
            return true;
        }
    }

    public static final class PairTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode firstTypeNode;
        @Node.Child
        private TypeNode secondTypeNode;

        public PairTypeNode(SourceSection sourceSection, TypeNode firstTypeNode, TypeNode secondTypeNode) {
            super(sourceSection);
            this.firstTypeNode = firstTypeNode;
            this.secondTypeNode = secondTypeNode;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmPair) {
                VmPair vmPair = (VmPair)value2;
                Object first2 = this.firstTypeNode.execute(frame, vmPair.getFirst());
                Object second2 = this.secondTypeNode.execute(frame, vmPair.getSecond());
                if (first2 == vmPair.getFirst() && second2 == vmPair.getSecond()) {
                    return vmPair;
                }
                return new VmPair(first2, second2);
            }
            throw this.typeMismatch(value2, BaseModule.getPairClass());
        }

        @Override
        public Object executeEagerly(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmPair) {
                VmPair vmPair = (VmPair)value2;
                this.firstTypeNode.executeEagerly(frame, vmPair.getFirst());
                this.secondTypeNode.executeEagerly(frame, vmPair.getSecond());
                return value2;
            }
            throw this.typeMismatch(value2, BaseModule.getPairClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getPairClass();
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return VmList.of(this.firstTypeNode.getMirror(), this.secondTypeNode.getMirror());
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof PairTypeNode)) {
                return false;
            }
            PairTypeNode pairTypeNode = (PairTypeNode)other;
            return this.firstTypeNode.isEquivalentTo(pairTypeNode.firstTypeNode) && this.secondTypeNode.isEquivalentTo(pairTypeNode.secondTypeNode);
        }

        @Override
        protected PType doExport() {
            return new PType.Class(BaseModule.getPairClass().export(), this.firstTypeNode.doExport(), this.secondTypeNode.doExport());
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }

        @Override
        protected boolean isParametric() {
            return true;
        }
    }

    public static abstract class FunctionNClassTypeNode
    extends ObjectSlotTypeNode {
        private final TypeNode[] typeArgumentNodes;

        protected FunctionNClassTypeNode(SourceSection sourceSection, TypeNode[] typeArgumentNodes) {
            super(sourceSection);
            this.typeArgumentNodes = typeArgumentNodes;
        }

        @Override
        public final VmClass getVmClass() {
            return this.getFunctionNClass();
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return FunctionNClassTypeNode.getMirrors(this.typeArgumentNodes);
        }

        @Override
        @ExplodeLoop
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof FunctionNClassTypeNode)) {
                return false;
            }
            FunctionNClassTypeNode functionNClassTypeNode = (FunctionNClassTypeNode)other;
            if (this.typeArgumentNodes.length != functionNClassTypeNode.typeArgumentNodes.length) {
                return false;
            }
            boolean ret = true;
            for (int i = 0; i < this.typeArgumentNodes.length; ++i) {
                TypeNode otherTypeNode;
                TypeNode typeNode;
                if (!ret || (typeNode = this.typeArgumentNodes[i]).isEquivalentTo(otherTypeNode = functionNClassTypeNode.typeArgumentNodes[i])) continue;
                ret = false;
            }
            LoopNode.reportLoopCount(this, this.typeArgumentNodes.length);
            return ret;
        }

        @Override
        protected final PType doExport() {
            List<PType> typeArguments = Arrays.stream(this.typeArgumentNodes).map(TypeNode::export).collect(Collectors.toList());
            return new PType.Class(this.getFunctionNClass().export(), typeArguments);
        }

        @Specialization(guards={"value.getVmClass() == getFunctionNClass()"})
        protected Object eval(VmFunction value2) {
            return value2;
        }

        @Fallback
        protected Object fallback(Object value2) {
            throw this.typeMismatch(value2, this.getFunctionNClass());
        }

        protected VmClass getFunctionNClass() {
            return BaseModule.getFunctionNClass(this.typeArgumentNodes.length - 1);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }

        @Override
        protected boolean isParametric() {
            return true;
        }
    }

    public static abstract class FunctionClassTypeNode
    extends ObjectSlotTypeNode {
        private final TypeNode typeArgumentNode;

        protected FunctionClassTypeNode(SourceSection sourceSection, TypeNode typeArgumentNode) {
            super(sourceSection);
            this.typeArgumentNode = typeArgumentNode;
        }

        @Override
        public final VmClass getVmClass() {
            return BaseModule.getFunctionClass();
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return VmList.of(this.typeArgumentNode.getMirror());
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getFunctionClass().export(), TypeNode.export(this.typeArgumentNode));
        }

        @Specialization
        protected Object eval(VmFunction value2) {
            return value2;
        }

        @Fallback
        protected void fallback(Object value2) {
            throw this.typeMismatch(value2, BaseModule.getFunctionClass());
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof FunctionClassTypeNode)) {
                return false;
            }
            FunctionClassTypeNode functionClassTypeNode = (FunctionClassTypeNode)other;
            return this.typeArgumentNode.isEquivalentTo(functionClassTypeNode.typeArgumentNode);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }

        @Override
        protected boolean isParametric() {
            return true;
        }
    }

    public static abstract class FunctionTypeNode
    extends ObjectSlotTypeNode {
        private final TypeNode[] parameterTypeNodes;
        private final TypeNode returnTypeNode;

        protected FunctionTypeNode(SourceSection sourceSection, TypeNode[] parameterTypeNodes, TypeNode returnTypeNode) {
            super(sourceSection);
            this.parameterTypeNodes = parameterTypeNodes;
            this.returnTypeNode = returnTypeNode;
        }

        @Override
        public final VmClass getVmClass() {
            return this.getFunctionNClass();
        }

        @Override
        public final VmTyped getMirror() {
            return MirrorFactories.functionTypeFactory.create(this);
        }

        public final VmList getParameterTypeMirrors() {
            return FunctionTypeNode.getMirrors(this.parameterTypeNodes);
        }

        public final VmTyped getReturnTypeMirror() {
            return this.returnTypeNode.getMirror();
        }

        @Override
        @ExplodeLoop
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof FunctionTypeNode)) {
                return false;
            }
            FunctionTypeNode functionTypeNode = (FunctionTypeNode)other;
            if (!this.returnTypeNode.isEquivalentTo(functionTypeNode.returnTypeNode)) {
                return false;
            }
            if (this.parameterTypeNodes.length != functionTypeNode.parameterTypeNodes.length) {
                return false;
            }
            boolean ret = true;
            for (int i = 0; i < this.parameterTypeNodes.length; ++i) {
                TypeNode typeNode = this.parameterTypeNodes[i];
                TypeNode otherTypeNode = functionTypeNode.parameterTypeNodes[i];
                if (!ret || typeNode.isEquivalentTo(otherTypeNode)) continue;
                ret = false;
            }
            LoopNode.reportLoopCount(this, this.parameterTypeNodes.length);
            return ret;
        }

        @Override
        protected final PType doExport() {
            List<PType> parameterTypes = Arrays.stream(this.parameterTypeNodes).map(TypeNode::export).collect(Collectors.toList());
            return new PType.Function(parameterTypes, TypeNode.export(this.returnTypeNode));
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }

        @Specialization(guards={"value.getVmClass() == getFunctionNClass()"})
        protected Object eval(VmFunction value2) {
            return value2;
        }

        @Fallback
        protected Object fallback(Object value2) {
            throw this.typeMismatch(value2, this.getFunctionNClass());
        }

        protected VmClass getFunctionNClass() {
            return BaseModule.getFunctionNClass(this.parameterTypeNodes.length);
        }

        @Override
        protected boolean isParametric() {
            return true;
        }
    }

    public static abstract class ListingOrMappingTypeNode
    extends ObjectSlotTypeNode {
        private final VmLanguage language;
        @Node.Child
        @Nullable
        protected TypeNode keyTypeNode;
        @Node.Child
        protected TypeNode valueTypeNode;
        @Node.Child
        @Nullable
        protected ListingOrMappingTypeCastNode valueTypeCastNode;
        private final boolean skipKeyTypeChecks;
        private final boolean skipValueTypeChecks;

        protected ListingOrMappingTypeNode(SourceSection sourceSection, VmLanguage language, @Nullable TypeNode keyTypeNode, TypeNode valueTypeNode) {
            super(sourceSection);
            this.language = language;
            this.keyTypeNode = keyTypeNode;
            this.valueTypeNode = valueTypeNode;
            this.skipKeyTypeChecks = keyTypeNode == null || keyTypeNode.isNoopTypeCheck();
            this.skipValueTypeChecks = valueTypeNode.isNoopTypeCheck();
        }

        private boolean isListing() {
            return this.keyTypeNode == null;
        }

        @Nullable
        public TypeNode getKeyTypeNode() {
            return this.keyTypeNode;
        }

        public TypeNode getValueTypeNode() {
            return this.valueTypeNode;
        }

        protected ListingOrMappingTypeCastNode getValueTypeCastNode() {
            if (this.valueTypeCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.valueTypeCastNode = new ListingOrMappingTypeCastNode(this.language, new FrameDescriptor(), this.valueTypeNode, this.getRootNode().getName());
            }
            return this.valueTypeCastNode;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public final Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            if (this.valueTypeNode instanceof UnknownTypeNode) {
                if (this.isListing()) {
                    return new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), EconomicMaps.create(), 0);
                }
                return new VmMapping(VmUtils.createEmptyMaterializedFrame(), BaseModule.getMappingClass().getPrototype(), EconomicMaps.create());
            }
            ObjectMember defaultMember = new ObjectMember(headerSection, headerSection, 8, Identifier.DEFAULT, qualifiedName + ".default");
            Object defaultMemberValue = this.valueTypeNode.createDefaultValue(language, headerSection, qualifiedName);
            if (defaultMemberValue == null) {
                defaultMember.initMemberNode(new UntypedObjectMemberNode(language, new FrameDescriptor(), defaultMember, (ExpressionNode)new DefaultPropertyBodyNode(headerSection, Identifier.DEFAULT, null)));
            } else {
                defaultMember.initConstantValue(new VmFunction(VmUtils.createEmptyMaterializedFrame(), null, 1, new SimpleRootNode(language, new FrameDescriptor(), headerSection, defaultMember.getQualifiedName() + ".<function>", new ConstantValueNode(defaultMemberValue)), null));
            }
            if (this.isListing()) {
                return new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), EconomicMaps.of(Identifier.DEFAULT, defaultMember), 0);
            }
            return new VmMapping(VmUtils.createEmptyMaterializedFrame(), BaseModule.getMappingClass().getPrototype(), EconomicMaps.of(Identifier.DEFAULT, defaultMember));
        }

        protected void doEagerCheck(VirtualFrame frame, VmObject object) {
            this.doEagerCheck(frame, object, this.skipKeyTypeChecks, this.skipValueTypeChecks);
        }

        protected void doEagerCheck(VirtualFrame frame, VmObject object, boolean skipKeyTypeChecks, boolean skipValueTypeChecks) {
            if (skipKeyTypeChecks && skipValueTypeChecks) {
                return;
            }
            int loopCount = 0;
            for (VmObject owner = object; owner != null; owner = owner.getParent()) {
                UnmodifiableMapCursor<Object, ObjectMember> cursor = EconomicMaps.getEntries(owner.getMembers());
                while (cursor.advance()) {
                    ++loopCount;
                    ObjectMember member = cursor.getValue();
                    if (member.isProp()) continue;
                    Object memberKey = cursor.getKey();
                    if (!skipKeyTypeChecks) {
                        assert (this.keyTypeNode != null);
                        try {
                            this.keyTypeNode.executeEagerly(frame, memberKey);
                        }
                        catch (VmTypeMismatchException e2) {
                            CompilerDirectives.transferToInterpreter();
                            e2.putInsertedStackFrame(this.getRootNode().getCallTarget(), VmUtils.createStackFrame(member.getHeaderSection(), member.getQualifiedName()));
                            throw e2;
                        }
                    }
                    if (skipValueTypeChecks) continue;
                    Object memberValue = object.getCachedValue(memberKey);
                    if (memberValue == null) {
                        memberValue = member.getConstantValue();
                        if (memberValue == null) {
                            RootCallTarget callTarget = member.getCallTarget();
                            memberValue = callTarget.call(object, owner, memberKey);
                        }
                        object.setCachedValue(memberKey, memberValue);
                    }
                    this.valueTypeNode.executeEagerly(frame, memberValue);
                }
            }
            LoopNode.reportLoopCount(this, loopCount);
        }

        @Override
        protected boolean isParametric() {
            return true;
        }
    }

    public static final class MappingTypeNode
    extends ListingOrMappingTypeNode {
        public MappingTypeNode(SourceSection sourceSection, VmLanguage language, TypeNode keyTypeNode, TypeNode valueTypeNode) {
            super(sourceSection, language, keyTypeNode, valueTypeNode);
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (!(value2 instanceof VmMapping)) {
                throw this.typeMismatch(value2, BaseModule.getMappingClass());
            }
            VmMapping vmMapping = (VmMapping)value2;
            this.doEagerCheck(frame, vmMapping, false, true);
            if (vmMapping.isValueTypeKnownSubtypeOf(this.valueTypeNode)) {
                return vmMapping;
            }
            return new VmMapping(vmMapping.getEnclosingFrame(), vmMapping, EconomicMaps.emptyMap(), this.getValueTypeCastNode(), VmUtils.getReceiver(frame), VmUtils.getOwner(frame));
        }

        @Override
        public Object executeEagerly(VirtualFrame frame, Object value2) {
            if (!(value2 instanceof VmMapping)) {
                throw this.typeMismatch(value2, BaseModule.getMappingClass());
            }
            VmMapping vmMapping = (VmMapping)value2;
            this.doEagerCheck(frame, vmMapping, false, false);
            return value2;
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getMappingClass();
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            assert (this.keyTypeNode != null);
            return VmList.of(this.keyTypeNode.getMirror(), this.valueTypeNode.getMirror());
        }

        @Override
        protected PType doExport() {
            assert (this.keyTypeNode != null);
            return new PType.Class(BaseModule.getMappingClass().export(), this.keyTypeNode.doExport(), this.valueTypeNode.doExport());
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof MappingTypeNode)) {
                return false;
            }
            MappingTypeNode mappingTypeNode = (MappingTypeNode)other;
            assert (this.keyTypeNode != null);
            assert (mappingTypeNode.keyTypeNode != null);
            return this.keyTypeNode.isEquivalentTo(mappingTypeNode.keyTypeNode) && this.valueTypeNode.isEquivalentTo(mappingTypeNode.valueTypeNode);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class ListingTypeNode
    extends ListingOrMappingTypeNode {
        public ListingTypeNode(SourceSection sourceSection, VmLanguage language, TypeNode valueTypeNode) {
            super(sourceSection, language, null, valueTypeNode);
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (!(value2 instanceof VmListing)) {
                throw this.typeMismatch(value2, BaseModule.getListingClass());
            }
            VmListing vmListing = (VmListing)value2;
            if (vmListing.isValueTypeKnownSubtypeOf(this.valueTypeNode)) {
                return vmListing;
            }
            return new VmListing(vmListing.getEnclosingFrame(), vmListing, EconomicMaps.emptyMap(), vmListing.getLength(), this.getValueTypeCastNode(), VmUtils.getReceiver(frame), VmUtils.getOwner(frame));
        }

        @Override
        public Object executeEagerly(VirtualFrame frame, Object value2) {
            if (!(value2 instanceof VmListing)) {
                throw this.typeMismatch(value2, BaseModule.getListingClass());
            }
            VmListing vmListing = (VmListing)value2;
            this.doEagerCheck(frame, vmListing);
            return value2;
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getListingClass();
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return VmList.of(this.valueTypeNode.getMirror());
        }

        @Override
        protected PType doExport() {
            return new PType.Class(BaseModule.getListingClass().export(), this.valueTypeNode.doExport());
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof ListingTypeNode)) {
                return false;
            }
            ListingTypeNode listingTypeNode = (ListingTypeNode)other;
            return this.valueTypeNode.isEquivalentTo(listingTypeNode.valueTypeNode);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class MapTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode keyTypeNode;
        @Node.Child
        private TypeNode valueTypeNode;
        private final boolean skipEntryTypeChecks;

        public MapTypeNode(SourceSection sourceSection, TypeNode keyTypeNode, TypeNode valueTypeNode) {
            super(sourceSection);
            this.keyTypeNode = keyTypeNode;
            this.valueTypeNode = valueTypeNode;
            this.skipEntryTypeChecks = keyTypeNode.isNoopTypeCheck() && valueTypeNode.isNoopTypeCheck();
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmMap) {
                VmMap vmMap = (VmMap)value2;
                return this.eval(frame, vmMap);
            }
            throw this.typeMismatch(value2, BaseModule.getMapClass());
        }

        @Override
        public Object executeEagerly(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmMap) {
                VmMap vmMap = (VmMap)value2;
                return this.evalEager(frame, vmMap);
            }
            throw this.typeMismatch(value2, BaseModule.getMapClass());
        }

        @Override
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmMap.EMPTY;
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getMapClass();
        }

        public TypeNode getValueTypeNode() {
            return this.valueTypeNode;
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return VmList.of(this.keyTypeNode.getMirror(), this.valueTypeNode.getMirror());
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof MapTypeNode)) {
                return false;
            }
            MapTypeNode mapTypeNode = (MapTypeNode)other;
            return this.keyTypeNode.isEquivalentTo(mapTypeNode.keyTypeNode) && this.valueTypeNode.isEquivalentTo(mapTypeNode.valueTypeNode);
        }

        @Override
        protected PType doExport() {
            return new PType.Class(BaseModule.getMapClass().export(), this.keyTypeNode.doExport(), this.valueTypeNode.doExport());
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }

        private Object eval(VirtualFrame frame, VmMap value2) {
            if (this.skipEntryTypeChecks) {
                return value2;
            }
            VmMap ret = value2;
            for (Map.Entry<Object, Object> entry : value2) {
                Object key2 = VmUtils.getKey(entry);
                this.keyTypeNode.executeEagerly(frame, key2);
                Object result = this.valueTypeNode.execute(frame, VmUtils.getValue(entry));
                if (result == VmUtils.getValue(entry)) continue;
                ret = ret.put(key2, result);
            }
            LoopNode.reportLoopCount(this, value2.getLength());
            return ret;
        }

        private Object evalEager(VirtualFrame frame, VmMap value2) {
            if (this.skipEntryTypeChecks) {
                return value2;
            }
            for (Map.Entry<Object, Object> entry : value2) {
                this.keyTypeNode.executeEagerly(frame, VmUtils.getKey(entry));
                this.valueTypeNode.execute(frame, VmUtils.getValue(entry));
            }
            LoopNode.reportLoopCount(this, value2.getLength());
            return value2;
        }

        @Override
        protected boolean isParametric() {
            return true;
        }
    }

    public static abstract class SetTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode elementTypeNode;
        private final boolean skipElementTypeChecks;

        protected SetTypeNode(SourceSection sourceSection, TypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
            this.skipElementTypeChecks = elementTypeNode.isNoopTypeCheck();
        }

        @Override
        public final Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmSet.EMPTY;
        }

        @Override
        public final VmClass getVmClass() {
            return BaseModule.getSetClass();
        }

        public TypeNode getElementTypeNode() {
            return this.elementTypeNode;
        }

        @Override
        public final VmList getTypeArgumentMirrors() {
            return VmList.of(this.elementTypeNode.getMirror());
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof SetTypeNode)) {
                return false;
            }
            SetTypeNode setTypeNode = (SetTypeNode)other;
            return this.elementTypeNode.isEquivalentTo(setTypeNode.elementTypeNode);
        }

        @Override
        protected final PType doExport() {
            return new PType.Class(BaseModule.getSetClass().export(), this.elementTypeNode.doExport());
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }

        @Specialization
        protected Object eval(VirtualFrame frame, VmSet value2) {
            if (this.skipElementTypeChecks) {
                return value2;
            }
            for (Object elem : value2) {
                this.elementTypeNode.executeEagerly(frame, elem);
            }
            LoopNode.reportLoopCount(this, value2.getLength());
            return value2;
        }

        @Fallback
        protected Object fallback(Object value2) {
            throw this.typeMismatch(value2, BaseModule.getSetClass());
        }

        @Override
        protected boolean isParametric() {
            return true;
        }
    }

    public static final class ListTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode elementTypeNode;
        private final boolean skipElementTypeChecks;

        public ListTypeNode(SourceSection sourceSection, TypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
            this.skipElementTypeChecks = elementTypeNode.isNoopTypeCheck();
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }

        @Override
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmList.EMPTY;
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getListClass();
        }

        public TypeNode getElementTypeNode() {
            return this.elementTypeNode;
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return VmList.of(this.elementTypeNode.getMirror());
        }

        @Override
        protected PType doExport() {
            return new PType.Class(BaseModule.getListClass().export(), this.elementTypeNode.doExport());
        }

        @Override
        public Object executeEagerly(VirtualFrame frame, Object value2) {
            if (!(value2 instanceof VmList)) {
                throw this.typeMismatch(value2, BaseModule.getListClass());
            }
            VmList vmList = (VmList)value2;
            if (this.skipElementTypeChecks) {
                return vmList;
            }
            for (Object elem : vmList) {
                this.elementTypeNode.executeEagerly(frame, elem);
            }
            LoopNode.reportLoopCount(this, vmList.getLength());
            return value2;
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame, Object value2) {
            if (!(value2 instanceof VmList)) {
                throw this.typeMismatch(value2, BaseModule.getListClass());
            }
            VmList vmList = (VmList)value2;
            if (this.skipElementTypeChecks) {
                return vmList;
            }
            VmList ret = vmList;
            int idx = 0;
            for (Object elem : vmList) {
                Object result = this.elementTypeNode.execute(frame, elem);
                if (result != elem) {
                    ret = ret.replace(idx, result);
                }
                ++idx;
            }
            LoopNode.reportLoopCount(this, vmList.getLength());
            return ret;
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof ListTypeNode)) {
                return false;
            }
            ListTypeNode listTypeNode = (ListTypeNode)other;
            return this.elementTypeNode.isEquivalentTo(listTypeNode.elementTypeNode);
        }

        @Override
        protected boolean isParametric() {
            return true;
        }
    }

    public static final class CollectionTypeNode
    extends ObjectSlotTypeNode {
        @Node.Child
        private TypeNode elementTypeNode;

        public CollectionTypeNode(SourceSection sourceSection, TypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmList) {
                VmList vmList = (VmList)value2;
                return this.evalList(frame, vmList);
            }
            if (value2 instanceof VmSet) {
                VmSet vmSet = (VmSet)value2;
                return this.evalSet(frame, vmSet);
            }
            throw this.typeMismatch(value2, BaseModule.getCollectionClass());
        }

        @Override
        public Object executeEagerly(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmList) {
                VmList vmList = (VmList)value2;
                return this.evalListEagerly(frame, vmList);
            }
            if (value2 instanceof VmSet) {
                VmSet vmSet = (VmSet)value2;
                return this.evalSet(frame, vmSet);
            }
            throw this.typeMismatch(value2, BaseModule.getCollectionClass());
        }

        @Override
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmList.EMPTY;
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getCollectionClass();
        }

        @Override
        protected PType doExport() {
            return new PType.Class(BaseModule.getCollectionClass().export(), this.elementTypeNode.doExport());
        }

        @Override
        public VmList getTypeArgumentMirrors() {
            return VmList.of(this.elementTypeNode.getMirror());
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return false;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }

        @ExplodeLoop
        private Object evalList(VirtualFrame frame, VmList value2) {
            VmList ret = value2;
            int idx = 0;
            for (Object elem : value2) {
                Object result = this.elementTypeNode.execute(frame, elem);
                if (result != elem) {
                    ret = ret.replace(idx, result);
                }
                ++idx;
            }
            LoopNode.reportLoopCount(this, idx);
            return ret;
        }

        private Object evalListEagerly(VirtualFrame frame, VmList value2) {
            for (Object elem : value2) {
                this.elementTypeNode.executeEagerly(frame, elem);
            }
            LoopNode.reportLoopCount(this, value2.getLength());
            return value2;
        }

        private Object evalSet(VirtualFrame frame, VmSet value2) {
            for (Object elem : value2) {
                this.elementTypeNode.executeEagerly(frame, elem);
            }
            LoopNode.reportLoopCount(this, value2.getLength());
            return value2;
        }

        @Override
        protected boolean isParametric() {
            return true;
        }
    }

    public static final class UnionOfStringLiteralsTypeNode
    extends ObjectSlotTypeNode {
        private final Set<String> stringLiterals;
        @Nullable
        private final String unionDefault;

        UnionOfStringLiteralsTypeNode(SourceSection sourceSection, int defaultIndex, Set<String> stringLiterals) {
            super(sourceSection);
            assert (!stringLiterals.isEmpty());
            this.stringLiterals = stringLiterals;
            this.unionDefault = defaultIndex == -1 ? null : stringLiterals.toArray(new String[0])[defaultIndex];
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.unionOfStringLiteralsTypeFactory.create(this);
        }

        public VmList getElementTypeMirrors() {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            for (String literal : this.stringLiterals) {
                builder.add(MirrorFactories.stringLiteralTypeFactory2.create(literal));
            }
            return builder.build();
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (this.contains(value2)) {
                return value2;
            }
            throw this.typeMismatch(value2, this.stringLiterals);
        }

        @CompilerDirectives.TruffleBoundary
        private boolean contains(Object value2) {
            return this.stringLiterals.contains(value2);
        }

        @Override
        protected PType doExport() {
            return new PType.Union(this.stringLiterals.stream().map(PType.StringLiteral::new).collect(Collectors.toList()));
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof UnionOfStringLiteralsTypeNode)) {
                return false;
            }
            UnionOfStringLiteralsTypeNode unionOfStringLiteralsTypeNode = (UnionOfStringLiteralsTypeNode)other;
            return this.stringLiterals.equals(unionOfStringLiteralsTypeNode.stringLiterals);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        @Nullable
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return this.unionDefault;
        }
    }

    public static class UnionTypeNode
    extends WriteFrameSlotTypeNode {
        @Node.Children
        final TypeNode[] elementTypeNodes;
        private final boolean skipElementTypeChecks;
        private final int defaultIndex;

        public UnionTypeNode(SourceSection sourceSection, int defaultIndex, TypeNode[] elementTypeNodes, boolean skipElementTypeChecks) {
            super(sourceSection);
            assert (elementTypeNodes.length > 0);
            this.elementTypeNodes = elementTypeNodes;
            this.defaultIndex = defaultIndex;
            this.skipElementTypeChecks = skipElementTypeChecks;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.unionTypeFactory.create(this);
        }

        public VmList getElementTypeMirrors() {
            return UnionTypeNode.getMirrors(this.elementTypeNodes);
        }

        public TypeNode[] getElementTypeNodes() {
            return this.elementTypeNodes;
        }

        @Override
        public boolean isNoopTypeCheck() {
            return this.skipElementTypeChecks;
        }

        @Override
        @Nullable
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return this.defaultIndex == -1 ? null : this.elementTypeNodes[this.defaultIndex].createDefaultValue(language, headerSection, qualifiedName);
        }

        @Override
        protected PType doExport() {
            List<PType> elementTypes = Arrays.stream(this.elementTypeNodes).map(TypeNode::export).collect(Collectors.toList());
            return new PType.Union(elementTypes);
        }

        @Override
        @ExplodeLoop
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof UnionTypeNode)) {
                return false;
            }
            UnionTypeNode unionTypeNode = (UnionTypeNode)other;
            if (this.elementTypeNodes.length != unionTypeNode.elementTypeNodes.length) {
                return false;
            }
            boolean ret = true;
            for (int i = 0; i < this.elementTypeNodes.length; ++i) {
                if (!ret || this.elementTypeNodes[i].isEquivalentTo(unionTypeNode.elementTypeNodes[i])) continue;
                ret = false;
            }
            LoopNode.reportLoopCount(this, this.elementTypeNodes.length);
            return ret;
        }

        @Override
        @ExplodeLoop
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            if (!consumer.accept(this)) {
                return false;
            }
            boolean ret = true;
            for (int i = 0; i < this.elementTypeNodes.length; ++i) {
                if (!ret || this.elementTypeNodes[i].acceptTypeNode(consumer)) continue;
                ret = false;
            }
            LoopNode.reportLoopCount(this, this.elementTypeNodes.length);
            return ret;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean shouldEagerCheck() {
            EconomicSet seenParameterizedClasses = EconomicSets.create();
            MutableBoolean ret = new MutableBoolean(false);
            this.acceptTypeNode(typeNode -> {
                if (!typeNode.isParametric()) {
                    return true;
                }
                VmClass typeNodeClass = typeNode.getVmClass();
                if (typeNodeClass == null) {
                    return true;
                }
                if (seenParameterizedClasses.contains(typeNodeClass)) {
                    ret.set(true);
                    return false;
                }
                EconomicSets.add(seenParameterizedClasses, typeNodeClass);
                return true;
            });
            return ret.get();
        }

        @Override
        @ExplodeLoop
        @Fallback
        public Object execute(VirtualFrame frame, Object value2) {
            if (this.skipElementTypeChecks) {
                return value2;
            }
            VmTypeMismatchException[] typeMismatches = new VmTypeMismatchException[this.elementTypeNodes.length];
            boolean shouldEagerCheck = this.shouldEagerCheck();
            for (int i = 0; i < this.elementTypeNodes.length; ++i) {
                TypeNode elementTypeNode = this.elementTypeNodes[i];
                try {
                    if (shouldEagerCheck) {
                        return elementTypeNode.executeEagerly(frame, value2);
                    }
                    return elementTypeNode.execute(frame, value2);
                }
                catch (VmTypeMismatchException e2) {
                    typeMismatches[i] = e2;
                    continue;
                }
            }
            throw new VmTypeMismatchException.Union(this.sourceSection, value2, this, typeMismatches);
        }

        @Override
        public Object executeEagerly(VirtualFrame frame, Object value2) {
            if (this.skipElementTypeChecks) {
                return value2;
            }
            VmTypeMismatchException[] typeMismatches = new VmTypeMismatchException[this.elementTypeNodes.length];
            for (int i = 0; i < this.elementTypeNodes.length; ++i) {
                try {
                    return this.elementTypeNodes[i].executeEagerly(frame, value2);
                }
                catch (VmTypeMismatchException e2) {
                    typeMismatches[i] = e2;
                    continue;
                }
            }
            throw new VmTypeMismatchException.Union(this.sourceSection, value2, this, typeMismatches);
        }
    }

    public static class NullableTypeNode
    extends WriteFrameSlotTypeNode {
        @Node.Child
        private TypeNode elementTypeNode;

        public NullableTypeNode(SourceSection sourceSection, TypeNode elementTypeNode) {
            super(sourceSection);
            this.elementTypeNode = elementTypeNode;
        }

        public TypeNode getElementTypeNode() {
            return this.elementTypeNode;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.nullableTypeFactory.create(this);
        }

        public VmTyped getElementTypeMirror() {
            return this.elementTypeNode.getMirror();
        }

        @Override
        @Nullable
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmNull.withDefault(this.elementTypeNode.createDefaultValue(language, headerSection, qualifiedName));
        }

        @Override
        protected final PType doExport() {
            return new PType.Nullable(this.elementTypeNode.doExport());
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmNull) {
                return value2;
            }
            return this.elementTypeNode.execute(frame, value2);
        }

        @Override
        public Object executeEagerly(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmNull) {
                return value2;
            }
            return this.elementTypeNode.executeEagerly(frame, value2);
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof NullableTypeNode)) {
                return false;
            }
            NullableTypeNode nullableTypeNode = (NullableTypeNode)other;
            return this.elementTypeNode.isEquivalentTo(nullableTypeNode.elementTypeNode);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            if (!consumer.accept(this)) {
                return false;
            }
            return this.elementTypeNode.acceptTypeNode(consumer);
        }
    }

    public static final class DynamicTypeNode
    extends ObjectSlotTypeNode {
        public DynamicTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmDynamic) {
                return value2;
            }
            throw this.typeMismatch(value2, BaseModule.getDynamicClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getDynamicClass();
        }

        @Override
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return VmDynamic.empty();
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof DynamicTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class TypedTypeNode
    extends ObjectSlotTypeNode {
        public TypedTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (value2 instanceof VmTyped) {
                return value2;
            }
            throw this.typeMismatch(value2, BaseModule.getTypedClass());
        }

        @Override
        public VmClass getVmClass() {
            return BaseModule.getTypedClass();
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof TypedTypeNode;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class StringLiteralTypeNode
    extends ObjectSlotTypeNode {
        private final String literal;

        public StringLiteralTypeNode(SourceSection sourceSection, String literal) {
            super(sourceSection);
            this.literal = literal;
        }

        public String getLiteral() {
            return this.literal;
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof StringLiteralTypeNode)) {
                return false;
            }
            StringLiteralTypeNode stringLiteralTypeNode = (StringLiteralTypeNode)other;
            return this.literal.equals(stringLiteralTypeNode.literal);
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            if (this.literal.equals(value2)) {
                return value2;
            }
            throw this.typeMismatch(value2, this.literal);
        }

        @Override
        public Object createDefaultValue(VmLanguage language, SourceSection headerSection, String qualifiedName) {
            return this.literal;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.stringLiteralTypeFactory.create(this);
        }

        @Override
        protected PType doExport() {
            return new PType.StringLiteral(this.literal);
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class NonFinalModuleTypeNode
    extends ObjectSlotTypeNode {
        private final VmClass moduleClass;
        @Node.Child
        private ExpressionNode getModuleNode;

        public NonFinalModuleTypeNode(SourceSection sourceSection, VmClass moduleClass) {
            super(sourceSection);
            this.moduleClass = moduleClass;
            this.getModuleNode = new GetModuleNode(sourceSection);
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            VmTyped typed;
            VmClass valueClass;
            VmClass moduleClass = ((VmTyped)this.getModuleNode.executeGeneric(frame)).getVmClass();
            if (value2 instanceof VmTyped && moduleClass.isSuperclassOf(valueClass = (typed = (VmTyped)value2).getVmClass())) {
                return value2;
            }
            throw this.typeMismatch(value2, moduleClass);
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.moduleTypeFactory.create(null);
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof NonFinalModuleTypeNode)) {
                return false;
            }
            NonFinalModuleTypeNode nonFinalModuleTypeNode = (NonFinalModuleTypeNode)other;
            return this.moduleClass.equals(nonFinalModuleTypeNode.moduleClass);
        }

        @Override
        protected PType doExport() {
            return PType.MODULE;
        }

        @Override
        public VmClass getVmClass() {
            return this.moduleClass;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class FinalModuleTypeNode
    extends ObjectSlotTypeNode {
        private final VmClass moduleClass;

        public FinalModuleTypeNode(SourceSection sourceSection, VmClass moduleClass) {
            super(sourceSection);
            this.moduleClass = moduleClass;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            VmTyped typed;
            if (value2 instanceof VmTyped && (typed = (VmTyped)value2).getVmClass() == this.moduleClass) {
                return value2;
            }
            throw this.typeMismatch(value2, this.moduleClass);
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.moduleTypeFactory.create(null);
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            if (!(other instanceof FinalModuleTypeNode)) {
                return false;
            }
            FinalModuleTypeNode finalModuleTypeNode = (FinalModuleTypeNode)other;
            return this.moduleClass.equals(finalModuleTypeNode.moduleClass);
        }

        @Override
        protected PType doExport() {
            return PType.MODULE;
        }

        @Override
        public VmClass getVmClass() {
            return this.moduleClass;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class NothingTypeNode
    extends TypeNode {
        public NothingTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public TypeNode initWriteSlotNode(int slot) {
            return this;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            CompilerDirectives.transferToInterpreter();
            throw new VmTypeMismatchException.Nothing(this.sourceSection, value2);
        }

        @Override
        public Object executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
            CompilerDirectives.transferToInterpreter();
            throw PklBugException.unreachableCode();
        }

        @Override
        public Object executeEagerlyAndSet(VirtualFrame frame, Object value2) {
            return this.executeAndSet(frame, value2);
        }

        @Override
        public FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Illegal;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.nothingTypeFactory.create(null);
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof NothingTypeNode;
        }

        @Override
        protected PType doExport() {
            return PType.NOTHING;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static final class UnknownTypeNode
    extends WriteFrameSlotTypeNode {
        public UnknownTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public boolean isNoopTypeCheck() {
            return true;
        }

        @Override
        public boolean doIsEquivalentTo(TypeNode other) {
            return other instanceof UnknownTypeNode;
        }

        @Override
        public Object execute(VirtualFrame frame, Object value2) {
            return value2;
        }

        @Override
        public VmTyped getMirror() {
            return MirrorFactories.unknownTypeFactory.create(null);
        }

        @Override
        protected PType doExport() {
            return PType.UNKNOWN;
        }

        @Override
        protected boolean acceptTypeNode(TypeNodeConsumer consumer) {
            return consumer.accept(this);
        }
    }

    public static abstract class WriteFrameSlotTypeNode
    extends TypeNode {
        @CompilerDirectives.CompilationFinal
        protected int slot;
        @Node.Child
        @LateInit
        private WriteFrameSlotNode writeSlotNode;

        protected WriteFrameSlotTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public final FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Illegal;
        }

        @Override
        public TypeNode initWriteSlotNode(int slot) {
            this.writeSlotNode = WriteFrameSlotNodeGen.create(VmUtils.unavailableSourceSection(), slot, null);
            this.slot = slot;
            return this;
        }

        @Override
        public final Object executeAndSet(VirtualFrame frame, Object value2) {
            Object result = this.execute(frame, value2);
            this.writeSlotNode.executeWithValue(frame, result);
            return result;
        }

        @Override
        public Object executeEagerlyAndSet(VirtualFrame frame, Object value2) {
            Object result = this.executeEagerly(frame, value2);
            this.writeSlotNode.executeWithValue(frame, result);
            return result;
        }
    }

    public static abstract class ObjectSlotTypeNode
    extends FrameSlotTypeNode {
        protected ObjectSlotTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public final FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Object;
        }

        @Override
        public final Object executeAndSet(VirtualFrame frame, Object value2) {
            Object result = this.execute(frame, value2);
            frame.setObject(this.slot, result);
            return result;
        }

        @Override
        public final Object executeEagerlyAndSet(VirtualFrame frame, Object value2) {
            Object result = this.executeEagerly(frame, value2);
            frame.setObject(this.slot, result);
            return result;
        }
    }

    public static abstract class IntSlotTypeNode
    extends FrameSlotTypeNode {
        protected IntSlotTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public final FrameSlotKind getFrameSlotKind() {
            return FrameSlotKind.Long;
        }

        @Override
        public final Object executeAndSet(VirtualFrame frame, Object value2) {
            this.execute(frame, value2);
            frame.setLong(this.slot, (Long)value2);
            return value2;
        }

        @Override
        public Object executeEagerlyAndSet(VirtualFrame frame, Object value2) {
            return this.executeAndSet(frame, value2);
        }
    }

    public static abstract class FrameSlotTypeNode
    extends TypeNode {
        @CompilerDirectives.CompilationFinal
        protected int slot = -1;
        @CompilerDirectives.CompilationFinal
        @Node.Child
        protected WriteFrameSlotNode writeFrameSlotNode;

        protected FrameSlotTypeNode(SourceSection sourceSection) {
            super(sourceSection);
        }

        @Override
        public TypeNode initWriteSlotNode(int slot) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.slot = slot;
            this.writeFrameSlotNode = WriteFrameSlotNodeGen.create(this.sourceSection, slot, null);
            return this;
        }
    }
}

