/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.type;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.PklNode;
import org.pkl.core.ast.builder.SymbolTable;
import org.pkl.core.ast.lambda.ApplyVmFunction1Node;
import org.pkl.core.ast.type.VmTypeMismatchException;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmUtils;

@NodeChild(value="bodyNode", type=ExpressionNode.class)
public abstract class TypeConstraintNode
extends PklNode {
    @CompilerDirectives.CompilationFinal
    private int customThisSlot = -1;

    protected TypeConstraintNode(SourceSection sourceSection) {
        super(sourceSection);
    }

    public abstract void execute(VirtualFrame var1);

    public String export() {
        return this.getSourceSection().getCharacters().toString();
    }

    @Specialization
    protected void eval(VirtualFrame frame, boolean result) {
        this.initConstraintSlot(frame);
        if (!result) {
            throw new VmTypeMismatchException.Constraint(this.sourceSection, frame.getAuxiliarySlot(this.customThisSlot));
        }
    }

    @Specialization
    protected void eval(VirtualFrame frame, VmFunction function, @Cached(value="createApplyNode()", neverDefault=true) ApplyVmFunction1Node applyNode) {
        this.initConstraintSlot(frame);
        Object value2 = frame.getAuxiliarySlot(this.customThisSlot);
        boolean result = applyNode.executeBoolean(function, value2);
        if (!result) {
            throw new VmTypeMismatchException.Constraint(this.sourceSection, value2);
        }
    }

    @Fallback
    protected void fallback(Object object) {
        CompilerDirectives.transferToInterpreter();
        throw this.exceptionBuilder().typeMismatch(object, BaseModule.getBooleanClass(), BaseModule.getFunctionClass()).build();
    }

    protected static ApplyVmFunction1Node createApplyNode() {
        return ApplyVmFunction1Node.create();
    }

    private void initConstraintSlot(VirtualFrame frame) {
        if (this.customThisSlot == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.customThisSlot = VmUtils.findAuxiliarySlot(frame, SymbolTable.CustomThisScope.FRAME_SLOT_ID);
        }
    }
}

