/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import java.util.List;
import org.pkl.core.TypeParameter;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.VmModifier;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.ast.member.FunctionNode;
import org.pkl.core.ast.member.UnresolvedClassMemberNode;
import org.pkl.core.ast.type.TypeNode;
import org.pkl.core.ast.type.UnresolvedTypeNode;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

public final class UnresolvedMethodNode
extends UnresolvedClassMemberNode {
    private final int parameterCount;
    private final List<TypeParameter> typeParameters;
    @Node.Children
    @Nullable
    private final UnresolvedTypeNode[] unresolvedParameterTypeNodes;
    @Node.Child
    @Nullable
    private UnresolvedTypeNode unresolvedReturnTypeNode;
    private final boolean isReturnTypeChecked;
    private final ExpressionNode bodyNode;

    public UnresolvedMethodNode(VmLanguage language, SourceSection sourceSection, SourceSection headerSection, FrameDescriptor descriptor, @Nullable SourceSection docComment, ExpressionNode[] annotationNodes, int modifiers, Identifier name, String qualifiedName, int parameterCount, List<TypeParameter> typeParameters, @Nullable UnresolvedTypeNode[] unresolvedParameterTypeNodes, @Nullable UnresolvedTypeNode unresolvedReturnTypeNode, boolean isReturnTypeChecked, ExpressionNode bodyNode) {
        super(language, sourceSection, headerSection, descriptor, docComment, annotationNodes, modifiers, name, qualifiedName);
        this.parameterCount = parameterCount;
        this.typeParameters = typeParameters;
        this.unresolvedParameterTypeNodes = unresolvedParameterTypeNodes;
        this.unresolvedReturnTypeNode = unresolvedReturnTypeNode;
        this.isReturnTypeChecked = isReturnTypeChecked;
        this.bodyNode = bodyNode;
    }

    public Identifier getName() {
        return this.name;
    }

    public SourceSection getHeaderSection() {
        return this.headerSection;
    }

    public boolean isLocal() {
        return VmModifier.isLocal(this.modifiers);
    }

    @Override
    public ClassMethod execute(VirtualFrame frame, VmClass clazz) {
        CompilerDirectives.transferToInterpreter();
        List<VmTyped> annotations = VmUtils.evaluateAnnotations(frame, this.annotationNodes);
        TypeNode[] parameterTypeNodes = VmUtils.resolveParameterTypes(frame, this.descriptor, this.unresolvedParameterTypeNodes);
        TypeNode returnTypeNode = this.unresolvedReturnTypeNode != null ? this.unresolvedReturnTypeNode.execute(frame) : null;
        String deprecation = null;
        for (VmTyped annotation : annotations) {
            String string;
            if (annotation.getVmClass() != BaseModule.getDeprecatedClass()) continue;
            Object messageObj = VmUtils.readMemberOrNull(annotation, Identifier.MESSAGE);
            deprecation = messageObj instanceof String ? (string = (String)messageObj) : "";
            break;
        }
        ClassMethod method = new ClassMethod(this.sourceSection, this.headerSection, this.modifiers, this.name, this.qualifiedName, this.docComment, annotations, clazz.getPrototype(), this.typeParameters, deprecation);
        FunctionNode functionNode = new FunctionNode(this.language, this.descriptor, method, this.parameterCount, parameterTypeNodes, returnTypeNode, this.isReturnTypeChecked, this.bodyNode);
        method.initFunctionNode(functionNode);
        return method;
    }
}

