/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.ast.member.PropertyTypeNode;
import org.pkl.core.ast.member.RegularMemberNode;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmUtils;

public final class TypedPropertyNode
extends RegularMemberNode {
    @Node.Child
    private DirectCallNode typeCheckCallNode;

    @CompilerDirectives.TruffleBoundary
    public TypedPropertyNode(VmLanguage language, FrameDescriptor descriptor, ObjectMember member, ExpressionNode bodyNode, PropertyTypeNode typeNode) {
        super(language, descriptor, member, bodyNode);
        assert (member.isProp());
        this.typeCheckCallNode = DirectCallNode.create(typeNode.getCallTarget());
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object propertyValue = this.executeBody(frame);
        if (VmUtils.shouldRunTypeCheck(frame)) {
            return this.typeCheckCallNode.call(VmUtils.getReceiver(frame), VmUtils.getOwner(frame), propertyValue, this.member.isInIterable());
        }
        return propertyValue;
    }
}

