/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.member;

import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.VmModifier;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.util.Nullable;

public abstract class Member {
    protected final SourceSection sourceSection;
    protected final SourceSection headerSection;
    protected final int modifiers;
    @Nullable
    protected final Identifier name;
    protected final String qualifiedName;

    public Member(SourceSection sourceSection, SourceSection headerSection, int modifiers, @Nullable Identifier name, String qualifiedName) {
        this.sourceSection = sourceSection;
        this.headerSection = headerSection;
        this.modifiers = modifiers;
        this.name = name;
        this.qualifiedName = qualifiedName;
    }

    public final SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public final SourceSection getHeaderSection() {
        return this.headerSection;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    @Nullable
    public Identifier getNameOrNull() {
        return this.name;
    }

    public Identifier getName() {
        assert (this.name != null);
        return this.name;
    }

    public final String getQualifiedName() {
        return this.qualifiedName;
    }

    @Nullable
    public abstract String getCallSignature();

    public final boolean isLocal() {
        return VmModifier.isLocal(this.modifiers);
    }

    public final boolean isConst() {
        return VmModifier.isConst(this.modifiers);
    }

    public final boolean isFixed() {
        return VmModifier.isFixed(this.modifiers);
    }

    public final boolean isHidden() {
        return VmModifier.isHidden(this.modifiers);
    }

    public final boolean isExternal() {
        return VmModifier.isExternal(this.modifiers);
    }

    public final boolean isClass() {
        return VmModifier.isClass(this.modifiers);
    }

    public final boolean isTypeAlias() {
        return VmModifier.isTypeAlias(this.modifiers);
    }

    public final boolean isImport() {
        return VmModifier.isImport(this.modifiers);
    }

    public final boolean isGlob() {
        return VmModifier.isGlob(this.modifiers);
    }

    public final boolean isAbstract() {
        return VmModifier.isAbstract(this.modifiers);
    }

    public final boolean isType() {
        return VmModifier.isType(this.modifiers);
    }

    public final boolean isLocalOrExternalOrHidden() {
        return VmModifier.isLocalOrExternalOrHidden(this.modifiers);
    }

    public final boolean isConstOrFixed() {
        return VmModifier.isConstOrFixed(this.modifiers);
    }

    public final boolean isLocalOrExternalOrAbstract() {
        return VmModifier.isLocalOrExternalOrAbstract(this.modifiers);
    }

    public boolean isInIterable() {
        return VmModifier.isInIterable(this.modifiers);
    }
}

