/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.invoke.MethodHandles;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.internal.GetClassNode;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmValue;

@GeneratedBy(value=GetClassNode.class)
public final class GetClassNodeGen
extends GetClassNode {
    static final InlineSupport.ReferenceField<EvalVmValueData> EVAL_VM_VALUE_CACHE_UPDATER = InlineSupport.ReferenceField.create(MethodHandles.lookup(), "evalVmValue_cache", EvalVmValueData.class);
    @Node.Child
    private ExpressionNode valueNode_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    @InlineSupport.UnsafeAccessedField
    private EvalVmValueData evalVmValue_cache;

    private GetClassNodeGen(SourceSection sourceSection, ExpressionNode valueNode) {
        super(sourceSection);
        this.valueNode_ = valueNode;
    }

    private GetClassNodeGen(ExpressionNode valueNode) {
        this.valueNode_ = valueNode;
    }

    @Override
    @ExplodeLoop
    public VmClass executeWith(VirtualFrame frameValue, Object valueNodeValue) {
        int state_0 = this.state_0_;
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && valueNodeValue instanceof String) {
                String valueNodeValue_ = (String)valueNodeValue;
                return this.evalString(valueNodeValue_);
            }
            if ((state_0 & 2) != 0 && valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                return this.evalInt(valueNodeValue_);
            }
            if ((state_0 & 4) != 0 && valueNodeValue instanceof Double) {
                double valueNodeValue_ = (Double)valueNodeValue;
                return this.evalFloat(valueNodeValue_);
            }
            if ((state_0 & 8) != 0 && valueNodeValue instanceof Boolean) {
                boolean valueNodeValue_ = (Boolean)valueNodeValue;
                return this.evalBoolean(valueNodeValue_);
            }
            if ((state_0 & 0x10) != 0) {
                EvalVmValueData s4_ = this.evalVmValue_cache;
                while (s4_ != null) {
                    if (valueNodeValue.getClass() == s4_.cachedClass_) {
                        return this.evalVmValue(valueNodeValue, s4_.cachedClass_);
                    }
                    s4_ = s4_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(valueNodeValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0x1D) == 0 && state_0 != 0) {
            return this.executeGeneric_long0(state_0, frameValue);
        }
        if ((state_0 & 0x1B) == 0 && state_0 != 0) {
            return this.executeGeneric_double1(state_0, frameValue);
        }
        if ((state_0 & 0x17) == 0 && state_0 != 0) {
            return this.executeGeneric_boolean2(state_0, frameValue);
        }
        return this.executeGeneric_generic3(state_0, frameValue);
    }

    private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
        long valueNodeValue_;
        int state_0 = state_0__;
        try {
            valueNodeValue_ = this.valueNode_.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 2) != 0);
        return this.evalInt(valueNodeValue_);
    }

    private Object executeGeneric_double1(int state_0__, VirtualFrame frameValue) {
        double valueNodeValue_;
        int state_0 = state_0__;
        try {
            valueNodeValue_ = this.valueNode_.executeFloat(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 4) != 0);
        return this.evalFloat(valueNodeValue_);
    }

    private Object executeGeneric_boolean2(int state_0__, VirtualFrame frameValue) {
        boolean valueNodeValue_;
        int state_0 = state_0__;
        try {
            valueNodeValue_ = this.valueNode_.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(ex.getResult());
        }
        assert ((state_0 & 8) != 0);
        return this.evalBoolean(valueNodeValue_);
    }

    @ExplodeLoop
    private Object executeGeneric_generic3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object valueNodeValue_ = this.valueNode_.executeGeneric(frameValue);
        if (state_0 != 0) {
            if ((state_0 & 1) != 0 && valueNodeValue_ instanceof String) {
                String valueNodeValue__ = (String)valueNodeValue_;
                return this.evalString(valueNodeValue__);
            }
            if ((state_0 & 2) != 0 && valueNodeValue_ instanceof Long) {
                long valueNodeValue__ = (Long)valueNodeValue_;
                return this.evalInt(valueNodeValue__);
            }
            if ((state_0 & 4) != 0 && valueNodeValue_ instanceof Double) {
                double valueNodeValue__ = (Double)valueNodeValue_;
                return this.evalFloat(valueNodeValue__);
            }
            if ((state_0 & 8) != 0 && valueNodeValue_ instanceof Boolean) {
                boolean valueNodeValue__ = (Boolean)valueNodeValue_;
                return this.evalBoolean(valueNodeValue__);
            }
            if ((state_0 & 0x10) != 0) {
                EvalVmValueData s4_ = this.evalVmValue_cache;
                while (s4_ != null) {
                    if (valueNodeValue_.getClass() == s4_.cachedClass_) {
                        return this.evalVmValue(valueNodeValue_, s4_.cachedClass_);
                    }
                    s4_ = s4_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(valueNodeValue_);
    }

    private VmClass executeAndSpecialize(Object valueNodeValue) {
        EvalVmValueData s4_;
        block7: {
            EvalVmValueData s4_original;
            int state_0 = this.state_0_;
            if (valueNodeValue instanceof String) {
                String valueNodeValue_ = (String)valueNodeValue;
                this.state_0_ = state_0 |= 1;
                return this.evalString(valueNodeValue_);
            }
            if (valueNodeValue instanceof Long) {
                long valueNodeValue_ = (Long)valueNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.evalInt(valueNodeValue_);
            }
            if (valueNodeValue instanceof Double) {
                double valueNodeValue_ = (Double)valueNodeValue;
                this.state_0_ = state_0 |= 4;
                return this.evalFloat(valueNodeValue_);
            }
            if (valueNodeValue instanceof Boolean) {
                boolean valueNodeValue_ = (Boolean)valueNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.evalBoolean(valueNodeValue_);
            }
            do {
                int count4_ = 0;
                s4_original = s4_ = EVAL_VM_VALUE_CACHE_UPDATER.getVolatile(this);
                while (s4_ != null && valueNodeValue.getClass() != s4_.cachedClass_) {
                    ++count4_;
                    s4_ = s4_.next_;
                }
                if (s4_ != null) break block7;
                Class<? extends VmValue> cachedClass__ = GetClassNode.getValueClass(valueNodeValue);
                if (valueNodeValue.getClass() != cachedClass__ || count4_ >= 99) break block7;
                s4_ = new EvalVmValueData(s4_original);
                s4_.cachedClass_ = cachedClass__;
            } while (!EVAL_VM_VALUE_CACHE_UPDATER.compareAndSet(this, s4_original, s4_));
            this.state_0_ = state_0 |= 0x10;
        }
        if (s4_ != null) {
            return this.evalVmValue(valueNodeValue, s4_.cachedClass_);
        }
        throw new UnsupportedSpecializationException(this, new Node[]{this.valueNode_}, valueNodeValue);
    }

    @Override
    public NodeCost getCost() {
        EvalVmValueData s4_;
        int state_0 = this.state_0_;
        if (state_0 == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & state_0 - 1) == 0 && ((s4_ = this.evalVmValue_cache) == null || s4_.next_ == null)) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    @NeverDefault
    public static GetClassNode create(SourceSection sourceSection, ExpressionNode valueNode) {
        return new GetClassNodeGen(sourceSection, valueNode);
    }

    @NeverDefault
    public static GetClassNode create(ExpressionNode valueNode) {
        return new GetClassNodeGen(valueNode);
    }

    @GeneratedBy(value=GetClassNode.class)
    @DenyReplace
    private static final class EvalVmValueData {
        @CompilerDirectives.CompilationFinal
        final EvalVmValueData next_;
        @CompilerDirectives.CompilationFinal
        Class<? extends VmValue> cachedClass_;

        EvalVmValueData(EvalVmValueData next_) {
            this.next_ = next_;
        }
    }
}

