/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.frame;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmUtils;

public class ReadEnclosingAuxiliarySlotNode
extends ExpressionNode {
    private final int slot;
    private final int levelsUp;

    public ReadEnclosingAuxiliarySlotNode(SourceSection sourceSection, int slot, int levelsUp) {
        super(sourceSection);
        this.slot = slot;
        this.levelsUp = levelsUp;
    }

    @ExplodeLoop
    protected final MaterializedFrame getCapturedFrame(VirtualFrame frame) {
        VmObjectLike owner = VmUtils.getOwner(frame);
        for (int i = 0; i < this.levelsUp - 1; ++i) {
            owner = owner.getEnclosingOwner();
            assert (owner != null);
        }
        return owner.getEnclosingFrame();
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        return this.getCapturedFrame(frame).getAuxiliarySlot(this.slot);
    }
}

