/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.ast.expression.member;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.pkl.core.ast.ConstantValueNode;
import org.pkl.core.ast.ExpressionNode;
import org.pkl.core.ast.MemberLookupMode;
import org.pkl.core.ast.builder.ConstLevel;
import org.pkl.core.ast.expression.member.InvokeMethodDirectNode;
import org.pkl.core.ast.expression.member.InvokeMethodLexicalNode;
import org.pkl.core.ast.expression.member.InvokeMethodVirtualNodeGen;
import org.pkl.core.ast.expression.primary.GetEnclosingReceiverNode;
import org.pkl.core.ast.expression.primary.GetReceiverNode;
import org.pkl.core.ast.internal.GetClassNodeGen;
import org.pkl.core.ast.member.ClassMethod;
import org.pkl.core.ast.member.Member;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;

@NodeInfo(shortName="resolveMethod")
public final class ResolveMethodNode
extends ExpressionNode {
    private final Identifier methodName;
    private final ExpressionNode[] argumentNodes;
    private final boolean isBaseModule;
    private final boolean isCustomThisScope;
    private final ConstLevel constLevel;
    private final int constDepth;
    private final boolean isInIterable;

    public ResolveMethodNode(SourceSection sourceSection, Identifier methodName, ExpressionNode[] argumentNodes, boolean isBaseModule, boolean isCustomThisScope, ConstLevel constLevel, int constDepth, boolean isInIterable) {
        super(sourceSection);
        this.methodName = methodName;
        this.argumentNodes = argumentNodes;
        this.isBaseModule = isBaseModule;
        this.isCustomThisScope = isCustomThisScope;
        this.constLevel = constLevel;
        this.constDepth = constDepth;
        this.isInIterable = isInIterable;
    }

    @Override
    public Object executeGeneric(VirtualFrame frame) {
        return this.replace(this.doResolve(VmUtils.getOwner(frame))).executeGeneric(frame);
    }

    @CompilerDirectives.TruffleBoundary
    private ExpressionNode doResolve(VmObjectLike initialOwner) {
        VmTyped baseModule;
        ClassMethod method;
        int levelsUp = 0;
        Identifier localMethodName = this.methodName.toLocalMethod();
        for (VmObjectLike currOwner = initialOwner; currOwner != null; currOwner = currOwner.getEnclosingOwner()) {
            if (currOwner.isPrototype()) {
                localMethod = currOwner.getVmClass().getDeclaredMethod(localMethodName);
                if (localMethod != null) {
                    assert (localMethod.isLocal());
                    this.checkConst(currOwner, localMethod, levelsUp);
                    return new InvokeMethodLexicalNode(this.sourceSection, ((ClassMethod)localMethod).getCallTarget(this.sourceSection), levelsUp, this.argumentNodes, this.isInIterable);
                }
                ClassMethod method2 = currOwner.getVmClass().getDeclaredMethod(this.methodName);
                if (method2 != null) {
                    assert (!method2.isLocal());
                    this.checkConst(currOwner, method2, levelsUp);
                    if (method2.getDeclaringClass().isClosed()) {
                        return new InvokeMethodLexicalNode(this.sourceSection, method2.getCallTarget(this.sourceSection), levelsUp, this.argumentNodes, this.isInIterable);
                    }
                    return InvokeMethodVirtualNodeGen.create(this.sourceSection, this.methodName, this.argumentNodes, MemberLookupMode.IMPLICIT_LEXICAL, this.isInIterable, levelsUp == 0 ? new GetReceiverNode() : new GetEnclosingReceiverNode(levelsUp), GetClassNodeGen.create(null));
                }
            } else {
                localMethod = currOwner.getMember(localMethodName);
                if (localMethod != null) {
                    assert (localMethod.isLocal());
                    this.checkConst(currOwner, localMethod, levelsUp);
                    CallTarget methodCallTarget = (CallTarget)((ObjectMember)localMethod).getCallTarget().call(currOwner, currOwner);
                    return new InvokeMethodLexicalNode(this.sourceSection, methodCallTarget, levelsUp, this.argumentNodes, this.isInIterable);
                }
            }
            ++levelsUp;
        }
        if (!this.isBaseModule && (method = (baseModule = BaseModule.getModule()).getVmClass().getDeclaredMethod(this.methodName)) != null) {
            assert (!method.isLocal());
            return new InvokeMethodDirectNode(this.sourceSection, method, new ConstantValueNode(baseModule), this.argumentNodes, this.isInIterable);
        }
        boolean needsConst = this.constLevel == ConstLevel.ALL && this.constDepth == -1 && !this.isCustomThisScope;
        return InvokeMethodVirtualNodeGen.create(this.sourceSection, this.methodName, this.argumentNodes, MemberLookupMode.IMPLICIT_THIS, needsConst, this.isInIterable, VmUtils.createThisNode(VmUtils.unavailableSourceSection(), this.isCustomThisScope), GetClassNodeGen.create(null));
    }

    private void checkConst(VmObjectLike currOwner, Member method, int levelsUp) {
        boolean invalid;
        if (!this.constLevel.isConst()) {
            return;
        }
        boolean memberIsOutsideConstScope = levelsUp > this.constDepth;
        switch (this.constLevel) {
            case ALL: {
                boolean bl;
                if (memberIsOutsideConstScope && !method.isConst()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case MODULE: {
                boolean bl;
                if (currOwner.isModuleObject() && !method.isConst()) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = invalid = false;
            }
        }
        if (invalid) {
            throw this.exceptionBuilder().evalError("methodMustBeConst", this.methodName.toString()).build();
        }
    }
}

