/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;

public final class Version
implements Comparable<Version> {
    private static final Pattern VERSION = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(?:-([^+]+))?(?:\\+(.+))?");
    private static final Pattern NUMERIC_IDENTIFIER = Pattern.compile("(0|[1-9]\\d*)");
    private static final Comparator<Version> COMPARATOR = Comparator.comparingInt(Version::getMajor).thenComparingInt(Version::getMinor).thenComparingInt(Version::getPatch).thenComparing((v1, v2) -> {
        if (v1.preRelease == null) {
            return v2.preRelease == null ? 0 : 1;
        }
        if (v2.preRelease == null) {
            return -1;
        }
        Identifier[] ids1 = v1.getPreReleaseIdentifiers();
        Identifier[] ids2 = v2.getPreReleaseIdentifiers();
        int minSize = Math.min(ids1.length, ids2.length);
        for (int i = 0; i < minSize; ++i) {
            int result = ids1[i].compareTo(ids2[i]);
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(ids1.length, ids2.length);
    });
    private final int major;
    private final int minor;
    private final int patch;
    @Nullable
    private final String preRelease;
    @Nullable
    private final String build;
    @LateInit
    private volatile Identifier[] __preReleaseIdentifiers;

    public Version(int major, int minor, int patch, @Nullable String preRelease, @Nullable String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.build = build;
    }

    public static Version parse(String version) {
        Version result = Version.parseOrNull(version);
        if (result != null) {
            return result;
        }
        if (VERSION.matcher(version).matches()) {
            throw new IllegalArgumentException(String.format("`%s` is too large to fit into a Version.", version));
        }
        throw new IllegalArgumentException(String.format("`%s` could not be parsed as a semantic version number.", version));
    }

    @Nullable
    public static Version parseOrNull(String version) {
        Matcher matcher = VERSION.matcher(version);
        if (!matcher.matches()) {
            return null;
        }
        try {
            return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), matcher.group(4), matcher.group(5));
        }
        catch (NumberFormatException e2) {
            return null;
        }
    }

    public static Comparator<Version> comparator() {
        return COMPARATOR;
    }

    public int getMajor() {
        return this.major;
    }

    public Version withMajor(int major) {
        return new Version(major, this.minor, this.patch, this.preRelease, this.build);
    }

    public int getMinor() {
        return this.minor;
    }

    public Version withMinor(int minor) {
        return new Version(this.major, minor, this.patch, this.preRelease, this.build);
    }

    public int getPatch() {
        return this.patch;
    }

    public Version withPatch(int patch) {
        return new Version(this.major, this.minor, patch, this.preRelease, this.build);
    }

    @Nullable
    public String getPreRelease() {
        return this.preRelease;
    }

    public Version withPreRelease(@Nullable String preRelease) {
        return new Version(this.major, this.minor, this.patch, preRelease, this.build);
    }

    @Nullable
    public String getBuild() {
        return this.build;
    }

    public Version withBuild(@Nullable String build) {
        return new Version(this.major, this.minor, this.patch, this.preRelease, build);
    }

    public boolean isNormal() {
        return this.preRelease == null && this.build == null;
    }

    public boolean isStable() {
        return this.major != 0 && this.preRelease == null;
    }

    public Version toNormal() {
        return this.preRelease == null && this.build == null ? this : new Version(this.major, this.minor, this.patch, null, null);
    }

    @Override
    public int compareTo(Version other) {
        return COMPARATOR.compare(this, other);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch && Objects.equals(this.preRelease, other.preRelease);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.preRelease);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (String)(this.preRelease != null ? "-" + this.preRelease : "") + (String)(this.build != null ? "+" + this.build : "");
    }

    private Identifier[] getPreReleaseIdentifiers() {
        if (this.__preReleaseIdentifiers == null) {
            this.__preReleaseIdentifiers = this.preRelease == null ? new Identifier[]{} : (Identifier[])Arrays.stream(this.preRelease.split("\\.")).map(str -> NUMERIC_IDENTIFIER.matcher((CharSequence)str).matches() ? new Identifier(Long.parseLong(str), null) : new Identifier(-1L, (String)str)).toArray(Identifier[]::new);
        }
        return this.__preReleaseIdentifiers;
    }

    private static final class Identifier
    implements Comparable<Identifier> {
        private final long numericId;
        @Nullable
        private final String alphanumericId;

        Identifier(long numericId, @Nullable String alphanumericId) {
            this.numericId = numericId;
            this.alphanumericId = alphanumericId;
        }

        @Override
        public int compareTo(Identifier other) {
            return this.alphanumericId != null ? (other.alphanumericId != null ? this.alphanumericId.compareTo(other.alphanumericId) : 1) : (other.alphanumericId != null ? -1 : Long.compare(this.numericId, other.numericId));
        }
    }
}

