/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PModule;
import org.pkl.core.PObject;
import org.pkl.core.Pair;
import org.pkl.core.TypeAlias;
import org.pkl.core.Value;
import org.pkl.core.util.Nullable;

public interface ValueVisitor {
    default public void visitDefault(@Nullable Object value2) {
    }

    default public void visitNull() {
        this.visitDefault(null);
    }

    default public void visitString(String value2) {
        this.visitDefault(value2);
    }

    default public void visitBoolean(Boolean value2) {
        this.visitDefault(value2);
    }

    default public void visitInt(Long value2) {
        this.visitDefault(value2);
    }

    default public void visitFloat(Double value2) {
        this.visitDefault(value2);
    }

    default public void visitDuration(Duration value2) {
        this.visitDefault(value2);
    }

    default public void visitDataSize(DataSize value2) {
        this.visitDefault(value2);
    }

    default public void visitPair(Pair<?, ?> value2) {
        this.visitDefault(value2);
    }

    default public void visitList(List<?> value2) {
        this.visitDefault(value2);
    }

    default public void visitSet(Set<?> value2) {
        this.visitDefault(value2);
    }

    default public void visitMap(Map<?, ?> value2) {
        this.visitDefault(value2);
    }

    default public void visitObject(PObject value2) {
        this.visitDefault(value2);
    }

    default public void visitModule(PModule value2) {
        this.visitDefault(value2);
    }

    default public void visitClass(PClass value2) {
        this.visitDefault(value2);
    }

    default public void visitTypeAlias(TypeAlias value2) {
        this.visitDefault(value2);
    }

    default public void visitRegex(Pattern value2) {
        this.visitDefault(value2);
    }

    default public void visit(Object value2) {
        if (value2 instanceof Value) {
            Value v = (Value)value2;
            v.accept(this);
        } else if (value2 instanceof String) {
            String string = (String)value2;
            this.visitString(string);
        } else if (value2 instanceof Boolean) {
            Boolean b2 = (Boolean)value2;
            this.visitBoolean(b2);
        } else if (value2 instanceof Long) {
            Long l = (Long)value2;
            this.visitInt(l);
        } else if (value2 instanceof Double) {
            Double d2 = (Double)value2;
            this.visitFloat(d2);
        } else if (value2 instanceof List) {
            List list = (List)value2;
            this.visitList(list);
        } else if (value2 instanceof Set) {
            Set set = (Set)value2;
            this.visitSet(set);
        } else if (value2 instanceof Map) {
            Map map2 = (Map)value2;
            this.visitMap(map2);
        } else if (value2 instanceof Pattern) {
            Pattern pattern2 = (Pattern)value2;
            this.visitRegex(pattern2);
        } else {
            throw new IllegalArgumentException("Cannot visit value with unexpected type: " + value2);
        }
    }
}

