/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.pkl.core.DataSize;
import org.pkl.core.Duration;
import org.pkl.core.PClass;
import org.pkl.core.PModule;
import org.pkl.core.PObject;
import org.pkl.core.Pair;
import org.pkl.core.TypeAlias;
import org.pkl.core.Value;

public interface ValueConverter<T> {
    public T convertNull();

    public T convertString(String var1);

    public T convertBoolean(Boolean var1);

    public T convertInt(Long var1);

    public T convertFloat(Double var1);

    public T convertDuration(Duration var1);

    public T convertDataSize(DataSize var1);

    public T convertPair(Pair<?, ?> var1);

    public T convertList(List<?> var1);

    public T convertSet(Set<?> var1);

    public T convertMap(Map<?, ?> var1);

    public T convertObject(PObject var1);

    public T convertModule(PModule var1);

    public T convertClass(PClass var1);

    public T convertTypeAlias(TypeAlias var1);

    public T convertRegex(Pattern var1);

    default public T convert(Object value2) {
        if (value2 instanceof Value) {
            Value v = (Value)value2;
            return v.accept(this);
        }
        if (value2 instanceof String) {
            String string = (String)value2;
            return this.convertString(string);
        }
        if (value2 instanceof Boolean) {
            Boolean b2 = (Boolean)value2;
            return this.convertBoolean(b2);
        }
        if (value2 instanceof Long) {
            Long l = (Long)value2;
            return this.convertInt(l);
        }
        if (value2 instanceof Double) {
            Double d2 = (Double)value2;
            return this.convertFloat(d2);
        }
        if (value2 instanceof List) {
            List list = (List)value2;
            return this.convertList(list);
        }
        if (value2 instanceof Set) {
            Set set = (Set)value2;
            return this.convertSet(set);
        }
        if (value2 instanceof Map) {
            Map map2 = (Map)value2;
            return this.convertMap(map2);
        }
        if (value2 instanceof Pattern) {
            Pattern pattern2 = (Pattern)value2;
            return this.convertRegex(pattern2);
        }
        throw new IllegalArgumentException("Cannot convert value with unexpected type: " + value2);
    }
}

