/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.util.ArrayList;
import java.util.List;
import org.pkl.core.PklException;
import org.pkl.core.util.Nullable;

public record TestResults(String moduleName, String displayUri, TestSectionResults facts, TestSectionResults examples, String logs, @Nullable Error error) {
    public int totalTests() {
        return this.facts.totalTests() + this.examples.totalTests();
    }

    public int totalFailures() {
        return this.facts.totalFailures() + this.examples.totalFailures();
    }

    public int totalAsserts() {
        return this.facts.totalAsserts() + this.examples.totalAsserts();
    }

    public int totalAssertsFailed() {
        return this.facts.totalAssertsFailedOrErrored() + this.examples.totalAssertsFailedOrErrored();
    }

    public boolean failed() {
        return this.error != null || this.facts.failed() || this.examples.failed();
    }

    public boolean isExampleWrittenFailure() {
        if (!this.failed() || this.facts.failed() || !this.examples.failed()) {
            return false;
        }
        for (TestResult testResult : this.examples.results) {
            if (testResult.isExampleWritten) continue;
            return false;
        }
        return true;
    }

    public record TestSectionResults(TestSectionName name, List<TestResult> results) {
        public int totalTests() {
            return this.results.size();
        }

        public int totalAsserts() {
            int total = 0;
            for (TestResult res : this.results) {
                total += res.totalAsserts();
            }
            return total;
        }

        public int totalAssertsFailedOrErrored() {
            int total = 0;
            for (TestResult res : this.results) {
                total += res.totalAssertsFailedOrErrored();
            }
            return total;
        }

        public int totalFailures() {
            int total = 0;
            for (TestResult res : this.results) {
                if (!res.isFailure()) continue;
                ++total;
            }
            return total;
        }

        public boolean failed() {
            for (TestResult res : this.results) {
                if (!res.isFailure()) continue;
                return true;
            }
            return false;
        }

        public boolean hasError() {
            for (TestResult res : this.results) {
                if (!res.hasErrors()) continue;
                return true;
            }
            return false;
        }
    }

    public record Error(String message, PklException exception) {
    }

    public record TestResult(String name, int totalAsserts, List<Failure> failures, List<Error> errors, boolean isExampleWritten) {
        public int totalAssertsFailedOrErrored() {
            return this.failures().size() + this.errors.size();
        }

        public boolean isFailure() {
            return this.totalAssertsFailedOrErrored() > 0;
        }

        public boolean hasErrors() {
            return !this.errors().isEmpty();
        }

        public boolean hasFailures() {
            return !this.failures.isEmpty();
        }

        public static class Builder {
            private final String name;
            private final List<Failure> failures = new ArrayList<Failure>();
            private final List<Error> errors = new ArrayList<Error>();
            private boolean isExampleWritten;
            private int count = 0;

            public Builder(String name) {
                this.name = name;
            }

            public Builder addSuccess() {
                ++this.count;
                return this;
            }

            public int getCount() {
                return this.count;
            }

            public Builder addFailure(Failure failure) {
                this.failures.add(failure);
                ++this.count;
                return this;
            }

            public Builder addError(Error error) {
                this.errors.add(error);
                ++this.count;
                return this;
            }

            public Builder setExampleWritten(boolean exampleWritten) {
                this.isExampleWritten = exampleWritten;
                return this;
            }

            public TestResult build() {
                return new TestResult(this.name, this.count, this.failures, this.errors, this.isExampleWritten);
            }
        }
    }

    public record Failure(String kind, String message) {
    }

    public static enum TestSectionName {
        FACTS("facts"),
        EXAMPLES("examples");

        private final String name;

        private TestSectionName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Builder {
        private final String moduleName;
        private final String displayUri;
        private TestSectionResults factsSection = new TestSectionResults(TestSectionName.FACTS, List.of());
        private TestSectionResults examplesSection = new TestSectionResults(TestSectionName.EXAMPLES, List.of());
        private String stdErr = "";
        @Nullable
        private Error error = null;

        public Builder(String moduleName, String displayUri) {
            this.moduleName = moduleName;
            this.displayUri = displayUri;
        }

        public Builder setError(Error error) {
            this.error = error;
            return this;
        }

        public Builder setStdErr(String stdErr) {
            this.stdErr = stdErr;
            return this;
        }

        public Builder setFactsSection(TestSectionResults factsSection) {
            assert (factsSection.name() == TestSectionName.FACTS);
            this.factsSection = factsSection;
            return this;
        }

        public Builder setExamplesSection(TestSectionResults examplesSection) {
            assert (examplesSection.name() == TestSectionName.EXAMPLES);
            this.examplesSection = examplesSection;
            return this;
        }

        public TestResults build() {
            return new TestResults(this.moduleName, this.displayUri, this.factsSection, this.examplesSection, this.stdErr, this.error);
        }
    }
}

