/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.pkl.core.util.json.Json;

public record ImportGraph(Map<URI, Set<Import>> imports, Map<URI, URI> resolvedImports) {
    public static ImportGraph parseFromJson(String input) throws Json.JsonParseException {
        Json.JsObject parsed = Json.parseObject(input);
        Map<URI, Set<Import>> imports = ImportGraph.parseImports(parsed.getObject("imports"));
        Map<URI, URI> resolvedImports = ImportGraph.parseResolvedImports(parsed.getObject("resolvedImports"));
        return new ImportGraph(imports, resolvedImports);
    }

    private static Map<URI, Set<Import>> parseImports(Json.JsObject jsObject) throws Json.JsonParseException {
        TreeMap<URI, Set<Import>> ret = new TreeMap<URI, Set<Import>>();
        for (Map.Entry<String, Object> entry : jsObject.entrySet()) {
            try {
                URI key2 = new URI(entry.getKey());
                Object value2 = entry.getValue();
                TreeSet<Import> set = new TreeSet<Import>();
                if (!(value2 instanceof Json.JsArray)) {
                    throw new Json.FormatException("array", value2.getClass());
                }
                Json.JsArray array = (Json.JsArray)value2;
                for (Object elem : array) {
                    if (!(elem instanceof Json.JsObject)) {
                        throw new Json.FormatException("object", elem.getClass());
                    }
                    Json.JsObject importObj = (Json.JsObject)elem;
                    set.add(ImportGraph.parseImport(importObj));
                }
                ret.put(key2, set);
            }
            catch (URISyntaxException e2) {
                throw new Json.MappingException(entry.getKey(), e2);
            }
        }
        return ret;
    }

    private static Import parseImport(Json.JsObject jsObject) throws Json.JsonParseException {
        URI uri = jsObject.getURI("uri");
        return new Import(uri);
    }

    private static Map<URI, URI> parseResolvedImports(Json.JsObject jsObject) throws Json.JsonParseException {
        TreeMap<URI, URI> ret = new TreeMap<URI, URI>();
        for (Map.Entry<String, Object> entry : jsObject.entrySet()) {
            try {
                URI key2 = new URI(entry.getKey());
                Object value2 = entry.getValue();
                if (!(value2 instanceof String)) {
                    throw new Json.FormatException("string", value2.getClass());
                }
                String str = (String)value2;
                URI valueUri = new URI(str);
                ret.put(key2, valueUri);
            }
            catch (URISyntaxException e2) {
                throw new Json.MappingException(entry.getKey(), e2);
            }
        }
        return ret;
    }

    public record Import(URI uri) implements Comparable<Import>
    {
        @Override
        public int compareTo(Import o) {
            return this.uri.compareTo(o.uri());
        }
    }
}

