/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.graalvm.polyglot.Context;
import org.pkl.core.ImportGraph;
import org.pkl.core.Loggers;
import org.pkl.core.PklBugException;
import org.pkl.core.PklException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.StackFrameTransformer;
import org.pkl.core.http.HttpClient;
import org.pkl.core.http.HttpClientInitException;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ProjectDependenciesManager;
import org.pkl.core.packages.PackageLoadError;
import org.pkl.core.packages.PackageResolver;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.ResourceManager;
import org.pkl.core.runtime.VmContext;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmImportAnalyzer;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;

public class Analyzer {
    private final StackFrameTransformer transformer;
    private final boolean color;
    private final SecurityManager securityManager;
    @Nullable
    private final Path moduleCacheDir;
    @Nullable
    private final DeclaredDependencies projectDependencies;
    private final ModuleResolver moduleResolver;
    private final HttpClient httpClient;

    public Analyzer(StackFrameTransformer transformer, boolean color, SecurityManager securityManager2, Collection<ModuleKeyFactory> moduleKeyFactories, @Nullable Path moduleCacheDir2, @Nullable DeclaredDependencies projectDependencies, HttpClient httpClient2) {
        this.transformer = transformer;
        this.color = color;
        this.securityManager = securityManager2;
        this.moduleCacheDir = moduleCacheDir2;
        this.projectDependencies = projectDependencies;
        this.moduleResolver = new ModuleResolver(moduleKeyFactories);
        this.httpClient = httpClient2;
    }

    public ImportGraph importGraph(URI ... sources) {
        Context context2 = this.createContext();
        try {
            context2.enter();
            VmContext vmContext = VmContext.get(null);
            ImportGraph importGraph2 = VmImportAnalyzer.analyze(sources, vmContext);
            return importGraph2;
        }
        catch (IOException | URISyntaxException | SecurityManagerException | HttpClientInitException | PackageLoadError e2) {
            throw new PklException(e2.getMessage(), e2);
        }
        catch (PklException err) {
            throw err;
        }
        catch (VmException err) {
            throw err.toPklException(this.transformer, this.color);
        }
        catch (Exception e3) {
            throw new PklBugException(e3);
        }
        finally {
            context2.leave();
            context2.close();
        }
    }

    private Context createContext() {
        PackageResolver packageResolver = PackageResolver.getInstance(this.securityManager, HttpClient.builder().buildLazily(), this.moduleCacheDir);
        return VmUtils.createContext(() -> {
            VmContext vmContext = VmContext.get(null);
            vmContext.initialize(new VmContext.Holder(this.transformer, this.securityManager, this.httpClient, this.moduleResolver, new ResourceManager(this.securityManager, List.of()), Loggers.stdErr(), Map.of(), Map.of(), this.moduleCacheDir, null, packageResolver, this.projectDependencies == null ? null : new ProjectDependenciesManager(this.projectDependencies, this.moduleResolver, this.securityManager)));
        });
    }
}

