/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.cli.repl;

import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.pkl.core.Release;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/pkl/cli/repl/ReplMessages;", "", "()V", "examples", "", "getExamples", "()Ljava/lang/String;", "help", "getHelp", "welcome", "getWelcome", "isMacOs", "", "pkl-cli"})
public final class ReplMessages {
    @NotNull
    public static final ReplMessages INSTANCE = new ReplMessages();
    @NotNull
    private static final String welcome = StringsKt.trimIndent("\n    Welcome to Pkl " + Release.current().version() + ".\n    Type an expression to have it evaluated.\n    Type `:help` or `:examples` for more information.\n  ");
    @NotNull
    private static final String help = "`<expr>`           Evaluate <expr> and print the result. `1 + 3`\n`<name> = <expr>`  Evaluate <expr> and assign the result to property <name>. `msg = \"howdy\"`\n`:clear`           Clear the screen.\n`:examples`        Show code examples (use copy and paste to run them).\n`:force <expr>`    Force eager evaluation of a value.\n`:help`            Show this help.\n`:load <file>`     Load <file> from local file system. `:load path/to/config.pkl`\n`:quit`            Quit this program.\n`:reset`           Reset the environment to its initial state.\n\nTips:\n* Commands can be abbreviated. `:h`\n* Commands can be completed. `:<TAB>`\n* File paths can be completed. `:load <TAB>`\n* Expressions can be completed. `\"hello\".re<TAB>`\n* Multiple declarations and expressions can be evaluated at once. `a = 1; b = a + 2`\n* Incomplete input will be continued on the next line.\n* Multi-line programs can be copy-pasted into the REPL.\n";
    @NotNull
    private static final String examples = StringsKt.trimIndent("\n    Expressions:\n    `2 + 3 * 4`\n\n    Strings:\n    `\"Hello, \" + \"World!\"`\n\n    Properties:\n    `timeout = 5.min; timeout`\n\n    Objects:\n    ```pigeon {\n      name = \"Pigeon\"\n      fullName = \"\\(name) Bird\"\n      age = 42\n      address {\n        street = \"Landers St.\"\n      }\n    }\n    pigeon.fullName\n    \n    hobbies {\n      \"Swimming\"\n      \"Dancing\"\n      \"Surfing\"\n    }\n    hobbies[1]\n    \n    prices {\n      [\"Apple\"] = 1.5\n      [\"Orange\"] = 5\n      [\"Banana\"] = 2\n    }\n    prices[\"Banana\"]```\n    \n    Inheritance:\n    ```parrot = (pigeon) {\n      name = \"Parrot\"\n      age = 41\n    }\n    :force parrot```\n\n    For more examples, see the Language Reference" + (INSTANCE.isMacOs() ? " (Command+Double-click the link below)" : "") + ":\n\n    " + Release.current().documentation().homepage() + "language-reference/\n\n  ");

    private ReplMessages() {
    }

    @NotNull
    public final String getWelcome() {
        return welcome;
    }

    @NotNull
    public final String getHelp() {
        return help;
    }

    @NotNull
    public final String getExamples() {
        return examples;
    }

    private final boolean isMacOs() {
        return StringsKt.equals(System.getProperty("os.name"), "Mac OS X", true);
    }
}

