/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.cli;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.pkl.cli.CliProjectCommand;
import org.pkl.cli.CliTestRunner;
import org.pkl.commons.cli.CliBaseOptions;
import org.pkl.commons.cli.CliException;
import org.pkl.commons.cli.CliTestException;
import org.pkl.commons.cli.CliTestOptions;
import org.pkl.core.evaluatorSettings.Color;
import org.pkl.core.project.DeclaredDependencies;
import org.pkl.core.project.Package;
import org.pkl.core.project.Project;
import org.pkl.core.project.ProjectPackager;
import org.pkl.core.util.ErrorMessages;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/pkl/cli/CliProjectPackager;", "Lorg/pkl/cli/CliProjectCommand;", "baseOptions", "Lorg/pkl/commons/cli/CliBaseOptions;", "projectDirs", "", "Ljava/nio/file/Path;", "testOptions", "Lorg/pkl/commons/cli/CliTestOptions;", "outputPath", "", "skipPublishCheck", "", "consoleWriter", "Ljava/io/Writer;", "errWriter", "(Lorg/pkl/commons/cli/CliBaseOptions;Ljava/util/List;Lorg/pkl/commons/cli/CliTestOptions;Ljava/lang/String;ZLjava/io/Writer;Ljava/io/Writer;)V", "doRun", "", "runApiTests", "project", "Lorg/pkl/core/project/Project;", "pkl-cli"})
public final class CliProjectPackager
extends CliProjectCommand {
    @NotNull
    private final CliTestOptions testOptions;
    @NotNull
    private final String outputPath;
    private final boolean skipPublishCheck;
    @NotNull
    private final Writer consoleWriter;
    @NotNull
    private final Writer errWriter;

    public CliProjectPackager(@NotNull CliBaseOptions baseOptions, @NotNull List<? extends Path> projectDirs, @NotNull CliTestOptions testOptions, @NotNull String outputPath, boolean skipPublishCheck, @NotNull Writer consoleWriter, @NotNull Writer errWriter) {
        Intrinsics.checkNotNullParameter(baseOptions, "baseOptions");
        Intrinsics.checkNotNullParameter(projectDirs, "projectDirs");
        Intrinsics.checkNotNullParameter(testOptions, "testOptions");
        Intrinsics.checkNotNullParameter(outputPath, "outputPath");
        Intrinsics.checkNotNullParameter(consoleWriter, "consoleWriter");
        Intrinsics.checkNotNullParameter(errWriter, "errWriter");
        super(baseOptions, projectDirs);
        this.testOptions = testOptions;
        this.outputPath = outputPath;
        this.skipPublishCheck = skipPublishCheck;
        this.consoleWriter = consoleWriter;
        this.errWriter = errWriter;
    }

    public /* synthetic */ CliProjectPackager(CliBaseOptions cliBaseOptions, List list, CliTestOptions cliTestOptions2, String string, boolean bl, Writer writer, Writer writer2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Charset charset;
        OutputStream outputStream2;
        if ((n & 0x20) != 0) {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            outputStream2 = printStream;
            charset = Charsets.UTF_8;
            writer = new OutputStreamWriter(outputStream2, charset);
        }
        if ((n & 0x40) != 0) {
            PrintStream printStream = System.err;
            Intrinsics.checkNotNullExpressionValue(printStream, "err");
            outputStream2 = printStream;
            charset = Charsets.UTF_8;
            writer2 = new OutputStreamWriter(outputStream2, charset);
        }
        this(cliBaseOptions, list, cliTestOptions2, string, bl, writer, writer2);
    }

    /*
     * WARNING - void declaration
     */
    private final void runApiTests(Project project2) {
        void $this$mapTo$iv$iv;
        Package package_ = project2.getPackage();
        Intrinsics.checkNotNull(package_);
        List<Path> list = package_.getApiTests();
        Intrinsics.checkNotNullExpressionValue(list, "project.`package`!!.apiTests");
        List<Path> apiTests = list;
        if (apiTests.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = apiTests;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(project2.getProjectDir().resolve((Path)it).toUri());
        }
        List normalizeApiTests = (List)destination$iv$iv;
        CliTestRunner testRunner = new CliTestRunner(CliBaseOptions.copy$default(this.getCliOptions(), normalizeApiTests, null, null, null, null, null, null, null, null, project2.getProjectDir(), null, null, null, false, false, false, false, 0, null, null, null, null, null, 8388094, null), this.testOptions, this.consoleWriter, this.errWriter);
        try {
            testRunner.run();
        }
        catch (CliTestException e2) {
            Object[] objectArray = new Object[1];
            Package package_2 = project2.getPackage();
            Intrinsics.checkNotNull(package_2);
            objectArray[0] = package_2.getUri();
            String string = ErrorMessages.create("packageTestsFailed", objectArray);
            Intrinsics.checkNotNullExpressionValue(string, "create(\"packageTestsFail\u2026 project.`package`!!.uri)");
            throw new CliException(string, 0, 2, null);
        }
    }

    @Override
    protected void doRun() {
        List<Project> list;
        List<Project> $this$doRun_u24lambda_u2d1 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Path projectFile : this.getNormalizedProjectFiles()) {
            Project project2 = this.loadProject(projectFile);
            if (project2.getPackage() == null) {
                Object[] objectArray = new Object[]{project2.getProjectFileUri()};
                String string = ErrorMessages.create("noPackageDefinedByProject", objectArray);
                Intrinsics.checkNotNullExpressionValue(string, "create(\"noPackageDefined\u2026, project.projectFileUri)");
                throw new CliException(string, 0, 2, null);
            }
            this.runApiTests(project2);
            $this$doRun_u24lambda_u2d1.add(project2);
        }
        List<Project> projects = CollectionsKt.build(list);
        Iterable $this$forEach$iv = projects;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project proj = (Project)element$iv;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = proj.getDependencies().getLocalDependencies().values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                boolean bl3;
                Path projectDir;
                block7: {
                    DeclaredDependencies localDep = (DeclaredDependencies)element$iv2;
                    boolean bl4 = false;
                    projectDir = Path.of(localDep.getProjectFileUri()).getParent();
                    Iterable $this$none$iv = projects;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv3 : $this$none$iv) {
                            Project it = (Project)element$iv3;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual(it.getProjectDir(), projectDir)) continue;
                            bl3 = false;
                            break block7;
                        }
                        bl3 = true;
                    }
                }
                if (!bl3) continue;
                Object[] objectArray = new Object[]{proj.getProjectDir(), projectDir};
                String string = ErrorMessages.create("missingProjectInPackageCommand", objectArray);
                Intrinsics.checkNotNullExpressionValue(string, "create(\"missingProjectIn\u2026j.projectDir, projectDir)");
                throw new CliException(string, 0, 2, null);
            }
        }
        Color color = this.getCliOptions().getColor();
        new ProjectPackager(projects, this.getCliOptions().getNormalizedWorkingDir(), this.outputPath, this.getStackFrameTransformer(), color != null ? color.hasColor() : false, this.getSecurityManager(), this.getHttpClient(), this.skipPublishCheck, this.consoleWriter).createPackages();
    }
}

