/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.cli;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.pkl.cli.CliImportAnalyzerOptions;
import org.pkl.commons.PathsKt;
import org.pkl.commons.cli.CliCommand;
import org.pkl.core.Closeables;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.ModuleSource;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/pkl/cli/CliImportAnalyzer;", "Lorg/pkl/commons/cli/CliCommand;", "options", "Lorg/pkl/cli/CliImportAnalyzerOptions;", "consoleWriter", "Ljava/io/Writer;", "(Lorg/pkl/cli/CliImportAnalyzerOptions;Ljava/io/Writer;)V", "sourceModule", "Lorg/pkl/core/ModuleSource;", "doRun", "", "render", "", "pkl-cli"})
public final class CliImportAnalyzer
extends CliCommand {
    @NotNull
    private final CliImportAnalyzerOptions options;
    @NotNull
    private final Writer consoleWriter;
    @NotNull
    private final ModuleSource sourceModule;

    @JvmOverloads
    public CliImportAnalyzer(@NotNull CliImportAnalyzerOptions options, @NotNull Writer consoleWriter) {
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(consoleWriter, "consoleWriter");
        super(options.getBase());
        this.options = options;
        this.consoleWriter = consoleWriter;
        ModuleSource moduleSource = ModuleSource.text("import \"pkl:analyze\"\n\nlocal importStrings = read*(\"prop:pkl.analyzeImports.**\").toMap().values.toSet()\n\noutput {\n  value = analyze.importGraph(importStrings)\n  renderer {\n    converters {\n      [Map] = (it) -> it.toMapping()\n      [Set] = (it) -> it.toListing()\n    }\n  }\n}");
        Intrinsics.checkNotNullExpressionValue(moduleSource, "text(\n      \"\"\"\n        \u2026      .trimIndent()\n    )");
        this.sourceModule = moduleSource;
    }

    public /* synthetic */ CliImportAnalyzer(CliImportAnalyzerOptions cliImportAnalyzerOptions, Writer writer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            OutputStream outputStream2 = printStream;
            Charset charset = Charsets.UTF_8;
            writer = new OutputStreamWriter(outputStream2, charset);
        }
        this(cliImportAnalyzerOptions, writer);
    }

    @Override
    protected void doRun() {
        String rendered = this.render();
        if (this.options.getOutputPath() != null) {
            PathsKt.createParentDirectories(this.options.getOutputPath(), new FileAttribute[0]);
            PathsKt.writeString$default(this.options.getOutputPath(), rendered, null, new OpenOption[0], 2, null);
        } else {
            this.consoleWriter.write(rendered);
            this.consoleWriter.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String render() {
        EvaluatorBuilder evaluatorBuilder = this.evaluatorBuilder().setOutputFormat(this.options.getOutputFormat());
        Intrinsics.checkNotNullExpressionValue(evaluatorBuilder, "evaluatorBuilder().setOu\u2026mat(options.outputFormat)");
        EvaluatorBuilder builder = evaluatorBuilder;
        try {
            String string;
            Object object = builder;
            EvaluatorBuilder $this$render_u24lambda_u2d0 = object;
            boolean bl = false;
            Iterator<URI> iterator2 = this.options.getBase().getNormalizedSourceModules().iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int idx = n++;
                URI sourceModule = iterator2.next();
                $this$render_u24lambda_u2d0.addExternalProperty("pkl.analyzeImports." + idx, sourceModule.toString());
            }
            object = ((EvaluatorBuilder)object).build();
            Throwable throwable = null;
            try {
                Evaluator it = (Evaluator)object;
                boolean bl2 = false;
                String string2 = it.evaluateOutputText(this.sourceModule);
                string = string2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object, throwable);
            }
            Intrinsics.checkNotNullExpressionValue(string, "builder\n        .apply {\u2026utputText(sourceModule) }");
            String string3 = string;
            return string3;
        }
        finally {
            Closeables.closeQuietly((Iterable<? extends AutoCloseable>)builder.getModuleKeyFactories());
            Closeables.closeQuietly((Iterable<? extends AutoCloseable>)builder.getResourceReaders());
        }
    }

    @JvmOverloads
    public CliImportAnalyzer(@NotNull CliImportAnalyzerOptions options) {
        Intrinsics.checkNotNullParameter(options, "options");
        this(options, null, 2, null);
    }
}

