/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.cli;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pkl.cli.CliEvaluatorOptions;
import org.pkl.cli.OutputFile;
import org.pkl.commons.PathsKt;
import org.pkl.commons.cli.CliCommand;
import org.pkl.commons.cli.CliException;
import org.pkl.core.Closeables;
import org.pkl.core.Evaluator;
import org.pkl.core.EvaluatorBuilder;
import org.pkl.core.FileOutput;
import org.pkl.core.ModuleSource;
import org.pkl.core.PklException;
import org.pkl.core.evaluatorSettings.Color;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.ModuleKeyFactory;
import org.pkl.core.module.ModulePathResolver;
import org.pkl.core.runtime.ModuleResolver;
import org.pkl.core.runtime.VmException;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.IoUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020!H\u0014J\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010&\u001a\u00020#H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR)\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00158FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0010\u0012\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR)\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00158FX\u0086\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0010\u0012\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u001a\u00a8\u0006/"}, d2={"Lorg/pkl/cli/CliEvaluator;", "Lorg/pkl/commons/cli/CliCommand;", "options", "Lorg/pkl/cli/CliEvaluatorOptions;", "consoleReader", "Ljava/io/Reader;", "consoleWriter", "Ljava/io/Writer;", "(Lorg/pkl/cli/CliEvaluatorOptions;Ljava/io/Reader;Ljava/io/Writer;)V", "directoryOutputPaths", "", "Ljava/net/URI;", "Ljava/nio/file/Path;", "getDirectoryOutputPaths", "()Ljava/util/Map;", "directoryOutputPaths$delegate", "Lkotlin/Lazy;", "fileOutputPaths", "getFileOutputPaths", "fileOutputPaths$delegate", "outputDirectories", "", "Ljava/io/File;", "getOutputDirectories$annotations", "()V", "getOutputDirectories", "()Ljava/util/Set;", "outputDirectories$delegate", "outputFiles", "getOutputFiles$annotations", "getOutputFiles", "outputFiles$delegate", "checkPathSpec", "", "pathSpec", "", "doRun", "resolveOutputPaths", "pathStr", "toModuleSource", "Lorg/pkl/core/ModuleSource;", "uri", "reader", "writeMultipleFileOutput", "builder", "Lorg/pkl/core/EvaluatorBuilder;", "writeOutput", "pkl-cli"})
public final class CliEvaluator
extends CliCommand {
    @NotNull
    private final CliEvaluatorOptions options;
    @NotNull
    private final Reader consoleReader;
    @NotNull
    private final Writer consoleWriter;
    @NotNull
    private final Lazy outputFiles$delegate;
    @NotNull
    private final Lazy outputDirectories$delegate;
    @NotNull
    private final Lazy fileOutputPaths$delegate;
    @NotNull
    private final Lazy directoryOutputPaths$delegate;

    @JvmOverloads
    public CliEvaluator(@NotNull CliEvaluatorOptions options, @NotNull Reader consoleReader, @NotNull Writer consoleWriter) {
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(consoleReader, "consoleReader");
        Intrinsics.checkNotNullParameter(consoleWriter, "consoleWriter");
        super(options.getBase());
        this.options = options;
        this.consoleReader = consoleReader;
        this.consoleWriter = consoleWriter;
        this.outputFiles$delegate = LazyKt.lazy((Function0)new Function0<Set<File>>(this){
            final /* synthetic */ CliEvaluator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Set<File> invoke() {
                Set set;
                Map<URI, Path> map2 = this.this$0.getFileOutputPaths();
                if (map2 != null && (map2 = map2.values()) != null) {
                    void var2_2;
                    void $this$mapTo$iv;
                    Iterable iterable = (Iterable)((Object)map2);
                    Collection destination$iv = new LinkedHashSet<E>();
                    boolean $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        void p0;
                        Path path2 = (Path)item$iv;
                        Collection collection = destination$iv;
                        boolean bl = false;
                        collection.add(p0.toFile());
                    }
                    set = (Set)var2_2;
                } else {
                    set = null;
                }
                return set;
            }
        });
        this.outputDirectories$delegate = LazyKt.lazy((Function0)new Function0<Set<File>>(this){
            final /* synthetic */ CliEvaluator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Set<File> invoke() {
                Set set;
                Object object = CliEvaluator.access$getDirectoryOutputPaths(this.this$0);
                if (object != null && (object = object.values()) != null) {
                    void var2_2;
                    void $this$mapTo$iv;
                    Iterable iterable = (Iterable)object;
                    Collection destination$iv = new LinkedHashSet<E>();
                    boolean $i$f$mapTo = false;
                    for (T item$iv : $this$mapTo$iv) {
                        void p0;
                        Path path2 = (Path)item$iv;
                        Collection collection = destination$iv;
                        boolean bl = false;
                        collection.add(p0.toFile());
                    }
                    set = (Set)var2_2;
                } else {
                    set = null;
                }
                return set;
            }
        });
        this.fileOutputPaths$delegate = LazyKt.lazy((Function0)new Function0<Map<URI, ? extends Path>>(this){
            final /* synthetic */ CliEvaluator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Map<URI, Path> invoke() {
                Map map2;
                if (CliEvaluator.access$getOptions$p(this.this$0).getMultipleFileOutputPath() != null) {
                    return null;
                }
                String string = CliEvaluator.access$getOptions$p(this.this$0).getOutputPath();
                if (string != null) {
                    String string2 = string;
                    CliEvaluator cliEvaluator = this.this$0;
                    String it = string2;
                    boolean bl = false;
                    map2 = CliEvaluator.access$resolveOutputPaths(cliEvaluator, it);
                } else {
                    map2 = null;
                }
                return map2;
            }
        });
        this.directoryOutputPaths$delegate = LazyKt.lazy((Function0)new Function0<Map<URI, ? extends Path>>(this){
            final /* synthetic */ CliEvaluator this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Map<URI, Path> invoke() {
                Map map2;
                String string = CliEvaluator.access$getOptions$p(this.this$0).getMultipleFileOutputPath();
                if (string != null) {
                    String string2 = string;
                    CliEvaluator cliEvaluator = this.this$0;
                    String it = string2;
                    boolean bl = false;
                    map2 = CliEvaluator.access$resolveOutputPaths(cliEvaluator, it);
                } else {
                    map2 = null;
                }
                return map2;
            }
        });
    }

    public /* synthetic */ CliEvaluator(CliEvaluatorOptions cliEvaluatorOptions, Reader reader, Writer writer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        Charset charset;
        Closeable closeable;
        if ((n & 2) != 0) {
            InputStream inputStream2 = System.in;
            Intrinsics.checkNotNullExpressionValue(inputStream2, "`in`");
            closeable = inputStream2;
            charset = Charsets.UTF_8;
            reader = new InputStreamReader((InputStream)closeable, charset);
        }
        if ((n & 4) != 0) {
            PrintStream printStream = System.out;
            Intrinsics.checkNotNullExpressionValue(printStream, "out");
            closeable = printStream;
            charset = Charsets.UTF_8;
            writer = new OutputStreamWriter((OutputStream)closeable, charset);
        }
        this(cliEvaluatorOptions, reader, writer);
    }

    @Nullable
    public final Set<File> getOutputFiles() {
        Lazy lazy = this.outputFiles$delegate;
        return (Set)lazy.getValue();
    }

    public static /* synthetic */ void getOutputFiles$annotations() {
    }

    @Nullable
    public final Set<File> getOutputDirectories() {
        Lazy lazy = this.outputDirectories$delegate;
        return (Set)lazy.getValue();
    }

    public static /* synthetic */ void getOutputDirectories$annotations() {
    }

    @Nullable
    public final Map<URI, Path> getFileOutputPaths() {
        Lazy lazy = this.fileOutputPaths$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<URI, Path> getDirectoryOutputPaths() {
        Lazy lazy = this.directoryOutputPaths$delegate;
        return (Map)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        EvaluatorBuilder builder = this.evaluatorBuilder();
        try {
            if (this.options.getMultipleFileOutputPath() != null) {
                this.writeMultipleFileOutput(builder);
            } else {
                this.writeOutput(builder);
            }
        }
        finally {
            Closeables.closeQuietly((Iterable<? extends AutoCloseable>)builder.getModuleKeyFactories());
            Closeables.closeQuietly((Iterable<? extends AutoCloseable>)builder.getResourceReaders());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<URI, Path> resolveOutputPaths(String pathStr) {
        List<URI> moduleUris = this.options.getBase().getNormalizedSourceModules();
        Path workingDir = this.options.getBase().getNormalizedWorkingDir();
        ModulePathResolver modulePathResolver = ModulePathResolver.empty();
        Intrinsics.checkNotNullExpressionValue(modulePathResolver, "empty()");
        ModuleResolver moduleResolver = new ModuleResolver((Collection<ModuleKeyFactory>)this.moduleKeyFactories(modulePathResolver));
        Iterable $this$associateWith$iv = moduleUris;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Path absolutePath;
            String substituted;
            String string;
            Object it;
            void uri;
            URI uRI = (URI)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Path path2 = IoUtils.toPath((URI)uri);
            if (path2 != null) {
                CharSequence charSequence;
                it = path2;
                boolean bl2 = false;
                CharSequence charSequence2 = ((Object)IoUtils.relativize(it.getParent(), workingDir)).toString();
                if (charSequence2.length() == 0) {
                    boolean bl3 = false;
                    charSequence = ".";
                } else {
                    charSequence = charSequence2;
                }
                string = (String)charSequence;
            } else {
                string = null;
            }
            String moduleDir = string;
            try {
                it = moduleResolver.resolve((URI)uri);
            }
            catch (VmException e2) {
                Color color = this.options.getBase().getColor();
                PklException pklException = e2.toPklException(this.getStackFrameTransformer(), color != null ? color.hasColor() : false);
                Intrinsics.checkNotNullExpressionValue(pklException, "e.toPklException(stackFr\u2026lor?.hasColor() ?: false)");
                throw (Throwable)pklException;
            }
            Object object = it;
            Intrinsics.checkNotNullExpressionValue(object, "try {\n          moduleRe\u2026lor() ?: false)\n        }");
            Object moduleKey = object;
            String string2 = IoUtils.inferModuleName((ModuleKey)moduleKey);
            Intrinsics.checkNotNullExpressionValue(string2, "inferModuleName(moduleKey)");
            String string3 = StringsKt.replace$default(pathStr, "%{moduleName}", string2, false, 4, null);
            String string4 = this.options.getOutputFormat();
            if (string4 == null) {
                string4 = "%{outputFormat}";
            }
            String string5 = StringsKt.replace$default(string3, "%{outputFormat}", string4, false, 4, null);
            String string6 = moduleDir;
            if (string6 == null) {
                string6 = "%{moduleDir}";
            }
            if (StringsKt.contains$default((CharSequence)(substituted = StringsKt.replace$default(string5, "%{moduleDir}", string6, false, 4, null)), "%{moduleDir}", false, 2, null)) {
                throw new PklException("Cannot substitute output path placeholder `%{moduleDir}` because module `" + (URI)uri + "` does not have a file system path.");
            }
            Path path3 = absolutePath = workingDir.resolve(substituted).normalize();
            map2.put(t, path3);
        }
        return result$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeOutput(EvaluatorBuilder builder) {
        Evaluator evaluator = builder.setOutputFormat(this.options.getOutputFormat()).build();
        Intrinsics.checkNotNullExpressionValue(evaluator, "builder.setOutputFormat(\u2026ons.outputFormat).build()");
        Evaluator evaluator2 = evaluator;
        AutoCloseable autoCloseable = evaluator2;
        Throwable throwable = null;
        try {
            Evaluator it = (Evaluator)autoCloseable;
            boolean bl = false;
            Map<URI, Path> outputFiles2 = this.getFileOutputPaths();
            if (outputFiles2 != null) {
                Set writtenFiles = new LinkedHashSet();
                for (Map.Entry<URI, Path> entry : outputFiles2.entrySet()) {
                    String output;
                    URI moduleUri = entry.getKey();
                    Path outputFile = entry.getValue();
                    ModuleSource moduleSource = this.toModuleSource(moduleUri, this.consoleReader);
                    Intrinsics.checkNotNullExpressionValue(evaluator2.evaluateExpressionString(moduleSource, this.options.getExpression()), "evaluator.evaluateExpres\u2026urce, options.expression)");
                    PathsKt.createParentDirectories(outputFile, new FileAttribute[0]);
                    if (!writtenFiles.contains(outputFile)) {
                        PathsKt.writeString$default(outputFile, output, null, new OpenOption[0], 2, null);
                        if (!(((CharSequence)output).length() > 0)) continue;
                        writtenFiles.add(outputFile);
                        continue;
                    }
                    if (!(((CharSequence)output).length() > 0)) continue;
                    OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND};
                    PathsKt.writeString(outputFile, this.options.getModuleOutputSeparator() + "\n", Charsets.UTF_8, openOptionArray);
                    openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND};
                    PathsKt.writeString(outputFile, output, Charsets.UTF_8, openOptionArray);
                }
            } else {
                boolean outputWritten = false;
                for (URI moduleUri : this.options.getBase().getNormalizedSourceModules()) {
                    String output;
                    ModuleSource moduleSource = this.toModuleSource(moduleUri, this.consoleReader);
                    Intrinsics.checkNotNullExpressionValue(evaluator2.evaluateExpressionString(moduleSource, this.options.getExpression()), "evaluator.evaluateExpres\u2026urce, options.expression)");
                    if (!(((CharSequence)output).length() > 0)) continue;
                    if (outputWritten) {
                        Appendable appendable = ((Appendable)this.consoleWriter).append(this.options.getModuleOutputSeparator());
                        Intrinsics.checkNotNullExpressionValue(appendable, "append(value)");
                        Intrinsics.checkNotNullExpressionValue(appendable.append('\n'), "append('\\n')");
                    }
                    this.consoleWriter.write(output);
                    this.consoleWriter.flush();
                    outputWritten = true;
                }
            }
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally(autoCloseable, throwable);
        }
    }

    private final ModuleSource toModuleSource(URI uri, Reader reader) {
        ModuleSource moduleSource = Intrinsics.areEqual(uri, VmUtils.REPL_TEXT_URI) ? ModuleSource.create(uri, TextStreamsKt.readText(reader)) : ModuleSource.uri(uri);
        Intrinsics.checkNotNullExpressionValue(moduleSource, "if (uri == VmUtils.REPL_\u2026lse ModuleSource.uri(uri)");
        return moduleSource;
    }

    private final void checkPathSpec(String pathSpec) {
        int illegal;
        block2: {
            int n;
            CharSequence $this$indexOfFirst$iv = pathSpec;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(IoUtils.isReservedFilenameChar(it) && it != '/')) continue;
                n = index$iv;
                break block2;
            }
            n = illegal = -1;
        }
        if (illegal == -1) {
            return;
        }
        throw new CliException("Path spec `" + pathSpec + "` contains illegal character `" + pathSpec.charAt(illegal) + "`.", 0, 2, null);
    }

    private final void writeMultipleFileOutput(EvaluatorBuilder builder) {
        Map<URI, Path> map2 = this.getDirectoryOutputPaths();
        Intrinsics.checkNotNull(map2);
        Map<URI, Path> outputDirs = map2;
        Map writtenFiles = new LinkedHashMap();
        for (Map.Entry<URI, Path> entry : outputDirs.entrySet()) {
            Map<String, FileOutput> output;
            Evaluator evaluator;
            URI moduleUri = entry.getKey();
            Path outputDir = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(builder.setOutputFormat(this.options.getOutputFormat()).build(), "builder.setOutputFormat(\u2026ons.outputFormat).build()");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(outputDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                if (!Files.isDirectory(outputDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                    throw new CliException("Output path `" + outputDir + "` exists and is not a directory.", 0, 2, null);
                }
            }
            ModuleSource moduleSource = this.toModuleSource(moduleUri, this.consoleReader);
            Intrinsics.checkNotNullExpressionValue(evaluator.evaluateOutputFiles(moduleSource), "evaluator.evaluateOutputFiles(moduleSource)");
            for (Map.Entry<String, FileOutput> entry2 : output.entrySet()) {
                Path realPath;
                String pathSpec = entry2.getKey();
                FileOutput fileOutput = entry2.getValue();
                Intrinsics.checkNotNullExpressionValue(pathSpec, "pathSpec");
                this.checkPathSpec(pathSpec);
                Path resolvedPath = outputDir.resolve(pathSpec).normalize();
                Intrinsics.checkNotNullExpressionValue(resolvedPath, "resolvedPath");
                LinkOption[] linkOptionArray3 = new LinkOption[]{};
                Path path2 = realPath = Files.exists(resolvedPath, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length)) ? resolvedPath.toRealPath(new LinkOption[0]) : resolvedPath;
                if (!realPath.startsWith(outputDir)) {
                    throw new CliException("Output file conflict: `output.files` entry `\"" + pathSpec + "\"` in module `" + moduleUri + "` resolves to file path `" + realPath + "`, which is outside output directory `" + outputDir + "`.", 0, 2, null);
                }
                OutputFile previousOutput = (OutputFile)writtenFiles.get(realPath);
                if (previousOutput != null) {
                    throw new CliException("Output file conflict: `output.files` entries `\"" + previousOutput.getPathSpec() + "\"` in module `" + previousOutput.getModuleUri() + "` and `\"" + pathSpec + "\"` in module `" + moduleUri + "` resolve to the same file path `" + realPath + "`.", 0, 2, null);
                }
                Intrinsics.checkNotNullExpressionValue(realPath, "realPath");
                LinkOption[] linkOptionArray4 = new LinkOption[]{};
                if (Files.isDirectory(realPath, Arrays.copyOf(linkOptionArray4, linkOptionArray4.length))) {
                    throw new CliException("Output file conflict: `output.files` entry `\"" + pathSpec + "\"` in module `" + moduleUri + "` resolves to file path `" + realPath + "`, which is a directory.", 0, 2, null);
                }
                writtenFiles.put(realPath, new OutputFile(pathSpec, moduleUri));
                PathsKt.createParentDirectories(realPath, new FileAttribute[0]);
                String string = fileOutput.getText();
                Intrinsics.checkNotNullExpressionValue(string, "fileOutput.text");
                PathsKt.writeString$default(realPath, string, null, new OpenOption[0], 2, null);
                this.consoleWriter.write(IoUtils.relativize(resolvedPath, PathsKt.getCurrentWorkingDir()) + IoUtils.getLineSeparator());
                this.consoleWriter.flush();
            }
        }
    }

    @JvmOverloads
    public CliEvaluator(@NotNull CliEvaluatorOptions options, @NotNull Reader consoleReader) {
        Intrinsics.checkNotNullParameter(options, "options");
        Intrinsics.checkNotNullParameter(consoleReader, "consoleReader");
        this(options, consoleReader, null, 4, null);
    }

    @JvmOverloads
    public CliEvaluator(@NotNull CliEvaluatorOptions options) {
        Intrinsics.checkNotNullParameter(options, "options");
        this(options, null, null, 6, null);
    }

    public static final /* synthetic */ Map access$getDirectoryOutputPaths(CliEvaluator $this) {
        return $this.getDirectoryOutputPaths();
    }

    public static final /* synthetic */ CliEvaluatorOptions access$getOptions$p(CliEvaluator $this) {
        return $this.options;
    }

    public static final /* synthetic */ Map access$resolveOutputPaths(CliEvaluator $this, String pathStr) {
        return $this.resolveOutputPaths(pathStr);
    }
}

