/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.value.impl;

import java.io.IOException;
import java.util.Arrays;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.ImmutableBinaryValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueType;
import org.msgpack.value.impl.AbstractImmutableRawValue;

public class ImmutableBinaryValueImpl
extends AbstractImmutableRawValue
implements ImmutableBinaryValue {
    public ImmutableBinaryValueImpl(byte[] byArray) {
        super(byArray);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.BINARY;
    }

    @Override
    public ImmutableBinaryValue immutableValue() {
        return this;
    }

    @Override
    public ImmutableBinaryValue asBinaryValue() {
        return this;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packBinaryHeader(this.data.length);
        messagePacker.writePayload(this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value2 = (Value)object;
        if (!value2.isBinaryValue()) {
            return false;
        }
        if (value2 instanceof ImmutableBinaryValueImpl) {
            ImmutableBinaryValueImpl immutableBinaryValueImpl = (ImmutableBinaryValueImpl)value2;
            return Arrays.equals(this.data, immutableBinaryValueImpl.data);
        }
        return Arrays.equals(this.data, value2.asBinaryValue().asByteArray());
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

