/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.HostToGuestRootNode;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotFastThreadLocals;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotInteropErrors;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotToHostNode;
import com.oracle.truffle.polyglot.PolyglotValueDispatchFactory;
import com.oracle.truffle.polyglot.PolyglotWrapper;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.TypeLiteral;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

abstract class PolyglotValueDispatch
extends AbstractPolyglotImpl.AbstractValueDispatch {
    private static final String TRUNCATION_SUFFIX = "...";
    private static final String UNKNOWN = "Unknown";
    static final InteropLibrary UNCACHED_INTEROP = InteropLibrary.getFactory().getUncached();
    final PolyglotImpl impl;
    final PolyglotLanguageInstance languageInstance;
    private static final int CHARACTER_LIMIT = 140;
    private static final InteropLibrary INTEROP = InteropLibrary.getFactory().getUncached();

    PolyglotValueDispatch(PolyglotImpl impl, PolyglotLanguageInstance languageInstance) {
        super(impl);
        this.impl = impl;
        this.languageInstance = languageInstance;
    }

    @Override
    public final Context getContext(Object context2) {
        if (context2 == null) {
            return null;
        }
        return ((PolyglotLanguageContext)context2).context.api;
    }

    static <T extends Throwable> PolyglotException guestToHostException(PolyglotLanguageContext languageContext, T e2, boolean entered) {
        throw PolyglotImpl.guestToHostException(languageContext, e2, entered);
    }

    @Override
    public Value getArrayElement(Object languageContext, Object receiver, long index) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            Value value2 = PolyglotValueDispatch.getArrayElementUnsupported(context2, receiver);
            return value2;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Value getArrayElementUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getArrayElement(long)", "hasArrayElements()");
    }

    @Override
    public void setArrayElement(Object languageContext, Object receiver, long index, Object value2) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            PolyglotValueDispatch.setArrayElementUnsupported(context2, receiver);
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static void setArrayElementUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "setArrayElement(long, Object)", "hasArrayElements()");
    }

    @Override
    public boolean removeArrayElement(Object languageContext, Object receiver, long index) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.removeArrayElementUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException removeArrayElementUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "removeArrayElement(long, Object)", null);
    }

    @Override
    public long getArraySize(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            long l = PolyglotValueDispatch.getArraySizeUnsupported(context2, receiver);
            return l;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static long getArraySizeUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getArraySize()", "hasArrayElements()");
    }

    @Override
    public boolean isBufferWritable(Object languageContext, Object receiver) throws UnsupportedOperationException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.isBufferWritableUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException isBufferWritableUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "isBufferWritable()", "hasBufferElements()");
    }

    @Override
    public long getBufferSize(Object languageContext, Object receiver) throws UnsupportedOperationException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.getBufferSizeUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException getBufferSizeUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "getBufferSize()", "hasBufferElements()");
    }

    @Override
    public byte readBufferByte(Object languageContext, Object receiver, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.readBufferByteUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferByteUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "readBufferByte()", "hasBufferElements()");
    }

    @Override
    public void writeBufferByte(Object languageContext, Object receiver, long byteOffset, byte value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.writeBufferByteUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferByteUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferByte()", "hasBufferElements()");
    }

    @Override
    public short readBufferShort(Object languageContext, Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.readBufferShortUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferShortUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "readBufferShort()", "hasBufferElements()");
    }

    @Override
    public void writeBufferShort(Object languageContext, Object receiver, ByteOrder order, long byteOffset, short value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.writeBufferShortUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferShortUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferShort()", "hasBufferElements()");
    }

    @Override
    public int readBufferInt(Object languageContext, Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.readBufferIntUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferIntUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "readBufferInt()", "hasBufferElements()");
    }

    @Override
    public void writeBufferInt(Object languageContext, Object receiver, ByteOrder order, long byteOffset, int value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.writeBufferIntUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferIntUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferInt()", "hasBufferElements()");
    }

    @Override
    public long readBufferLong(Object languageContext, Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.readBufferLongUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferLongUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "readBufferLong()", "hasBufferElements()");
    }

    @Override
    public void writeBufferLong(Object languageContext, Object receiver, ByteOrder order, long byteOffset, long value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.writeBufferLongUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferLongUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferLong()", "hasBufferElements()");
    }

    @Override
    public float readBufferFloat(Object languageContext, Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.readBufferFloatUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferFloatUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "readBufferFloat()", "hasBufferElements()");
    }

    @Override
    public void writeBufferFloat(Object languageContext, Object receiver, ByteOrder order, long byteOffset, float value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.writeBufferFloatUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferFloatUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferFloat()", "hasBufferElements()");
    }

    @Override
    public double readBufferDouble(Object languageContext, Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.readBufferDoubleUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException readBufferDoubleUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "readBufferDouble()", "hasBufferElements()");
    }

    @Override
    public void writeBufferDouble(Object languageContext, Object receiver, ByteOrder order, long byteOffset, double value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.writeBufferDoubleUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException writeBufferDoubleUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferDouble()", "hasBufferElements()");
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidBufferIndex(PolyglotLanguageContext context2, Object receiver, long byteOffset, long size) {
        String message = String.format("Invalid buffer access of length %d at byte offset %d for buffer %s.", size, byteOffset, PolyglotValueDispatch.getValueInfo(context2, receiver));
        throw PolyglotEngineException.bufferIndexOutOfBounds(message);
    }

    @Override
    public Value getMember(Object languageContext, Object receiver, String key2) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            Value value2 = PolyglotValueDispatch.getMemberUnsupported(context2, receiver, key2);
            return value2;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Value getMemberUnsupported(PolyglotLanguageContext context2, Object receiver, String key2) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getMember(String)", "hasMembers()");
    }

    @Override
    public void putMember(Object languageContext, Object receiver, String key2, Object member) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            PolyglotValueDispatch.putMemberUnsupported(context2, receiver);
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException putMemberUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "putMember(String, Object)", "hasMembers()");
    }

    @Override
    public boolean removeMember(Object languageContext, Object receiver, String key2) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.removeMemberUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException removeMemberUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "removeMember(String, Object)", null);
    }

    @Override
    public Value execute(Object languageContext, Object receiver, Object[] arguments) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.executeUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @Override
    public Value execute(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.executeUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException executeUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "execute(Object...)", "canExecute()");
    }

    @Override
    public Value newInstance(Object languageContext, Object receiver, Object[] arguments) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            Value value2 = PolyglotValueDispatch.newInstanceUnsupported(context2, receiver);
            return value2;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static Value newInstanceUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "newInstance(Object...)", "canInstantiate()");
    }

    @Override
    public void executeVoid(Object languageContext, Object receiver, Object[] arguments) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            PolyglotValueDispatch.executeVoidUnsupported(context2, receiver);
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @Override
    public void executeVoid(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            PolyglotValueDispatch.executeVoidUnsupported(context2, receiver);
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static void executeVoidUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "executeVoid(Object...)", "canExecute()");
    }

    @Override
    public Value invoke(Object languageContext, Object receiver, String identifier, Object[] arguments) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.invokeUnsupported(context2, receiver, identifier);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @Override
    public Value invoke(Object languageContext, Object receiver, String identifier) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.invokeUnsupported(context2, receiver, identifier);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static RuntimeException invokeUnsupported(PolyglotLanguageContext context2, Object receiver, String identifier) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "invoke(" + identifier + ", Object...)", "canInvoke(String)");
    }

    @Override
    public String asString(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            String string = PolyglotValueDispatch.asStringUnsupported(context2, receiver);
            return string;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    protected static String asStringUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.invalidCastPrimitive(context2, receiver, String.class, "asString()", "isString()", "Invalid coercion.");
    }

    @Override
    public boolean asBoolean(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            boolean bl = PolyglotValueDispatch.asBooleanUnsupported(context2, receiver);
            return bl;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    private static boolean isNullUncached(Object receiver) {
        return InteropLibrary.getFactory().getUncached().isNull(receiver);
    }

    protected static boolean asBooleanUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.invalidCastPrimitive(context2, receiver, Boolean.TYPE, "asBoolean()", "isBoolean()", "Invalid or lossy primitive coercion.");
    }

    private static <T> T invalidCastPrimitive(PolyglotLanguageContext context2, Object receiver, Class<T> clazz, String asMethodName, String isMethodName, String detail) {
        if (PolyglotValueDispatch.isNullUncached(receiver)) {
            throw PolyglotValueDispatch.nullCoercion(context2, receiver, clazz, asMethodName, isMethodName);
        }
        throw PolyglotValueDispatch.cannotConvert(context2, receiver, clazz, asMethodName, isMethodName, detail);
    }

    @Override
    public int asInt(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            int n = PolyglotValueDispatch.asIntUnsupported(context2, receiver);
            return n;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    protected static int asIntUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.invalidCastPrimitive(context2, receiver, Integer.TYPE, "asInt()", "fitsInInt()", "Invalid or lossy primitive coercion.");
    }

    @Override
    public long asLong(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            long l = PolyglotValueDispatch.asLongUnsupported(context2, receiver);
            return l;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    protected static long asLongUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.invalidCastPrimitive(context2, receiver, Long.TYPE, "asLong()", "fitsInLong()", "Invalid or lossy primitive coercion.");
    }

    @Override
    public BigInteger asBigInteger(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            BigInteger bigInteger = PolyglotValueDispatch.asBigIntegerUnsupported(context2, receiver);
            return bigInteger;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    protected static BigInteger asBigIntegerUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.cannotConvert(context2, receiver, BigInteger.class, "asBigInteger()", "fitsInBigInteger()", "Invalid or lossy coercion.");
    }

    @Override
    public double asDouble(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            double d2 = PolyglotValueDispatch.asDoubleUnsupported(context2, receiver);
            return d2;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    protected static double asDoubleUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.invalidCastPrimitive(context2, receiver, Double.TYPE, "asDouble()", "fitsInDouble()", "Invalid or lossy primitive coercion.");
    }

    @Override
    public float asFloat(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            float f = PolyglotValueDispatch.asFloatUnsupported(context2, receiver);
            return f;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    protected static float asFloatUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.invalidCastPrimitive(context2, receiver, Float.TYPE, "asFloat()", "fitsInFloat()", "Invalid or lossy primitive coercion.").floatValue();
    }

    @Override
    public byte asByte(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            byte by = PolyglotValueDispatch.asByteUnsupported(context2, receiver);
            return by;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    protected static byte asByteUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.invalidCastPrimitive(context2, receiver, Byte.TYPE, "asByte()", "fitsInByte()", "Invalid or lossy primitive coercion.");
    }

    @Override
    public short asShort(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            short s2 = PolyglotValueDispatch.asShortUnsupported(context2, receiver);
            return s2;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    protected static short asShortUnsupported(PolyglotLanguageContext context2, Object receiver) {
        return PolyglotValueDispatch.invalidCastPrimitive(context2, receiver, Short.TYPE, "asShort()", "fitsInShort()", "Invalid or lossy primitive coercion.");
    }

    @Override
    public long asNativePointer(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            long l = PolyglotValueDispatch.asNativePointerUnsupported(context2, receiver);
            return l;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    static long asNativePointerUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.cannotConvert(context2, receiver, Long.TYPE, "asNativePointer()", "isNativeObject()", "Value cannot be converted to a native pointer.");
    }

    @Override
    public Object asHostObject(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            Object object = PolyglotValueDispatch.asHostObjectUnsupported(context2, receiver);
            return object;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    protected static Object asHostObjectUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asHostObject()", "isHostObject()", "Value is not a host object.");
    }

    @Override
    public Object asProxyObject(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            Object object = PolyglotValueDispatch.asProxyObjectUnsupported(context2, receiver);
            return object;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    protected static Object asProxyObjectUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asProxyObject()", "isProxyObject()", "Value is not a proxy object.");
    }

    @Override
    public LocalDate asDate(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            if (PolyglotValueDispatch.isNullUncached(receiver)) {
                LocalDate localDate = null;
                return localDate;
            }
            try {
                throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asDate()", "isDate()", "Value does not contain date information.");
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @Override
    public LocalTime asTime(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            if (PolyglotValueDispatch.isNullUncached(receiver)) {
                LocalTime localTime = null;
                return localTime;
            }
            try {
                throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asTime()", "isTime()", "Value does not contain time information.");
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @Override
    public ZoneId asTimeZone(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            if (PolyglotValueDispatch.isNullUncached(receiver)) {
                ZoneId zoneId = null;
                return zoneId;
            }
            try {
                throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asTimeZone()", "isTimeZone()", "Value does not contain time zone information.");
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @Override
    public Instant asInstant(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            if (PolyglotValueDispatch.isNullUncached(receiver)) {
                Instant instant = null;
                return instant;
            }
            try {
                throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asInstant()", "isInstant()", "Value does not contain instant information.");
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @Override
    public Duration asDuration(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            if (PolyglotValueDispatch.isNullUncached(receiver)) {
                Duration duration = null;
                return duration;
            }
            try {
                throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asDuration()", "isDuration()", "Value does not contain duration information.");
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @Override
    public RuntimeException throwException(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.unsupported(context2, receiver, "throwException()", "isException()");
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @Override
    public final Value getMetaObject(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            Value value2 = this.getMetaObjectImpl(context2, receiver);
            return value2;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @Override
    public Value getIterator(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            Value value2 = PolyglotValueDispatch.getIteratorUnsupported(context2, receiver);
            return value2;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final Value getIteratorUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getIterator()", "hasIterator()");
    }

    @Override
    public boolean hasIteratorNextElement(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            boolean bl = PolyglotValueDispatch.hasIteratorNextElementUnsupported(context2, receiver);
            return bl;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final boolean hasIteratorNextElementUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "hasIteratorNextElement()", "isIterator()");
    }

    @Override
    public Value getIteratorNextElement(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            Value value2 = PolyglotValueDispatch.getIteratorNextElementUnsupported(context2, receiver);
            return value2;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final Value getIteratorNextElementUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getIteratorNextElement()", "isIterator()");
    }

    @Override
    public long getHashSize(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.getHashSizeUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashSizeUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getHashSize()", "hasHashEntries()");
    }

    @Override
    public Value getHashValue(Object languageContext, Object receiver, Object key2) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.getHashValueUnsupported(context2, receiver, key2);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashValueUnsupported(PolyglotLanguageContext context2, Object receiver, Object key2) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getHashValue(Object)", "hasHashEntries()");
    }

    @Override
    public Value getHashValueOrDefault(Object languageContext, Object receiver, Object key2, Object defaultValue) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.getHashValueOrDefaultUnsupported(context2, receiver, key2, defaultValue);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashValueOrDefaultUnsupported(PolyglotLanguageContext context2, Object receiver, Object key2, Object defaultValue) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getHashValueOrDefault(Object, Object)", "hasHashEntries()");
    }

    @Override
    public void putHashEntry(Object languageContext, Object receiver, Object key2, Object value2) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            PolyglotValueDispatch.putHashEntryUnsupported(context2, receiver, key2, value2);
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException putHashEntryUnsupported(PolyglotLanguageContext context2, Object receiver, Object key2, Object value2) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "putHashEntry(Object, Object)", "hasHashEntries()");
    }

    @Override
    public boolean removeHashEntry(Object languageContext, Object receiver, Object key2) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.removeHashEntryUnsupported(context2, receiver, key2);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException removeHashEntryUnsupported(PolyglotLanguageContext context2, Object receiver, Object key2) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "removeHashEntry(Object)", "hasHashEntries()");
    }

    @Override
    public Value getHashEntriesIterator(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.getHashEntriesIteratorUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashEntriesIteratorUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getHashEntriesIterator()", "hasHashEntries()");
    }

    @Override
    public Value getHashKeysIterator(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.getHashKeysIteratorUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashKeysIteratorUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getHashKeysIterator()", "hasHashEntries()");
    }

    @Override
    public Value getHashValuesIterator(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.getHashValuesIteratorUnsupported(context2, receiver);
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @Override
    public void pin(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            this.languageInstance.sharing.engine.host.pin(receiver);
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @CompilerDirectives.TruffleBoundary
    static final RuntimeException getHashValuesIteratorUnsupported(PolyglotLanguageContext context2, Object receiver) {
        throw PolyglotValueDispatch.unsupported(context2, receiver, "getHashValuesIterator()", "hasHashEntries()");
    }

    protected Value getMetaObjectImpl(PolyglotLanguageContext context2, Object receiver) {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
        if (lib.hasMetaObject(receiver)) {
            try {
                return PolyglotValueDispatch.asValue(context2, lib.getMetaObject(receiver));
            }
            catch (UnsupportedMessageException e2) {
                throw CompilerDirectives.shouldNotReachHere("Unexpected unsupported message.", e2);
            }
        }
        return null;
    }

    private static Value asValue(PolyglotLanguageContext context2, Object value2) {
        if (context2 == null) {
            return PolyglotImpl.getInstance().asValue(PolyglotFastThreadLocals.getContext(null), value2);
        }
        return context2.asValue(value2);
    }

    static Object hostEnter(Object languageContext) {
        if (languageContext == null) {
            return null;
        }
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        PolyglotContextImpl c = context2.context;
        try {
            return c.engine.enterIfNeeded(c, true);
        }
        catch (Throwable t) {
            throw PolyglotValueDispatch.guestToHostException(context2, t, false);
        }
    }

    static void hostLeave(Object languageContext, Object prev) {
        if (languageContext == null) {
            return;
        }
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        try {
            PolyglotContextImpl c = context2.context;
            c.engine.leaveIfNeeded(prev, c);
        }
        catch (Throwable t) {
            throw PolyglotValueDispatch.guestToHostException(context2, t, false);
        }
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException unsupported(PolyglotLanguageContext context2, Object receiver, String message, String useToCheck) {
        String polyglotMessage = useToCheck != null ? String.format("Unsupported operation %s.%s for %s. You can ensure that the operation is supported using %s.%s.", Value.class.getSimpleName(), message, PolyglotValueDispatch.getValueInfo(context2, receiver), Value.class.getSimpleName(), useToCheck) : String.format("Unsupported operation %s.%s for %s.", Value.class.getSimpleName(), message, PolyglotValueDispatch.getValueInfo(context2, receiver));
        return PolyglotEngineException.unsupported(polyglotMessage);
    }

    @CompilerDirectives.TruffleBoundary
    static String getValueInfo(Object languageContext, Object receiver) {
        PolyglotContextImpl context2 = languageContext != null ? ((PolyglotLanguageContext)languageContext).context : null;
        return PolyglotValueDispatch.getValueInfo(context2, receiver);
    }

    @CompilerDirectives.TruffleBoundary
    static String getValueInfo(PolyglotContextImpl context2, Object receiver) {
        String valueToString;
        Object view;
        if (context2 == null) {
            return receiver.toString();
        }
        if (receiver == null) {
            assert (false) : "receiver should never be null";
            return "null";
        }
        PolyglotLanguage displayLanguage = EngineAccessor.EngineImpl.findObjectLanguage(context2.engine, receiver);
        if (displayLanguage == null) {
            displayLanguage = context2.engine.hostLanguage;
            view = context2.getHostContext().getLanguageView(receiver);
        } else {
            view = receiver;
        }
        String metaObjectToString = UNKNOWN;
        try {
            InteropLibrary uncached = InteropLibrary.getFactory().getUncached(view);
            if (uncached.hasMetaObject(view)) {
                Object qualifiedName = INTEROP.getMetaQualifiedName(uncached.getMetaObject(view));
                metaObjectToString = PolyglotValueDispatch.truncateString(INTEROP.asString(qualifiedName), 140);
            }
            valueToString = PolyglotValueDispatch.truncateString(INTEROP.asString(uncached.toDisplayString(view)), 140);
        }
        catch (UnsupportedMessageException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
        String languageName = null;
        boolean hideType = false;
        if (displayLanguage.isHost()) {
            languageName = "Java";
            if (UNKNOWN.equals(metaObjectToString) && INTEROP.isNull(receiver)) {
                hideType = true;
            }
        } else {
            languageName = displayLanguage.getName();
        }
        if (hideType) {
            return String.format("'%s'(language: %s)", valueToString, languageName);
        }
        return String.format("'%s'(language: %s, type: %s)", valueToString, languageName, metaObjectToString);
    }

    private static String truncateString(String s2, int i) {
        if (s2.length() > i) {
            return s2.substring(0, i - TRUNCATION_SUFFIX.length()) + TRUNCATION_SUFFIX;
        }
        return s2;
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nullCoercion(Object languageContext, Object receiver, Class<?> targetType, String message, String useToCheck) {
        assert (PolyglotValueDispatch.isEnteredOrNull(languageContext));
        String valueInfo = PolyglotValueDispatch.getValueInfo(languageContext, receiver);
        throw PolyglotEngineException.nullPointer(String.format("Cannot convert null value %s to Java type '%s' using %s.%s. You can ensure that the operation is supported using %s.%s.", valueInfo, targetType, Value.class.getSimpleName(), message, Value.class.getSimpleName(), useToCheck));
    }

    static boolean isEnteredOrNull(Object languageContext) {
        if (languageContext == null) {
            return true;
        }
        PolyglotContextImpl context2 = ((PolyglotLanguageContext)languageContext).context;
        return !context2.engine.needsEnter(context2);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException cannotConvert(Object languageContext, Object receiver, Class<?> targetType, String message, String useToCheck, String reason) {
        assert (PolyglotValueDispatch.isEnteredOrNull(languageContext));
        String valueInfo = PolyglotValueDispatch.getValueInfo(languageContext, receiver);
        String targetTypeString = "";
        if (targetType != null) {
            targetTypeString = String.format("to Java type '%s'", targetType.getTypeName());
        }
        throw PolyglotEngineException.classCast(String.format("Cannot convert %s %s using %s.%s: %s You can ensure that the value can be converted using %s.%s.", valueInfo, targetTypeString, Value.class.getSimpleName(), message, reason, Value.class.getSimpleName(), useToCheck));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidArrayIndex(PolyglotLanguageContext context2, Object receiver, long index) {
        String message = String.format("Invalid array index %s for array %s.", index, PolyglotValueDispatch.getValueInfo(context2, receiver));
        throw PolyglotEngineException.arrayIndexOutOfBounds(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidArrayValue(PolyglotLanguageContext context2, Object receiver, long identifier, Object value2) {
        throw PolyglotEngineException.classCast(String.format("Invalid array value %s for array %s and index %s.", PolyglotValueDispatch.getValueInfo(context2, value2), PolyglotValueDispatch.getValueInfo(context2, receiver), identifier));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nonReadableMemberKey(PolyglotLanguageContext context2, Object receiver, String identifier) {
        String message = String.format("Non readable or non-existent member key '%s' for object %s.", identifier, PolyglotValueDispatch.getValueInfo(context2, receiver));
        throw PolyglotEngineException.unsupported(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nonWritableMemberKey(PolyglotLanguageContext context2, Object receiver, String identifier) {
        String message = String.format("Non writable or non-existent member key '%s' for object %s.", identifier, PolyglotValueDispatch.getValueInfo(context2, receiver));
        throw PolyglotEngineException.unsupported(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nonRemovableMemberKey(PolyglotLanguageContext context2, Object receiver, String identifier) {
        String message = String.format("Non removable or non-existent member key '%s' for object %s.", identifier, PolyglotValueDispatch.getValueInfo(context2, receiver));
        throw PolyglotEngineException.unsupported(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidMemberValue(PolyglotLanguageContext context2, Object receiver, String identifier, Object value2) {
        String message = String.format("Invalid member value %s for object %s and member key '%s'.", PolyglotValueDispatch.getValueInfo(context2, value2), PolyglotValueDispatch.getValueInfo(context2, receiver), identifier);
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException stopIteration(PolyglotLanguageContext context2, Object receiver) {
        String message = String.format("Iteration was stopped for iterator %s.", PolyglotValueDispatch.getValueInfo(context2, receiver));
        throw PolyglotEngineException.noSuchElement(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException nonReadableIteratorElement() {
        throw PolyglotEngineException.unsupported("Iterator element is not readable.");
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidHashValue(PolyglotLanguageContext context2, Object receiver, Object key2, Object value2) {
        String message = String.format("Invalid hash value %s for object %s and hash key %s.", PolyglotValueDispatch.getValueInfo(context2, value2), PolyglotValueDispatch.getValueInfo(context2, receiver), PolyglotValueDispatch.getValueInfo(context2, key2));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidExecuteArgumentType(PolyglotLanguageContext context2, Object receiver, UnsupportedTypeException e2) {
        String originalMessage = e2.getMessage() == null ? "" : e2.getMessage() + " ";
        String[] formattedArgs = PolyglotValueDispatch.formatArgs(context2, e2.getSuppliedValues());
        throw PolyglotEngineException.illegalArgument(String.format("Invalid argument when executing %s. %sProvided arguments: %s.", PolyglotValueDispatch.getValueInfo(context2, receiver), originalMessage, Arrays.asList(formattedArgs)));
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInvokeArgumentType(PolyglotLanguageContext context2, Object receiver, String member, UnsupportedTypeException e2) {
        String originalMessage = e2.getMessage() == null ? "" : e2.getMessage();
        String[] formattedArgs = PolyglotValueDispatch.formatArgs(context2, e2.getSuppliedValues());
        String message = String.format("Invalid argument when invoking '%s' on %s. %sProvided arguments: %s.", member, PolyglotValueDispatch.getValueInfo(context2, receiver), originalMessage, Arrays.asList(formattedArgs));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInstantiateArgumentType(PolyglotLanguageContext context2, Object receiver, Object[] arguments) {
        String[] formattedArgs = PolyglotValueDispatch.formatArgs(context2, arguments);
        String message = String.format("Invalid argument when instantiating %s with arguments %s.", PolyglotValueDispatch.getValueInfo(context2, receiver), Arrays.asList(formattedArgs));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInstantiateArity(PolyglotLanguageContext context2, Object receiver, Object[] arguments, int expectedMin, int expectedMax, int actual) {
        String[] formattedArgs = PolyglotValueDispatch.formatArgs(context2, arguments);
        String message = String.format("Invalid argument count when instantiating %s with arguments %s. %s", PolyglotValueDispatch.getValueInfo(context2, receiver), Arrays.asList(formattedArgs), PolyglotValueDispatch.formatExpectedArguments(expectedMin, expectedMax, actual));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidExecuteArity(PolyglotLanguageContext context2, Object receiver, Object[] arguments, int expectedMin, int expectedMax, int actual) {
        String[] formattedArgs = PolyglotValueDispatch.formatArgs(context2, arguments);
        String message = String.format("Invalid argument count when executing %s with arguments %s. %s", PolyglotValueDispatch.getValueInfo(context2, receiver), Arrays.asList(formattedArgs), PolyglotValueDispatch.formatExpectedArguments(expectedMin, expectedMax, actual));
        throw PolyglotEngineException.illegalArgument(message);
    }

    @CompilerDirectives.TruffleBoundary
    protected static RuntimeException invalidInvokeArity(PolyglotLanguageContext context2, Object receiver, String member, Object[] arguments, int expectedMin, int expectedMax, int actual) {
        String[] formattedArgs = PolyglotValueDispatch.formatArgs(context2, arguments);
        String message = String.format("Invalid argument count when invoking '%s' on %s with arguments %s. %s", member, PolyglotValueDispatch.getValueInfo(context2, receiver), Arrays.asList(formattedArgs), PolyglotValueDispatch.formatExpectedArguments(expectedMin, expectedMax, actual));
        throw PolyglotEngineException.illegalArgument(message);
    }

    static String formatExpectedArguments(int expectedMinArity, int expectedMaxArity, int actualArity) {
        String actual = actualArity < 0 ? "unknown" : String.valueOf(actualArity);
        Object expected = expectedMinArity == expectedMaxArity ? String.valueOf(expectedMinArity) : (expectedMaxArity < 0 ? expectedMinArity + "+" : expectedMinArity + "-" + expectedMaxArity);
        return String.format("Expected %s argument(s) but got %s.", expected, actual);
    }

    private static String[] formatArgs(Object languageContext, Object[] arguments) {
        String[] formattedArgs = new String[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            formattedArgs[i] = PolyglotValueDispatch.getValueInfo(languageContext, arguments[i]);
        }
        return formattedArgs;
    }

    @Override
    public final String toString(Object languageContext, Object receiver) {
        PolyglotContextImpl.State localContextState;
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = null;
        if (context2 != null && (localContextState = context2.context.state).isInvalidOrClosed()) {
            return "Error in toString(): Context is invalid or closed.";
        }
        try {
            prev = PolyglotValueDispatch.hostEnter(context2);
        }
        catch (Throwable t) {
            return String.format("Error in toString(): Could not enter context: %s.", t.getMessage());
        }
        try {
            String t = this.toStringImpl(context2, receiver);
            return t;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            try {
                PolyglotValueDispatch.hostLeave(languageContext, prev);
            }
            catch (Throwable throwable) {}
        }
    }

    String toStringImpl(PolyglotLanguageContext context2, Object receiver) throws AssertionError {
        return PolyglotWrapper.toStringImpl(context2, receiver);
    }

    @Override
    public org.graalvm.polyglot.SourceSection getSourceLocation(Object languageContext, Object receiver) {
        if (languageContext == null) {
            return null;
        }
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
            SourceSection result = null;
            if (lib.hasSourceLocation(receiver)) {
                try {
                    result = lib.getSourceLocation(receiver);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            if (result == null) {
                org.graalvm.polyglot.SourceSection sourceSection = null;
                return sourceSection;
            }
            org.graalvm.polyglot.SourceSection sourceSection = PolyglotImpl.getPolyglotSourceSection(this.impl, result);
            return sourceSection;
        }
        catch (Throwable e2) {
            throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
        }
        finally {
            PolyglotValueDispatch.hostLeave(context2, prev);
        }
    }

    @Override
    public boolean isMetaObject(Object languageContext, Object receiver) {
        return false;
    }

    @Override
    public boolean equalsImpl(Object languageContext, Object receiver, Object obj) {
        if (receiver == obj) {
            return true;
        }
        return PolyglotWrapper.equals(languageContext, receiver, obj);
    }

    @Override
    public int hashCodeImpl(Object languageContext, Object receiver) {
        return PolyglotWrapper.hashCode(languageContext, receiver);
    }

    @Override
    public boolean isMetaInstance(Object languageContext, Object receiver, Object instance) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.unsupported(context2, receiver, "isMetaInstance(Object)", "isMetaObject()");
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @Override
    public String getMetaQualifiedName(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.unsupported(context2, receiver, "getMetaQualifiedName()", "isMetaObject()");
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @Override
    public String getMetaSimpleName(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.unsupported(context2, receiver, "getMetaSimpleName()", "isMetaObject()");
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    @Override
    public boolean hasMetaParents(Object languageContext, Object receiver) {
        return false;
    }

    @Override
    public Value getMetaParents(Object languageContext, Object receiver) {
        PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
        Object prev = PolyglotValueDispatch.hostEnter(context2);
        try {
            try {
                throw PolyglotValueDispatch.unsupported(context2, receiver, "getMetaParents()", "hasMetaParents()");
            }
            catch (Throwable e2) {
                throw PolyglotValueDispatch.guestToHostException(context2, e2, true);
            }
        }
        catch (Throwable throwable) {
            PolyglotValueDispatch.hostLeave(context2, prev);
            throw throwable;
        }
    }

    static CallTarget createTarget(InteropNode root) {
        RootCallTarget target = root.getCallTarget();
        Class<?>[] types = root.getArgumentTypes();
        if (types != null) {
            EngineAccessor.RUNTIME.initializeProfile(target, types);
        }
        return target;
    }

    static PolyglotValueDispatch createInteropValue(PolyglotLanguageInstance languageInstance, TruffleObject receiver, Class<?> receiverType) {
        return new InteropValue(languageInstance.getImpl(), languageInstance, receiver, receiverType);
    }

    static PolyglotValueDispatch createHostNull(PolyglotImpl polyglot) {
        return new HostNull(polyglot);
    }

    static void createDefaultValues(PolyglotImpl polyglot, PolyglotLanguageInstance languageInstance, Map<Class<?>, PolyglotValueDispatch> valueCache) {
        PolyglotValueDispatch.addDefaultValue(polyglot, languageInstance, valueCache, false);
        PolyglotValueDispatch.addDefaultValue(polyglot, languageInstance, valueCache, "");
        PolyglotValueDispatch.addDefaultValue(polyglot, languageInstance, valueCache, TruffleString.fromJavaStringUncached("", TruffleString.Encoding.UTF_16));
        PolyglotValueDispatch.addDefaultValue(polyglot, languageInstance, valueCache, Character.valueOf('a'));
        PolyglotValueDispatch.addDefaultValue(polyglot, languageInstance, valueCache, (byte)0);
        PolyglotValueDispatch.addDefaultValue(polyglot, languageInstance, valueCache, (short)0);
        PolyglotValueDispatch.addDefaultValue(polyglot, languageInstance, valueCache, 0);
        PolyglotValueDispatch.addDefaultValue(polyglot, languageInstance, valueCache, 0L);
        PolyglotValueDispatch.addDefaultValue(polyglot, languageInstance, valueCache, Float.valueOf(0.0f));
        PolyglotValueDispatch.addDefaultValue(polyglot, languageInstance, valueCache, 0.0);
    }

    static void addDefaultValue(PolyglotImpl polyglot, PolyglotLanguageInstance languageInstance, Map<Class<?>, PolyglotValueDispatch> valueCache, Object primitive) {
        valueCache.put(primitive.getClass(), new PrimitiveValue(polyglot, languageInstance, primitive));
    }

    static abstract class InteropNode
    extends HostToGuestRootNode {
        protected static final int CACHE_LIMIT = 5;
        protected final InteropValue polyglot;

        protected abstract String getOperationName();

        protected InteropNode(InteropValue polyglot) {
            super(polyglot.languageInstance);
            this.polyglot = polyglot;
        }

        protected abstract Class<?>[] getArgumentTypes();

        protected Class<? extends Object> getReceiverType() {
            return this.polyglot.receiverType;
        }

        @Override
        public final String getName() {
            return "org.graalvm.polyglot.Value<" + this.polyglot.receiverType.getSimpleName() + ">." + this.getOperationName();
        }

        protected final AbstractPolyglotImpl getImpl() {
            return this.polyglot.impl;
        }

        @Override
        public final String toString() {
            return this.getName();
        }
    }

    static final class InteropValue
    extends PolyglotValueDispatch {
        final CallTarget isNativePointer;
        final CallTarget asNativePointer;
        final CallTarget hasArrayElements;
        final CallTarget getArrayElement;
        final CallTarget setArrayElement;
        final CallTarget removeArrayElement;
        final CallTarget getArraySize;
        final CallTarget hasBufferElements;
        final CallTarget isBufferWritable;
        final CallTarget getBufferSize;
        final CallTarget readBufferByte;
        final CallTarget writeBufferByte;
        final CallTarget readBufferShort;
        final CallTarget writeBufferShort;
        final CallTarget readBufferInt;
        final CallTarget writeBufferInt;
        final CallTarget readBufferLong;
        final CallTarget writeBufferLong;
        final CallTarget readBufferFloat;
        final CallTarget writeBufferFloat;
        final CallTarget readBufferDouble;
        final CallTarget writeBufferDouble;
        final CallTarget hasMembers;
        final CallTarget hasMember;
        final CallTarget getMember;
        final CallTarget putMember;
        final CallTarget removeMember;
        final CallTarget isNull;
        final CallTarget canExecute;
        final CallTarget execute;
        final CallTarget canInstantiate;
        final CallTarget newInstance;
        final CallTarget executeNoArgs;
        final CallTarget executeVoid;
        final CallTarget executeVoidNoArgs;
        final CallTarget canInvoke;
        final CallTarget invoke;
        final CallTarget invokeNoArgs;
        final CallTarget getMemberKeys;
        final CallTarget isDate;
        final CallTarget asDate;
        final CallTarget isTime;
        final CallTarget asTime;
        final CallTarget isTimeZone;
        final CallTarget asTimeZone;
        final CallTarget asInstant;
        final CallTarget isDuration;
        final CallTarget asDuration;
        final CallTarget isException;
        final CallTarget throwException;
        final CallTarget isMetaObject;
        final CallTarget isMetaInstance;
        final CallTarget getMetaQualifiedName;
        final CallTarget getMetaSimpleName;
        final CallTarget hasMetaParents;
        final CallTarget getMetaParents;
        final CallTarget hasIterator;
        final CallTarget getIterator;
        final CallTarget isIterator;
        final CallTarget hasIteratorNextElement;
        final CallTarget getIteratorNextElement;
        final CallTarget hasHashEntries;
        final CallTarget getHashSize;
        final CallTarget hasHashEntry;
        final CallTarget getHashValue;
        final CallTarget getHashValueOrDefault;
        final CallTarget putHashEntry;
        final CallTarget removeHashEntry;
        final CallTarget getHashEntriesIterator;
        final CallTarget getHashKeysIterator;
        final CallTarget getHashValuesIterator;
        final CallTarget asClassLiteral;
        final CallTarget asTypeLiteral;
        final Class<?> receiverType;

        InteropValue(PolyglotImpl polyglot, PolyglotLanguageInstance languageInstance, Object receiverObject, Class<?> receiverType) {
            super(polyglot, languageInstance);
            this.receiverType = receiverType;
            this.asClassLiteral = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.AsClassLiteralNodeGen.create(this));
            this.asTypeLiteral = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.AsTypeLiteralNodeGen.create(this));
            this.isNativePointer = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsNativePointerNodeGen.create(this));
            this.asNativePointer = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.AsNativePointerNodeGen.create(this));
            this.hasArrayElements = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.HasArrayElementsNodeGen.create(this));
            this.getArrayElement = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetArrayElementNodeGen.create(this));
            this.setArrayElement = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.SetArrayElementNodeGen.create(this));
            this.removeArrayElement = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.RemoveArrayElementNodeGen.create(this));
            this.getArraySize = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetArraySizeNodeGen.create(this));
            this.hasBufferElements = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.HasBufferElementsNodeGen.create(this));
            this.isBufferWritable = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsBufferWritableNodeGen.create(this));
            this.getBufferSize = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetBufferSizeNodeGen.create(this));
            this.readBufferByte = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ReadBufferByteNodeGen.create(this));
            this.writeBufferByte = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.WriteBufferByteNodeGen.create(this));
            this.readBufferShort = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ReadBufferShortNodeGen.create(this));
            this.writeBufferShort = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.WriteBufferShortNodeGen.create(this));
            this.readBufferInt = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ReadBufferIntNodeGen.create(this));
            this.writeBufferInt = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.WriteBufferIntNodeGen.create(this));
            this.readBufferLong = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ReadBufferLongNodeGen.create(this));
            this.writeBufferLong = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.WriteBufferLongNodeGen.create(this));
            this.readBufferFloat = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ReadBufferFloatNodeGen.create(this));
            this.writeBufferFloat = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.WriteBufferFloatNodeGen.create(this));
            this.readBufferDouble = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ReadBufferDoubleNodeGen.create(this));
            this.writeBufferDouble = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.WriteBufferDoubleNodeGen.create(this));
            this.hasMember = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.HasMemberNodeGen.create(this));
            this.getMember = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetMemberNodeGen.create(this));
            this.putMember = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.PutMemberNodeGen.create(this));
            this.removeMember = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.RemoveMemberNodeGen.create(this));
            this.isNull = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsNullNodeGen.create(this));
            this.execute = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ExecuteNodeGen.create(this));
            this.executeNoArgs = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ExecuteNoArgsNodeGen.create(this));
            this.executeVoid = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ExecuteVoidNodeGen.create(this));
            this.executeVoidNoArgs = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ExecuteVoidNoArgsNodeGen.create(this));
            this.newInstance = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.NewInstanceNodeGen.create(this));
            this.canInstantiate = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.CanInstantiateNodeGen.create(this));
            this.canExecute = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.CanExecuteNodeGen.create(this));
            this.canInvoke = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.CanInvokeNodeGen.create(this));
            this.invoke = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.InvokeNodeGen.create(this));
            this.invokeNoArgs = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.InvokeNoArgsNodeGen.create(this));
            this.hasMembers = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.HasMembersNodeGen.create(this));
            this.getMemberKeys = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetMemberKeysNodeGen.create(this));
            this.isDate = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsDateNodeGen.create(this));
            this.asDate = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.AsDateNodeGen.create(this));
            this.isTime = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsTimeNodeGen.create(this));
            this.asTime = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.AsTimeNodeGen.create(this));
            this.isTimeZone = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsTimeZoneNodeGen.create(this));
            this.asTimeZone = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.AsTimeZoneNodeGen.create(this));
            this.asInstant = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.AsInstantNodeGen.create(this));
            this.isDuration = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsDurationNodeGen.create(this));
            this.asDuration = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.AsDurationNodeGen.create(this));
            this.isException = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsExceptionNodeGen.create(this));
            this.throwException = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.ThrowExceptionNodeGen.create(this));
            this.isMetaObject = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsMetaObjectNodeGen.create(this));
            this.isMetaInstance = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsMetaInstanceNodeGen.create(this));
            this.getMetaQualifiedName = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetMetaQualifiedNameNodeGen.create(this));
            this.getMetaSimpleName = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetMetaSimpleNameNodeGen.create(this));
            this.hasMetaParents = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.HasMetaParentsNodeGen.create(this));
            this.getMetaParents = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetMetaParentsNodeGen.create(this));
            this.hasIterator = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.HasIteratorNodeGen.create(this));
            this.getIterator = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetIteratorNodeGen.create(this));
            this.isIterator = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.IsIteratorNodeGen.create(this));
            this.hasIteratorNextElement = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.HasIteratorNextElementNodeGen.create(this));
            this.getIteratorNextElement = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetIteratorNextElementNodeGen.create(this));
            this.hasHashEntries = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.HasHashEntriesNodeGen.create(this));
            this.getHashSize = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetHashSizeNodeGen.create(this));
            this.hasHashEntry = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.HasHashEntryNodeGen.create(this));
            this.getHashValue = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetHashValueNodeGen.create(this));
            this.getHashValueOrDefault = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetHashValueOrDefaultNodeGen.create(this));
            this.putHashEntry = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.PutHashEntryNodeGen.create(this));
            this.removeHashEntry = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.RemoveHashEntryNodeGen.create(this));
            this.getHashEntriesIterator = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetHashEntriesIteratorNodeGen.create(this));
            this.getHashKeysIterator = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetHashKeysIteratorNodeGen.create(this));
            this.getHashValuesIterator = InteropValue.createTarget(PolyglotValueDispatchFactory.InteropValueFactory.GetHashValuesIteratorNodeGen.create(this));
        }

        @Override
        public <T> T as(Object languageContext, Object receiver, Class<T> targetType) {
            return (T)EngineAccessor.RUNTIME.callProfiled(this.asClassLiteral, languageContext, receiver, targetType);
        }

        @Override
        public <T> T as(Object languageContext, Object receiver, TypeLiteral<T> targetType) {
            return (T)EngineAccessor.RUNTIME.callProfiled(this.asTypeLiteral, languageContext, receiver, targetType);
        }

        @Override
        public boolean isNativePointer(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isNativePointer, languageContext, receiver);
        }

        @Override
        public boolean hasArrayElements(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.hasArrayElements, languageContext, receiver);
        }

        @Override
        public Value getArrayElement(Object languageContext, Object receiver, long index) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.getArrayElement, languageContext, receiver, index);
        }

        @Override
        public void setArrayElement(Object languageContext, Object receiver, long index, Object value2) {
            EngineAccessor.RUNTIME.callProfiled(this.setArrayElement, languageContext, receiver, index, value2);
        }

        @Override
        public boolean removeArrayElement(Object languageContext, Object receiver, long index) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.removeArrayElement, languageContext, receiver, index);
        }

        @Override
        public long getArraySize(Object languageContext, Object receiver) {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.getArraySize, languageContext, receiver);
        }

        @Override
        public boolean hasBufferElements(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.hasBufferElements, languageContext, receiver);
        }

        @Override
        public boolean isBufferWritable(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isBufferWritable, languageContext, receiver);
        }

        @Override
        public long getBufferSize(Object languageContext, Object receiver) throws UnsupportedOperationException {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.getBufferSize, languageContext, receiver);
        }

        @Override
        public byte readBufferByte(Object languageContext, Object receiver, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return (Byte)EngineAccessor.RUNTIME.callProfiled(this.readBufferByte, languageContext, receiver, byteOffset);
        }

        @Override
        public void writeBufferByte(Object languageContext, Object receiver, long byteOffset, byte value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.writeBufferByte, languageContext, receiver, byteOffset, value2);
        }

        @Override
        public short readBufferShort(Object languageContext, Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return (Short)EngineAccessor.RUNTIME.callProfiled(this.readBufferShort, languageContext, receiver, order, byteOffset);
        }

        @Override
        public void writeBufferShort(Object languageContext, Object receiver, ByteOrder order, long byteOffset, short value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.writeBufferShort, languageContext, receiver, order, byteOffset, value2);
        }

        @Override
        public int readBufferInt(Object languageContext, Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return (Integer)EngineAccessor.RUNTIME.callProfiled(this.readBufferInt, languageContext, receiver, order, byteOffset);
        }

        @Override
        public void writeBufferInt(Object languageContext, Object receiver, ByteOrder order, long byteOffset, int value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.writeBufferInt, languageContext, receiver, order, byteOffset, value2);
        }

        @Override
        public long readBufferLong(Object languageContext, Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.readBufferLong, languageContext, receiver, order, byteOffset);
        }

        @Override
        public void writeBufferLong(Object languageContext, Object receiver, ByteOrder order, long byteOffset, long value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.writeBufferLong, languageContext, receiver, order, byteOffset, value2);
        }

        @Override
        public float readBufferFloat(Object languageContext, Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return ((Float)EngineAccessor.RUNTIME.callProfiled(this.readBufferFloat, languageContext, receiver, order, byteOffset)).floatValue();
        }

        @Override
        public void writeBufferFloat(Object languageContext, Object receiver, ByteOrder order, long byteOffset, float value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.writeBufferFloat, languageContext, receiver, order, byteOffset, Float.valueOf(value2));
        }

        @Override
        public double readBufferDouble(Object languageContext, Object receiver, ByteOrder order, long byteOffset) throws UnsupportedOperationException, IndexOutOfBoundsException {
            return (Double)EngineAccessor.RUNTIME.callProfiled(this.readBufferDouble, languageContext, receiver, order, byteOffset);
        }

        @Override
        public void writeBufferDouble(Object languageContext, Object receiver, ByteOrder order, long byteOffset, double value2) throws UnsupportedOperationException, IndexOutOfBoundsException {
            EngineAccessor.RUNTIME.callProfiled(this.writeBufferDouble, languageContext, receiver, order, byteOffset, value2);
        }

        @Override
        public boolean hasMembers(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.hasMembers, languageContext, receiver);
        }

        @Override
        public Value getMember(Object languageContext, Object receiver, String key2) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.getMember, languageContext, receiver, key2);
        }

        @Override
        public boolean hasMember(Object languageContext, Object receiver, String key2) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.hasMember, languageContext, receiver, key2);
        }

        @Override
        public void putMember(Object languageContext, Object receiver, String key2, Object member) {
            EngineAccessor.RUNTIME.callProfiled(this.putMember, languageContext, receiver, key2, member);
        }

        @Override
        public boolean removeMember(Object languageContext, Object receiver, String key2) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.removeMember, languageContext, receiver, key2);
        }

        @Override
        public Set<String> getMemberKeys(Object languageContext, Object receiver) {
            Value keys2 = (Value)EngineAccessor.RUNTIME.callProfiled(this.getMemberKeys, languageContext, receiver);
            if (keys2 == null) {
                return Collections.emptySet();
            }
            return new MemberSet(languageContext, receiver, keys2);
        }

        @Override
        public long asNativePointer(Object languageContext, Object receiver) {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.asNativePointer, languageContext, receiver);
        }

        @Override
        public boolean isDate(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isDate, languageContext, receiver);
        }

        @Override
        public LocalDate asDate(Object languageContext, Object receiver) {
            return (LocalDate)EngineAccessor.RUNTIME.callProfiled(this.asDate, languageContext, receiver);
        }

        @Override
        public boolean isTime(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isTime, languageContext, receiver);
        }

        @Override
        public LocalTime asTime(Object languageContext, Object receiver) {
            return (LocalTime)EngineAccessor.RUNTIME.callProfiled(this.asTime, languageContext, receiver);
        }

        @Override
        public boolean isTimeZone(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isTimeZone, languageContext, receiver);
        }

        @Override
        public ZoneId asTimeZone(Object languageContext, Object receiver) {
            return (ZoneId)EngineAccessor.RUNTIME.callProfiled(this.asTimeZone, languageContext, receiver);
        }

        @Override
        public Instant asInstant(Object languageContext, Object receiver) {
            return (Instant)EngineAccessor.RUNTIME.callProfiled(this.asInstant, languageContext, receiver);
        }

        @Override
        public boolean isDuration(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isDuration, languageContext, receiver);
        }

        @Override
        public Duration asDuration(Object languageContext, Object receiver) {
            return (Duration)EngineAccessor.RUNTIME.callProfiled(this.asDuration, languageContext, receiver);
        }

        @Override
        public boolean isHostObject(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object prev = InteropValue.hostEnter(context2);
            try {
                boolean bl = this.getEngine().host.isHostObject(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, prev);
            }
        }

        private PolyglotEngineImpl getEngine() {
            return this.languageInstance.sharing.engine;
        }

        @Override
        public boolean isProxyObject(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object prev = InteropValue.hostEnter(context2);
            try {
                boolean bl = this.getEngine().host.isHostProxy(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, prev);
            }
        }

        @Override
        public Object asProxyObject(Object languageContext, Object receiver) {
            if (this.isProxyObject(languageContext, receiver)) {
                return this.getEngine().host.unboxProxyObject(receiver);
            }
            return super.asProxyObject(languageContext, receiver);
        }

        @Override
        public Object asHostObject(Object languageContext, Object receiver) {
            if (this.isHostObject(languageContext, receiver)) {
                return this.getEngine().host.unboxHostObject(receiver);
            }
            return super.asHostObject(languageContext, receiver);
        }

        @Override
        public boolean isNull(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isNull, languageContext, receiver);
        }

        @Override
        public boolean canExecute(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.canExecute, languageContext, receiver);
        }

        @Override
        public void executeVoid(Object languageContext, Object receiver, Object[] arguments) {
            EngineAccessor.RUNTIME.callProfiled(this.executeVoid, languageContext, receiver, arguments);
        }

        @Override
        public void executeVoid(Object languageContext, Object receiver) {
            EngineAccessor.RUNTIME.callProfiled(this.executeVoidNoArgs, languageContext, receiver);
        }

        @Override
        public Value execute(Object languageContext, Object receiver, Object[] arguments) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.execute, languageContext, receiver, arguments);
        }

        @Override
        public Value execute(Object languageContext, Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.executeNoArgs, languageContext, receiver);
        }

        @Override
        public boolean canInstantiate(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.canInstantiate, languageContext, receiver);
        }

        @Override
        public Value newInstance(Object languageContext, Object receiver, Object[] arguments) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.newInstance, languageContext, receiver, arguments);
        }

        @Override
        public boolean canInvoke(Object languageContext, String identifier, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.canInvoke, languageContext, receiver, identifier);
        }

        @Override
        public Value invoke(Object languageContext, Object receiver, String identifier, Object[] arguments) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.invoke, languageContext, receiver, identifier, arguments);
        }

        @Override
        public Value invoke(Object languageContext, Object receiver, String identifier) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.invokeNoArgs, languageContext, receiver, identifier);
        }

        @Override
        public boolean isException(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isException, languageContext, receiver);
        }

        @Override
        public RuntimeException throwException(Object languageContext, Object receiver) {
            EngineAccessor.RUNTIME.callProfiled(this.throwException, languageContext, receiver);
            throw super.throwException(languageContext, receiver);
        }

        @Override
        public boolean isNumber(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = UNCACHED_INTEROP.isNumber(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean fitsInByte(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInByte(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public byte asByte(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                byte by = UNCACHED_INTEROP.asByte(receiver);
                return by;
            }
            catch (UnsupportedMessageException e2) {
                byte by = InteropValue.asByteUnsupported(context2, receiver);
                return by;
            }
            catch (Throwable e3) {
                throw InteropValue.guestToHostException(context2, e3, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean isString(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = UNCACHED_INTEROP.isString(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public String asString(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                if (PolyglotValueDispatch.isNullUncached(receiver)) {
                    String string = null;
                    return string;
                }
                String string = UNCACHED_INTEROP.asString(receiver);
                return string;
            }
            catch (UnsupportedMessageException e2) {
                String string = InteropValue.asStringUnsupported(context2, receiver);
                return string;
            }
            catch (Throwable e3) {
                throw InteropValue.guestToHostException(context2, e3, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean fitsInInt(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInInt(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public int asInt(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                int n = UNCACHED_INTEROP.asInt(receiver);
                return n;
            }
            catch (UnsupportedMessageException e2) {
                int n = InteropValue.asIntUnsupported(context2, receiver);
                return n;
            }
            catch (Throwable e3) {
                throw InteropValue.guestToHostException(context2, e3, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean isBoolean(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = InteropLibrary.getFactory().getUncached().isBoolean(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean asBoolean(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = InteropLibrary.getFactory().getUncached().asBoolean(receiver);
                return bl;
            }
            catch (UnsupportedMessageException e2) {
                boolean bl = InteropValue.asBooleanUnsupported(context2, receiver);
                return bl;
            }
            catch (Throwable e3) {
                throw InteropValue.guestToHostException(context2, e3, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean fitsInFloat(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = InteropLibrary.getFactory().getUncached().fitsInFloat(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public float asFloat(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                float f = UNCACHED_INTEROP.asFloat(receiver);
                return f;
            }
            catch (UnsupportedMessageException e2) {
                float f = InteropValue.asFloatUnsupported(context2, receiver);
                return f;
            }
            catch (Throwable e3) {
                throw InteropValue.guestToHostException(context2, e3, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean fitsInDouble(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInDouble(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public double asDouble(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                double d2 = UNCACHED_INTEROP.asDouble(receiver);
                return d2;
            }
            catch (UnsupportedMessageException e2) {
                double d3 = InteropValue.asDoubleUnsupported(context2, receiver);
                return d3;
            }
            catch (Throwable e3) {
                throw InteropValue.guestToHostException(context2, e3, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean fitsInLong(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInLong(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public long asLong(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                long l = UNCACHED_INTEROP.asLong(receiver);
                return l;
            }
            catch (UnsupportedMessageException e2) {
                long l = InteropValue.asLongUnsupported(context2, receiver);
                return l;
            }
            catch (Throwable e3) {
                throw InteropValue.guestToHostException(context2, e3, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean fitsInBigInteger(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInBigInteger(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public BigInteger asBigInteger(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                BigInteger bigInteger = UNCACHED_INTEROP.asBigInteger(receiver);
                return bigInteger;
            }
            catch (UnsupportedMessageException e2) {
                BigInteger bigInteger = InteropValue.asBigIntegerUnsupported(context2, receiver);
                return bigInteger;
            }
            catch (Throwable e3) {
                throw InteropValue.guestToHostException(context2, e3, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean fitsInShort(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                boolean bl = UNCACHED_INTEROP.fitsInShort(receiver);
                return bl;
            }
            catch (Throwable e2) {
                throw InteropValue.guestToHostException(context2, e2, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public short asShort(Object languageContext, Object receiver) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object c = InteropValue.hostEnter(context2);
            try {
                short s2 = UNCACHED_INTEROP.asShort(receiver);
                return s2;
            }
            catch (UnsupportedMessageException e2) {
                short s3 = InteropValue.asShortUnsupported(context2, receiver);
                return s3;
            }
            catch (Throwable e3) {
                throw InteropValue.guestToHostException(context2, e3, true);
            }
            finally {
                InteropValue.hostLeave(context2, c);
            }
        }

        @Override
        public boolean isMetaObject(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isMetaObject, languageContext, receiver);
        }

        @Override
        public boolean isMetaInstance(Object languageContext, Object receiver, Object instance) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isMetaInstance, languageContext, receiver, instance);
        }

        @Override
        public String getMetaQualifiedName(Object languageContext, Object receiver) {
            return (String)EngineAccessor.RUNTIME.callProfiled(this.getMetaQualifiedName, languageContext, receiver);
        }

        @Override
        public String getMetaSimpleName(Object languageContext, Object receiver) {
            return (String)EngineAccessor.RUNTIME.callProfiled(this.getMetaSimpleName, languageContext, receiver);
        }

        @Override
        public boolean hasMetaParents(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.hasMetaParents, languageContext, receiver);
        }

        @Override
        public Value getMetaParents(Object languageContext, Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.getMetaParents, languageContext, receiver);
        }

        @Override
        public boolean hasIterator(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.hasIterator, languageContext, receiver);
        }

        @Override
        public Value getIterator(Object languageContext, Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.getIterator, languageContext, receiver);
        }

        @Override
        public boolean isIterator(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.isIterator, languageContext, receiver);
        }

        @Override
        public boolean hasIteratorNextElement(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.hasIteratorNextElement, languageContext, receiver);
        }

        @Override
        public Value getIteratorNextElement(Object languageContext, Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.getIteratorNextElement, languageContext, receiver);
        }

        @Override
        public boolean hasHashEntries(Object languageContext, Object receiver) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.hasHashEntries, languageContext, receiver);
        }

        @Override
        public long getHashSize(Object languageContext, Object receiver) {
            return (Long)EngineAccessor.RUNTIME.callProfiled(this.getHashSize, languageContext, receiver);
        }

        @Override
        public boolean hasHashEntry(Object languageContext, Object receiver, Object key2) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.hasHashEntry, languageContext, receiver, key2);
        }

        @Override
        public Value getHashValue(Object languageContext, Object receiver, Object key2) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.getHashValue, languageContext, receiver, key2);
        }

        @Override
        public Value getHashValueOrDefault(Object languageContext, Object receiver, Object key2, Object defaultValue) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.getHashValueOrDefault, languageContext, receiver, key2, defaultValue);
        }

        @Override
        public void putHashEntry(Object languageContext, Object receiver, Object key2, Object value2) {
            EngineAccessor.RUNTIME.callProfiled(this.putHashEntry, languageContext, receiver, key2, value2);
        }

        @Override
        public boolean removeHashEntry(Object languageContext, Object receiver, Object key2) {
            return (Boolean)EngineAccessor.RUNTIME.callProfiled(this.removeHashEntry, languageContext, receiver, key2);
        }

        @Override
        public Value getHashEntriesIterator(Object languageContext, Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.getHashEntriesIterator, languageContext, receiver);
        }

        @Override
        public Value getHashKeysIterator(Object languageContext, Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.getHashKeysIterator, languageContext, receiver);
        }

        @Override
        public Value getHashValuesIterator(Object languageContext, Object receiver) {
            return (Value)EngineAccessor.RUNTIME.callProfiled(this.getHashValuesIterator, languageContext, receiver);
        }

        static abstract class AsClassLiteralNode
        extends InteropNode {
            protected AsClassLiteralNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Class.class};
            }

            @Override
            protected String getOperationName() {
                return "as";
            }

            @Specialization
            final Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Cached PolyglotToHostNode toHost) {
                return toHost.execute(this, context2, receiver, (Class)args2[2], null);
            }
        }

        static abstract class AsTypeLiteralNode
        extends InteropNode {
            protected AsTypeLiteralNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, TypeLiteral.class};
            }

            @Override
            protected String getOperationName() {
                return "as";
            }

            @Specialization
            final Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Cached PolyglotToHostNode toHost) {
                TypeLiteral typeLiteral = (TypeLiteral)args2[2];
                return toHost.execute(this, context2, receiver, typeLiteral.getRawType(), typeLiteral.getType());
            }
        }

        static abstract class IsNativePointerNode
        extends InteropNode {
            protected IsNativePointerNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isNativePointer";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary natives) {
                return natives.isPointer(receiver);
            }
        }

        static abstract class AsNativePointerNode
        extends InteropNode {
            protected AsNativePointerNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asNativePointer";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary natives, @Cached InlinedBranchProfile unsupported) {
                try {
                    return natives.asPointer(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.cannotConvert(context2, receiver, Long.TYPE, "asNativePointer()", "isNativeObject()", "Value cannot be converted to a native pointer.");
                }
            }
        }

        static abstract class HasArrayElementsNode
        extends InteropNode {
            protected HasArrayElementsNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasArrayElements";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary arrays) {
                return arrays.hasArrayElements(receiver);
            }
        }

        static abstract class GetArrayElementNode
        extends InteropNode {
            protected GetArrayElementNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "getArrayElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile unknown) {
                long index = (Long)args2[2];
                try {
                    return toHost.execute(node, context2, arrays.readArrayElement(receiver, index));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    return PolyglotValueDispatch.getArrayElementUnsupported(context2, receiver);
                }
                catch (InvalidArrayIndexException e3) {
                    unknown.enter(node);
                    throw PolyglotValueDispatch.invalidArrayIndex(context2, receiver, index);
                }
            }
        }

        static abstract class SetArrayElementNode
        extends InteropNode {
            protected SetArrayElementNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class, null};
            }

            @Override
            protected String getOperationName() {
                return "setArrayElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached(inline=true) PolyglotLanguageContext.ToGuestValueNode toGuestValue, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidIndex, @Cached InlinedBranchProfile invalidValue) {
                long index = (Long)args2[2];
                Object value2 = toGuestValue.execute(node, context2, args2[3]);
                try {
                    arrays.writeArrayElement(receiver, index, value2);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    PolyglotValueDispatch.setArrayElementUnsupported(context2, receiver);
                }
                catch (UnsupportedTypeException e3) {
                    invalidValue.enter(node);
                    throw PolyglotValueDispatch.invalidArrayValue(context2, receiver, index, value2);
                }
                catch (InvalidArrayIndexException e4) {
                    invalidIndex.enter(node);
                    throw PolyglotValueDispatch.invalidArrayIndex(context2, receiver, index);
                }
                return null;
            }
        }

        static abstract class RemoveArrayElementNode
        extends InteropNode {
            protected RemoveArrayElementNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "removeArrayElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidIndex) {
                Boolean value2;
                long index = (Long)args2[2];
                try {
                    arrays.removeArrayElement(receiver, index);
                    value2 = Boolean.TRUE;
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.removeArrayElementUnsupported(context2, receiver);
                }
                catch (InvalidArrayIndexException e3) {
                    invalidIndex.enter(node);
                    throw PolyglotValueDispatch.invalidArrayIndex(context2, receiver, index);
                }
                return value2;
            }
        }

        static abstract class GetArraySizeNode
        extends InteropNode {
            protected GetArraySizeNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getArraySize";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary arrays, @Cached InlinedBranchProfile unsupported) {
                try {
                    return arrays.getArraySize(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    return PolyglotValueDispatch.getArraySizeUnsupported(context2, receiver);
                }
            }
        }

        static abstract class HasBufferElementsNode
        extends InteropNode {
            protected HasBufferElementsNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasBufferElements";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers) {
                return buffers.hasBufferElements(receiver);
            }
        }

        static abstract class IsBufferWritableNode
        extends InteropNode {
            protected IsBufferWritableNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isBufferWritable";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached InlinedBranchProfile unsupported) {
                try {
                    return buffers.isBufferWritable(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.getBufferSizeUnsupported(context2, receiver);
                }
            }
        }

        static abstract class GetBufferSizeNode
        extends InteropNode {
            protected GetBufferSizeNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getBufferSize";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached InlinedBranchProfile unsupported) {
                try {
                    return buffers.getBufferSize(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.getBufferSizeUnsupported(context2, receiver);
                }
            }
        }

        static abstract class ReadBufferByteNode
        extends InteropNode {
            protected ReadBufferByteNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferByte";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile unknown) {
                long byteOffset = (Long)args2[2];
                try {
                    return buffers.readBufferByte(receiver, byteOffset);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.readBufferByteUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    unknown.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
            }
        }

        static abstract class WriteBufferByteNode
        extends InteropNode {
            protected WriteBufferByteNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Long.class, Byte.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferByte";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidIndex, @Cached InlinedBranchProfile invalidValue) {
                long byteOffset = (Long)args2[2];
                byte value2 = (Byte)args2[3];
                try {
                    buffers.writeBufferByte(receiver, byteOffset, value2);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferByte()", "isBufferWritable()");
                    }
                    throw PolyglotValueDispatch.writeBufferByteUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    invalidIndex.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferShortNode
        extends InteropNode {
            protected ReadBufferShortNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferShort";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile unknown) {
                ByteOrder order = (ByteOrder)args2[2];
                long byteOffset = (Long)args2[3];
                try {
                    return buffers.readBufferShort(receiver, order, byteOffset);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.readBufferShortUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    unknown.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
            }
        }

        static abstract class WriteBufferShortNode
        extends InteropNode {
            protected WriteBufferShortNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class, Short.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferShort";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidIndex, @Cached InlinedBranchProfile invalidValue) {
                ByteOrder order = (ByteOrder)args2[2];
                long byteOffset = (Long)args2[3];
                short value2 = (Short)args2[4];
                try {
                    buffers.writeBufferShort(receiver, order, byteOffset, value2);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferShort()", "isBufferWritable()");
                    }
                    throw PolyglotValueDispatch.writeBufferShortUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    invalidIndex.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferIntNode
        extends InteropNode {
            protected ReadBufferIntNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferInt";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile unknown) {
                ByteOrder order = (ByteOrder)args2[2];
                long byteOffset = (Long)args2[3];
                try {
                    return buffers.readBufferInt(receiver, order, byteOffset);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.readBufferIntUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    unknown.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
            }
        }

        static abstract class WriteBufferIntNode
        extends InteropNode {
            protected WriteBufferIntNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class, Integer.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferInt";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidIndex, @Cached InlinedBranchProfile invalidValue) {
                ByteOrder order = (ByteOrder)args2[2];
                long byteOffset = (Long)args2[3];
                int value2 = (Integer)args2[4];
                try {
                    buffers.writeBufferInt(receiver, order, byteOffset, value2);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferInt()", "isBufferWritable()");
                    }
                    throw PolyglotValueDispatch.writeBufferIntUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    invalidIndex.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferLongNode
        extends InteropNode {
            protected ReadBufferLongNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferLong";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile unknown) {
                ByteOrder order = (ByteOrder)args2[2];
                long byteOffset = (Long)args2[3];
                try {
                    return buffers.readBufferLong(receiver, order, byteOffset);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.readBufferLongUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    unknown.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
            }
        }

        static abstract class WriteBufferLongNode
        extends InteropNode {
            protected WriteBufferLongNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferLong";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidIndex, @Cached InlinedBranchProfile invalidValue) {
                ByteOrder order = (ByteOrder)args2[2];
                long byteOffset = (Long)args2[3];
                long value2 = (Long)args2[4];
                try {
                    buffers.writeBufferLong(receiver, order, byteOffset, value2);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferLong()", "isBufferWritable()");
                    }
                    throw PolyglotValueDispatch.writeBufferLongUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    invalidIndex.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferFloatNode
        extends InteropNode {
            protected ReadBufferFloatNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferFloat";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile unknown) {
                ByteOrder order = (ByteOrder)args2[2];
                long byteOffset = (Long)args2[3];
                try {
                    return Float.valueOf(buffers.readBufferFloat(receiver, order, byteOffset));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.readBufferFloatUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    unknown.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
            }
        }

        static abstract class WriteBufferFloatNode
        extends InteropNode {
            protected WriteBufferFloatNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class, Float.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferFloat";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidIndex) {
                ByteOrder order = (ByteOrder)args2[2];
                long byteOffset = (Long)args2[3];
                float value2 = ((Float)args2[4]).floatValue();
                try {
                    buffers.writeBufferFloat(receiver, order, byteOffset, value2);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferFloat()", "isBufferWritable()");
                    }
                    throw PolyglotValueDispatch.writeBufferFloatUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    invalidIndex.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
                return null;
            }
        }

        static abstract class ReadBufferDoubleNode
        extends InteropNode {
            protected ReadBufferDoubleNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class};
            }

            @Override
            protected String getOperationName() {
                return "readBufferDouble";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile unknown) {
                ByteOrder order = (ByteOrder)args2[2];
                long byteOffset = (Long)args2[3];
                try {
                    return buffers.readBufferDouble(receiver, order, byteOffset);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.readBufferDoubleUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    unknown.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
            }
        }

        static abstract class WriteBufferDoubleNode
        extends InteropNode {
            protected WriteBufferDoubleNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, ByteOrder.class, Long.class, Double.class};
            }

            @Override
            protected String getOperationName() {
                return "writeBufferDouble";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary buffers, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidIndex, @Cached InlinedBranchProfile invalidValue) {
                ByteOrder order = (ByteOrder)args2[2];
                long byteOffset = (Long)args2[3];
                double value2 = (Double)args2[4];
                try {
                    buffers.writeBufferDouble(receiver, order, byteOffset, value2);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (buffers.hasBufferElements(receiver)) {
                        throw PolyglotValueDispatch.unsupported(context2, receiver, "writeBufferDouble()", "isBufferWritable()");
                    }
                    throw PolyglotValueDispatch.writeBufferDoubleUnsupported(context2, receiver);
                }
                catch (InvalidBufferOffsetException e3) {
                    invalidIndex.enter(node);
                    throw PolyglotValueDispatch.invalidBufferIndex(context2, receiver, e3.getByteOffset(), e3.getLength());
                }
                return null;
            }
        }

        static abstract class HasMemberNode
        extends AbstractMemberInfoNode {
            protected HasMemberNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "hasMember";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects) {
                String key2 = (String)args2[2];
                return objects.isMemberExisting(receiver, key2);
            }
        }

        static abstract class GetMemberNode
        extends InteropNode {
            protected GetMemberNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }

            @Override
            protected String getOperationName() {
                return "getMember";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile unknown) {
                Value value2;
                String key2 = (String)args2[2];
                try {
                    assert (key2 != null) : "should be handled already";
                    value2 = toHost.execute(node, context2, objects.readMember(receiver, key2));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (objects.hasMembers(receiver)) {
                        value2 = null;
                    }
                    return PolyglotValueDispatch.getMemberUnsupported(context2, receiver, key2);
                }
                catch (UnknownIdentifierException e3) {
                    unknown.enter(node);
                    value2 = null;
                }
                return value2;
            }
        }

        static abstract class PutMemberNode
        extends InteropNode {
            protected PutMemberNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "putMember";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class, null};
            }

            @Specialization
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(limit="CACHE_LIMIT") InteropLibrary objects, @Cached(inline=true) PolyglotLanguageContext.ToGuestValueNode toGuestValue, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidValue, @Cached InlinedBranchProfile unknown) {
                String key2 = (String)args2[2];
                Object originalValue = args2[3];
                Object value2 = toGuestValue.execute(node, context2, originalValue);
                assert (key2 != null);
                try {
                    objects.writeMember(receiver, key2, value2);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.putMemberUnsupported(context2, receiver);
                }
                catch (UnknownIdentifierException e3) {
                    unknown.enter(node);
                    throw PolyglotValueDispatch.nonWritableMemberKey(context2, receiver, key2);
                }
                catch (UnsupportedTypeException e4) {
                    invalidValue.enter(node);
                    throw PolyglotValueDispatch.invalidMemberValue(context2, receiver, key2, value2);
                }
                return null;
            }
        }

        static abstract class RemoveMemberNode
        extends InteropNode {
            protected RemoveMemberNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "removeMember";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile unknown) {
                Boolean value2;
                String key2 = (String)args2[2];
                try {
                    assert (key2 != null) : "should be handled already";
                    objects.removeMember(receiver, key2);
                    value2 = Boolean.TRUE;
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (!objects.hasMembers(receiver)) {
                        throw PolyglotValueDispatch.removeMemberUnsupported(context2, receiver);
                    }
                    if (objects.isMemberExisting(receiver, key2)) {
                        throw PolyglotValueDispatch.nonRemovableMemberKey(context2, receiver, key2);
                    }
                    value2 = Boolean.FALSE;
                }
                catch (UnknownIdentifierException e3) {
                    unknown.enter(node);
                    if (objects.isMemberExisting(receiver, key2)) {
                        throw PolyglotValueDispatch.nonRemovableMemberKey(context2, receiver, key2);
                    }
                    value2 = Boolean.FALSE;
                }
                return value2;
            }
        }

        static abstract class IsNullNode
        extends InteropNode {
            protected IsNullNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isNull";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary values2) {
                return values2.isNull(receiver);
            }
        }

        static abstract class ExecuteNode
        extends InteropNode {
            protected ExecuteNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object[].class};
            }

            @Specialization
            final Object doDefault(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Cached PolyglotLanguageContext.ToHostValueNode toHostValue, @Cached SharedExecuteNode executeNode) {
                return toHostValue.execute(this, context2, executeNode.executeShared(this, context2, receiver, (Object[])args2[2]));
            }

            @Override
            protected String getOperationName() {
                return "execute";
            }
        }

        static abstract class ExecuteNoArgsNode
        extends InteropNode {
            protected ExecuteNoArgsNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Specialization
            final Object doDefault(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Cached PolyglotLanguageContext.ToHostValueNode toHostValue, @Cached SharedExecuteNode executeNode) {
                return toHostValue.execute(this, context2, executeNode.executeShared(this, context2, receiver, ExecuteVoidNoArgsNode.NO_ARGS));
            }

            @Override
            protected String getOperationName() {
                return "execute";
            }
        }

        static abstract class ExecuteVoidNode
        extends InteropNode {
            protected ExecuteVoidNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object[].class};
            }

            @Specialization
            final Object doDefault(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Cached SharedExecuteNode executeNode) {
                executeNode.executeShared(this, context2, receiver, (Object[])args2[2]);
                return null;
            }

            @Override
            protected String getOperationName() {
                return "executeVoid";
            }
        }

        static abstract class ExecuteVoidNoArgsNode
        extends InteropNode {
            private static final Object[] NO_ARGS = new Object[0];

            protected ExecuteVoidNoArgsNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Specialization
            final Object doDefault(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Cached SharedExecuteNode executeNode) {
                executeNode.executeShared(this, context2, receiver, NO_ARGS);
                return null;
            }

            @Override
            protected String getOperationName() {
                return "executeVoid";
            }
        }

        static abstract class NewInstanceNode
        extends InteropNode {
            protected NewInstanceNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object[].class};
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary instantiables, @Cached PolyglotLanguageContext.ToGuestValuesNode toGuestValues, @Cached PolyglotLanguageContext.ToHostValueNode toHostValue, @Cached InlinedBranchProfile arity, @Cached InlinedBranchProfile invalidArgument, @Cached InlinedBranchProfile unsupported) {
                Object[] instantiateArguments = toGuestValues.execute(node, context2, (Object[])args2[2]);
                try {
                    return toHostValue.execute(node, context2, instantiables.instantiate(receiver, instantiateArguments));
                }
                catch (UnsupportedTypeException e2) {
                    invalidArgument.enter(node);
                    throw PolyglotValueDispatch.invalidInstantiateArgumentType(context2, receiver, instantiateArguments);
                }
                catch (ArityException e3) {
                    arity.enter(node);
                    throw PolyglotValueDispatch.invalidInstantiateArity(context2, receiver, instantiateArguments, e3.getExpectedMinArity(), e3.getExpectedMaxArity(), e3.getActualArity());
                }
                catch (UnsupportedMessageException e4) {
                    unsupported.enter(node);
                    return PolyglotValueDispatch.newInstanceUnsupported(context2, receiver);
                }
            }

            @Override
            protected String getOperationName() {
                return "newInstance";
            }
        }

        static abstract class CanInstantiateNode
        extends InteropNode {
            protected CanInstantiateNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "canInstantiate";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary instantiables) {
                return instantiables.isInstantiable(receiver);
            }
        }

        static abstract class CanExecuteNode
        extends InteropNode {
            protected CanExecuteNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "canExecute";
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary executables) {
                return executables.isExecutable(receiver);
            }
        }

        static abstract class CanInvokeNode
        extends AbstractMemberInfoNode {
            protected CanInvokeNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected String getOperationName() {
                return "canInvoke";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects) {
                String key2 = (String)args2[2];
                return objects.isMemberInvocable(receiver, key2);
            }
        }

        static abstract class InvokeNode
        extends InteropNode {
            protected InvokeNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class, Object[].class};
            }

            @Override
            protected String getOperationName() {
                return "invoke";
            }

            @Specialization
            final Object doDefault(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Cached SharedInvokeNode sharedInvoke, @Cached PolyglotLanguageContext.ToGuestValuesNode toGuestValues) {
                String key2 = (String)args2[2];
                Object[] guestArguments = toGuestValues.execute(this, context2, (Object[])args2[3]);
                return sharedInvoke.executeShared(this, context2, receiver, key2, guestArguments);
            }
        }

        static abstract class InvokeNoArgsNode
        extends InteropNode {
            protected InvokeNoArgsNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }

            @Override
            protected String getOperationName() {
                return "invoke";
            }

            @Specialization
            final Object doDefault(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Cached SharedInvokeNode sharedInvoke) {
                String key2 = (String)args2[2];
                return sharedInvoke.executeShared(this, context2, receiver, key2, ExecuteVoidNoArgsNode.NO_ARGS);
            }
        }

        static abstract class HasMembersNode
        extends InteropNode {
            protected HasMembersNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasMembers";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.hasMembers(receiver);
            }
        }

        static abstract class GetMemberKeysNode
        extends InteropNode {
            protected GetMemberKeysNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getMemberKeys";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported) {
                try {
                    return toHost.execute(node, context2, objects.getMembers(receiver));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    return null;
                }
            }
        }

        static abstract class IsDateNode
        extends InteropNode {
            protected IsDateNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isDate";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isDate(receiver);
            }
        }

        static abstract class AsDateNode
        extends InteropNode {
            protected AsDateNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asDate";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached InlinedBranchProfile unsupported) {
                try {
                    return objects.asDate(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asDate()", "isDate()", "Value does not contain date information.");
                }
            }
        }

        static abstract class IsTimeNode
        extends InteropNode {
            protected IsTimeNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isTime";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isTime(receiver);
            }
        }

        static abstract class AsTimeNode
        extends InteropNode {
            protected AsTimeNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asTime";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached InlinedBranchProfile unsupported) {
                try {
                    return objects.asTime(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asTime()", "isTime()", "Value does not contain time information.");
                }
            }
        }

        static abstract class IsTimeZoneNode
        extends InteropNode {
            protected IsTimeZoneNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isTimeZone";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isTimeZone(receiver);
            }
        }

        static abstract class AsTimeZoneNode
        extends InteropNode {
            protected AsTimeZoneNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asTimeZone";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached InlinedBranchProfile unsupported) {
                try {
                    return objects.asTimeZone(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asTimeZone()", "isTimeZone()", "Value does not contain time-zone information.");
                }
            }
        }

        static abstract class AsInstantNode
        extends InteropNode {
            protected AsInstantNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getInstant";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached InlinedBranchProfile unsupported) {
                try {
                    return objects.asInstant(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asInstant()", "hasInstant()", "Value does not contain instant information.");
                }
            }
        }

        static abstract class IsDurationNode
        extends InteropNode {
            protected IsDurationNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isDuration";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isDuration(receiver);
            }
        }

        static abstract class AsDurationNode
        extends InteropNode {
            protected AsDurationNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "asDuration";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached InlinedBranchProfile unsupported) {
                try {
                    return objects.asDuration(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (objects.isNull(receiver)) {
                        return null;
                    }
                    throw PolyglotValueDispatch.cannotConvert(context2, receiver, null, "asDuration()", "isDuration()", "Value does not contain duration information.");
                }
            }
        }

        static abstract class IsExceptionNode
        extends InteropNode {
            protected IsExceptionNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isException";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isException(receiver);
            }
        }

        static abstract class ThrowExceptionNode
        extends InteropNode {
            protected ThrowExceptionNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "throwException";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached InlinedBranchProfile unsupported) {
                try {
                    throw objects.throwException(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.unsupported(context2, receiver, "throwException()", "isException()");
                }
            }
        }

        static abstract class IsMetaObjectNode
        extends InteropNode {
            protected IsMetaObjectNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isMetaObject";
            }

            @Specialization(limit="CACHE_LIMIT")
            static boolean doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects) {
                return objects.isMetaObject(receiver);
            }
        }

        static abstract class IsMetaInstanceNode
        extends InteropNode {
            protected IsMetaInstanceNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, null};
            }

            @Override
            protected String getOperationName() {
                return "isMetaInstance";
            }

            @Specialization(limit="CACHE_LIMIT")
            static boolean doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached(inline=true) PolyglotLanguageContext.ToGuestValueNode toGuest, @Cached InlinedBranchProfile unsupported) {
                try {
                    return objects.isMetaInstance(receiver, toGuest.execute(node, context2, args2[2]));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.unsupported(context2, receiver, "isMetaInstance()", "isMetaObject()");
                }
            }
        }

        static abstract class GetMetaQualifiedNameNode
        extends InteropNode {
            protected GetMetaQualifiedNameNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getMetaQualifiedName";
            }

            @Specialization(limit="CACHE_LIMIT")
            static String doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @CachedLibrary(limit="1") InteropLibrary toString2, @Cached InlinedBranchProfile unsupported) {
                try {
                    return toString2.asString(objects.getMetaQualifiedName(receiver));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.unsupported(context2, receiver, "getMetaQualifiedName()", "isMetaObject()");
                }
            }
        }

        static abstract class GetMetaSimpleNameNode
        extends InteropNode {
            protected GetMetaSimpleNameNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getMetaSimpleName";
            }

            @Specialization(limit="CACHE_LIMIT")
            static String doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @CachedLibrary(limit="1") InteropLibrary toString2, @Cached InlinedBranchProfile unsupported) {
                try {
                    return toString2.asString(objects.getMetaSimpleName(receiver));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.unsupported(context2, receiver, "getMetaSimpleName()", "isMetaObject()");
                }
            }
        }

        static abstract class HasMetaParentsNode
        extends InteropNode {
            protected HasMetaParentsNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasMetaParents";
            }

            @Specialization(limit="CACHE_LIMIT")
            static boolean doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached InlinedBranchProfile unsupported) {
                return objects.hasMetaParents(receiver);
            }
        }

        static abstract class GetMetaParentsNode
        extends InteropNode {
            protected GetMetaParentsNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getMetaParents";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported) {
                try {
                    return toHost.execute(node, context2, objects.getMetaParents(receiver));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.unsupported(context2, receiver, "getMetaParents()", "hasMetaParents()");
                }
            }
        }

        static abstract class HasIteratorNode
        extends InteropNode {
            protected HasIteratorNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary iterators) {
                return iterators.hasIterator(receiver);
            }
        }

        static abstract class GetIteratorNode
        extends InteropNode {
            protected GetIteratorNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary iterators, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported) {
                try {
                    return toHost.execute(node, context2, iterators.getIterator(receiver));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    return PolyglotValueDispatch.getIteratorUnsupported(context2, receiver);
                }
            }
        }

        static abstract class IsIteratorNode
        extends InteropNode {
            protected IsIteratorNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "isIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary iterators) {
                return iterators.isIterator(receiver);
            }
        }

        static abstract class HasIteratorNextElementNode
        extends InteropNode {
            protected HasIteratorNextElementNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasIteratorNextElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary iterators, @Cached InlinedBranchProfile unsupported) {
                try {
                    return iterators.hasIteratorNextElement(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    return PolyglotValueDispatch.hasIteratorNextElementUnsupported(context2, receiver);
                }
            }
        }

        static abstract class GetIteratorNextElementNode
        extends InteropNode {
            protected GetIteratorNextElementNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getIteratorNextElement";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary iterators, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile stop) {
                try {
                    return toHost.execute(node, context2, iterators.getIteratorNextElement(receiver));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.nonReadableIteratorElement();
                }
                catch (StopIterationException e3) {
                    stop.enter(node);
                    throw PolyglotValueDispatch.stopIteration(context2, receiver);
                }
            }
        }

        static abstract class HasHashEntriesNode
        extends InteropNode {
            protected HasHashEntriesNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "hasHashEntries";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary hashes) {
                return hashes.hasHashEntries(receiver);
            }
        }

        static abstract class GetHashSizeNode
        extends InteropNode {
            protected GetHashSizeNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getHashSize";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached InlinedBranchProfile unsupported) {
                try {
                    return hashes.getHashSize(receiver);
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.getHashSizeUnsupported(context2, receiver);
                }
            }
        }

        static abstract class HasHashEntryNode
        extends InteropNode {
            protected HasHashEntryNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object.class};
            }

            @Override
            protected String getOperationName() {
                return "hasHashEntry";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached(inline=true) PolyglotLanguageContext.ToGuestValueNode toGuestKey) {
                Object hostKey = args2[2];
                Object key2 = toGuestKey.execute(node, context2, hostKey);
                return hashes.isHashEntryExisting(receiver, key2);
            }
        }

        static abstract class GetHashValueNode
        extends InteropNode {
            protected GetHashValueNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object.class};
            }

            @Override
            protected String getOperationName() {
                return "getHashValue";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached(inline=true) PolyglotLanguageContext.ToGuestValueNode toGuestKey, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidKey) {
                Object hostKey = args2[2];
                Object key2 = toGuestKey.execute(node, context2, hostKey);
                try {
                    return toHost.execute(node, context2, hashes.readHashValue(receiver, key2));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.getHashValueUnsupported(context2, receiver, key2);
                }
                catch (UnknownKeyException e3) {
                    invalidKey.enter(node);
                    if (hashes.isHashEntryExisting(receiver, key2)) {
                        throw PolyglotValueDispatch.getHashValueUnsupported(context2, receiver, key2);
                    }
                    return null;
                }
            }
        }

        static abstract class GetHashValueOrDefaultNode
        extends InteropNode {
            protected GetHashValueOrDefaultNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object.class, Object.class};
            }

            @Override
            protected String getOperationName() {
                return "getHashValueOrDefault";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached(inline=true) PolyglotLanguageContext.ToGuestValueNode toGuestKey, @Cached(inline=true) PolyglotLanguageContext.ToGuestValueNode toGuestDefaultValue, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidKey) {
                Object hostKey = args2[2];
                Object hostDefaultValue = args2[3];
                Object key2 = toGuestKey.execute(node, context2, hostKey);
                Object defaultValue = toGuestDefaultValue.execute(node, context2, hostDefaultValue);
                try {
                    return toHost.execute(node, context2, hashes.readHashValueOrDefault(receiver, key2, hostDefaultValue));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.getHashValueUnsupported(context2, receiver, key2);
                }
            }
        }

        static abstract class PutHashEntryNode
        extends InteropNode {
            protected PutHashEntryNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object.class, Object.class};
            }

            @Override
            protected String getOperationName() {
                return "putHashEntry";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached(inline=true) PolyglotLanguageContext.ToGuestValueNode toGuestKey, @Cached(inline=true) PolyglotLanguageContext.ToGuestValueNode toGuestValue, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidKey, @Cached InlinedBranchProfile invalidValue) {
                Object hostKey = args2[2];
                Object hostValue = args2[3];
                Object key2 = toGuestKey.execute(node, context2, hostKey);
                Object value2 = toGuestValue.execute(node, context2, hostValue);
                try {
                    hashes.writeHashEntry(receiver, key2, value2);
                }
                catch (UnknownKeyException | UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.putHashEntryUnsupported(context2, receiver, key2, value2);
                }
                catch (UnsupportedTypeException e3) {
                    invalidValue.enter(node);
                    throw PolyglotValueDispatch.invalidHashValue(context2, receiver, key2, value2);
                }
                return null;
            }
        }

        static abstract class RemoveHashEntryNode
        extends InteropNode {
            protected RemoveHashEntryNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, Object.class};
            }

            @Override
            protected String getOperationName() {
                return "removeHashEntry";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached(inline=true) PolyglotLanguageContext.ToGuestValueNode toGuestKey, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile invalidKey) {
                Boolean result;
                Object hostKey = args2[2];
                Object key2 = toGuestKey.execute(node, context2, hostKey);
                try {
                    hashes.removeHashEntry(receiver, key2);
                    result = Boolean.TRUE;
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    if (!hashes.hasHashEntries(receiver) || hashes.isHashEntryExisting(receiver, key2)) {
                        throw PolyglotValueDispatch.removeHashEntryUnsupported(context2, receiver, key2);
                    }
                    result = Boolean.FALSE;
                }
                catch (UnknownKeyException e3) {
                    invalidKey.enter(node);
                    result = Boolean.FALSE;
                }
                return result;
            }
        }

        static abstract class GetHashEntriesIteratorNode
        extends InteropNode {
            GetHashEntriesIteratorNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getHashEntriesIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported) {
                try {
                    return toHost.execute(node, context2, hashes.getHashEntriesIterator(receiver));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.getHashEntriesIteratorUnsupported(context2, receiver);
                }
            }
        }

        static abstract class GetHashKeysIteratorNode
        extends InteropNode {
            GetHashKeysIteratorNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getHashKeysIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported) {
                try {
                    return toHost.execute(node, context2, hashes.getHashKeysIterator(receiver));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.getHashEntriesIteratorUnsupported(context2, receiver);
                }
            }
        }

        static abstract class GetHashValuesIteratorNode
        extends InteropNode {
            GetHashValuesIteratorNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType};
            }

            @Override
            protected String getOperationName() {
                return "getHashValuesIterator";
            }

            @Specialization(limit="CACHE_LIMIT")
            static Object doCached(PolyglotLanguageContext context2, Object receiver, Object[] args2, @Bind(value="this") Node node, @CachedLibrary(value="receiver") InteropLibrary hashes, @Cached PolyglotLanguageContext.ToHostValueNode toHost, @Cached InlinedBranchProfile unsupported) {
                try {
                    return toHost.execute(node, context2, hashes.getHashValuesIterator(receiver));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.getHashEntriesIteratorUnsupported(context2, receiver);
                }
            }
        }

        private final class MemberSet
        extends AbstractSet<String> {
            private final Object context;
            private final Object receiver;
            private final Value keys;
            private int cachedSize = -1;

            MemberSet(Object languageContext, Object receiver, Value keys2) {
                this.context = languageContext;
                this.receiver = receiver;
                this.keys = keys2;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof String)) {
                    return false;
                }
                return InteropValue.this.hasMember(this.context, this.receiver, (String)o);
            }

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < MemberSet.this.size();
                    }

                    @Override
                    public String next() {
                        Value arrayElement;
                        if (this.index >= MemberSet.this.size()) {
                            throw new NoSuchElementException();
                        }
                        if ((arrayElement = MemberSet.this.keys.getArrayElement(this.index++)).isString()) {
                            return arrayElement.asString();
                        }
                        return null;
                    }
                };
            }

            @Override
            public int size() {
                int size = this.cachedSize;
                if (size != -1) {
                    return size;
                }
                this.cachedSize = size = (int)this.keys.getArraySize();
                return size;
            }
        }

        @ImportStatic(value={InteropNode.class})
        @GenerateInline(value=true)
        @GenerateCached(value=false)
        static abstract class SharedInvokeNode
        extends Node {
            SharedInvokeNode() {
            }

            protected abstract Object executeShared(Node var1, PolyglotLanguageContext var2, Object var3, String var4, Object[] var5);

            @Specialization(limit="CACHE_LIMIT")
            protected static Object doDefault(Node node, PolyglotLanguageContext context2, Object receiver, String key2, Object[] guestArguments, @CachedLibrary(value="receiver") InteropLibrary objects, @Cached PolyglotLanguageContext.ToHostValueNode toHostValue, @Cached InlinedBranchProfile invalidArgument, @Cached InlinedBranchProfile arity, @Cached InlinedBranchProfile unsupported, @Cached InlinedBranchProfile unknownIdentifier) {
                try {
                    return toHostValue.execute(node, context2, objects.invokeMember(receiver, key2, guestArguments));
                }
                catch (UnsupportedMessageException e2) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.invokeUnsupported(context2, receiver, key2);
                }
                catch (UnknownIdentifierException e3) {
                    unknownIdentifier.enter(node);
                    throw PolyglotValueDispatch.nonReadableMemberKey(context2, receiver, key2);
                }
                catch (UnsupportedTypeException e4) {
                    invalidArgument.enter(node);
                    throw PolyglotValueDispatch.invalidInvokeArgumentType(context2, receiver, key2, e4);
                }
                catch (ArityException e5) {
                    arity.enter(node);
                    throw PolyglotValueDispatch.invalidInvokeArity(context2, receiver, key2, guestArguments, e5.getExpectedMinArity(), e5.getExpectedMaxArity(), e5.getActualArity());
                }
            }
        }

        @ImportStatic(value={InteropNode.class})
        @GenerateInline(value=true)
        @GenerateCached(value=false)
        static abstract class SharedExecuteNode
        extends Node {
            SharedExecuteNode() {
            }

            protected abstract Object executeShared(Node var1, PolyglotLanguageContext var2, Object var3, Object[] var4);

            @Specialization(limit="CACHE_LIMIT")
            protected static Object doDefault(Node node, PolyglotLanguageContext context2, Object receiver, Object[] args2, @CachedLibrary(value="receiver") InteropLibrary executables, @Cached PolyglotLanguageContext.ToGuestValuesNode toGuestValues, @Cached PolyglotLanguageContext.ToHostValueNode toHostValue, @Cached InlinedBranchProfile invalidArgument, @Cached InlinedBranchProfile arity, @Cached InlinedBranchProfile unsupported) {
                Object[] guestArguments = toGuestValues.execute(node, context2, args2);
                try {
                    return executables.execute(receiver, guestArguments);
                }
                catch (UnsupportedTypeException e2) {
                    invalidArgument.enter(node);
                    throw PolyglotValueDispatch.invalidExecuteArgumentType(context2, receiver, e2);
                }
                catch (ArityException e3) {
                    arity.enter(node);
                    throw PolyglotValueDispatch.invalidExecuteArity(context2, receiver, guestArguments, e3.getExpectedMinArity(), e3.getExpectedMaxArity(), e3.getActualArity());
                }
                catch (UnsupportedMessageException e4) {
                    unsupported.enter(node);
                    throw PolyglotValueDispatch.executeUnsupported(context2, receiver);
                }
            }
        }

        private static abstract class AbstractMemberInfoNode
        extends InteropNode {
            protected AbstractMemberInfoNode(InteropValue interop) {
                super(interop);
            }

            @Override
            protected final Class<?>[] getArgumentTypes() {
                return new Class[]{PolyglotLanguageContext.class, this.polyglot.receiverType, String.class};
            }
        }
    }

    private static final class HostNull
    extends PolyglotValueDispatch {
        private final PolyglotImpl polyglot;

        HostNull(PolyglotImpl polyglot) {
            super(polyglot, null);
            this.polyglot = polyglot;
        }

        @Override
        public boolean isNull(Object languageContext, Object receiver) {
            return true;
        }

        @Override
        public <T> T as(Object languageContext, Object receiver, Class<T> targetType) {
            if (targetType == Value.class) {
                return (T)this.polyglot.hostNull;
            }
            return null;
        }

        @Override
        public <T> T as(Object languageContext, Object receiver, TypeLiteral<T> targetType) {
            return this.as(languageContext, receiver, targetType.getRawType());
        }
    }

    static final class PrimitiveValue
    extends PolyglotValueDispatch {
        private final InteropLibrary interop;
        private final PolyglotLanguage language;

        private PrimitiveValue(PolyglotImpl impl, PolyglotLanguageInstance instance, Object primitiveValue) {
            super(impl, instance);
            this.interop = InteropLibrary.getFactory().getUncached(primitiveValue);
            this.language = instance != null ? instance.language : null;
        }

        @Override
        public boolean isString(Object languageContext, Object receiver) {
            return this.interop.isString(receiver);
        }

        @Override
        public boolean isBoolean(Object languageContext, Object receiver) {
            return this.interop.isBoolean(receiver);
        }

        @Override
        public boolean asBoolean(Object languageContext, Object receiver) {
            try {
                return this.interop.asBoolean(receiver);
            }
            catch (UnsupportedMessageException e2) {
                return super.asBoolean(languageContext, receiver);
            }
        }

        @Override
        public String asString(Object languageContext, Object receiver) {
            try {
                return this.interop.asString(receiver);
            }
            catch (UnsupportedMessageException e2) {
                return super.asString(languageContext, receiver);
            }
        }

        @Override
        public boolean isNumber(Object languageContext, Object receiver) {
            return this.interop.isNumber(receiver);
        }

        @Override
        public boolean fitsInByte(Object languageContext, Object receiver) {
            return this.interop.fitsInByte(receiver);
        }

        @Override
        public boolean fitsInShort(Object languageContext, Object receiver) {
            return this.interop.fitsInShort(receiver);
        }

        @Override
        public boolean fitsInInt(Object languageContext, Object receiver) {
            return this.interop.fitsInInt(receiver);
        }

        @Override
        public boolean fitsInLong(Object languageContext, Object receiver) {
            return this.interop.fitsInLong(receiver);
        }

        @Override
        public boolean fitsInBigInteger(Object languageContext, Object receiver) {
            return this.interop.fitsInBigInteger(receiver);
        }

        @Override
        public boolean fitsInFloat(Object languageContext, Object receiver) {
            return this.interop.fitsInFloat(receiver);
        }

        @Override
        public boolean fitsInDouble(Object languageContext, Object receiver) {
            return this.interop.fitsInDouble(receiver);
        }

        @Override
        public byte asByte(Object languageContext, Object receiver) {
            try {
                return this.interop.asByte(receiver);
            }
            catch (UnsupportedMessageException e2) {
                return super.asByte(languageContext, receiver);
            }
        }

        @Override
        public short asShort(Object languageContext, Object receiver) {
            try {
                return this.interop.asShort(receiver);
            }
            catch (UnsupportedMessageException e2) {
                return super.asShort(languageContext, receiver);
            }
        }

        @Override
        public int asInt(Object languageContext, Object receiver) {
            try {
                return this.interop.asInt(receiver);
            }
            catch (UnsupportedMessageException e2) {
                return super.asInt(languageContext, receiver);
            }
        }

        @Override
        public long asLong(Object languageContext, Object receiver) {
            try {
                return this.interop.asLong(receiver);
            }
            catch (UnsupportedMessageException e2) {
                return super.asLong(languageContext, receiver);
            }
        }

        @Override
        public BigInteger asBigInteger(Object languageContext, Object receiver) {
            try {
                return this.interop.asBigInteger(receiver);
            }
            catch (UnsupportedMessageException e2) {
                return super.asBigInteger(languageContext, receiver);
            }
        }

        @Override
        public float asFloat(Object languageContext, Object receiver) {
            try {
                return this.interop.asFloat(receiver);
            }
            catch (UnsupportedMessageException e2) {
                return super.asFloat(languageContext, receiver);
            }
        }

        @Override
        public double asDouble(Object languageContext, Object receiver) {
            try {
                return this.interop.asDouble(receiver);
            }
            catch (UnsupportedMessageException e2) {
                return super.asDouble(languageContext, receiver);
            }
        }

        @Override
        public <T> T as(Object languageContext, Object receiver, Class<T> targetType) {
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)languageContext;
            Object prev = PrimitiveValue.hostEnter(context2);
            try {
                if (context2 != null) {
                    T t = this.language.engine.host.toHostType(null, null, context2.context.getHostContextImpl(), receiver, targetType, targetType);
                    return t;
                }
                Object result = EngineAccessor.HOST.convertPrimitiveLossy(receiver, targetType);
                if (result == null) {
                    throw PolyglotInteropErrors.cannotConvertPrimitive(null, receiver, targetType);
                }
                Object object = result;
                return (T)object;
            }
            catch (Throwable e2) {
                throw PrimitiveValue.guestToHostException(context2, e2, true);
            }
            finally {
                PrimitiveValue.hostLeave(context2, prev);
            }
        }

        @Override
        public <T> T as(Object languageContext, Object receiver, TypeLiteral<T> targetType) {
            return this.as(languageContext, receiver, targetType.getRawType());
        }

        @Override
        public Value getMetaObjectImpl(PolyglotLanguageContext languageContext, Object receiver) {
            return super.getMetaObjectImpl(languageContext, this.getLanguageView(languageContext, receiver));
        }

        @Override
        String toStringImpl(PolyglotLanguageContext context2, Object receiver) throws AssertionError {
            return super.toStringImpl(context2, this.getLanguageView(context2, receiver));
        }

        private Object getLanguageView(Object languageContext, Object receiver) {
            if (languageContext == null || this.language == null) {
                return receiver;
            }
            PolyglotContextImpl c = ((PolyglotLanguageContext)languageContext).context;
            return c.getContext(this.language).getLanguageViewNoCheck(receiver);
        }
    }

    static final class BigIntegerHostValue
    extends HostValue {
        BigIntegerHostValue(PolyglotImpl polyglot) {
            super(polyglot);
        }

        @Override
        public boolean isNumber(Object context2, Object receiver) {
            assert (this.asHostObject(context2, receiver) instanceof BigInteger);
            return true;
        }

        @Override
        public boolean fitsInByte(Object context2, Object receiver) {
            assert (this.asHostObject(context2, receiver) instanceof BigInteger);
            return ((BigInteger)this.asHostObject(context2, receiver)).bitLength() < 8;
        }

        @Override
        public boolean fitsInShort(Object context2, Object receiver) {
            assert (this.asHostObject(context2, receiver) instanceof BigInteger);
            return ((BigInteger)this.asHostObject(context2, receiver)).bitLength() < 16;
        }

        @Override
        public boolean fitsInInt(Object context2, Object receiver) {
            assert (this.asHostObject(context2, receiver) instanceof BigInteger);
            return ((BigInteger)this.asHostObject(context2, receiver)).bitLength() < 32;
        }

        @Override
        public boolean fitsInLong(Object context2, Object receiver) {
            assert (this.asHostObject(context2, receiver) instanceof BigInteger);
            return ((BigInteger)this.asHostObject(context2, receiver)).bitLength() < 64;
        }

        @Override
        public boolean fitsInBigInteger(Object context2, Object receiver) {
            assert (this.asHostObject(context2, receiver) instanceof BigInteger);
            return true;
        }

        @Override
        public boolean fitsInFloat(Object context2, Object receiver) {
            assert (this.asHostObject(context2, receiver) instanceof BigInteger);
            return EngineAccessor.HOST.bigIntegerFitsInFloat((BigInteger)this.asHostObject(context2, receiver));
        }

        @Override
        public boolean fitsInDouble(Object context2, Object receiver) {
            assert (this.asHostObject(context2, receiver) instanceof BigInteger);
            return EngineAccessor.HOST.bigIntegerFitsInDouble((BigInteger)this.asHostObject(context2, receiver));
        }

        @Override
        public byte asByte(Object languageContext, Object receiver) {
            assert (this.asHostObject(languageContext, receiver) instanceof BigInteger);
            try {
                return ((BigInteger)this.asHostObject(languageContext, receiver)).byteValueExact();
            }
            catch (ArithmeticException e2) {
                return super.asByte(languageContext, receiver);
            }
        }

        @Override
        public short asShort(Object languageContext, Object receiver) {
            assert (this.asHostObject(languageContext, receiver) instanceof BigInteger);
            try {
                return ((BigInteger)this.asHostObject(languageContext, receiver)).shortValueExact();
            }
            catch (ArithmeticException e2) {
                return super.asShort(languageContext, receiver);
            }
        }

        @Override
        public int asInt(Object languageContext, Object receiver) {
            assert (this.asHostObject(languageContext, receiver) instanceof BigInteger);
            try {
                return ((BigInteger)this.asHostObject(languageContext, receiver)).intValueExact();
            }
            catch (ArithmeticException e2) {
                return super.asInt(languageContext, receiver);
            }
        }

        @Override
        public long asLong(Object languageContext, Object receiver) {
            assert (this.asHostObject(languageContext, receiver) instanceof BigInteger);
            try {
                return ((BigInteger)this.asHostObject(languageContext, receiver)).longValueExact();
            }
            catch (ArithmeticException e2) {
                return super.asLong(languageContext, receiver);
            }
        }

        @Override
        public BigInteger asBigInteger(Object languageContext, Object receiver) {
            assert (this.asHostObject(languageContext, receiver) instanceof BigInteger);
            return (BigInteger)this.asHostObject(languageContext, receiver);
        }

        @Override
        public float asFloat(Object languageContext, Object receiver) {
            assert (this.asHostObject(languageContext, receiver) instanceof BigInteger);
            if (this.fitsInFloat(languageContext, receiver)) {
                return ((BigInteger)this.asHostObject(languageContext, receiver)).floatValue();
            }
            return super.asFloat(languageContext, receiver);
        }

        @Override
        public double asDouble(Object languageContext, Object receiver) {
            assert (this.asHostObject(languageContext, receiver) instanceof BigInteger);
            if (this.fitsInFloat(languageContext, receiver)) {
                return ((BigInteger)this.asHostObject(languageContext, receiver)).doubleValue();
            }
            return super.asDouble(languageContext, receiver);
        }

        @Override
        <T> T asImpl(Object languageContext, Object receiver, Class<T> targetType) {
            int v;
            assert (this.asHostObject(languageContext, receiver) instanceof BigInteger);
            if (targetType == Byte.TYPE || targetType == Byte.class) {
                return (T)Byte.valueOf(this.asByte(languageContext, receiver));
            }
            if (targetType == Short.TYPE || targetType == Short.class) {
                return (T)Short.valueOf(this.asShort(languageContext, receiver));
            }
            if (targetType == Integer.TYPE || targetType == Integer.class) {
                return (T)Integer.valueOf(this.asInt(languageContext, receiver));
            }
            if (targetType == Long.TYPE || targetType == Long.class) {
                return (T)Long.valueOf(this.asLong(languageContext, receiver));
            }
            if (targetType == Float.TYPE || targetType == Float.class) {
                return (T)Float.valueOf(this.asFloat(languageContext, receiver));
            }
            if (targetType == Double.TYPE || targetType == Double.class) {
                return (T)Double.valueOf(this.asDouble(languageContext, receiver));
            }
            if (targetType == BigInteger.class || targetType == Number.class) {
                return (T)this.asBigInteger(languageContext, receiver);
            }
            if ((targetType == Character.TYPE || targetType == Character.class) && this.fitsInInt(languageContext, receiver) && (v = this.asInt(languageContext, receiver)) >= 0 && v < 65536) {
                return (T)Character.valueOf((char)v);
            }
            return super.asImpl(languageContext, receiver, targetType);
        }
    }

    static class HostValue
    extends PolyglotValueDispatch {
        HostValue(PolyglotImpl polyglot) {
            super(polyglot, null);
        }

        @Override
        public boolean isHostObject(Object languageContext, Object receiver) {
            return EngineAccessor.HOST.isDisconnectedHostObject(receiver);
        }

        @Override
        public Object asHostObject(Object languageContext, Object receiver) {
            return EngineAccessor.HOST.unboxDisconnectedHostObject(receiver);
        }

        @Override
        public boolean isProxyObject(Object languageContext, Object receiver) {
            return EngineAccessor.HOST.isDisconnectedHostProxy(receiver);
        }

        @Override
        public Object asProxyObject(Object languageContext, Object receiver) {
            return EngineAccessor.HOST.unboxDisconnectedHostProxy(receiver);
        }

        @Override
        public <T> T as(Object languageContext, Object receiver, Class<T> targetType) {
            return this.asImpl(languageContext, receiver, targetType);
        }

        @Override
        public <T> T as(Object languageContext, Object receiver, TypeLiteral<T> targetType) {
            return this.asImpl(languageContext, receiver, targetType.getRawType());
        }

        <T> T asImpl(Object languageContext, Object receiver, Class<T> targetType) {
            Object hostValue;
            if (this.isProxyObject(languageContext, receiver)) {
                hostValue = this.asProxyObject(languageContext, receiver);
            } else if (this.isHostObject(languageContext, receiver)) {
                hostValue = this.asHostObject(languageContext, receiver);
            } else {
                throw new ClassCastException();
            }
            return targetType.cast(hostValue);
        }
    }
}

