/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class FileSystems {
    static final org.graalvm.polyglot.io.FileSystem INVALID_FILESYSTEM = new InvalidFileSystem();

    private FileSystems() {
        throw new IllegalStateException("No instance allowed");
    }

    static org.graalvm.polyglot.io.FileSystem newDefaultFileSystem() {
        return new NIOFileSystem(FileSystems.findDefaultFileSystem(), true);
    }

    static org.graalvm.polyglot.io.FileSystem newNIOFileSystem(FileSystem fileSystem) {
        return new NIOFileSystem(fileSystem, false);
    }

    static org.graalvm.polyglot.io.FileSystem allowLanguageHomeAccess(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return new LanguageHomeFileSystem(FileSystems.newDefaultFileSystem(), fileSystem);
    }

    static org.graalvm.polyglot.io.FileSystem newReadOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return new ReadOnlyFileSystem(fileSystem);
    }

    static org.graalvm.polyglot.io.FileSystem newNoIOFileSystem() {
        return new DeniedIOFileSystem();
    }

    static org.graalvm.polyglot.io.FileSystem newLanguageHomeFileSystem() {
        org.graalvm.polyglot.io.FileSystem defaultFS = FileSystems.newDefaultFileSystem();
        return new LanguageHomeFileSystem(new ReadOnlyFileSystem(defaultFS), new PathOperationsOnlyFileSystem(defaultFS));
    }

    static boolean hasNoAccess(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).hasNoAccess();
    }

    static boolean isInternal(AbstractPolyglotImpl polyglot, org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).isInternal(polyglot);
    }

    static boolean isHostFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return fileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)fileSystem).isHost();
    }

    static Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> newFileTypeDetectorsSupplier(Iterable<LanguageCache> languageCaches) {
        return new FileTypeDetectorsSupplier(languageCaches);
    }

    static String getRelativePathInLanguageHome(TruffleFile file2) {
        Object engineObject = EngineAccessor.LANGUAGE.getFileSystemEngineObject(EngineAccessor.LANGUAGE.getFileSystemContext(file2));
        if (engineObject instanceof PolyglotLanguageContext) {
            Path path2;
            PolyglotLanguageContext context2 = (PolyglotLanguageContext)engineObject;
            org.graalvm.polyglot.io.FileSystem fs = EngineAccessor.LANGUAGE.getFileSystem(file2);
            String result = FileSystems.relativizeToLanguageHome(fs, path2 = EngineAccessor.LANGUAGE.getPath(file2), context2.language);
            if (result != null) {
                return result;
            }
            Map<String, LanguageInfo> accessibleLanguages = context2.getAccessibleLanguages(true);
            if (accessibleLanguages != null) {
                for (LanguageInfo language : accessibleLanguages.values()) {
                    PolyglotLanguage lang = context2.context.engine.idToLanguage.get(language.getId());
                    result = FileSystems.relativizeToLanguageHome(fs, path2, lang);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
        if (engineObject instanceof PolyglotImpl.EmbedderFileSystemContext) {
            return null;
        }
        throw new AssertionError();
    }

    private static String relativizeToLanguageHome(org.graalvm.polyglot.io.FileSystem fs, Path path2, PolyglotLanguage language) {
        String languageHome = language.cache.getLanguageHome();
        if (languageHome == null) {
            return null;
        }
        Path languageHomePath = fs.parsePath(language.cache.getLanguageHome());
        if (path2.startsWith(languageHomePath)) {
            return languageHomePath.relativize(path2).toString();
        }
        return null;
    }

    private static FileSystem findDefaultFileSystem() {
        FileSystem fs = java.nio.file.FileSystems.getDefault();
        assert ("file".equals(fs.provider().getScheme()));
        return fs;
    }

    private static FileSystemProvider findDefaultFileSystemProvider() {
        for (FileSystemProvider provider : FileSystemProvider.installedProviders()) {
            if (!"file".equals(provider.getScheme())) continue;
            return provider;
        }
        return null;
    }

    private static boolean isFollowLinks(LinkOption ... linkOptions) {
        for (LinkOption lo : linkOptions) {
            if (Objects.requireNonNull(lo) != LinkOption.NOFOLLOW_LINKS) continue;
            return false;
        }
        return true;
    }

    private static void validateLinkOptions(LinkOption ... linkOptions) {
        for (LinkOption linkOption : linkOptions) {
            Objects.requireNonNull(linkOption);
        }
    }

    private static SecurityException forbidden(Path path2) {
        throw new SecurityException((String)(path2 == null ? "Operation is not allowed." : "Operation is not allowed for: " + path2));
    }

    private static final class NIOFileSystem
    implements PolyglotFileSystem {
        private final FileSystem fileSystem;
        private final FileSystemProvider fileSystemProvider;
        private final boolean isDefault;
        private volatile Path userDir;
        private volatile Path tmpDir;

        NIOFileSystem(FileSystem fileSystem, boolean isDefault) {
            Objects.requireNonNull(fileSystem, "FileSystem must be non null.");
            this.fileSystem = fileSystem;
            this.fileSystemProvider = fileSystem.provider();
            this.isDefault = isDefault;
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return this.isDefault;
        }

        @Override
        public boolean hasNoAccess() {
            return false;
        }

        @Override
        public boolean isHost() {
            return this.isDefault;
        }

        @Override
        public Path parsePath(URI uri) {
            if (!this.fileSystemProvider.getScheme().equals(uri.getScheme())) {
                throw new UnsupportedOperationException("Unsupported URI scheme " + uri.getScheme());
            }
            try {
                return this.fileSystemProvider.getPath(uri);
            }
            catch (FileSystemNotFoundException e2) {
                throw new UnsupportedOperationException(e2);
            }
        }

        @Override
        public Path parsePath(String path2) {
            Objects.requireNonNull(path2);
            return this.fileSystem.getPath(path2, new String[0]);
        }

        @Override
        public void checkAccess(Path path2, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            Objects.requireNonNull(path2);
            Objects.requireNonNull(modes);
            if (FileSystems.isFollowLinks(linkOptions)) {
                this.fileSystemProvider.checkAccess(this.resolveRelative(path2), modes.toArray(new AccessMode[0]));
            } else if (modes.isEmpty()) {
                this.fileSystemProvider.readAttributes(path2, "isRegularFile", LinkOption.NOFOLLOW_LINKS);
            } else {
                throw new UnsupportedOperationException("CheckAccess for NIO Provider is unsupported with non empty AccessMode and NOFOLLOW_LINKS.");
            }
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(dir);
            Objects.requireNonNull(attrs);
            this.fileSystemProvider.createDirectory(this.resolveRelative(dir), attrs);
        }

        @Override
        public void delete(Path path2) throws IOException {
            Objects.requireNonNull(path2);
            this.fileSystemProvider.delete(this.resolveRelative(path2));
        }

        @Override
        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            Objects.requireNonNull(options);
            this.fileSystemProvider.copy(this.resolveRelative(source), this.resolveRelative(target), options);
        }

        @Override
        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            Objects.requireNonNull(options);
            this.fileSystemProvider.move(this.resolveRelative(source), this.resolveRelative(target), options);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path2, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(path2);
            Objects.requireNonNull(options);
            Objects.requireNonNull(attrs);
            Path resolved = this.resolveRelative(path2);
            try {
                return this.fileSystemProvider.newFileChannel(resolved, options, attrs);
            }
            catch (UnsupportedOperationException uoe) {
                return this.fileSystemProvider.newByteChannel(resolved, options, attrs);
            }
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) throws IOException {
            boolean relativize;
            Path resolvedPath;
            Objects.requireNonNull(dir);
            Path cwd = this.userDir;
            if (!dir.isAbsolute() && cwd != null) {
                resolvedPath = cwd.resolve(dir);
                relativize = true;
            } else {
                resolvedPath = dir;
                relativize = false;
            }
            RelativizeDirectoryStream result = this.fileSystemProvider.newDirectoryStream(resolvedPath, filter2);
            if (relativize) {
                result = new RelativizeDirectoryStream(cwd, result);
            }
            return result;
        }

        @Override
        public void createLink(Path link, Path existing) throws IOException {
            Objects.requireNonNull(link);
            Objects.requireNonNull(existing);
            this.fileSystemProvider.createLink(this.resolveRelative(link), this.resolveRelative(existing));
        }

        @Override
        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            Objects.requireNonNull(link);
            Objects.requireNonNull(target);
            Objects.requireNonNull(attrs);
            this.fileSystemProvider.createSymbolicLink(this.resolveRelative(link), target, attrs);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            Objects.requireNonNull(link);
            return this.fileSystemProvider.readSymbolicLink(this.resolveRelative(link));
        }

        @Override
        public Map<String, Object> readAttributes(Path path2, String attributes, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path2);
            FileSystems.validateLinkOptions(options);
            return this.fileSystemProvider.readAttributes(this.resolveRelative(path2), attributes, options);
        }

        @Override
        public void setAttribute(Path path2, String attribute, Object value2, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path2);
            FileSystems.validateLinkOptions(options);
            this.fileSystemProvider.setAttribute(this.resolveRelative(path2), attribute, value2, options);
        }

        @Override
        public Path toAbsolutePath(Path path2) {
            Objects.requireNonNull(path2);
            if (path2.isAbsolute()) {
                return path2;
            }
            Path cwd = this.userDir;
            if (cwd == null) {
                return path2.toAbsolutePath();
            }
            return cwd.resolve(path2);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            boolean nonDirectory;
            Objects.requireNonNull(currentWorkingDirectory, "Current working directory must be non null.");
            if (!currentWorkingDirectory.isAbsolute()) {
                throw new IllegalArgumentException("Current working directory must be absolute.");
            }
            try {
                nonDirectory = Boolean.FALSE.equals(this.fileSystemProvider.readAttributes(currentWorkingDirectory, "isDirectory", new LinkOption[0]).get("isDirectory"));
            }
            catch (IOException ioe) {
                nonDirectory = false;
            }
            if (nonDirectory) {
                throw new IllegalArgumentException("Current working directory must be directory.");
            }
            this.userDir = currentWorkingDirectory;
        }

        @Override
        public Path toRealPath(Path path2, LinkOption ... linkOptions) throws IOException {
            Objects.requireNonNull(path2);
            FileSystems.validateLinkOptions(linkOptions);
            Path resolvedPath = this.resolveRelative(path2);
            return resolvedPath.toRealPath(linkOptions);
        }

        @Override
        public Path getTempDirectory() {
            Path result = this.tmpDir;
            if (result == null) {
                String tmpDirPath = EngineAccessor.RUNTIME.getSavedProperty("java.io.tmpdir");
                if (tmpDirPath == null) {
                    throw new IllegalStateException("The java.io.tmpdir is not set.");
                }
                result = this.parsePath(tmpDirPath);
                if (this.isDefault || this.isDirectory(result)) {
                    this.tmpDir = result;
                } else {
                    throw new UnsupportedOperationException("Temporary directories not supported");
                }
            }
            return result;
        }

        private boolean isDirectory(Path path2) {
            try {
                return (Boolean)this.readAttributes(path2, "isDirectory", new LinkOption[0]).get("isDirectory");
            }
            catch (IOException ioe) {
                return false;
            }
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            Objects.requireNonNull(path1);
            Objects.requireNonNull(path2);
            if (FileSystems.isFollowLinks(options)) {
                Path absolutePath1 = this.resolveRelative(path1);
                Path absolutePath2 = this.resolveRelative(path2);
                return this.fileSystemProvider.isSameFile(absolutePath1, absolutePath2);
            }
            return PolyglotFileSystem.super.isSameFile(path1, path2, options);
        }

        private Path resolveRelative(Path path2) {
            return !path2.isAbsolute() && this.userDir != null ? this.toAbsolutePath(path2) : path2;
        }

        private static final class RelativizeDirectoryStream
        implements DirectoryStream<Path> {
            private final Path folder;
            private final DirectoryStream<? extends Path> delegateDirectoryStream;

            RelativizeDirectoryStream(Path folder, DirectoryStream<? extends Path> delegateDirectoryStream) {
                this.folder = folder;
                this.delegateDirectoryStream = delegateDirectoryStream;
            }

            @Override
            public Iterator<Path> iterator() {
                return new RelativizeIterator(this.folder, this.delegateDirectoryStream.iterator());
            }

            @Override
            public void close() throws IOException {
                this.delegateDirectoryStream.close();
            }

            private static final class RelativizeIterator
            implements Iterator<Path> {
                private final Path folder;
                private final Iterator<? extends Path> delegateIterator;

                RelativizeIterator(Path folder, Iterator<? extends Path> delegateIterator) {
                    this.folder = folder;
                    this.delegateIterator = delegateIterator;
                }

                @Override
                public boolean hasNext() {
                    return this.delegateIterator.hasNext();
                }

                @Override
                public Path next() {
                    return this.folder.relativize(this.delegateIterator.next());
                }
            }
        }
    }

    private static final class LanguageHomeFileSystem
    implements PolyglotFileSystem {
        private final org.graalvm.polyglot.io.FileSystem languageHomeFileSystem;
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;
        private volatile Set<Path> languageHomes;

        LanguageHomeFileSystem(org.graalvm.polyglot.io.FileSystem languageHomeFileSystem, org.graalvm.polyglot.io.FileSystem delegateFileSystem) {
            this.languageHomeFileSystem = languageHomeFileSystem;
            this.delegateFileSystem = delegateFileSystem;
            Class<?> languageHomeFileSystemPathType = this.languageHomeFileSystem.parsePath("").getClass();
            Class<?> customFileSystemPathType = delegateFileSystem.parsePath("").getClass();
            if (languageHomeFileSystemPathType != customFileSystemPathType) {
                throw new IllegalArgumentException("Given FileSystem must have the same Path type as the default FileSystem.");
            }
            if (!languageHomeFileSystem.getSeparator().equals(delegateFileSystem.getSeparator())) {
                throw new IllegalArgumentException("Given FileSystem must use the same separator character as the default FileSystem.");
            }
            if (!languageHomeFileSystem.getPathSeparator().equals(delegateFileSystem.getPathSeparator())) {
                throw new IllegalArgumentException("Given FileSystem must use the same path separator character as the default FileSystem.");
            }
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).isHost();
        }

        @Override
        public Path parsePath(URI uri) {
            return this.delegateFileSystem.parsePath(uri);
        }

        @Override
        public Path parsePath(String path2) {
            return this.delegateFileSystem.parsePath(path2);
        }

        @Override
        public void checkAccess(Path path2, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path2);
            if (this.inLanguageHome(absolutePath)) {
                this.languageHomeFileSystem.checkAccess(absolutePath, modes, linkOptions);
            } else {
                this.delegateFileSystem.checkAccess(path2, modes, linkOptions);
            }
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(dir);
            if (this.inLanguageHome(absolutePath)) {
                this.languageHomeFileSystem.createDirectory(absolutePath, attrs);
            } else {
                this.delegateFileSystem.createDirectory(dir, attrs);
            }
        }

        @Override
        public void delete(Path path2) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path2);
            if (this.inLanguageHome(absolutePath)) {
                this.languageHomeFileSystem.delete(absolutePath);
            } else {
                this.delegateFileSystem.delete(path2);
            }
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path2, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path2);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.newByteChannel(absolutePath, options, attrs);
            }
            return this.delegateFileSystem.newByteChannel(path2, options, attrs);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(dir);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.newDirectoryStream(absolutePath, filter2);
            }
            return this.delegateFileSystem.newDirectoryStream(dir, filter2);
        }

        @Override
        public Path toAbsolutePath(Path path2) {
            return this.delegateFileSystem.toAbsolutePath(path2);
        }

        @Override
        public Path toRealPath(Path path2, LinkOption ... linkOptions) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path2);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.toRealPath(path2, new LinkOption[0]);
            }
            return this.delegateFileSystem.toRealPath(path2, new LinkOption[0]);
        }

        @Override
        public Map<String, Object> readAttributes(Path path2, String attributes, LinkOption ... options) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path2);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.readAttributes(absolutePath, attributes, options);
            }
            return this.delegateFileSystem.readAttributes(path2, attributes, options);
        }

        @Override
        public void setAttribute(Path path2, String attribute, Object value2, LinkOption ... options) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(path2);
            if (this.inLanguageHome(absolutePath)) {
                this.languageHomeFileSystem.setAttribute(absolutePath, attribute, value2, options);
            } else {
                this.delegateFileSystem.setAttribute(path2, attribute, value2, options);
            }
        }

        @Override
        public void createLink(Path link, Path existing) throws IOException {
            Path absoluteLink = this.toNormalizedAbsolutePath(link);
            Path absoluteExisting = this.toNormalizedAbsolutePath(existing);
            boolean linkInHome = this.inLanguageHome(absoluteLink);
            boolean existingInHome = this.inLanguageHome(absoluteExisting);
            if (linkInHome && existingInHome) {
                this.languageHomeFileSystem.createLink(absoluteLink, absoluteExisting);
            } else if (!linkInHome && !existingInHome) {
                this.delegateFileSystem.createLink(link, existing);
            } else {
                throw new IOException("Cross file system linking is not supported.");
            }
        }

        @Override
        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            Path absoluteLink = this.toNormalizedAbsolutePath(link);
            Path absoluteTarget = this.toNormalizedAbsolutePath(target);
            boolean linkInHome = this.inLanguageHome(absoluteLink);
            boolean targetInHome = this.inLanguageHome(absoluteTarget);
            if (linkInHome && targetInHome) {
                this.languageHomeFileSystem.createSymbolicLink(absoluteLink, target, new FileAttribute[0]);
            } else if (!linkInHome && !targetInHome) {
                this.delegateFileSystem.createSymbolicLink(link, target, new FileAttribute[0]);
            } else {
                throw new IOException("Cross file system linking is not supported.");
            }
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            Path absolutePath = this.toNormalizedAbsolutePath(link);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.readSymbolicLink(absolutePath);
            }
            return this.delegateFileSystem.readSymbolicLink(link);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.languageHomeFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        @Override
        public String getSeparator() {
            return this.delegateFileSystem.getSeparator();
        }

        @Override
        public String getPathSeparator() {
            return this.delegateFileSystem.getPathSeparator();
        }

        @Override
        public String getMimeType(Path path2) {
            Path absolutePath = this.toNormalizedAbsolutePath(path2);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.getMimeType(absolutePath);
            }
            return this.delegateFileSystem.getMimeType(path2);
        }

        @Override
        public Charset getEncoding(Path path2) {
            Path absolutePath = this.toNormalizedAbsolutePath(path2);
            if (this.inLanguageHome(absolutePath)) {
                return this.languageHomeFileSystem.getEncoding(absolutePath);
            }
            return this.delegateFileSystem.getEncoding(path2);
        }

        @Override
        public Path getTempDirectory() {
            return this.delegateFileSystem.getTempDirectory();
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            Path absolutePath1 = this.toNormalizedAbsolutePath(path1);
            Path absolutePath2 = this.toNormalizedAbsolutePath(path2);
            boolean path1InHome = this.inLanguageHome(absolutePath1);
            boolean path2InHome = this.inLanguageHome(absolutePath2);
            if (path1InHome && path2InHome) {
                return this.languageHomeFileSystem.isSameFile(absolutePath1, absolutePath2, options);
            }
            if (!path1InHome && !path2InHome) {
                return this.delegateFileSystem.isSameFile(path1, path2, new LinkOption[0]);
            }
            return false;
        }

        private Path toNormalizedAbsolutePath(Path path2) {
            if (path2.isAbsolute()) {
                return path2;
            }
            Path absolutePath = this.languageHomeFileSystem.toAbsolutePath(path2);
            if (LanguageHomeFileSystem.isNormalized(path2)) {
                return absolutePath;
            }
            return absolutePath.normalize();
        }

        private static boolean isNormalized(Path path2) {
            for (Path name : path2) {
                String strName = name.toString();
                if (!".".equals(strName) && !"..".equals(strName)) continue;
                return false;
            }
            return true;
        }

        private boolean inLanguageHome(Path path2) {
            if (!path2.isAbsolute() || !LanguageHomeFileSystem.isNormalized(path2)) {
                throw new IllegalArgumentException("The path must be normalized absolute path.");
            }
            for (Path home : this.getLanguageHomes()) {
                if (!path2.startsWith(home)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<Path> getLanguageHomes() {
            Set<Path> res = this.languageHomes;
            if (res == null) {
                LanguageHomeFileSystem languageHomeFileSystem = this;
                synchronized (languageHomeFileSystem) {
                    res = this.languageHomes;
                    if (res == null) {
                        res = new HashSet<Path>();
                        for (LanguageCache cache : LanguageCache.languages().values()) {
                            String languageHome = cache.getLanguageHome();
                            if (languageHome == null) continue;
                            res.add(Paths.get(languageHome, new String[0]));
                        }
                        this.languageHomes = res;
                    }
                }
            }
            return res;
        }
    }

    private static class ReadOnlyFileSystem
    extends DeniedIOFileSystem {
        private static final List<AccessMode> READ_MODES = Arrays.asList(AccessMode.READ, AccessMode.EXECUTE);
        private static final List<StandardOpenOption> READ_OPTIONS = Arrays.asList(StandardOpenOption.READ, StandardOpenOption.DSYNC, StandardOpenOption.SPARSE, StandardOpenOption.SYNC, StandardOpenOption.TRUNCATE_EXISTING);
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;

        ReadOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
            this.delegateFileSystem = fileSystem;
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).isHost();
        }

        @Override
        public void checkAccess(Path path2, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            HashSet<? extends AccessMode> writeModes = new HashSet<AccessMode>(modes);
            writeModes.removeAll(READ_MODES);
            if (!writeModes.isEmpty()) {
                throw new IOException("Read-only file");
            }
            this.delegateFileSystem.checkAccess(path2, modes, linkOptions);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path inPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            boolean write;
            HashSet<? extends OpenOption> copy = new HashSet<OpenOption>(options);
            HashSet<? extends OpenOption> writeOptions = new HashSet<OpenOption>(copy);
            boolean read = writeOptions.contains(StandardOpenOption.READ);
            writeOptions.removeAll(READ_OPTIONS);
            if (read) {
                writeOptions.remove(StandardOpenOption.APPEND);
            }
            boolean bl = write = !writeOptions.isEmpty();
            if (write) {
                throw FileSystems.forbidden(inPath);
            }
            return this.delegateFileSystem.newByteChannel(inPath, copy, attrs);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) throws IOException {
            return this.delegateFileSystem.newDirectoryStream(dir, filter2);
        }

        @Override
        public Map<String, Object> readAttributes(Path path2, String attributes, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.readAttributes(path2, attributes, options);
        }

        @Override
        public Path toAbsolutePath(Path path2) {
            return this.delegateFileSystem.toAbsolutePath(path2);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            return this.delegateFileSystem.readSymbolicLink(link);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            super.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        @Override
        public Path toRealPath(Path path2, LinkOption ... linkOptions) throws IOException {
            return this.delegateFileSystem.toRealPath(path2, linkOptions);
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.isSameFile(path1, path2, options);
        }

        @Override
        public String getMimeType(Path path2) {
            return this.delegateFileSystem.getMimeType(path2);
        }

        @Override
        public Charset getEncoding(Path path2) {
            return this.delegateFileSystem.getEncoding(path2);
        }
    }

    private static class DeniedIOFileSystem
    implements PolyglotFileSystem {
        private final FileSystemProvider defaultFileSystemProvider = FileSystems.findDefaultFileSystemProvider();

        DeniedIOFileSystem() {
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return true;
        }

        @Override
        public boolean hasNoAccess() {
            return true;
        }

        @Override
        public boolean isHost() {
            return false;
        }

        @Override
        public Path parsePath(URI uri) {
            if (!this.defaultFileSystemProvider.getScheme().equals(uri.getScheme())) {
                throw new UnsupportedOperationException("Unsupported URI scheme " + uri.getScheme());
            }
            try {
                return this.defaultFileSystemProvider.getPath(uri);
            }
            catch (FileSystemNotFoundException e2) {
                throw new UnsupportedOperationException(e2);
            }
        }

        @Override
        public Path parsePath(String path2) {
            return Paths.get(path2, new String[0]);
        }

        @Override
        public void checkAccess(Path path2, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            throw FileSystems.forbidden(dir);
        }

        @Override
        public void delete(Path path2) throws IOException {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            throw FileSystems.forbidden(source);
        }

        @Override
        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            throw FileSystems.forbidden(source);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path inPath, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            throw FileSystems.forbidden(inPath);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) throws IOException {
            throw FileSystems.forbidden(dir);
        }

        @Override
        public Map<String, Object> readAttributes(Path path2, String attributes, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public void setAttribute(Path path2, String attribute, Object value2, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public Path toAbsolutePath(Path path2) {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
        }

        @Override
        public Path toRealPath(Path path2, LinkOption ... linkOptions) throws IOException {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public Path getTempDirectory() {
            throw FileSystems.forbidden(null);
        }

        @Override
        public void createLink(Path link, Path existing) {
            throw FileSystems.forbidden(link);
        }

        @Override
        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(link);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            throw FileSystems.forbidden(link);
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            throw FileSystems.forbidden(path1);
        }
    }

    private static final class PathOperationsOnlyFileSystem
    extends DeniedIOFileSystem {
        private final org.graalvm.polyglot.io.FileSystem delegateFileSystem;

        PathOperationsOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
            this.delegateFileSystem = fileSystem;
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegateFileSystem);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegateFileSystem instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegateFileSystem).hasNoAccess();
        }

        @Override
        public Path toAbsolutePath(Path path2) {
            return this.delegateFileSystem.toAbsolutePath(path2);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegateFileSystem.setCurrentWorkingDirectory(currentWorkingDirectory);
            super.setCurrentWorkingDirectory(currentWorkingDirectory);
        }

        @Override
        public Path toRealPath(Path path2, LinkOption ... linkOptions) throws IOException {
            return this.delegateFileSystem.toRealPath(path2, linkOptions);
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegateFileSystem.isSameFile(path1, path2, options);
        }
    }

    private static interface PolyglotFileSystem
    extends org.graalvm.polyglot.io.FileSystem {
        public boolean isInternal(AbstractPolyglotImpl var1);

        public boolean hasNoAccess();

        public boolean isHost();
    }

    private static final class FileTypeDetectorsSupplier
    implements Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> {
        private final Iterable<LanguageCache> languageCaches;

        FileTypeDetectorsSupplier(Iterable<LanguageCache> languageCaches) {
            this.languageCaches = languageCaches;
        }

        @Override
        public Map<String, Collection<? extends TruffleFile.FileTypeDetector>> get() {
            HashMap<String, Collection<? extends TruffleFile.FileTypeDetector>> detectors = new HashMap<String, Collection<? extends TruffleFile.FileTypeDetector>>();
            for (LanguageCache cache : this.languageCaches) {
                for (String mimeType : cache.getMimeTypes()) {
                    List<? extends TruffleFile.FileTypeDetector> languageDetectors = cache.getFileTypeDetectors();
                    Collection mimeTypeDetectors = (Collection)detectors.get(mimeType);
                    if (mimeTypeDetectors != null) {
                        if (languageDetectors.isEmpty()) continue;
                        ArrayList<? extends TruffleFile.FileTypeDetector> mergedDetectors = new ArrayList<TruffleFile.FileTypeDetector>(mimeTypeDetectors);
                        mergedDetectors.addAll(languageDetectors);
                        detectors.put(mimeType, mergedDetectors);
                        continue;
                    }
                    detectors.put(mimeType, languageDetectors);
                }
            }
            return detectors;
        }
    }

    private static final class InvalidFileSystem
    implements PolyglotFileSystem {
        private InvalidFileSystem() {
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return true;
        }

        @Override
        public boolean hasNoAccess() {
            return true;
        }

        @Override
        public boolean isHost() {
            return false;
        }

        @Override
        public Path parsePath(URI uri) {
            throw new UnsupportedOperationException("ParsePath not supported on InvalidFileSystem");
        }

        @Override
        public Path parsePath(String path2) {
            throw new UnsupportedOperationException("ParsePath not supported on InvalidFileSystem");
        }

        @Override
        public void checkAccess(Path path2, Set<? extends AccessMode> modes, LinkOption ... linkOptions) {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(dir);
        }

        @Override
        public void delete(Path path2) {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path2, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) {
            throw FileSystems.forbidden(dir);
        }

        @Override
        public Path toAbsolutePath(Path path2) {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public Path toRealPath(Path path2, LinkOption ... linkOptions) {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public Map<String, Object> readAttributes(Path path2, String attributes, LinkOption ... options) {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public void setAttribute(Path path2, String attribute, Object value2, LinkOption ... options) {
            throw FileSystems.forbidden(path2);
        }

        @Override
        public void copy(Path source, Path target, CopyOption ... options) {
            throw FileSystems.forbidden(source);
        }

        @Override
        public void move(Path source, Path target, CopyOption ... options) {
            throw FileSystems.forbidden(source);
        }

        @Override
        public void createLink(Path link, Path existing) {
            throw FileSystems.forbidden(link);
        }

        @Override
        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
            throw FileSystems.forbidden(link);
        }

        @Override
        public Path readSymbolicLink(Path link) {
            throw FileSystems.forbidden(link);
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            throw FileSystems.forbidden(currentWorkingDirectory);
        }
    }

    static final class PreInitializeContextFileSystem
    implements PolyglotFileSystem {
        private org.graalvm.polyglot.io.FileSystem delegate = FileSystems.newDefaultFileSystem();
        private Function<Path, PreInitializePath> factory = new ImageBuildTimeFactory();

        PreInitializeContextFileSystem() {
        }

        void onPreInitializeContextEnd() {
            if (this.factory == null) {
                throw new IllegalStateException("Context pre-initialization already finished.");
            }
            ((ImageBuildTimeFactory)this.factory).onPreInitializeContextEnd();
            this.factory = null;
            this.delegate = INVALID_FILESYSTEM;
        }

        void onLoadPreinitializedContext(org.graalvm.polyglot.io.FileSystem newDelegate) {
            Objects.requireNonNull(newDelegate, "NewDelegate must be non null.");
            if (this.factory != null) {
                throw new IllegalStateException("Pre-initialized context already loaded.");
            }
            this.delegate = newDelegate;
            this.factory = new ImageExecutionTimeFactory();
        }

        String pathToString(Path path2) {
            if (this.delegate != INVALID_FILESYSTEM) {
                return path2.toString();
            }
            PreInitializeContextFileSystem.verifyImageState();
            return ((PreInitializePath)path2).resolve(FileSystems.newDefaultFileSystem()).toString();
        }

        URI absolutePathtoURI(Path path2) {
            if (this.delegate != INVALID_FILESYSTEM) {
                return path2.toUri();
            }
            PreInitializeContextFileSystem.verifyImageState();
            Path resolved = ((PreInitializePath)path2).resolve(FileSystems.newDefaultFileSystem());
            if (!resolved.isAbsolute()) {
                throw new IllegalArgumentException("Path must be absolute.");
            }
            return resolved.toUri();
        }

        private static void verifyImageState() {
            if (ImageInfo.inImageBuildtimeCode()) {
                throw new IllegalStateException("Reintroducing absolute path into an image heap.");
            }
        }

        @Override
        public boolean isInternal(AbstractPolyglotImpl polyglot) {
            return polyglot.isInternalFileSystem(this.delegate);
        }

        @Override
        public boolean hasNoAccess() {
            return this.delegate instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegate).hasNoAccess();
        }

        @Override
        public boolean isHost() {
            return this.delegate instanceof PolyglotFileSystem && ((PolyglotFileSystem)this.delegate).isHost();
        }

        @Override
        public Path parsePath(URI path2) {
            return this.wrap(this.delegate.parsePath(path2));
        }

        @Override
        public Path parsePath(String path2) {
            return this.wrap(this.delegate.parsePath(path2));
        }

        @Override
        public void checkAccess(Path path2, Set<? extends AccessMode> modes, LinkOption ... linkOptions) throws IOException {
            this.delegate.checkAccess(PreInitializeContextFileSystem.unwrap(path2), modes, linkOptions);
        }

        @Override
        public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createDirectory(PreInitializeContextFileSystem.unwrap(dir), attrs);
        }

        @Override
        public void delete(Path path2) throws IOException {
            this.delegate.delete(PreInitializeContextFileSystem.unwrap(path2));
        }

        @Override
        public SeekableByteChannel newByteChannel(Path path2, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
            return this.delegate.newByteChannel(PreInitializeContextFileSystem.unwrap(path2), options, attrs);
        }

        @Override
        public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) throws IOException {
            final DirectoryStream<Path> delegateStream = this.delegate.newDirectoryStream(PreInitializeContextFileSystem.unwrap(dir), filter2);
            return new DirectoryStream<Path>(){

                @Override
                public Iterator<Path> iterator() {
                    return new WrappingPathIterator(delegateStream.iterator());
                }

                @Override
                public void close() throws IOException {
                    delegateStream.close();
                }
            };
        }

        @Override
        public Path toAbsolutePath(Path path2) {
            return this.wrap(this.delegate.toAbsolutePath(PreInitializeContextFileSystem.unwrap(path2)));
        }

        @Override
        public Path toRealPath(Path path2, LinkOption ... linkOptions) throws IOException {
            return this.wrap(this.delegate.toRealPath(PreInitializeContextFileSystem.unwrap(path2), linkOptions));
        }

        @Override
        public Map<String, Object> readAttributes(Path path2, String attributes, LinkOption ... options) throws IOException {
            return this.delegate.readAttributes(PreInitializeContextFileSystem.unwrap(path2), attributes, options);
        }

        @Override
        public void setAttribute(Path path2, String attribute, Object value2, LinkOption ... options) throws IOException {
            this.delegate.setAttribute(PreInitializeContextFileSystem.unwrap(path2), attribute, value2, options);
        }

        @Override
        public void copy(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.copy(PreInitializeContextFileSystem.unwrap(source), PreInitializeContextFileSystem.unwrap(target), options);
        }

        @Override
        public void move(Path source, Path target, CopyOption ... options) throws IOException {
            this.delegate.move(PreInitializeContextFileSystem.unwrap(source), PreInitializeContextFileSystem.unwrap(target), options);
        }

        @Override
        public void createLink(Path link, Path existing) throws IOException {
            this.delegate.createLink(PreInitializeContextFileSystem.unwrap(link), PreInitializeContextFileSystem.unwrap(existing));
        }

        @Override
        public void createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) throws IOException {
            this.delegate.createSymbolicLink(PreInitializeContextFileSystem.unwrap(link), PreInitializeContextFileSystem.unwrap(target), attrs);
        }

        @Override
        public Path readSymbolicLink(Path link) throws IOException {
            return this.wrap(this.delegate.readSymbolicLink(PreInitializeContextFileSystem.unwrap(link)));
        }

        @Override
        public void setCurrentWorkingDirectory(Path currentWorkingDirectory) {
            this.delegate.setCurrentWorkingDirectory(PreInitializeContextFileSystem.unwrap(currentWorkingDirectory));
        }

        @Override
        public String getSeparator() {
            return this.delegate.getSeparator();
        }

        @Override
        public Charset getEncoding(Path path2) {
            return this.delegate.getEncoding(PreInitializeContextFileSystem.unwrap(path2));
        }

        @Override
        public String getMimeType(Path path2) {
            return this.delegate.getMimeType(PreInitializeContextFileSystem.unwrap(path2));
        }

        @Override
        public Path getTempDirectory() {
            return this.wrap(this.delegate.getTempDirectory());
        }

        @Override
        public boolean isSameFile(Path path1, Path path2, LinkOption ... options) throws IOException {
            return this.delegate.isSameFile(PreInitializeContextFileSystem.unwrap(path1), PreInitializeContextFileSystem.unwrap(path2), options);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof PreInitializeContextFileSystem)) {
                return false;
            }
            return this.delegate.equals(((PreInitializeContextFileSystem)other).delegate);
        }

        Path wrap(Path path2) {
            return path2 == null ? null : (Path)this.factory.apply(path2);
        }

        static Path unwrap(Path path2) {
            return path2.getClass() == PreInitializePath.class ? ((PreInitializePath)path2).getDelegate() : path2;
        }

        private final class ImageBuildTimeFactory
        extends ImageExecutionTimeFactory {
            private final Collection<Reference<PreInitializePath>> emittedPaths;

            private ImageBuildTimeFactory() {
                this.emittedPaths = new ArrayList<Reference<PreInitializePath>>();
            }

            @Override
            public PreInitializePath apply(Path path2) {
                PreInitializePath preInitPath = super.apply(path2);
                this.emittedPaths.add(new WeakReference<PreInitializePath>(preInitPath));
                return preInitPath;
            }

            void onPreInitializeContextEnd() {
                HashMap<String, Path> languageHomes = new HashMap<String, Path>();
                for (LanguageCache languageCache : LanguageCache.languages().values()) {
                    String languageHome = languageCache.getLanguageHome();
                    if (languageHome == null) continue;
                    languageHomes.put(languageCache.getId(), PreInitializeContextFileSystem.this.delegate.parsePath(languageHome));
                }
                for (Reference reference : this.emittedPaths) {
                    PreInitializePath path2 = (PreInitializePath)reference.get();
                    if (path2 == null) continue;
                    path2.onPreInitializeContextEnd(languageHomes);
                }
            }
        }

        private class ImageExecutionTimeFactory
        implements Function<Path, PreInitializePath> {
            private ImageExecutionTimeFactory() {
            }

            @Override
            public PreInitializePath apply(Path path2) {
                return new PreInitializePath(path2);
            }
        }

        private final class PreInitializePath
        implements Path {
            private volatile Object delegatePath;

            PreInitializePath(Path delegatePath) {
                this.delegatePath = delegatePath;
            }

            private Path getDelegate() {
                Path result = this.resolve(PreInitializeContextFileSystem.this.delegate);
                this.delegatePath = result;
                return result;
            }

            private Path resolve(org.graalvm.polyglot.io.FileSystem fs) {
                Object current2 = this.delegatePath;
                if (current2 instanceof Path) {
                    return (Path)current2;
                }
                if (current2 instanceof ImageHeapPath) {
                    String newLanguageHome;
                    ImageHeapPath imageHeapPath = (ImageHeapPath)current2;
                    String languageId = imageHeapPath.languageId;
                    String path2 = imageHeapPath.path;
                    Path result = languageId != null && (newLanguageHome = LanguageCache.languages().get(languageId).getLanguageHome()) != null ? fs.parsePath(newLanguageHome).resolve(path2) : fs.parsePath(path2);
                    return result;
                }
                throw new IllegalStateException("Unknown delegate " + current2);
            }

            void onPreInitializeContextEnd(Map<String, Path> languageHomes) {
                Path internalPath = (Path)this.delegatePath;
                String languageId = null;
                for (Map.Entry<String, Path> e2 : languageHomes.entrySet()) {
                    if (!internalPath.startsWith(e2.getValue())) continue;
                    internalPath = e2.getValue().relativize(internalPath);
                    languageId = e2.getKey();
                    break;
                }
                this.delegatePath = new ImageHeapPath(languageId, internalPath.toString(), internalPath.isAbsolute());
            }

            @Override
            public FileSystem getFileSystem() {
                return this.getDelegate().getFileSystem();
            }

            @Override
            public boolean isAbsolute() {
                if (PreInitializeContextFileSystem.this.delegate == INVALID_FILESYSTEM) {
                    return ((ImageHeapPath)this.delegatePath).absolute;
                }
                return this.getDelegate().isAbsolute();
            }

            @Override
            public Path getRoot() {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().getRoot());
            }

            @Override
            public Path getFileName() {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().getFileName());
            }

            @Override
            public Path getParent() {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().getParent());
            }

            @Override
            public int getNameCount() {
                return this.getDelegate().getNameCount();
            }

            @Override
            public Path getName(int index) {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().getName(index));
            }

            @Override
            public Path subpath(int beginIndex, int endIndex) {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().subpath(beginIndex, endIndex));
            }

            @Override
            public boolean startsWith(Path other) {
                return this.getDelegate().startsWith(PreInitializeContextFileSystem.unwrap(other));
            }

            @Override
            public boolean startsWith(String other) {
                return this.getDelegate().startsWith(other);
            }

            @Override
            public boolean endsWith(Path other) {
                return this.getDelegate().endsWith(PreInitializeContextFileSystem.unwrap(other));
            }

            @Override
            public boolean endsWith(String other) {
                return this.getDelegate().endsWith(other);
            }

            @Override
            public Path normalize() {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().normalize());
            }

            @Override
            public Path resolve(Path other) {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().resolve(PreInitializeContextFileSystem.unwrap(other)));
            }

            @Override
            public Path resolve(String other) {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().resolve(other));
            }

            @Override
            public Path resolveSibling(Path other) {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().resolveSibling(PreInitializeContextFileSystem.unwrap(other)));
            }

            @Override
            public Path resolveSibling(String other) {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().resolveSibling(other));
            }

            @Override
            public Path relativize(Path other) {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().relativize(PreInitializeContextFileSystem.unwrap(other)));
            }

            @Override
            public URI toUri() {
                return this.getDelegate().toUri();
            }

            @Override
            public Path toAbsolutePath() {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().toAbsolutePath());
            }

            @Override
            public Path toRealPath(LinkOption ... options) throws IOException {
                return PreInitializeContextFileSystem.this.wrap(this.getDelegate().toRealPath(options));
            }

            @Override
            public File toFile() {
                return this.getDelegate().toFile();
            }

            @Override
            public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
                return this.getDelegate().register(watcher, events, modifiers);
            }

            @Override
            public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
                return this.getDelegate().register(watcher, events);
            }

            @Override
            public Iterator<Path> iterator() {
                return new WrappingPathIterator(this.getDelegate().iterator());
            }

            @Override
            public int compareTo(Path other) {
                return this.getDelegate().compareTo(PreInitializeContextFileSystem.unwrap(other));
            }

            @Override
            public int hashCode() {
                return this.getDelegate().hashCode();
            }

            @Override
            public boolean equals(Object other) {
                if (other == this) {
                    return true;
                }
                if (!(other instanceof Path)) {
                    return false;
                }
                return this.getDelegate().equals(PreInitializeContextFileSystem.unwrap((Path)other));
            }

            @Override
            public String toString() {
                if (PreInitializeContextFileSystem.this.delegate == INVALID_FILESYSTEM) {
                    ImageHeapPath imageHeapPath = (ImageHeapPath)this.delegatePath;
                    if (imageHeapPath.languageId != null) {
                        throw new UnsupportedOperationException("ToString in the image heap form is supported only for files outside language homes.");
                    }
                    return imageHeapPath.path;
                }
                return this.getDelegate().toString();
            }
        }

        private static final class ImageHeapPath {
            private final String languageId;
            private final String path;
            private final boolean absolute;

            ImageHeapPath(String languageId, String path2, boolean absolute) {
                assert (path2 != null);
                this.languageId = languageId;
                this.path = path2;
                this.absolute = absolute;
            }
        }

        private final class WrappingPathIterator
        implements Iterator<Path> {
            private final Iterator<Path> delegateIterator;

            WrappingPathIterator(Iterator<Path> delegateIterator) {
                this.delegateIterator = delegateIterator;
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public Path next() {
                return PreInitializeContextFileSystem.this.wrap(this.delegateIterator.next());
            }
        }
    }
}

