/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringOpsNodes;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;

@GeneratedBy(value=TStringOpsNodes.class)
final class TStringOpsNodesFactory {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final TruffleString.CompactionLevel[] COMPACTION_LEVEL_VALUES = (TruffleString.CompactionLevel[])DSLSupport.lookupEnumConstants(TruffleString.CompactionLevel.class);

    TStringOpsNodesFactory() {
    }

    private static TruffleString.CompactionLevel decodeCompactionLevel(int state) {
        if (state >= 0) {
            return COMPACTION_LEVEL_VALUES[state];
        }
        return null;
    }

    private static int encodeCompactionLevel(TruffleString.CompactionLevel e2) {
        if (e2 != null) {
            return e2.ordinal();
        }
        return -1;
    }

    @GeneratedBy(value=TStringOpsNodes.CalculateHashCodeNode.class)
    static final class CalculateHashCodeNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        CalculateHashCodeNodeGen() {
        }

        @NeverDefault
        public static TStringOpsNodes.CalculateHashCodeNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.CalculateHashCodeNode inline(@InlineSupport.RequiredField(bits=12, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.CalculateHashCodeNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.CalculateHashCodeNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TStringOpsNodes.CalculateHashCodeNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.CalculateHashCodeNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.CalculateHashCodeNode.class));
                this.state_0_ = target.getState(0, 12);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x111) != 0) {
                    TruffleString.CompactionLevel compaction__;
                    if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                        return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                    }
                    if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                        return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                    }
                    if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                        return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value) {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.CompactionLevel compaction__ = null;
                boolean Cached0_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    Cached0_duplicateFound_ = true;
                }
                if (!Cached0_duplicateFound_ && (state_0 & 1) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    Cached0_duplicateFound_ = true;
                }
                if (Cached0_duplicateFound_) {
                    return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                }
                compaction__ = null;
                boolean Cached1_duplicateFound_ = false;
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    Cached1_duplicateFound_ = true;
                }
                if (!Cached1_duplicateFound_ && (state_0 & 0x10) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    Cached1_duplicateFound_ = true;
                }
                if (Cached1_duplicateFound_) {
                    return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                }
                compaction__ = null;
                boolean Cached2_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    Cached2_duplicateFound_ = true;
                }
                if (!Cached2_duplicateFound_ && (state_0 & 0x100) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    Cached2_duplicateFound_ = true;
                }
                if (Cached2_duplicateFound_) {
                    return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfStringNode.class)
    static final class RawLastIndexOfStringNodeGen {
        private static final InlineSupport.StateField CACHED_LEN1_CACHED_LEN1_STATE_0_UPDATER = InlineSupport.StateField.create(CachedLen1Data.lookup_(), "cachedLen1_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        RawLastIndexOfStringNodeGen() {
        }

        @NeverDefault
        public static TStringOpsNodes.RawLastIndexOfStringNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.RawLastIndexOfStringNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=1, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.RawLastIndexOfStringNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, byte[] arg7Value) {
                return TStringOpsNodes.RawLastIndexOfStringNode.cachedLen1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg3Value.stride()), TruffleString.CompactionLevel.fromStride(arg3Value.stride()), InlinedConditionProfile.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfStringNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.RawLastIndexOfStringNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<CachedLen1Data> cachedLen1_cache;
            private final InlinedConditionProfile oneLength_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.RawLastIndexOfStringNode.class));
                this.state_0_ = target.getState(0, 1);
                this.cachedLen1_cache = target.getReference(1, CachedLen1Data.class);
                this.oneLength_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, CACHED_LEN1_CACHED_LEN1_STATE_0_UPDATER.subUpdater(6, 2)));
            }

            @Override
            @ExplodeLoop
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, byte[] arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    CachedLen1Data s0_ = this.cachedLen1_cache.get(arg0Value);
                    while (s0_ != null) {
                        TruffleString.CompactionLevel compactionB__;
                        TruffleString.CompactionLevel compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                        if (compactionA__ == TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 7) >>> 0) - 2) && (compactionB__ = TruffleString.CompactionLevel.fromStride(arg3Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 0x38) >>> 3) - 2)) {
                            return TStringOpsNodes.RawLastIndexOfStringNode.cachedLen1(s0_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, compactionA__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 7) >>> 0) - 2), compactionB__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 0x38) >>> 3) - 2), this.oneLength_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, byte[] arg7Value) {
                CachedLen1Data s0_;
                TruffleString.CompactionLevel compactionA__;
                TruffleString.CompactionLevel compactionB__;
                block3: {
                    CachedLen1Data s0_original;
                    int state_0 = this.state_0_.get(arg0Value);
                    compactionB__ = null;
                    compactionA__ = null;
                    do {
                        int count0_ = 0;
                        s0_original = s0_ = this.cachedLen1_cache.getVolatile(arg0Value);
                        while (s0_ != null && ((compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) != TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 7) >>> 0) - 2) || (compactionB__ = TruffleString.CompactionLevel.fromStride(arg3Value.stride())) != TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 0x38) >>> 3) - 2))) {
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || count0_ >= 9) break block3;
                        s0_ = arg0Value.insert(new CachedLen1Data(s0_original));
                        compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                        s0_.cachedLen1_state_0_ |= TStringOpsNodesFactory.encodeCompactionLevel(compactionA__) + 2 << 0;
                        compactionB__ = TruffleString.CompactionLevel.fromStride(arg3Value.stride());
                        s0_.cachedLen1_state_0_ |= TStringOpsNodesFactory.encodeCompactionLevel(compactionB__) + 2 << 3;
                    } while (!this.cachedLen1_cache.compareAndSet(arg0Value, s0_original, s0_));
                    this.state_0_.set(arg0Value, state_0 |= 1);
                }
                if (s0_ != null) {
                    return TStringOpsNodes.RawLastIndexOfStringNode.cachedLen1(s0_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, compactionA__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 7) >>> 0) - 2), compactionB__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 0x38) >>> 3) - 2), this.oneLength_);
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfStringNode.class)
        @DenyReplace
        private static final class CachedLen1Data
        extends Node {
            @Node.Child
            CachedLen1Data next_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int cachedLen1_state_0_;

            CachedLen1Data(CachedLen1Data next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.RawIndexOfStringNode.class)
    static final class RawIndexOfStringNodeGen {
        private static final InlineSupport.StateField CACHED_CACHED_STATE_0_UPDATER = InlineSupport.StateField.create(CachedData.lookup_(), "cached_state_0_");
        private static final Uncached UNCACHED = new Uncached();

        RawIndexOfStringNodeGen() {
        }

        @NeverDefault
        public static TStringOpsNodes.RawIndexOfStringNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.RawIndexOfStringNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=1, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.RawIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.RawIndexOfStringNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, byte[] arg7Value) {
                return TStringOpsNodes.RawIndexOfStringNode.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg3Value.stride()), TruffleString.CompactionLevel.fromStride(arg3Value.stride()), InlinedConditionProfile.getUncached());
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawIndexOfStringNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.RawIndexOfStringNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<CachedData> cached_cache;
            private final InlinedConditionProfile oneLength_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.RawIndexOfStringNode.class));
                this.state_0_ = target.getState(0, 1);
                this.cached_cache = target.getReference(1, CachedData.class);
                this.oneLength_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, CACHED_CACHED_STATE_0_UPDATER.subUpdater(6, 2)));
            }

            @Override
            @ExplodeLoop
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, byte[] arg7Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    CachedData s0_ = this.cached_cache.get(arg0Value);
                    while (s0_ != null) {
                        TruffleString.CompactionLevel compactionB__;
                        TruffleString.CompactionLevel compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                        if (compactionA__ == TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2) && (compactionB__ = TruffleString.CompactionLevel.fromStride(arg3Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2)) {
                            return TStringOpsNodes.RawIndexOfStringNode.doCached(s0_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, compactionA__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2), compactionB__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2), this.oneLength_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, AbstractTruffleString arg3Value, Object arg4Value, int arg5Value, int arg6Value, byte[] arg7Value) {
                CachedData s0_;
                TruffleString.CompactionLevel compactionA__;
                TruffleString.CompactionLevel compactionB__;
                block3: {
                    CachedData s0_original;
                    int state_0 = this.state_0_.get(arg0Value);
                    compactionB__ = null;
                    compactionA__ = null;
                    do {
                        int count0_ = 0;
                        s0_original = s0_ = this.cached_cache.getVolatile(arg0Value);
                        while (s0_ != null && ((compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) != TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2) || (compactionB__ = TruffleString.CompactionLevel.fromStride(arg3Value.stride())) != TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2))) {
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || count0_ >= 9) break block3;
                        s0_ = arg0Value.insert(new CachedData(s0_original));
                        compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                        s0_.cached_state_0_ |= TStringOpsNodesFactory.encodeCompactionLevel(compactionA__) + 2 << 0;
                        compactionB__ = TruffleString.CompactionLevel.fromStride(arg3Value.stride());
                        s0_.cached_state_0_ |= TStringOpsNodesFactory.encodeCompactionLevel(compactionB__) + 2 << 3;
                    } while (!this.cached_cache.compareAndSet(arg0Value, s0_original, s0_));
                    this.state_0_.set(arg0Value, state_0 |= 1);
                }
                if (s0_ != null) {
                    return TStringOpsNodes.RawIndexOfStringNode.doCached(s0_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, compactionA__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2), compactionB__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2), this.oneLength_);
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawIndexOfStringNode.class)
        @DenyReplace
        private static final class CachedData
        extends Node {
            @Node.Child
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int cached_state_0_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.NONE;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfCodePointNode.class)
    static final class RawLastIndexOfCodePointNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        RawLastIndexOfCodePointNodeGen() {
        }

        @NeverDefault
        public static TStringOpsNodes.RawLastIndexOfCodePointNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.RawLastIndexOfCodePointNode inline(@InlineSupport.RequiredField(bits=12, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.RawLastIndexOfCodePointNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value) {
                return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.RawLastIndexOfCodePointNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.RawLastIndexOfCodePointNode.class));
                this.state_0_ = target.getState(0, 12);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x111) != 0) {
                    TruffleString.CompactionLevel compaction__;
                    if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                        return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                    }
                    if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                        return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                    }
                    if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                        return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.CompactionLevel compaction__ = null;
                boolean Cached0_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    Cached0_duplicateFound_ = true;
                }
                if (!Cached0_duplicateFound_ && (state_0 & 1) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    Cached0_duplicateFound_ = true;
                }
                if (Cached0_duplicateFound_) {
                    return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                }
                compaction__ = null;
                boolean Cached1_duplicateFound_ = false;
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    Cached1_duplicateFound_ = true;
                }
                if (!Cached1_duplicateFound_ && (state_0 & 0x10) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    Cached1_duplicateFound_ = true;
                }
                if (Cached1_duplicateFound_) {
                    return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                }
                compaction__ = null;
                boolean Cached2_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    Cached2_duplicateFound_ = true;
                }
                if (!Cached2_duplicateFound_ && (state_0 & 0x100) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    Cached2_duplicateFound_ = true;
                }
                if (Cached2_duplicateFound_) {
                    return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.RawIndexOfCodePointNode.class)
    static final class RawIndexOfCodePointNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        RawIndexOfCodePointNodeGen() {
        }

        @NeverDefault
        public static TStringOpsNodes.RawIndexOfCodePointNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.RawIndexOfCodePointNode inline(@InlineSupport.RequiredField(bits=12, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.RawIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.RawIndexOfCodePointNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value) {
                return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.RawIndexOfCodePointNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.RawIndexOfCodePointNode.class));
                this.state_0_ = target.getState(0, 12);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x111) != 0) {
                    TruffleString.CompactionLevel compaction__;
                    if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                        return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                    }
                    if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                        return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                    }
                    if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                        return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.CompactionLevel compaction__ = null;
                boolean Cached0_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    Cached0_duplicateFound_ = true;
                }
                if (!Cached0_duplicateFound_ && (state_0 & 1) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    Cached0_duplicateFound_ = true;
                }
                if (Cached0_duplicateFound_) {
                    return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                }
                compaction__ = null;
                boolean Cached1_duplicateFound_ = false;
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    Cached1_duplicateFound_ = true;
                }
                if (!Cached1_duplicateFound_ && (state_0 & 0x10) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    Cached1_duplicateFound_ = true;
                }
                if (Cached1_duplicateFound_) {
                    return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                }
                compaction__ = null;
                boolean Cached2_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    Cached2_duplicateFound_ = true;
                }
                if (!Cached2_duplicateFound_ && (state_0 & 0x100) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    Cached2_duplicateFound_ = true;
                }
                if (Cached2_duplicateFound_) {
                    return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.IndexOfAnyIntNode.class)
    static final class IndexOfAnyIntNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        IndexOfAnyIntNodeGen() {
        }

        @NeverDefault
        public static TStringOpsNodes.IndexOfAnyIntNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.IndexOfAnyIntNode inline(@InlineSupport.RequiredField(bits=5, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.IndexOfAnyIntNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.IndexOfAnyIntNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int[] arg5Value) {
                if (TStringGuards.isStride0(arg1Value) && arg5Value.length == 1) {
                    return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride0(arg1Value) && arg5Value.length > 1) {
                    return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride1(arg1Value) && arg5Value.length == 1) {
                    return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride1(arg1Value) && arg5Value.length > 1) {
                    return this.stride1MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride2(arg1Value)) {
                    return this.stride2(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TStringOpsNodes.IndexOfAnyIntNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.IndexOfAnyIntNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.IndexOfAnyIntNode.class));
                this.state_0_ = target.getState(0, 5);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int[] arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isStride0(arg1Value) && arg5Value.length == 1) {
                        return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isStride0(arg1Value) && arg5Value.length > 1) {
                        return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isStride1(arg1Value) && arg5Value.length == 1) {
                        return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isStride1(arg1Value) && arg5Value.length > 1) {
                        return this.stride1MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isStride2(arg1Value)) {
                        return this.stride2(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, int[] arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isStride0(arg1Value) && arg5Value.length == 1) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride0(arg1Value) && arg5Value.length > 1) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride1(arg1Value) && arg5Value.length == 1) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride1(arg1Value) && arg5Value.length > 1) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    return this.stride1MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride2(arg1Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return this.stride2(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.IndexOfAnyCharNode.class)
    static final class IndexOfAnyCharNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        IndexOfAnyCharNodeGen() {
        }

        @NeverDefault
        public static TStringOpsNodes.IndexOfAnyCharNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.IndexOfAnyCharNode inline(@InlineSupport.RequiredField(bits=3, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.IndexOfAnyCharNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.IndexOfAnyCharNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, char[] arg5Value) {
                if (TStringGuards.isStride0(arg1Value) && arg5Value.length == 1) {
                    return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride0(arg1Value) && arg5Value.length > 1) {
                    return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride1(arg1Value)) {
                    return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TStringOpsNodes.IndexOfAnyCharNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.IndexOfAnyCharNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.IndexOfAnyCharNode.class));
                this.state_0_ = target.getState(0, 3);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, char[] arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isStride0(arg1Value) && arg5Value.length == 1) {
                        return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isStride0(arg1Value) && arg5Value.length > 1) {
                        return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isStride1(arg1Value)) {
                        return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value, int arg4Value, char[] arg5Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isStride0(arg1Value) && arg5Value.length == 1) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride0(arg1Value) && arg5Value.length > 1) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                if (TStringGuards.isStride1(arg1Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.RawReadValueNode.class)
    static final class RawReadValueNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        RawReadValueNodeGen() {
        }

        @NeverDefault
        public static TStringOpsNodes.RawReadValueNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.RawReadValueNode inline(@InlineSupport.RequiredField(bits=12, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.RawReadValueNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.RawReadValueNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value) {
                return TStringOpsNodes.RawReadValueNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()));
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawReadValueNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.RawReadValueNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.RawReadValueNode.class));
                this.state_0_ = target.getState(0, 12);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x111) != 0) {
                    TruffleString.CompactionLevel compaction__;
                    if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                        return TStringOpsNodes.RawReadValueNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                    }
                    if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                        return TStringOpsNodes.RawReadValueNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                    }
                    if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                        return TStringOpsNodes.RawReadValueNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, Object arg2Value, int arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.CompactionLevel compaction__ = null;
                boolean Cached0_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    Cached0_duplicateFound_ = true;
                }
                if (!Cached0_duplicateFound_ && (state_0 & 1) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    Cached0_duplicateFound_ = true;
                }
                if (Cached0_duplicateFound_) {
                    return TStringOpsNodes.RawReadValueNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                }
                compaction__ = null;
                boolean Cached1_duplicateFound_ = false;
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    Cached1_duplicateFound_ = true;
                }
                if (!Cached1_duplicateFound_ && (state_0 & 0x10) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    Cached1_duplicateFound_ = true;
                }
                if (Cached1_duplicateFound_) {
                    return TStringOpsNodes.RawReadValueNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                }
                compaction__ = null;
                boolean Cached2_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    Cached2_duplicateFound_ = true;
                }
                if (!Cached2_duplicateFound_ && (state_0 & 0x100) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    Cached2_duplicateFound_ = true;
                }
                if (Cached2_duplicateFound_) {
                    return TStringOpsNodes.RawReadValueNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                }
                throw new UnsupportedSpecializationException(this, new Node[]{null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }
        }
    }
}

