/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractInternalNode;
import com.oracle.truffle.api.strings.AbstractPublicNode;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.JCodings;
import com.oracle.truffle.api.strings.MutableTruffleStringFactory;
import com.oracle.truffle.api.strings.StringAttributes;
import com.oracle.truffle.api.strings.TSCodeRange;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringInternalNodes;
import com.oracle.truffle.api.strings.TStringOps;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;

public final class MutableTruffleString
extends AbstractTruffleString {
    private MutableTruffleString(Object data, int offset, int length2, int stride, int codePointLength, TruffleString.Encoding encoding) {
        super(data, offset, length2, stride, encoding, 0, codePointLength, TSCodeRange.getUnknownCodeRangeForEncoding(encoding.id));
        assert (data instanceof byte[] || data instanceof AbstractTruffleString.NativePointer);
    }

    private static MutableTruffleString create(Object data, int offset, int length2, TruffleString.Encoding encoding) {
        int codePointLength = encoding.isFixedWidth() ? (encoding.isSupported() ? length2 : length2 / JCodings.getInstance().minLength(encoding.jCoding)) : -1;
        MutableTruffleString string = new MutableTruffleString(data, offset, length2, encoding.naturalStride, codePointLength, encoding);
        if (AbstractTruffleString.DEBUG_ALWAYS_CREATE_JAVA_STRING) {
            string.toJavaStringUncached();
        }
        return string;
    }

    void invalidateCachedAttributes() {
        boolean isFixedWidth = TruffleString.Encoding.isFixedWidth(this.encoding());
        if (!isFixedWidth) {
            this.invalidateCodePointLength();
        }
        this.invalidateCodeRange();
        this.invalidateHashCode();
        if (this.data() instanceof AbstractTruffleString.NativePointer) {
            ((AbstractTruffleString.NativePointer)this.data()).invalidateCachedByteArray();
        }
    }

    public void notifyExternalMutation() {
        this.invalidateCachedAttributes();
    }

    @CompilerDirectives.TruffleBoundary
    public static MutableTruffleString fromByteArrayUncached(byte[] value2, int byteOffset, int byteLength, TruffleString.Encoding encoding, boolean copy) {
        return FromByteArrayNode.getUncached().execute(value2, byteOffset, byteLength, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    public static MutableTruffleString fromNativePointerUncached(Object pointerObject, int byteOffset, int byteLength, TruffleString.Encoding encoding, boolean copy) {
        return FromNativePointerNode.getUncached().execute(pointerObject, byteOffset, byteLength, encoding, copy);
    }

    @CompilerDirectives.TruffleBoundary
    public void writeByteUncached(int byteIndex, byte value2, TruffleString.Encoding expectedEncoding) {
        WriteByteNode.getUncached().execute(this, byteIndex, value2, expectedEncoding);
    }

    @CompilerDirectives.TruffleBoundary
    public MutableTruffleString concatUncached(AbstractTruffleString b2, TruffleString.Encoding expectedEncoding) {
        return ConcatNode.getUncached().execute(this, b2, expectedEncoding);
    }

    @CompilerDirectives.TruffleBoundary
    public MutableTruffleString substringUncached(int byteOffset, int byteLength, TruffleString.Encoding expectedEncoding) {
        return SubstringNode.getUncached().execute(this, byteOffset, byteLength, expectedEncoding);
    }

    @CompilerDirectives.TruffleBoundary
    public MutableTruffleString substringByteIndexUncached(int byteOffset, int byteLength, TruffleString.Encoding expectedEncoding) {
        return SubstringByteIndexNode.getUncached().execute(this, byteOffset, byteLength, expectedEncoding);
    }

    static MutableTruffleString createCopying(AbstractTruffleString a, TruffleString.Encoding encoding, TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        return MutableTruffleString.createCopying(a, encoding, encoding, a.byteLength(encoding), copyToByteArrayNode);
    }

    static MutableTruffleString createCopying(AbstractTruffleString a, TruffleString.Encoding expectedEncoding, TruffleString.Encoding targetEncoding, TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        int byteLength = a.byteLength(expectedEncoding);
        MutableTruffleString.checkByteLength(byteLength, targetEncoding);
        return MutableTruffleString.createCopying(a, expectedEncoding, targetEncoding, byteLength, copyToByteArrayNode);
    }

    static MutableTruffleString createCopying(AbstractTruffleString a, TruffleString.Encoding expectedEncoding, TruffleString.Encoding targetEncoding, int byteLength, TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        byte[] array = new byte[byteLength];
        copyToByteArrayNode.execute(a, 0, array, 0, byteLength, expectedEncoding);
        return MutableTruffleString.create(array, 0, byteLength >> targetEncoding.naturalStride, targetEncoding);
    }

    public static abstract class FromByteArrayNode
    extends AbstractPublicNode {
        FromByteArrayNode() {
        }

        public abstract MutableTruffleString execute(byte[] var1, int var2, int var3, TruffleString.Encoding var4, boolean var5);

        @Specialization
        static MutableTruffleString fromByteArray(byte[] value2, int byteOffset, int byteLength, TruffleString.Encoding enc, boolean copy) {
            int offset;
            byte[] array;
            AbstractTruffleString.checkArrayRange(value2, byteOffset, byteLength);
            AbstractTruffleString.checkByteLength(byteLength, enc);
            if (copy) {
                array = Arrays.copyOfRange(value2, byteOffset, byteOffset + byteLength);
                offset = 0;
            } else {
                array = value2;
                offset = byteOffset;
            }
            return MutableTruffleString.create(array, offset, byteLength >> enc.naturalStride, enc);
        }

        @NeverDefault
        public static FromByteArrayNode create() {
            return MutableTruffleStringFactory.FromByteArrayNodeGen.create();
        }

        public static FromByteArrayNode getUncached() {
            return MutableTruffleStringFactory.FromByteArrayNodeGen.getUncached();
        }
    }

    public static abstract class FromNativePointerNode
    extends AbstractPublicNode {
        FromNativePointerNode() {
        }

        public abstract MutableTruffleString execute(Object var1, int var2, int var3, TruffleString.Encoding var4, boolean var5);

        @Specialization
        MutableTruffleString fromNativePointer(Object pointerObject, int byteOffset, int byteLength, TruffleString.Encoding enc, boolean copy, @Cached(value="createInteropLibrary()", uncached="getUncachedInteropLibrary()") Node interopLibrary) {
            int offset;
            Object array;
            AbstractTruffleString.checkByteLength(byteLength, enc);
            AbstractTruffleString.NativePointer nativePointer = AbstractTruffleString.NativePointer.create(this, pointerObject, interopLibrary);
            if (copy) {
                array = TStringOps.arraycopyOfWithStride(this, nativePointer, byteOffset, byteLength, 0, byteLength, 0);
                offset = 0;
            } else {
                array = nativePointer;
                offset = byteOffset;
            }
            return MutableTruffleString.create(array, offset, byteLength >> enc.naturalStride, enc);
        }

        @NeverDefault
        public static FromNativePointerNode create() {
            return MutableTruffleStringFactory.FromNativePointerNodeGen.create();
        }

        public static FromNativePointerNode getUncached() {
            return MutableTruffleStringFactory.FromNativePointerNodeGen.getUncached();
        }
    }

    public static abstract class WriteByteNode
    extends AbstractPublicNode {
        WriteByteNode() {
        }

        public abstract void execute(MutableTruffleString var1, int var2, byte var3, TruffleString.Encoding var4);

        @Specialization
        static void writeByte(MutableTruffleString a, int byteIndex, byte value2, TruffleString.Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            int byteLength = a.length() << a.stride();
            TruffleString.boundsCheckI(byteIndex, byteLength);
            TStringOps.writeS0(a.data(), a.offset(), byteLength, byteIndex, value2);
            if (!TSCodeRange.is7Bit(a.codeRange()) || value2 < 0) {
                a.invalidateCachedAttributes();
            }
        }

        @NeverDefault
        public static WriteByteNode create() {
            return MutableTruffleStringFactory.WriteByteNodeGen.create();
        }

        public static WriteByteNode getUncached() {
            return MutableTruffleStringFactory.WriteByteNodeGen.getUncached();
        }
    }

    public static abstract class ConcatNode
    extends AbstractPublicNode {
        ConcatNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, AbstractTruffleString var2, TruffleString.Encoding var3);

        @Specialization
        final MutableTruffleString concat(AbstractTruffleString a, AbstractTruffleString b2, TruffleString.Encoding expectedEncoding, @Cached TruffleString.ToIndexableNode toIndexableNodeA, @Cached TruffleString.ToIndexableNode toIndexableNodeB, @Cached TStringInternalNodes.ConcatMaterializeBytesNode materializeBytesNode, @Cached InlinedBranchProfile outOfMemoryProfile) {
            a.checkEncoding(expectedEncoding);
            b2.checkEncoding(expectedEncoding);
            int length2 = TruffleString.ConcatNode.addByteLengths(this, a, b2, expectedEncoding.naturalStride, outOfMemoryProfile);
            int offset = 0;
            byte[] array = materializeBytesNode.execute(this, a, toIndexableNodeA.execute(this, a, a.data()), b2, toIndexableNodeB.execute(this, b2, b2.data()), expectedEncoding, length2, expectedEncoding.naturalStride);
            return MutableTruffleString.create(array, offset, length2, expectedEncoding);
        }

        @NeverDefault
        public static ConcatNode create() {
            return MutableTruffleStringFactory.ConcatNodeGen.create();
        }

        public static ConcatNode getUncached() {
            return MutableTruffleStringFactory.ConcatNodeGen.getUncached();
        }
    }

    public static abstract class SubstringNode
    extends AbstractPublicNode {
        SubstringNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, int var2, int var3, TruffleString.Encoding var4);

        @Specialization
        MutableTruffleString substring(AbstractTruffleString a, int fromIndex, int length2, TruffleString.Encoding encoding, @Cached TruffleString.ToIndexableNode toIndexableNode, @Cached TStringInternalNodes.GetCodeRangeForIndexCalculationNode getCodeRangeANode, @Cached TStringInternalNodes.GetCodePointLengthNode getCodePointLengthNode, @Cached TStringInternalNodes.CodePointIndexToRawNode translateIndexNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            a.checkEncoding(encoding);
            a.boundsCheckRegion(this, fromIndex, length2, encoding, getCodePointLengthNode);
            Object arrayA = toIndexableNode.execute(this, a, a.data());
            int codeRangeA = getCodeRangeANode.execute(this, a, encoding);
            int fromIndexRaw = translateIndexNode.execute(this, a, arrayA, codeRangeA, encoding, 0, fromIndex, length2 == 0);
            int lengthRaw = translateIndexNode.execute(this, a, arrayA, codeRangeA, encoding, fromIndexRaw, length2, true);
            byte stride = encoding.naturalStride;
            return SubstringByteIndexNode.createSubstring(a, fromIndexRaw << stride, lengthRaw << stride, encoding, copyToByteArrayNode);
        }

        @NeverDefault
        public static SubstringNode create() {
            return MutableTruffleStringFactory.SubstringNodeGen.create();
        }

        public static SubstringNode getUncached() {
            return MutableTruffleStringFactory.SubstringNodeGen.getUncached();
        }
    }

    public static abstract class SubstringByteIndexNode
    extends AbstractPublicNode {
        SubstringByteIndexNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, int var2, int var3, TruffleString.Encoding var4);

        @Specialization
        static MutableTruffleString substringByteIndex(AbstractTruffleString a, int byteOffset, int byteLength, TruffleString.Encoding expectedEncoding, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            return SubstringByteIndexNode.createSubstring(a, byteOffset, byteLength, expectedEncoding, copyToByteArrayNode);
        }

        static MutableTruffleString createSubstring(AbstractTruffleString a, int byteOffset, int byteLength, TruffleString.Encoding expectedEncoding, TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            a.checkEncoding(expectedEncoding);
            AbstractTruffleString.checkByteLength(byteLength, expectedEncoding);
            a.boundsCheckRegionRaw(AbstractTruffleString.rawIndex(byteOffset, expectedEncoding), AbstractTruffleString.rawIndex(byteLength, expectedEncoding));
            byte[] array = new byte[byteLength];
            copyToByteArrayNode.execute(a, byteOffset, array, 0, byteLength, expectedEncoding);
            return MutableTruffleString.create(array, 0, byteLength >> expectedEncoding.naturalStride, expectedEncoding);
        }

        @NeverDefault
        public static SubstringByteIndexNode create() {
            return MutableTruffleStringFactory.SubstringByteIndexNodeGen.create();
        }

        public static SubstringByteIndexNode getUncached() {
            return MutableTruffleStringFactory.SubstringByteIndexNodeGen.getUncached();
        }
    }

    static abstract class CalcLazyAttributesNode
    extends AbstractInternalNode {
        CalcLazyAttributesNode() {
        }

        abstract void execute(Node var1, MutableTruffleString var2);

        @Specialization
        static void calc(Node node, MutableTruffleString a, @Cached DataClassProfile dataClassProfile, @Cached InlinedConditionProfile asciiBytesLatinProfile, @Cached InlinedConditionProfile utf8Profile, @Cached InlinedConditionProfile utf8BrokenProfile, @Cached InlinedConditionProfile utf16Profile, @Cached InlinedConditionProfile utf16S0Profile, @Cached InlinedConditionProfile utf32Profile, @Cached InlinedConditionProfile utf32S0Profile, @Cached InlinedConditionProfile utf32S1Profile, @Cached InlinedConditionProfile exoticMaterializeNativeProfile, @Cached InlinedConditionProfile exoticValidProfile, @Cached InlinedConditionProfile exoticFixedWidthProfile) {
            int codePointLength;
            int codeRange;
            Object data = dataClassProfile.execute(node, a.data());
            int encoding = a.encoding();
            int offset = a.offset();
            int length2 = a.length();
            if (utf16Profile.profile(node, TStringGuards.isUTF16(encoding))) {
                if (utf16S0Profile.profile(node, TStringGuards.isStride0(a))) {
                    codeRange = TStringOps.calcStringAttributesLatin1(node, data, offset, length2);
                    codePointLength = length2;
                } else {
                    assert (TStringGuards.isStride1(a));
                    long attrs = TStringOps.calcStringAttributesUTF16(node, data, offset, length2, false);
                    codePointLength = StringAttributes.getCodePointLength(attrs);
                    codeRange = StringAttributes.getCodeRange(attrs);
                }
            } else if (utf32Profile.profile(node, TStringGuards.isUTF32(encoding))) {
                if (utf32S0Profile.profile(node, TStringGuards.isStride0(a))) {
                    codeRange = TStringOps.calcStringAttributesLatin1(node, data, offset, length2);
                } else if (utf32S1Profile.profile(node, TStringGuards.isStride1(a))) {
                    codeRange = TStringOps.calcStringAttributesBMP(node, data, offset, length2);
                } else {
                    assert (TStringGuards.isStride2(a));
                    codeRange = TStringOps.calcStringAttributesUTF32(node, data, offset, length2);
                }
                codePointLength = length2;
            } else if (utf8Profile.profile(node, TStringGuards.isUTF8(encoding))) {
                long attrs = TStringOps.calcStringAttributesUTF8(node, data, offset, length2, false, false, utf8BrokenProfile);
                codeRange = StringAttributes.getCodeRange(attrs);
                codePointLength = StringAttributes.getCodePointLength(attrs);
            } else if (asciiBytesLatinProfile.profile(node, TStringGuards.isAsciiBytesOrLatin1(encoding))) {
                int cr = TStringOps.calcStringAttributesLatin1(node, data, offset, length2);
                codeRange = TStringGuards.is8Bit(cr) ? TSCodeRange.asciiLatinBytesNonAsciiCodeRange(encoding) : cr;
                codePointLength = length2;
            } else {
                if (data instanceof AbstractTruffleString.NativePointer) {
                    ((AbstractTruffleString.NativePointer)data).materializeByteArray(node, a, exoticMaterializeNativeProfile);
                }
                long attrs = JCodings.getInstance().calcStringAttributes(node, data, offset, length2, TruffleString.Encoding.get(encoding), 0, exoticValidProfile, exoticFixedWidthProfile);
                codeRange = StringAttributes.getCodeRange(attrs);
                codePointLength = StringAttributes.getCodePointLength(attrs);
            }
            a.updateAttributes(codePointLength, codeRange);
        }
    }

    static abstract class DataClassProfile
    extends AbstractInternalNode {
        DataClassProfile() {
        }

        abstract Object execute(Node var1, Object var2);

        @Specialization
        static byte[] doByteArray(byte[] v) {
            return v;
        }

        @Specialization
        static AbstractTruffleString.NativePointer doNativePointer(AbstractTruffleString.NativePointer v) {
            return v;
        }
    }

    public static abstract class ForceEncodingNode
    extends AbstractPublicNode {
        ForceEncodingNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, TruffleString.Encoding var2, TruffleString.Encoding var3);

        @Specialization(guards={"a.isCompatibleToIntl(targetEncoding)"})
        static MutableTruffleString compatible(MutableTruffleString a, TruffleString.Encoding expectedEncoding, TruffleString.Encoding targetEncoding) {
            a.checkEncoding(expectedEncoding);
            return a;
        }

        @Specialization(guards={"!a.isCompatibleToIntl(targetEncoding) || a.isImmutable()"})
        static MutableTruffleString reinterpret(AbstractTruffleString a, TruffleString.Encoding expectedEncoding, TruffleString.Encoding targetEncoding, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            a.checkEncoding(expectedEncoding);
            return MutableTruffleString.createCopying(a, expectedEncoding, targetEncoding, copyToByteArrayNode);
        }

        @NeverDefault
        public static ForceEncodingNode create() {
            return MutableTruffleStringFactory.ForceEncodingNodeGen.create();
        }

        public static ForceEncodingNode getUncached() {
            return MutableTruffleStringFactory.ForceEncodingNodeGen.getUncached();
        }
    }

    public static abstract class SwitchEncodingNode
    extends AbstractPublicNode {
        SwitchEncodingNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, TruffleString.Encoding var2);

        @Specialization(guards={"a.isCompatibleToIntl(encoding)"})
        static MutableTruffleString compatibleMutable(MutableTruffleString a, TruffleString.Encoding encoding) {
            return a;
        }

        @Specialization(guards={"!a.isCompatibleToIntl(encoding) || a.isImmutable()"})
        static MutableTruffleString transcodeAndCopy(AbstractTruffleString a, TruffleString.Encoding encoding, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached AsMutableTruffleStringNode asMutableTruffleStringNode) {
            TruffleString switched = switchEncodingNode.execute(a, encoding);
            return asMutableTruffleStringNode.execute(switched, encoding);
        }

        @NeverDefault
        public static SwitchEncodingNode create() {
            return MutableTruffleStringFactory.SwitchEncodingNodeGen.create();
        }

        public static SwitchEncodingNode getUncached() {
            return MutableTruffleStringFactory.SwitchEncodingNodeGen.getUncached();
        }
    }

    public static abstract class AsManagedNode
    extends AbstractPublicNode {
        AsManagedNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, TruffleString.Encoding var2);

        @Specialization(guards={"!a.isNative()"})
        static MutableTruffleString mutable(MutableTruffleString a, TruffleString.Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            return a;
        }

        @Specialization(guards={"a.isNative() || a.isImmutable()"})
        static MutableTruffleString fromTruffleString(AbstractTruffleString a, TruffleString.Encoding expectedEncoding, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            return MutableTruffleString.createCopying(a, expectedEncoding, copyToByteArrayNode);
        }

        @NeverDefault
        public static AsManagedNode create() {
            return MutableTruffleStringFactory.AsManagedNodeGen.create();
        }

        public static AsManagedNode getUncached() {
            return MutableTruffleStringFactory.AsManagedNodeGen.getUncached();
        }
    }

    public static abstract class AsMutableTruffleStringNode
    extends AbstractPublicNode {
        AsMutableTruffleStringNode() {
        }

        public abstract MutableTruffleString execute(AbstractTruffleString var1, TruffleString.Encoding var2);

        @Specialization
        static MutableTruffleString mutable(MutableTruffleString a, TruffleString.Encoding expectedEncoding) {
            a.checkEncoding(expectedEncoding);
            return a;
        }

        @Specialization
        static MutableTruffleString fromTruffleString(TruffleString a, TruffleString.Encoding expectedEncoding, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            return MutableTruffleString.createCopying(a, expectedEncoding, copyToByteArrayNode);
        }

        @NeverDefault
        public static AsMutableTruffleStringNode create() {
            return MutableTruffleStringFactory.AsMutableTruffleStringNodeGen.create();
        }

        public static AsMutableTruffleStringNode getUncached() {
            return MutableTruffleStringFactory.AsMutableTruffleStringNodeGen.getUncached();
        }
    }
}

