/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v2.api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.api.LoadSettingsBuilder;
import org.snakeyaml.engine.v2.api.SettingKey;
import org.snakeyaml.engine.v2.common.SpecVersion;
import org.snakeyaml.engine.v2.env.EnvConfig;
import org.snakeyaml.engine.v2.nodes.Tag;
import org.snakeyaml.engine.v2.resolver.ScalarResolver;

public final class LoadSettings {
    private final String label;
    private final Map<Tag, ConstructNode> tagConstructors;
    private final ScalarResolver scalarResolver;
    private final IntFunction<List<Object>> defaultList;
    private final IntFunction<Set<Object>> defaultSet;
    private final IntFunction<Map<Object, Object>> defaultMap;
    private final UnaryOperator<SpecVersion> versionFunction;
    private final Integer bufferSize;
    private final boolean allowDuplicateKeys;
    private final boolean allowRecursiveKeys;
    private final boolean parseComments;
    private final int maxAliasesForCollections;
    private final boolean useMarks;
    private final Optional<EnvConfig> envConfig;
    private final int codePointLimit;
    private final Map<SettingKey, Object> customProperties;

    LoadSettings(String label, Map<Tag, ConstructNode> tagConstructors, ScalarResolver scalarResolver, IntFunction<List<Object>> defaultList, IntFunction<Set<Object>> defaultSet, IntFunction<Map<Object, Object>> defaultMap, UnaryOperator<SpecVersion> versionFunction, Integer bufferSize, boolean allowDuplicateKeys, boolean allowRecursiveKeys, int maxAliasesForCollections, boolean useMarks, Map<SettingKey, Object> customProperties, Optional<EnvConfig> envConfig, boolean parseComments, int codePointLimit) {
        this.label = label;
        this.tagConstructors = tagConstructors;
        this.scalarResolver = scalarResolver;
        this.defaultList = defaultList;
        this.defaultSet = defaultSet;
        this.defaultMap = defaultMap;
        this.versionFunction = versionFunction;
        this.bufferSize = bufferSize;
        this.allowDuplicateKeys = allowDuplicateKeys;
        this.allowRecursiveKeys = allowRecursiveKeys;
        this.parseComments = parseComments;
        this.maxAliasesForCollections = maxAliasesForCollections;
        this.useMarks = useMarks;
        this.customProperties = customProperties;
        this.envConfig = envConfig;
        this.codePointLimit = codePointLimit;
    }

    public static LoadSettingsBuilder builder() {
        return new LoadSettingsBuilder();
    }

    public String getLabel() {
        return this.label;
    }

    public Map<Tag, ConstructNode> getTagConstructors() {
        return this.tagConstructors;
    }

    public ScalarResolver getScalarResolver() {
        return this.scalarResolver;
    }

    public IntFunction<List<Object>> getDefaultList() {
        return this.defaultList;
    }

    public IntFunction<Set<Object>> getDefaultSet() {
        return this.defaultSet;
    }

    public IntFunction<Map<Object, Object>> getDefaultMap() {
        return this.defaultMap;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public boolean getAllowDuplicateKeys() {
        return this.allowDuplicateKeys;
    }

    public boolean getAllowRecursiveKeys() {
        return this.allowRecursiveKeys;
    }

    public boolean getUseMarks() {
        return this.useMarks;
    }

    public Function<SpecVersion, SpecVersion> getVersionFunction() {
        return this.versionFunction;
    }

    public Object getCustomProperty(SettingKey key2) {
        return this.customProperties.get(key2);
    }

    public int getMaxAliasesForCollections() {
        return this.maxAliasesForCollections;
    }

    public Optional<EnvConfig> getEnvConfig() {
        return this.envConfig;
    }

    public boolean getParseComments() {
        return this.parseComments;
    }

    public int getCodePointLimit() {
        return this.codePointLimit;
    }
}

