/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.server;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.pkl.core.SecurityManager;
import org.pkl.core.module.PathElement;
import org.pkl.core.resource.Resource;
import org.pkl.core.resource.ResourceReader;
import org.pkl.server.ListResourcesRequest;
import org.pkl.server.ListResourcesResponse;
import org.pkl.server.MessageTransport;
import org.pkl.server.ProtocolException;
import org.pkl.server.ReadResourceRequest;
import org.pkl.server.ReadResourceResponse;
import org.pkl.server.ResourceReaderSpec;
import org.pkl.server.ResponseMessage;
import org.pkl.server.UtilsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0016J\b\u0010\u001d\u001a\u00020\u0018H\u0016J\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/pkl/server/ClientResourceReader;", "Lorg/pkl/core/resource/ResourceReader;", "transport", "Lorg/pkl/server/MessageTransport;", "evaluatorId", "", "readerSpec", "Lorg/pkl/server/ResourceReaderSpec;", "(Lorg/pkl/server/MessageTransport;JLorg/pkl/server/ResourceReaderSpec;)V", "listResources", "", "Ljava/net/URI;", "Ljava/util/concurrent/Future;", "", "Lorg/pkl/core/module/PathElement;", "readResponses", "", "doListElements", "baseUri", "doRead", "uri", "getUriScheme", "", "hasElement", "", "securityManager", "Lorg/pkl/core/SecurityManager;", "elementUri", "hasHierarchicalUris", "isGlobbable", "listElements", "read", "Ljava/util/Optional;", "", "pkl-server"})
public final class ClientResourceReader
implements ResourceReader {
    @NotNull
    private final MessageTransport transport;
    private final long evaluatorId;
    @NotNull
    private final ResourceReaderSpec readerSpec;
    @NotNull
    private final Map<URI, Future<byte[]>> readResponses;
    @NotNull
    private final Map<URI, Future<List<PathElement>>> listResources;

    public ClientResourceReader(@NotNull MessageTransport transport, long evaluatorId, @NotNull ResourceReaderSpec readerSpec) {
        Intrinsics.checkNotNullParameter(transport, "transport");
        Intrinsics.checkNotNullParameter(readerSpec, "readerSpec");
        this.transport = transport;
        this.evaluatorId = evaluatorId;
        this.readerSpec = readerSpec;
        this.readResponses = new ConcurrentHashMap();
        this.listResources = new ConcurrentHashMap();
    }

    @Override
    public boolean hasHierarchicalUris() {
        return this.readerSpec.getHasHierarchicalUris();
    }

    @Override
    public boolean isGlobbable() {
        return this.readerSpec.isGlobbable();
    }

    @Override
    @NotNull
    public String getUriScheme() {
        return this.readerSpec.getScheme();
    }

    @Override
    @NotNull
    public Optional<Object> read(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter(uri, "uri");
        Optional<Object> optional2 = Optional.of(new Resource(uri, this.doRead(uri)));
        Intrinsics.checkNotNullExpressionValue(optional2, "of(Resource(uri, doRead(uri)))");
        return optional2;
    }

    @Override
    public boolean hasElement(@NotNull SecurityManager securityManager2, @NotNull URI elementUri) {
        boolean bl;
        Intrinsics.checkNotNullParameter(securityManager2, "securityManager");
        Intrinsics.checkNotNullParameter(elementUri, "elementUri");
        securityManager2.checkResolveResource(elementUri);
        try {
            this.doRead(elementUri);
            bl = true;
        }
        catch (IOException e2) {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public List<PathElement> listElements(@NotNull SecurityManager securityManager2, @NotNull URI baseUri) {
        Intrinsics.checkNotNullParameter(securityManager2, "securityManager");
        Intrinsics.checkNotNullParameter(baseUri, "baseUri");
        securityManager2.checkResolveResource(baseUri);
        return this.doListElements(baseUri);
    }

    private final List<PathElement> doListElements(URI baseUri) {
        Future future = this.listResources.computeIfAbsent(baseUri, arg_0 -> ClientResourceReader.doListElements$lambda-1(this, baseUri, arg_0));
        Intrinsics.checkNotNullExpressionValue(future, "listResources\n      .com\u2026      }\n        }\n      }");
        return (List)UtilsKt.getUnderlying(future);
    }

    private final byte[] doRead(URI uri) {
        Future future = this.readResponses.computeIfAbsent(uri, arg_0 -> ClientResourceReader.doRead$lambda-3(this, uri, arg_0));
        Intrinsics.checkNotNullExpressionValue(future, "readResponses\n      .com\u2026      }\n        }\n      }");
        return (byte[])UtilsKt.getUnderlying(future);
    }

    private static final Future doListElements$lambda-1(ClientResourceReader this$0, URI $baseUri, URI it) {
        CompletableFuture<List<PathElement>> completableFuture;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($baseUri, "$baseUri");
        Intrinsics.checkNotNullParameter(it, "it");
        CompletableFuture<List<PathElement>> $this$doListElements_u24lambda_u2d1_u24lambda_u2d0 = completableFuture = new CompletableFuture<List<PathElement>>();
        boolean bl = false;
        ListResourcesRequest request = new ListResourcesRequest(Random.Default.nextLong(), this$0.evaluatorId, $baseUri);
        this$0.transport.send(request, (Function1<? super ResponseMessage, Unit>)new Function1<ResponseMessage, Unit>($this$doListElements_u24lambda_u2d1_u24lambda_u2d0){
            final /* synthetic */ CompletableFuture<List<PathElement>> $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ResponseMessage response) {
                Intrinsics.checkNotNullParameter(response, "response");
                if (response instanceof ListResourcesResponse) {
                    if (((ListResourcesResponse)response).getError() != null) {
                        this.$this_apply.completeExceptionally(new IOException(((ListResourcesResponse)response).getError()));
                    } else {
                        List<PathElement> list = ((ListResourcesResponse)response).getPathElements();
                        if (list == null) {
                            list = CollectionsKt.emptyList();
                        }
                        this.$this_apply.complete(list);
                    }
                } else {
                    this.$this_apply.completeExceptionally(new ProtocolException("Unexpected response", null, 2, null));
                }
            }
        });
        return completableFuture;
    }

    private static final Future doRead$lambda-3(ClientResourceReader this$0, URI $uri, URI it) {
        CompletableFuture<byte[]> completableFuture;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($uri, "$uri");
        Intrinsics.checkNotNullParameter(it, "it");
        CompletableFuture<byte[]> $this$doRead_u24lambda_u2d3_u24lambda_u2d2 = completableFuture = new CompletableFuture<byte[]>();
        boolean bl = false;
        ReadResourceRequest request = new ReadResourceRequest(Random.Default.nextLong(), this$0.evaluatorId, $uri);
        this$0.transport.send(request, (Function1<? super ResponseMessage, Unit>)new Function1<ResponseMessage, Unit>($this$doRead_u24lambda_u2d3_u24lambda_u2d2){
            final /* synthetic */ CompletableFuture<byte[]> $this_apply;
            {
                this.$this_apply = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ResponseMessage response) {
                Intrinsics.checkNotNullParameter(response, "response");
                if (response instanceof ReadResourceResponse) {
                    if (((ReadResourceResponse)response).getError() != null) {
                        this.$this_apply.completeExceptionally(new IOException(((ReadResourceResponse)response).getError()));
                    } else {
                        byte[] byArray = ((ReadResourceResponse)response).getContents();
                        Intrinsics.checkNotNull(byArray);
                        this.$this_apply.complete(byArray);
                    }
                } else {
                    this.$this_apply.completeExceptionally(new ProtocolException("Unexpected response: " + response, null, 2, null));
                }
            }
        });
        return completableFuture;
    }
}

