/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.pkl.core.PklBugException;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.PathElement;
import org.pkl.core.runtime.ReaderBase;
import org.pkl.core.util.ErrorMessages;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.MutableLong;
import org.pkl.core.util.Pair;

public final class GlobResolver {
    private static final char NULL = '\u0000';
    private static final int MAX_LIST_ELEMENTS = 16384;
    private static final Map<String, Pattern> patterns = Collections.synchronizedMap(new WeakHashMap());

    private GlobResolver() {
    }

    private static char getNextChar(String pattern2, int i) {
        if (i >= pattern2.length() - 1) {
            return '\u0000';
        }
        return pattern2.charAt(i + 1);
    }

    private static int consumeCharacterClass(String globPattern, int idx, StringBuilder sb) throws InvalidGlobPatternException {
        sb.append("[[^/]&&[");
        int i = idx;
        switch (GlobResolver.getNextChar(globPattern, i)) {
            case '^': {
                sb.append("\\^");
                ++i;
                break;
            }
            case '!': {
                sb.append("^");
                ++i;
                break;
            }
            case ']': {
                sb.append(']');
                ++i;
                break;
            }
            case '\u0000': {
                throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobMissingCharacterClassTerminator", new Object[0]));
            }
        }
        char current2 = globPattern.charAt(++i);
        while (current2 != ']') {
            char next;
            if (current2 == '[' && ((next = GlobResolver.getNextChar(globPattern, i)) == ':' || next == '=' || next == '.')) {
                throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobUnsupportedFeature", new Object[0]));
            }
            if (current2 == '/') {
                throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobInvalidCharacterInCharacterClass", Character.valueOf(current2)));
            }
            if (current2 == '\\') {
                sb.append("\\\\");
            } else {
                sb.append(current2);
            }
            if (++i == globPattern.length()) {
                throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobMissingCharacterClassTerminator", new Object[0]));
            }
            current2 = globPattern.charAt(i);
        }
        sb.append("]]");
        return i;
    }

    public static Pattern toRegexPattern(String globPattern) throws InvalidGlobPatternException {
        Pattern pattern2 = patterns.get(globPattern);
        if (pattern2 == null) {
            pattern2 = Pattern.compile(GlobResolver.toRegexString(globPattern));
            patterns.put(globPattern, pattern2);
        }
        return pattern2;
    }

    public static String toRegexString(String globPattern) throws InvalidGlobPatternException {
        StringBuilder sb = new StringBuilder("^");
        boolean inGroup = false;
        block12: for (int i = 0; i < globPattern.length(); ++i) {
            char current2 = globPattern.charAt(i);
            switch (current2) {
                case '{': {
                    if (inGroup) {
                        throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobNestedSubpattern", new Object[0]));
                    }
                    inGroup = true;
                    sb.append("(?:(?:");
                    continue block12;
                }
                case '}': {
                    if (inGroup) {
                        inGroup = false;
                        sb.append("))");
                        continue block12;
                    }
                    sb.append('}');
                    continue block12;
                }
                case ',': {
                    if (inGroup) {
                        sb.append(")|(?:");
                        continue block12;
                    }
                    sb.append(',');
                    continue block12;
                }
                case '\\': {
                    char next = GlobResolver.getNextChar(globPattern, i);
                    if (next == '\u0000') {
                        throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobInvalidTerminatingCharacter", new Object[0]));
                    }
                    if (next != '?' && next != '*' && next != '[' && next != '{' && next != '\\') {
                        throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobInvalidEscapeCharacter", Character.valueOf(next)));
                    }
                    sb.append('\\').append(next);
                    ++i;
                    continue block12;
                }
                case '[': {
                    i = GlobResolver.consumeCharacterClass(globPattern, i, sb);
                    continue block12;
                }
                case '?': {
                    char next = GlobResolver.getNextChar(globPattern, i);
                    if (next == '(') {
                        throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobExtGlob", new Object[0]));
                    }
                    sb.append(".");
                    continue block12;
                }
                case '*': {
                    char next = GlobResolver.getNextChar(globPattern, i);
                    if (next == '(') {
                        throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobExtGlob", new Object[0]));
                    }
                    if (next == '*') {
                        sb.append(".*");
                        ++i;
                        continue block12;
                    }
                    sb.append("[^/]*");
                    continue block12;
                }
                case '+': 
                case '@': {
                    char next = GlobResolver.getNextChar(globPattern, i);
                    if (next == '(') {
                        throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobExtGlob", new Object[0]));
                    }
                    sb.append("\\+");
                    continue block12;
                }
                case '!': {
                    char next = GlobResolver.getNextChar(globPattern, i);
                    if (next == '(') {
                        throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobExtGlob", new Object[0]));
                    }
                    sb.append("!");
                    continue block12;
                }
                case '$': 
                case '%': 
                case '(': 
                case '.': 
                case '^': 
                case '|': {
                    sb.append("\\").append(current2);
                    continue block12;
                }
                default: {
                    sb.append(current2);
                }
            }
        }
        if (inGroup) {
            throw new InvalidGlobPatternException("invalidGlobUnclosedSubpattern");
        }
        return sb.append("$").toString();
    }

    private static void resolveOpaqueGlob(SecurityManager securityManager2, ReaderBase reader, URI globUri, Pattern pattern2, Map<String, ResolvedGlobElement> result) throws IOException, SecurityManagerException {
        List<PathElement> elements = reader.listElements(securityManager2, globUri);
        for (PathElement elem : GlobResolver.sorted(elements)) {
            URI resolvedUri;
            try {
                resolvedUri = new URI(globUri.getScheme(), elem.getName(), null);
            }
            catch (URISyntaxException e2) {
                throw new IllegalArgumentException(e2.getMessage(), e2);
            }
            if (!pattern2.matcher(resolvedUri.toString()).matches()) continue;
            String path2 = resolvedUri.toString();
            result.put(path2, new ResolvedGlobElement(path2, resolvedUri, false));
        }
    }

    private static List<PathElement> sorted(List<PathElement> elements) {
        return elements.stream().sorted(PathElement.comparator).collect(Collectors.toList());
    }

    private static Boolean isRegularPathPart(String pathPart) {
        for (int i = 0; i < pathPart.length(); ++i) {
            char c = pathPart.charAt(i);
            if (c != '\\' && c != '{' && c != '[' && c != '?' && c != '*') continue;
            return false;
        }
        return true;
    }

    private static String resolvePath(String basePath, String path2, boolean hasAbsoluteGlob) {
        if (basePath.isEmpty()) {
            return path2;
        }
        if (hasAbsoluteGlob) {
            try {
                path2 = new URI(null, null, path2, null).toString();
            }
            catch (URISyntaxException e2) {
                throw new IllegalArgumentException(e2);
            }
        }
        if (basePath.endsWith("/")) {
            return basePath + path2;
        }
        return basePath + "/" + path2;
    }

    private static List<ResolvedGlobElement> expandHierarchicalGlobPart(SecurityManager securityManager2, ReaderBase reader, String basePath, Pattern globPartPattern, URI baseUri, boolean isGlobStar, boolean hasAbsoluteGlob, MutableLong listElementCallCount) throws IOException, SecurityManagerException, InvalidGlobPatternException {
        ArrayList<ResolvedGlobElement> result = new ArrayList<ResolvedGlobElement>();
        GlobResolver.doExpandHierarchicalGlobPart(securityManager2, reader, basePath, globPartPattern, baseUri, isGlobStar, hasAbsoluteGlob, listElementCallCount, result);
        return result;
    }

    private static void doExpandHierarchicalGlobPart(SecurityManager securityManager2, ReaderBase reader, String expandedGlobSoFar, Pattern globPartPattern, URI baseUri, boolean isGlobStar, boolean hasAbsoluteGlob, MutableLong listElementCallCount, List<ResolvedGlobElement> result) throws IOException, SecurityManagerException, InvalidGlobPatternException {
        if (listElementCallCount.getAndIncrement() > 16384L) {
            throw new InvalidGlobPatternException(ErrorMessages.create("invalidGlobTooComplex", new Object[0]));
        }
        List<PathElement> elements = reader.listElements(securityManager2, baseUri);
        for (PathElement element : GlobResolver.sorted(elements)) {
            String elementPath = GlobResolver.resolvePath(expandedGlobSoFar, element.getName(), hasAbsoluteGlob);
            if (globPartPattern.matcher(element.getName()).matches()) {
                Object name = element.isDirectory() ? element.getName() + "/" : element.getName();
                URI elementUri = IoUtils.resolve(reader, baseUri, (String)name);
                result.add(new ResolvedGlobElement(elementPath, elementUri, element.isDirectory()));
            }
            if (!element.isDirectory() || !isGlobStar) continue;
            URI elementUri = IoUtils.resolve(reader, baseUri, element.getName() + "/");
            String newExpandedGlobPattern = GlobResolver.resolvePath(expandedGlobSoFar, element.getName(), hasAbsoluteGlob);
            GlobResolver.doExpandHierarchicalGlobPart(securityManager2, reader, newExpandedGlobPattern, globPartPattern, elementUri, true, hasAbsoluteGlob, listElementCallCount, result);
        }
    }

    private static void resolveHierarchicalGlob(SecurityManager securityManager2, ReaderBase reader, String[] globPatternParts, int idx, URI baseUri, String expandedGlobPatternSoFar, boolean hasAbsoluteGlob, Map<String, ResolvedGlobElement> result, MutableLong listElementCallCount) throws IOException, SecurityManagerException, InvalidGlobPatternException {
        boolean isLeaf = idx == globPatternParts.length - 1;
        String patternPart = globPatternParts[idx];
        if (GlobResolver.isRegularPathPart(patternPart).booleanValue()) {
            String newPath = GlobResolver.resolvePath(expandedGlobPatternSoFar, patternPart, hasAbsoluteGlob);
            if (isLeaf) {
                URI newBaseUri = IoUtils.resolve(reader, baseUri, patternPart);
                if (reader.hasElement(securityManager2, newBaseUri)) {
                    result.put(newPath, new ResolvedGlobElement(newPath, newBaseUri, false));
                }
            } else {
                URI newBaseUri = IoUtils.resolve(reader, baseUri, patternPart + "/");
                GlobResolver.resolveHierarchicalGlob(securityManager2, reader, globPatternParts, idx + 1, newBaseUri, newPath, hasAbsoluteGlob, result, listElementCallCount);
            }
        } else {
            Pattern globPartPattern = GlobResolver.toRegexPattern(patternPart);
            boolean isGlobStar = patternPart.contains("**");
            List<ResolvedGlobElement> matchedElements = GlobResolver.expandHierarchicalGlobPart(securityManager2, reader, expandedGlobPatternSoFar, globPartPattern, baseUri, isGlobStar, hasAbsoluteGlob, listElementCallCount);
            for (ResolvedGlobElement element : matchedElements) {
                if (isLeaf) {
                    result.put(element.getPath(), element);
                    continue;
                }
                if (!element.isDirectory()) continue;
                GlobResolver.resolveHierarchicalGlob(securityManager2, reader, globPatternParts, idx + 1, element.getUri(), element.getPath(), hasAbsoluteGlob, result, listElementCallCount);
            }
        }
    }

    private static Pair<String, String[]> splitGlobPatternIntoBaseAndWildcards(ReaderBase reader, String globPattern, boolean hasAbsoluteGlob) {
        String part;
        int i;
        String effectiveGlobPattern = globPattern;
        StringBuilder basePathSb = new StringBuilder();
        if (hasAbsoluteGlob) {
            URI globUri = URI.create(globPattern);
            if (reader.hasFragmentPaths()) {
                effectiveGlobPattern = globUri.getFragment();
                basePathSb.append(IoUtils.stripFragment(globUri)).append('#');
            } else {
                effectiveGlobPattern = globUri.getPath();
                basePathSb.append(globUri.getScheme()).append(':');
            }
        }
        String[] parts = effectiveGlobPattern.split("/");
        for (i = 0; i < parts.length && GlobResolver.isRegularPathPart(part = parts[i]).booleanValue(); ++i) {
            basePathSb.append(part).append('/');
        }
        return Pair.of(basePathSb.toString(), Arrays.copyOfRange(parts, i, parts.length));
    }

    @CompilerDirectives.TruffleBoundary
    public static Map<String, ResolvedGlobElement> resolveGlob(SecurityManager securityManager2, ReaderBase reader, ModuleKey enclosingModuleKey, URI enclosingUri, String globPattern) throws IOException, SecurityManagerException, InvalidGlobPatternException {
        LinkedHashMap<String, ResolvedGlobElement> result = new LinkedHashMap<String, ResolvedGlobElement>();
        boolean hasAbsoluteGlob = globPattern.matches("\\w+:.*");
        if (reader.hasHierarchicalUris()) {
            URI baseUri;
            Pair<String, String[]> splitPattern = GlobResolver.splitGlobPatternIntoBaseAndWildcards(reader, globPattern, hasAbsoluteGlob);
            String basePath = (String)splitPattern.first;
            String[] globParts = (String[])splitPattern.second;
            if (globParts.length == 0) {
                URI resolvedUri = IoUtils.resolve(reader, enclosingUri, globPattern);
                if (reader.hasElement(securityManager2, resolvedUri)) {
                    result.put(globPattern, new ResolvedGlobElement(globPattern, resolvedUri, true));
                }
                return result;
            }
            try {
                baseUri = IoUtils.resolve(securityManager2, enclosingModuleKey, URI.create(basePath));
            }
            catch (URISyntaxException e2) {
                throw new PklBugException(e2);
            }
            GlobResolver.resolveHierarchicalGlob(securityManager2, reader, globParts, 0, baseUri, basePath, hasAbsoluteGlob, result, new MutableLong(0L));
        } else {
            Pattern regexPattern = GlobResolver.toRegexPattern(globPattern);
            URI globUri = hasAbsoluteGlob ? URI.create(globPattern) : URI.create(enclosingUri.getScheme() + ":dummy");
            GlobResolver.resolveOpaqueGlob(securityManager2, reader, globUri, regexPattern, result);
        }
        return result;
    }

    public static final class InvalidGlobPatternException
    extends Exception {
        public InvalidGlobPatternException(String message) {
            super(message);
        }
    }

    public static final class ResolvedGlobElement {
        private final String path;
        private final URI uri;
        private final boolean isDirectory;

        public ResolvedGlobElement(String path2, URI uri, boolean isDirectory) {
            this.path = path2;
            this.uri = uri.normalize();
            this.isDirectory = isDirectory;
        }

        public String getPath() {
            return this.path;
        }

        public URI getUri() {
            return this.uri;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }
    }
}

