/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObjectLike;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;

public final class DynamicNodes {
    private DynamicNodes() {
    }

    public static abstract class toTyped
    extends ExternalMethod1Node {
        @Specialization
        protected VmObjectLike eval(VmDynamic self, VmClass clazz) {
            if (!clazz.isSubclassOf(BaseModule.getTypedClass())) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("notASubclassOfTyped", clazz).build();
            }
            VmUtils.checkIsInstantiable(clazz, this);
            VmTyped result = new VmTyped(VmUtils.createEmptyMaterializedFrame(), clazz.getPrototype(), clazz, clazz.getDynamicToTypedMembers());
            result.setExtraStorage(self);
            return result;
        }
    }

    public static abstract class toList
    extends ExternalMethod0Node {
        @Specialization
        protected VmList eval(VmDynamic self) {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                if (member.isElement()) {
                    builder.add(value2);
                }
                return true;
            });
            return builder.build();
        }
    }

    public static abstract class toMap
    extends ExternalMethod0Node {
        @Specialization
        protected VmMap eval(VmDynamic self) {
            VmMap.Builder builder = VmMap.builder();
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                if (!member.isElement()) {
                    builder.add(key2 instanceof Identifier ? key2.toString() : key2, value2);
                }
                return true;
            });
            return builder.build();
        }
    }

    public static abstract class getPropertyOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private IndirectCallNode callNode = IndirectCallNode.create();

        @Specialization
        protected Object eval(VmDynamic self, String name) {
            return VmNull.lift(VmUtils.readMemberOrNull((VmObjectLike)self, (Object)Identifier.get(name), this.callNode));
        }
    }

    public static abstract class getProperty
    extends ExternalMethod1Node {
        @Node.Child
        private IndirectCallNode callNode = IndirectCallNode.create();

        @Specialization
        protected Object eval(VmDynamic self, String name) {
            return VmUtils.readMember(self, Identifier.get(name), this.callNode);
        }
    }

    public static abstract class hasProperty
    extends ExternalMethod1Node {
        @Specialization
        protected Object eval(VmDynamic self, String name) {
            Identifier memberName = Identifier.get(name);
            if (self.hasCachedValue(name)) {
                return true;
            }
            for (VmObjectLike curr = self; curr != null; curr = ((VmObjectLike)curr).getParent()) {
                if (!((VmObjectLike)curr).hasMember(memberName)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class length
    extends ExternalMethod0Node {
        @Specialization
        protected long eval(VmDynamic self) {
            return self.getLength();
        }
    }
}

